/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.macosx;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.SharedLibrary;
import org.lwjgl.system.macosx.EnumerationMutationHandlerI;
import org.lwjgl.system.macosx.ObjCMethodDescription;
import org.lwjgl.system.macosx.ObjCPropertyAttribute;

public class ObjCRuntime {
    public static final long nil = 0L;
    public static final byte YES = 1;
    public static final byte NO = 0;
    public static final char _C_ID = '@';
    public static final char _C_CLASS = '#';
    public static final char _C_SEL = ':';
    public static final char _C_CHR = 'c';
    public static final char _C_UCHR = 'C';
    public static final char _C_SHT = 's';
    public static final char _C_USHT = 'S';
    public static final char _C_INT = 'i';
    public static final char _C_UINT = 'I';
    public static final char _C_LNG = 'l';
    public static final char _C_ULNG = 'L';
    public static final char _C_LNG_LNG = 'q';
    public static final char _C_ULNG_LNG = 'Q';
    public static final char _C_FLT = 'f';
    public static final char _C_DBL = 'd';
    public static final char _C_BFLD = 'b';
    public static final char _C_BOOL = 'B';
    public static final char _C_VOID = 'v';
    public static final char _C_UNDEF = '?';
    public static final char _C_PTR = '^';
    public static final char _C_CHARPTR = '*';
    public static final char _C_ATOM = '%';
    public static final char _C_ARY_B = '[';
    public static final char _C_ARY_E = ']';
    public static final char _C_UNION_B = '(';
    public static final char _C_UNION_E = ')';
    public static final char _C_STRUCT_B = '{';
    public static final char _C_STRUCT_E = '}';
    public static final char _C_VECTOR = '!';
    public static final char _C_CONST = 'r';
    public static final int OBJC_ASSOCIATION_ASSIGN = 0;
    public static final int OBJC_ASSOCIATION_RETAIN_NONATOMIC = 1;
    public static final int OBJC_ASSOCIATION_COPY_NONATOMIC = 3;
    public static final int OBJC_ASSOCIATION_RETAIN = 1401;
    public static final int OBJC_ASSOCIATION_COPY = 1403;
    private static final SharedLibrary OBJC = Library.loadNative("objc");

    protected ObjCRuntime() {
        throw new UnsupportedOperationException();
    }

    public static SharedLibrary getLibrary() {
        return OBJC;
    }

    public static long object_copy(long obj, long size) {
        long __functionAddress = Functions.object_copy;
        if (Checks.CHECKS) {
            Checks.checkPointer(obj);
        }
        return JNI.invokePPP(__functionAddress, obj, size);
    }

    public static long object_dispose(long obj) {
        long __functionAddress = Functions.object_dispose;
        if (Checks.CHECKS) {
            Checks.checkPointer(obj);
        }
        return JNI.invokePP(__functionAddress, obj);
    }

    public static long object_getClass(long obj) {
        long __functionAddress = Functions.object_getClass;
        return JNI.invokePP(__functionAddress, obj);
    }

    public static long object_setClass(long obj, long cls) {
        long __functionAddress = Functions.object_setClass;
        if (Checks.CHECKS) {
            Checks.checkPointer(cls);
        }
        return JNI.invokePPP(__functionAddress, obj, cls);
    }

    public static long nobject_getClassName(long obj) {
        long __functionAddress = Functions.object_getClassName;
        return JNI.invokePP(__functionAddress, obj);
    }

    public static String object_getClassName(long obj) {
        long __result = ObjCRuntime.nobject_getClassName(obj);
        return MemoryUtil.memUTF8(__result);
    }

    public static long object_getIndexedIvars(long obj) {
        long __functionAddress = Functions.object_getIndexedIvars;
        if (Checks.CHECKS) {
            Checks.checkPointer(obj);
        }
        return JNI.invokePP(__functionAddress, obj);
    }

    public static long object_getIvar(long obj, long ivar) {
        long __functionAddress = Functions.object_getIvar;
        if (Checks.CHECKS) {
            Checks.checkPointer(ivar);
        }
        return JNI.invokePPP(__functionAddress, obj, ivar);
    }

    public static void object_setIvar(long obj, long ivar, long value) {
        long __functionAddress = Functions.object_setIvar;
        if (Checks.CHECKS) {
            Checks.checkPointer(obj);
            Checks.checkPointer(ivar);
            Checks.checkPointer(value);
        }
        JNI.invokePPPV(__functionAddress, obj, ivar, value);
    }

    public static long nobject_setInstanceVariable(long obj, long name, long value) {
        long __functionAddress = Functions.object_setInstanceVariable;
        if (Checks.CHECKS) {
            Checks.checkPointer(obj);
        }
        return JNI.invokePPPP(__functionAddress, obj, name, value);
    }

    public static long object_setInstanceVariable(long obj, ByteBuffer name, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return ObjCRuntime.nobject_setInstanceVariable(obj, MemoryUtil.memAddress(name), MemoryUtil.memAddress(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long object_setInstanceVariable(long obj, CharSequence name, ByteBuffer value) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.UTF8(name);
            long l = ObjCRuntime.nobject_setInstanceVariable(obj, MemoryUtil.memAddress(nameEncoded), MemoryUtil.memAddress(value));
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nobject_getInstanceVariable(long obj, long name, long outValue) {
        long __functionAddress = Functions.object_getInstanceVariable;
        if (Checks.CHECKS) {
            Checks.checkPointer(obj);
        }
        return JNI.invokePPPP(__functionAddress, obj, name, outValue);
    }

    public static long object_getInstanceVariable(long obj, ByteBuffer name, PointerBuffer outValue) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return ObjCRuntime.nobject_getInstanceVariable(obj, MemoryUtil.memAddress(name), MemoryUtil.memAddress(outValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long object_getInstanceVariable(long obj, CharSequence name, PointerBuffer outValue) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.UTF8(name);
            long l = ObjCRuntime.nobject_getInstanceVariable(obj, MemoryUtil.memAddress(nameEncoded), MemoryUtil.memAddress(outValue));
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nobjc_getClass(long name) {
        long __functionAddress = Functions.objc_getClass;
        return JNI.invokePP(__functionAddress, name);
    }

    public static long objc_getClass(ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return ObjCRuntime.nobjc_getClass(MemoryUtil.memAddress(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long objc_getClass(CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.UTF8(name);
            long l = ObjCRuntime.nobjc_getClass(MemoryUtil.memAddress(nameEncoded));
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nobjc_getMetaClass(long name) {
        long __functionAddress = Functions.objc_getMetaClass;
        return JNI.invokePP(__functionAddress, name);
    }

    public static long objc_getMetaClass(ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return ObjCRuntime.nobjc_getMetaClass(MemoryUtil.memAddress(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long objc_getMetaClass(CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.UTF8(name);
            long l = ObjCRuntime.nobjc_getMetaClass(MemoryUtil.memAddress(nameEncoded));
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nobjc_lookUpClass(long name) {
        long __functionAddress = Functions.objc_lookUpClass;
        return JNI.invokePP(__functionAddress, name);
    }

    public static long objc_lookUpClass(ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return ObjCRuntime.nobjc_lookUpClass(MemoryUtil.memAddress(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long objc_lookUpClass(CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.UTF8(name);
            long l = ObjCRuntime.nobjc_lookUpClass(MemoryUtil.memAddress(nameEncoded));
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nobjc_getRequiredClass(long name) {
        long __functionAddress = Functions.objc_getRequiredClass;
        return JNI.invokePP(__functionAddress, name);
    }

    public static long objc_getRequiredClass(ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return ObjCRuntime.nobjc_getRequiredClass(MemoryUtil.memAddress(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long objc_getRequiredClass(CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.UTF8(name);
            long l = ObjCRuntime.nobjc_getRequiredClass(MemoryUtil.memAddress(nameEncoded));
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nobjc_getClassList(long buffer, int bufferCount) {
        long __functionAddress = Functions.objc_getClassList;
        return JNI.invokePI(__functionAddress, buffer, bufferCount);
    }

    public static int objc_getClassList(PointerBuffer buffer) {
        return ObjCRuntime.nobjc_getClassList(MemoryUtil.memAddressSafe(buffer), Checks.remainingSafe(buffer));
    }

    public static long nobjc_copyClassList(long outCount) {
        long __functionAddress = Functions.objc_copyClassList;
        return JNI.invokePP(__functionAddress, outCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PointerBuffer objc_copyClassList() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        IntBuffer outCount = stack.callocInt(1);
        try {
            long __result = ObjCRuntime.nobjc_copyClassList(MemoryUtil.memAddress(outCount));
            PointerBuffer pointerBuffer = MemoryUtil.memPointerBuffer(__result, outCount.get(0));
            return pointerBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nclass_getName(long cls) {
        long __functionAddress = Functions.class_getName;
        return JNI.invokePP(__functionAddress, cls);
    }

    public static String class_getName(long cls) {
        long __result = ObjCRuntime.nclass_getName(cls);
        return MemoryUtil.memUTF8(__result);
    }

    public static boolean class_isMetaClass(long cls) {
        long __functionAddress = Functions.class_isMetaClass;
        return JNI.invokePZ(__functionAddress, cls);
    }

    public static long class_getSuperclass(long cls) {
        long __functionAddress = Functions.class_getSuperclass;
        return JNI.invokePP(__functionAddress, cls);
    }

    public static int class_getVersion(long cls) {
        long __functionAddress = Functions.class_getVersion;
        if (Checks.CHECKS) {
            Checks.checkPointer(cls);
        }
        return JNI.invokePI(__functionAddress, cls);
    }

    public static void class_setVersion(long cls, int version) {
        long __functionAddress = Functions.class_setVersion;
        if (Checks.CHECKS) {
            Checks.checkPointer(cls);
        }
        JNI.invokePV(__functionAddress, cls, version);
    }

    public static long class_getInstanceSize(long cls) {
        long __functionAddress = Functions.class_getInstanceSize;
        return JNI.invokePP(__functionAddress, cls);
    }

    public static long nclass_getInstanceVariable(long cls, long name) {
        long __functionAddress = Functions.class_getInstanceVariable;
        if (Checks.CHECKS) {
            Checks.checkPointer(cls);
        }
        return JNI.invokePPP(__functionAddress, cls, name);
    }

    public static long class_getInstanceVariable(long cls, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return ObjCRuntime.nclass_getInstanceVariable(cls, MemoryUtil.memAddress(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long class_getInstanceVariable(long cls, CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.UTF8(name);
            long l = ObjCRuntime.nclass_getInstanceVariable(cls, MemoryUtil.memAddress(nameEncoded));
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nclass_getClassVariable(long cls, long name) {
        long __functionAddress = Functions.class_getClassVariable;
        if (Checks.CHECKS) {
            Checks.checkPointer(cls);
        }
        return JNI.invokePPP(__functionAddress, cls, name);
    }

    public static long class_getClassVariable(long cls, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return ObjCRuntime.nclass_getClassVariable(cls, MemoryUtil.memAddress(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long class_getClassVariable(long cls, CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.UTF8(name);
            long l = ObjCRuntime.nclass_getClassVariable(cls, MemoryUtil.memAddress(nameEncoded));
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nclass_copyIvarList(long cls, long outCount) {
        long __functionAddress = Functions.class_copyIvarList;
        return JNI.invokePPP(__functionAddress, cls, outCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PointerBuffer class_copyIvarList(long cls) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        IntBuffer outCount = stack.callocInt(1);
        try {
            long __result = ObjCRuntime.nclass_copyIvarList(cls, MemoryUtil.memAddress(outCount));
            PointerBuffer pointerBuffer = MemoryUtil.memPointerBuffer(__result, outCount.get(0));
            return pointerBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long class_getInstanceMethod(long cls, long name) {
        long __functionAddress = Functions.class_getInstanceMethod;
        if (Checks.CHECKS) {
            Checks.checkPointer(cls);
            Checks.checkPointer(name);
        }
        return JNI.invokePPP(__functionAddress, cls, name);
    }

    public static long class_getClassMethod(long cls, long name) {
        long __functionAddress = Functions.class_getClassMethod;
        if (Checks.CHECKS) {
            Checks.checkPointer(cls);
            Checks.checkPointer(name);
        }
        return JNI.invokePPP(__functionAddress, cls, name);
    }

    public static long class_getMethodImplementation(long cls, long name) {
        long __functionAddress = Functions.class_getMethodImplementation;
        if (Checks.CHECKS) {
            Checks.checkPointer(name);
        }
        return JNI.invokePPP(__functionAddress, cls, name);
    }

    public static boolean class_respondsToSelector(long cls, long name) {
        long __functionAddress = Functions.class_respondsToSelector;
        if (Checks.CHECKS) {
            Checks.checkPointer(cls);
            Checks.checkPointer(name);
        }
        return JNI.invokePPZ(__functionAddress, cls, name);
    }

    public static long nclass_copyMethodList(long cls, long outCount) {
        long __functionAddress = Functions.class_copyMethodList;
        return JNI.invokePPP(__functionAddress, cls, outCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PointerBuffer class_copyMethodList(long cls) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        IntBuffer outCount = stack.callocInt(1);
        try {
            long __result = ObjCRuntime.nclass_copyMethodList(cls, MemoryUtil.memAddress(outCount));
            PointerBuffer pointerBuffer = MemoryUtil.memPointerBuffer(__result, outCount.get(0));
            return pointerBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean class_conformsToProtocol(long cls, long protocol) {
        long __functionAddress = Functions.class_conformsToProtocol;
        if (Checks.CHECKS) {
            Checks.checkPointer(cls);
            Checks.checkPointer(protocol);
        }
        return JNI.invokePPZ(__functionAddress, cls, protocol);
    }

    public static long nclass_copyProtocolList(long cls, long outCount) {
        long __functionAddress = Functions.class_copyProtocolList;
        return JNI.invokePPP(__functionAddress, cls, outCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PointerBuffer class_copyProtocolList(long cls) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        IntBuffer outCount = stack.callocInt(1);
        try {
            long __result = ObjCRuntime.nclass_copyProtocolList(cls, MemoryUtil.memAddress(outCount));
            PointerBuffer pointerBuffer = MemoryUtil.memPointerBuffer(__result, outCount.get(0));
            return pointerBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nclass_getProperty(long cls, long name) {
        long __functionAddress = Functions.class_getProperty;
        return JNI.invokePPP(__functionAddress, cls, name);
    }

    public static long class_getProperty(long cls, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return ObjCRuntime.nclass_getProperty(cls, MemoryUtil.memAddress(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long class_getProperty(long cls, CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.UTF8(name);
            long l = ObjCRuntime.nclass_getProperty(cls, MemoryUtil.memAddress(nameEncoded));
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nclass_copyPropertyList(long cls, long outCount) {
        long __functionAddress = Functions.class_copyPropertyList;
        return JNI.invokePPP(__functionAddress, cls, outCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PointerBuffer class_copyPropertyList(long cls) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        IntBuffer outCount = stack.callocInt(1);
        try {
            long __result = ObjCRuntime.nclass_copyPropertyList(cls, MemoryUtil.memAddress(outCount));
            PointerBuffer pointerBuffer = MemoryUtil.memPointerBuffer(__result, outCount.get(0));
            return pointerBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nclass_getIvarLayout(long cls) {
        long __functionAddress = Functions.class_getIvarLayout;
        if (Checks.CHECKS) {
            Checks.checkPointer(cls);
        }
        return JNI.invokePP(__functionAddress, cls);
    }

    public static String class_getIvarLayout(long cls) {
        long __result = ObjCRuntime.nclass_getIvarLayout(cls);
        return MemoryUtil.memASCII(__result);
    }

    public static long nclass_getWeakIvarLayout(long cls) {
        long __functionAddress = Functions.class_getWeakIvarLayout;
        if (Checks.CHECKS) {
            Checks.checkPointer(cls);
        }
        return JNI.invokePP(__functionAddress, cls);
    }

    public static String class_getWeakIvarLayout(long cls) {
        long __result = ObjCRuntime.nclass_getWeakIvarLayout(cls);
        return MemoryUtil.memASCII(__result);
    }

    public static boolean nclass_addMethod(long cls, long name, long imp, long types) {
        long __functionAddress = Functions.class_addMethod;
        if (Checks.CHECKS) {
            Checks.checkPointer(cls);
            Checks.checkPointer(name);
            Checks.checkPointer(imp);
        }
        return JNI.invokePPPPZ(__functionAddress, cls, name, imp, types);
    }

    public static boolean class_addMethod(long cls, long name, long imp, ByteBuffer types) {
        if (Checks.CHECKS) {
            Checks.checkNT1(types);
        }
        return ObjCRuntime.nclass_addMethod(cls, name, imp, MemoryUtil.memAddress(types));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean class_addMethod(long cls, long name, long imp, CharSequence types) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer typesEncoded = stack.UTF8(types);
            boolean bl = ObjCRuntime.nclass_addMethod(cls, name, imp, MemoryUtil.memAddress(typesEncoded));
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nclass_replaceMethod(long cls, long name, long imp, long types) {
        long __functionAddress = Functions.class_replaceMethod;
        if (Checks.CHECKS) {
            Checks.checkPointer(cls);
            Checks.checkPointer(name);
            Checks.checkPointer(imp);
        }
        return JNI.invokePPPPP(__functionAddress, cls, name, imp, types);
    }

    public static long class_replaceMethod(long cls, long name, long imp, ByteBuffer types) {
        if (Checks.CHECKS) {
            Checks.checkNT1(types);
        }
        return ObjCRuntime.nclass_replaceMethod(cls, name, imp, MemoryUtil.memAddress(types));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long class_replaceMethod(long cls, long name, long imp, CharSequence types) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer typesEncoded = stack.UTF8(types);
            long l = ObjCRuntime.nclass_replaceMethod(cls, name, imp, MemoryUtil.memAddress(typesEncoded));
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean nclass_addIvar(long cls, long name, long size, byte alignment, long types) {
        long __functionAddress = Functions.class_addIvar;
        if (Checks.CHECKS) {
            Checks.checkPointer(cls);
        }
        return JNI.invokePPPPZ(__functionAddress, cls, name, size, alignment, types);
    }

    public static boolean class_addIvar(long cls, ByteBuffer name, long size, byte alignment, ByteBuffer types) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
            Checks.checkNT1(types);
        }
        return ObjCRuntime.nclass_addIvar(cls, MemoryUtil.memAddress(name), size, alignment, MemoryUtil.memAddress(types));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean class_addIvar(long cls, CharSequence name, long size, byte alignment, CharSequence types) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.UTF8(name);
            ByteBuffer typesEncoded = stack.UTF8(types);
            boolean bl = ObjCRuntime.nclass_addIvar(cls, MemoryUtil.memAddress(nameEncoded), size, alignment, MemoryUtil.memAddress(typesEncoded));
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean class_addProtocol(long cls, long protocol) {
        long __functionAddress = Functions.class_addProtocol;
        if (Checks.CHECKS) {
            Checks.checkPointer(cls);
            Checks.checkPointer(protocol);
        }
        return JNI.invokePPZ(__functionAddress, cls, protocol);
    }

    public static boolean nclass_addProperty(long cls, long name, long attributes, int attributeCount) {
        long __functionAddress = Functions.class_addProperty;
        if (Checks.CHECKS) {
            Checks.checkPointer(cls);
            ObjCPropertyAttribute.validate(attributes, attributeCount);
        }
        return JNI.invokePPPZ(__functionAddress, cls, name, attributes, attributeCount);
    }

    public static boolean class_addProperty(long cls, ByteBuffer name, ObjCPropertyAttribute.Buffer attributes) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return ObjCRuntime.nclass_addProperty(cls, MemoryUtil.memAddress(name), attributes.address(), attributes.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean class_addProperty(long cls, CharSequence name, ObjCPropertyAttribute.Buffer attributes) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.UTF8(name);
            boolean bl = ObjCRuntime.nclass_addProperty(cls, MemoryUtil.memAddress(nameEncoded), attributes.address(), attributes.remaining());
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nclass_replaceProperty(long cls, long name, long attributes, int attributeCount) {
        long __functionAddress = Functions.class_replaceProperty;
        if (Checks.CHECKS) {
            Checks.checkPointer(cls);
            ObjCPropertyAttribute.validate(attributes, attributeCount);
        }
        JNI.invokePPPV(__functionAddress, cls, name, attributes, attributeCount);
    }

    public static void class_replaceProperty(long cls, ByteBuffer name, ObjCPropertyAttribute.Buffer attributes) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        ObjCRuntime.nclass_replaceProperty(cls, MemoryUtil.memAddress(name), attributes.address(), attributes.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void class_replaceProperty(long cls, CharSequence name, ObjCPropertyAttribute.Buffer attributes) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.UTF8(name);
            ObjCRuntime.nclass_replaceProperty(cls, MemoryUtil.memAddress(nameEncoded), attributes.address(), attributes.remaining());
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nclass_setIvarLayout(long cls, long layout) {
        long __functionAddress = Functions.class_setIvarLayout;
        if (Checks.CHECKS) {
            Checks.checkPointer(cls);
        }
        JNI.invokePPV(__functionAddress, cls, layout);
    }

    public static void class_setIvarLayout(long cls, ByteBuffer layout) {
        if (Checks.CHECKS) {
            Checks.checkNT1(layout);
        }
        ObjCRuntime.nclass_setIvarLayout(cls, MemoryUtil.memAddress(layout));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void class_setIvarLayout(long cls, CharSequence layout) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer layoutEncoded = stack.ASCII(layout);
            ObjCRuntime.nclass_setIvarLayout(cls, MemoryUtil.memAddress(layoutEncoded));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nclass_setWeakIvarLayout(long cls, long layout) {
        long __functionAddress = Functions.class_setWeakIvarLayout;
        if (Checks.CHECKS) {
            Checks.checkPointer(cls);
        }
        JNI.invokePPV(__functionAddress, cls, layout);
    }

    public static void class_setWeakIvarLayout(long cls, ByteBuffer layout) {
        if (Checks.CHECKS) {
            Checks.checkNT1(layout);
        }
        ObjCRuntime.nclass_setWeakIvarLayout(cls, MemoryUtil.memAddress(layout));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void class_setWeakIvarLayout(long cls, CharSequence layout) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer layoutEncoded = stack.ASCII(layout);
            ObjCRuntime.nclass_setWeakIvarLayout(cls, MemoryUtil.memAddress(layoutEncoded));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long class_createInstance(long cls, long extraBytes) {
        long __functionAddress = Functions.class_createInstance;
        if (Checks.CHECKS) {
            Checks.checkPointer(cls);
        }
        return JNI.invokePPP(__functionAddress, cls, extraBytes);
    }

    public static long nobjc_constructInstance(long cls, long bytes) {
        long __functionAddress = Functions.objc_constructInstance;
        return JNI.invokePPP(__functionAddress, cls, bytes);
    }

    public static long objc_constructInstance(long cls, ByteBuffer bytes) {
        return ObjCRuntime.nobjc_constructInstance(cls, MemoryUtil.memAddressSafe(bytes));
    }

    public static long objc_destructInstance(long obj) {
        long __functionAddress = Functions.objc_destructInstance;
        if (Checks.CHECKS) {
            Checks.checkPointer(obj);
        }
        return JNI.invokePP(__functionAddress, obj);
    }

    public static long nobjc_allocateClassPair(long superclass, long name, long extraBytes) {
        long __functionAddress = Functions.objc_allocateClassPair;
        return JNI.invokePPPP(__functionAddress, superclass, name, extraBytes);
    }

    public static long objc_allocateClassPair(long superclass, ByteBuffer name, long extraBytes) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return ObjCRuntime.nobjc_allocateClassPair(superclass, MemoryUtil.memAddress(name), extraBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long objc_allocateClassPair(long superclass, CharSequence name, long extraBytes) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.UTF8(name);
            long l = ObjCRuntime.nobjc_allocateClassPair(superclass, MemoryUtil.memAddress(nameEncoded), extraBytes);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void objc_registerClassPair(long cls) {
        long __functionAddress = Functions.objc_registerClassPair;
        if (Checks.CHECKS) {
            Checks.checkPointer(cls);
        }
        JNI.invokePV(__functionAddress, cls);
    }

    public static void objc_disposeClassPair(long cls) {
        long __functionAddress = Functions.objc_disposeClassPair;
        if (Checks.CHECKS) {
            Checks.checkPointer(cls);
        }
        JNI.invokePV(__functionAddress, cls);
    }

    public static long method_getName(long m) {
        long __functionAddress = Functions.method_getName;
        if (Checks.CHECKS) {
            Checks.checkPointer(m);
        }
        return JNI.invokePP(__functionAddress, m);
    }

    public static long method_getImplementation(long m) {
        long __functionAddress = Functions.method_getImplementation;
        if (Checks.CHECKS) {
            Checks.checkPointer(m);
        }
        return JNI.invokePP(__functionAddress, m);
    }

    public static long nmethod_getTypeEncoding(long m) {
        long __functionAddress = Functions.method_getTypeEncoding;
        if (Checks.CHECKS) {
            Checks.checkPointer(m);
        }
        return JNI.invokePP(__functionAddress, m);
    }

    public static String method_getTypeEncoding(long m) {
        long __result = ObjCRuntime.nmethod_getTypeEncoding(m);
        return MemoryUtil.memUTF8(__result);
    }

    public static int method_getNumberOfArguments(long m) {
        long __functionAddress = Functions.method_getNumberOfArguments;
        if (Checks.CHECKS) {
            Checks.checkPointer(m);
        }
        return JNI.invokePI(__functionAddress, m);
    }

    public static long nmethod_copyReturnType(long m) {
        long __functionAddress = Functions.method_copyReturnType;
        if (Checks.CHECKS) {
            Checks.checkPointer(m);
        }
        return JNI.invokePP(__functionAddress, m);
    }

    public static String method_copyReturnType(long m) {
        long __result = ObjCRuntime.nmethod_copyReturnType(m);
        return MemoryUtil.memUTF8(__result);
    }

    public static long nmethod_copyArgumentType(long m, int index) {
        long __functionAddress = Functions.method_copyArgumentType;
        if (Checks.CHECKS) {
            Checks.checkPointer(m);
        }
        return JNI.invokePP(__functionAddress, m, index);
    }

    public static String method_copyArgumentType(long m, int index) {
        long __result = ObjCRuntime.nmethod_copyArgumentType(m, index);
        return MemoryUtil.memUTF8(__result);
    }

    public static void nmethod_getReturnType(long m, long dst, long dst_len) {
        long __functionAddress = Functions.method_getReturnType;
        if (Checks.CHECKS) {
            Checks.checkPointer(m);
        }
        JNI.invokePPPV(__functionAddress, m, dst, dst_len);
    }

    public static void method_getReturnType(long m, ByteBuffer dst) {
        ObjCRuntime.nmethod_getReturnType(m, MemoryUtil.memAddress(dst), dst.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String method_getReturnType(long m, long dst_len) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer dst = stack.malloc((int)dst_len);
            ObjCRuntime.nmethod_getReturnType(m, MemoryUtil.memAddress(dst), dst_len);
            String string = MemoryUtil.memUTF8(MemoryUtil.memByteBufferNT1(MemoryUtil.memAddress(dst), (int)dst_len));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nmethod_getArgumentType(long m, int index, long dst, long dst_len) {
        long __functionAddress = Functions.method_getArgumentType;
        if (Checks.CHECKS) {
            Checks.checkPointer(m);
        }
        JNI.invokePPPV(__functionAddress, m, index, dst, dst_len);
    }

    public static void method_getArgumentType(long m, int index, ByteBuffer dst) {
        ObjCRuntime.nmethod_getArgumentType(m, index, MemoryUtil.memAddress(dst), dst.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String method_getArgumentType(long m, int index, long dst_len) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer dst = stack.malloc((int)dst_len);
            ObjCRuntime.nmethod_getArgumentType(m, index, MemoryUtil.memAddress(dst), dst_len);
            String string = MemoryUtil.memUTF8(MemoryUtil.memByteBufferNT1(MemoryUtil.memAddress(dst), (int)dst_len));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long method_setImplementation(long m, long imp) {
        long __functionAddress = Functions.method_setImplementation;
        if (Checks.CHECKS) {
            Checks.checkPointer(m);
            Checks.checkPointer(imp);
        }
        return JNI.invokePPP(__functionAddress, m, imp);
    }

    public static void method_exchangeImplementations(long m1, long m2) {
        long __functionAddress = Functions.method_exchangeImplementations;
        if (Checks.CHECKS) {
            Checks.checkPointer(m1);
            Checks.checkPointer(m2);
        }
        JNI.invokePPV(__functionAddress, m1, m2);
    }

    public static long nivar_getName(long v) {
        long __functionAddress = Functions.ivar_getName;
        if (Checks.CHECKS) {
            Checks.checkPointer(v);
        }
        return JNI.invokePP(__functionAddress, v);
    }

    public static String ivar_getName(long v) {
        long __result = ObjCRuntime.nivar_getName(v);
        return MemoryUtil.memUTF8(__result);
    }

    public static long nivar_getTypeEncoding(long v) {
        long __functionAddress = Functions.ivar_getTypeEncoding;
        if (Checks.CHECKS) {
            Checks.checkPointer(v);
        }
        return JNI.invokePP(__functionAddress, v);
    }

    public static String ivar_getTypeEncoding(long v) {
        long __result = ObjCRuntime.nivar_getTypeEncoding(v);
        return MemoryUtil.memUTF8(__result);
    }

    public static long ivar_getOffset(long v) {
        long __functionAddress = Functions.ivar_getOffset;
        if (Checks.CHECKS) {
            Checks.checkPointer(v);
        }
        return JNI.invokePP(__functionAddress, v);
    }

    public static long nproperty_getName(long property) {
        long __functionAddress = Functions.property_getName;
        if (Checks.CHECKS) {
            Checks.checkPointer(property);
        }
        return JNI.invokePP(__functionAddress, property);
    }

    public static String property_getName(long property) {
        long __result = ObjCRuntime.nproperty_getName(property);
        return MemoryUtil.memUTF8(__result);
    }

    public static long nproperty_getAttributes(long property) {
        long __functionAddress = Functions.property_getAttributes;
        if (Checks.CHECKS) {
            Checks.checkPointer(property);
        }
        return JNI.invokePP(__functionAddress, property);
    }

    public static String property_getAttributes(long property) {
        long __result = ObjCRuntime.nproperty_getAttributes(property);
        return MemoryUtil.memUTF8(__result);
    }

    public static long nproperty_copyAttributeList(long property, long outCount) {
        long __functionAddress = Functions.property_copyAttributeList;
        if (Checks.CHECKS) {
            Checks.checkPointer(property);
        }
        return JNI.invokePPP(__functionAddress, property, outCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjCPropertyAttribute.Buffer property_copyAttributeList(long property) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        IntBuffer outCount = stack.callocInt(1);
        try {
            long __result = ObjCRuntime.nproperty_copyAttributeList(property, MemoryUtil.memAddress(outCount));
            ObjCPropertyAttribute.Buffer buffer = ObjCPropertyAttribute.create(__result, outCount.get(0));
            return buffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nproperty_copyAttributeValue(long property, long attributeName) {
        long __functionAddress = Functions.property_copyAttributeValue;
        if (Checks.CHECKS) {
            Checks.checkPointer(property);
        }
        return JNI.invokePPP(__functionAddress, property, attributeName);
    }

    public static String property_copyAttributeValue(long property, ByteBuffer attributeName) {
        if (Checks.CHECKS) {
            Checks.checkNT1(attributeName);
        }
        long __result = ObjCRuntime.nproperty_copyAttributeValue(property, MemoryUtil.memAddress(attributeName));
        return MemoryUtil.memUTF8(__result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String property_copyAttributeValue(long property, CharSequence attributeName) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer attributeNameEncoded = stack.UTF8(attributeName);
            long __result = ObjCRuntime.nproperty_copyAttributeValue(property, MemoryUtil.memAddress(attributeNameEncoded));
            String string = MemoryUtil.memUTF8(__result);
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nobjc_getProtocol(long name) {
        long __functionAddress = Functions.objc_getProtocol;
        return JNI.invokePP(__functionAddress, name);
    }

    public static long objc_getProtocol(ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return ObjCRuntime.nobjc_getProtocol(MemoryUtil.memAddress(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long objc_getProtocol(CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.UTF8(name);
            long l = ObjCRuntime.nobjc_getProtocol(MemoryUtil.memAddress(nameEncoded));
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nobjc_copyProtocolList(long outCount) {
        long __functionAddress = Functions.objc_copyProtocolList;
        return JNI.invokePP(__functionAddress, outCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PointerBuffer objc_copyProtocolList() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        IntBuffer outCount = stack.callocInt(1);
        try {
            long __result = ObjCRuntime.nobjc_copyProtocolList(MemoryUtil.memAddress(outCount));
            PointerBuffer pointerBuffer = MemoryUtil.memPointerBuffer(__result, outCount.get(0));
            return pointerBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean protocol_conformsToProtocol(long proto, long other) {
        long __functionAddress = Functions.protocol_conformsToProtocol;
        if (Checks.CHECKS) {
            Checks.checkPointer(proto);
            Checks.checkPointer(other);
        }
        return JNI.invokePPZ(__functionAddress, proto, other);
    }

    public static boolean protocol_isEqual(long proto, long other) {
        long __functionAddress = Functions.protocol_isEqual;
        if (Checks.CHECKS) {
            Checks.checkPointer(proto);
            Checks.checkPointer(other);
        }
        return JNI.invokePPZ(__functionAddress, proto, other);
    }

    public static long nprotocol_getName(long p) {
        long __functionAddress = Functions.protocol_getName;
        if (Checks.CHECKS) {
            Checks.checkPointer(p);
        }
        return JNI.invokePP(__functionAddress, p);
    }

    public static String protocol_getName(long p) {
        long __result = ObjCRuntime.nprotocol_getName(p);
        return MemoryUtil.memUTF8(__result);
    }

    public static native void nprotocol_getMethodDescription(long var0, long var2, long var4, boolean var6, boolean var7, long var8);

    public static void nprotocol_getMethodDescription(long p, long aSel, boolean isRequiredMethod, boolean isInstanceMethod, long __result) {
        long __functionAddress = Functions.protocol_getMethodDescription;
        if (Checks.CHECKS) {
            Checks.checkPointer(p);
            Checks.checkPointer(aSel);
        }
        ObjCRuntime.nprotocol_getMethodDescription(__functionAddress, p, aSel, isRequiredMethod, isInstanceMethod, __result);
    }

    public static ObjCMethodDescription protocol_getMethodDescription(long p, long aSel, boolean isRequiredMethod, boolean isInstanceMethod, ObjCMethodDescription __result) {
        ObjCRuntime.nprotocol_getMethodDescription(p, aSel, isRequiredMethod, isInstanceMethod, __result.address());
        return __result;
    }

    public static long nprotocol_copyMethodDescriptionList(long p, boolean isRequiredMethod, boolean isInstanceMethod, long outCount) {
        long __functionAddress = Functions.protocol_copyMethodDescriptionList;
        if (Checks.CHECKS) {
            Checks.checkPointer(p);
        }
        return JNI.invokePPP(__functionAddress, p, isRequiredMethod, isInstanceMethod, outCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjCMethodDescription.Buffer protocol_copyMethodDescriptionList(long p, boolean isRequiredMethod, boolean isInstanceMethod) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        IntBuffer outCount = stack.callocInt(1);
        try {
            long __result = ObjCRuntime.nprotocol_copyMethodDescriptionList(p, isRequiredMethod, isInstanceMethod, MemoryUtil.memAddress(outCount));
            ObjCMethodDescription.Buffer buffer = ObjCMethodDescription.create(__result, outCount.get(0));
            return buffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nprotocol_getProperty(long proto, long name, boolean isRequiredProperty, boolean isInstanceProperty) {
        long __functionAddress = Functions.protocol_getProperty;
        if (Checks.CHECKS) {
            Checks.checkPointer(proto);
        }
        return JNI.invokePPP(__functionAddress, proto, name, isRequiredProperty, isInstanceProperty);
    }

    public static long protocol_getProperty(long proto, ByteBuffer name, boolean isRequiredProperty, boolean isInstanceProperty) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return ObjCRuntime.nprotocol_getProperty(proto, MemoryUtil.memAddress(name), isRequiredProperty, isInstanceProperty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long protocol_getProperty(long proto, CharSequence name, boolean isRequiredProperty, boolean isInstanceProperty) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.UTF8(name);
            long l = ObjCRuntime.nprotocol_getProperty(proto, MemoryUtil.memAddress(nameEncoded), isRequiredProperty, isInstanceProperty);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nprotocol_copyPropertyList(long proto, long outCount) {
        long __functionAddress = Functions.protocol_copyPropertyList;
        if (Checks.CHECKS) {
            Checks.checkPointer(proto);
        }
        return JNI.invokePPP(__functionAddress, proto, outCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PointerBuffer protocol_copyPropertyList(long proto) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        IntBuffer outCount = stack.callocInt(1);
        try {
            long __result = ObjCRuntime.nprotocol_copyPropertyList(proto, MemoryUtil.memAddress(outCount));
            PointerBuffer pointerBuffer = MemoryUtil.memPointerBuffer(__result, outCount.get(0));
            return pointerBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nprotocol_copyProtocolList(long proto, long outCount) {
        long __functionAddress = Functions.protocol_copyProtocolList;
        if (Checks.CHECKS) {
            Checks.checkPointer(proto);
        }
        return JNI.invokePPP(__functionAddress, proto, outCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PointerBuffer protocol_copyProtocolList(long proto) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        IntBuffer outCount = stack.callocInt(1);
        try {
            long __result = ObjCRuntime.nprotocol_copyProtocolList(proto, MemoryUtil.memAddress(outCount));
            PointerBuffer pointerBuffer = MemoryUtil.memPointerBuffer(__result, outCount.get(0));
            return pointerBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nobjc_allocateProtocol(long name) {
        long __functionAddress = Functions.objc_allocateProtocol;
        return JNI.invokePP(__functionAddress, name);
    }

    public static long objc_allocateProtocol(ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return ObjCRuntime.nobjc_allocateProtocol(MemoryUtil.memAddress(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long objc_allocateProtocol(CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.UTF8(name);
            long l = ObjCRuntime.nobjc_allocateProtocol(MemoryUtil.memAddress(nameEncoded));
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void objc_registerProtocol(long proto) {
        long __functionAddress = Functions.objc_registerProtocol;
        if (Checks.CHECKS) {
            Checks.checkPointer(proto);
        }
        JNI.invokePV(__functionAddress, proto);
    }

    public static void nprotocol_addMethodDescription(long proto, long name, long types, boolean isRequiredMethod, boolean isInstanceMethod) {
        long __functionAddress = Functions.protocol_addMethodDescription;
        if (Checks.CHECKS) {
            Checks.checkPointer(proto);
            Checks.checkPointer(name);
        }
        JNI.invokePPPV(__functionAddress, proto, name, types, isRequiredMethod, isInstanceMethod);
    }

    public static void protocol_addMethodDescription(long proto, long name, ByteBuffer types, boolean isRequiredMethod, boolean isInstanceMethod) {
        if (Checks.CHECKS) {
            Checks.checkNT1(types);
        }
        ObjCRuntime.nprotocol_addMethodDescription(proto, name, MemoryUtil.memAddress(types), isRequiredMethod, isInstanceMethod);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void protocol_addMethodDescription(long proto, long name, CharSequence types, boolean isRequiredMethod, boolean isInstanceMethod) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer typesEncoded = stack.UTF8(types);
            ObjCRuntime.nprotocol_addMethodDescription(proto, name, MemoryUtil.memAddress(typesEncoded), isRequiredMethod, isInstanceMethod);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void protocol_addProtocol(long proto, long addition) {
        long __functionAddress = Functions.protocol_addProtocol;
        if (Checks.CHECKS) {
            Checks.checkPointer(proto);
            Checks.checkPointer(addition);
        }
        JNI.invokePPV(__functionAddress, proto, addition);
    }

    public static void nprotocol_addProperty(long proto, long name, long attributes, int attributeCount, boolean isRequiredProperty, boolean isInstanceProperty) {
        long __functionAddress = Functions.protocol_addProperty;
        if (Checks.CHECKS) {
            Checks.checkPointer(proto);
            ObjCPropertyAttribute.validate(attributes, attributeCount);
        }
        JNI.invokePPPV(__functionAddress, proto, name, attributes, attributeCount, isRequiredProperty, isInstanceProperty);
    }

    public static void protocol_addProperty(long proto, ByteBuffer name, ObjCPropertyAttribute.Buffer attributes, boolean isRequiredProperty, boolean isInstanceProperty) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        ObjCRuntime.nprotocol_addProperty(proto, MemoryUtil.memAddress(name), attributes.address(), attributes.remaining(), isRequiredProperty, isInstanceProperty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void protocol_addProperty(long proto, CharSequence name, ObjCPropertyAttribute.Buffer attributes, boolean isRequiredProperty, boolean isInstanceProperty) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.UTF8(name);
            ObjCRuntime.nprotocol_addProperty(proto, MemoryUtil.memAddress(nameEncoded), attributes.address(), attributes.remaining(), isRequiredProperty, isInstanceProperty);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nobjc_copyImageNames(long outCount) {
        long __functionAddress = Functions.objc_copyImageNames;
        return JNI.invokePP(__functionAddress, outCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PointerBuffer objc_copyImageNames() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        IntBuffer outCount = stack.callocInt(1);
        try {
            long __result = ObjCRuntime.nobjc_copyImageNames(MemoryUtil.memAddress(outCount));
            PointerBuffer pointerBuffer = MemoryUtil.memPointerBuffer(__result, outCount.get(0));
            return pointerBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nclass_getImageName(long cls) {
        long __functionAddress = Functions.class_getImageName;
        if (Checks.CHECKS) {
            Checks.checkPointer(cls);
        }
        return JNI.invokePP(__functionAddress, cls);
    }

    public static String class_getImageName(long cls) {
        long __result = ObjCRuntime.nclass_getImageName(cls);
        return MemoryUtil.memUTF8(__result);
    }

    public static long nobjc_copyClassNamesForImage(long image, long outCount) {
        long __functionAddress = Functions.objc_copyClassNamesForImage;
        return JNI.invokePPP(__functionAddress, image, outCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PointerBuffer objc_copyClassNamesForImage(ByteBuffer image) {
        if (Checks.CHECKS) {
            Checks.checkNT1(image);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        IntBuffer outCount = stack.callocInt(1);
        try {
            long __result = ObjCRuntime.nobjc_copyClassNamesForImage(MemoryUtil.memAddress(image), MemoryUtil.memAddress(outCount));
            PointerBuffer pointerBuffer = MemoryUtil.memPointerBuffer(__result, outCount.get(0));
            return pointerBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PointerBuffer objc_copyClassNamesForImage(CharSequence image) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer outCount = stack.callocInt(1);
            ByteBuffer imageEncoded = stack.UTF8(image);
            long __result = ObjCRuntime.nobjc_copyClassNamesForImage(MemoryUtil.memAddress(imageEncoded), MemoryUtil.memAddress(outCount));
            PointerBuffer pointerBuffer = MemoryUtil.memPointerBuffer(__result, outCount.get(0));
            return pointerBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nsel_getName(long sel) {
        long __functionAddress = Functions.sel_getName;
        if (Checks.CHECKS) {
            Checks.checkPointer(sel);
        }
        return JNI.invokePP(__functionAddress, sel);
    }

    public static String sel_getName(long sel) {
        long __result = ObjCRuntime.nsel_getName(sel);
        return MemoryUtil.memUTF8(__result);
    }

    public static long nsel_getUid(long str) {
        long __functionAddress = Functions.sel_getUid;
        return JNI.invokePP(__functionAddress, str);
    }

    public static long sel_getUid(ByteBuffer str) {
        if (Checks.CHECKS) {
            Checks.checkNT1(str);
        }
        return ObjCRuntime.nsel_getUid(MemoryUtil.memAddress(str));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long sel_getUid(CharSequence str) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer strEncoded = stack.UTF8(str);
            long l = ObjCRuntime.nsel_getUid(MemoryUtil.memAddress(strEncoded));
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nsel_registerName(long str) {
        long __functionAddress = Functions.sel_registerName;
        return JNI.invokePP(__functionAddress, str);
    }

    public static long sel_registerName(ByteBuffer str) {
        if (Checks.CHECKS) {
            Checks.checkNT1(str);
        }
        return ObjCRuntime.nsel_registerName(MemoryUtil.memAddress(str));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long sel_registerName(CharSequence str) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer strEncoded = stack.UTF8(str);
            long l = ObjCRuntime.nsel_registerName(MemoryUtil.memAddress(strEncoded));
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean sel_isEqual(long lhs, long rhs) {
        long __functionAddress = Functions.sel_isEqual;
        if (Checks.CHECKS) {
            Checks.checkPointer(lhs);
            Checks.checkPointer(rhs);
        }
        return JNI.invokePPZ(__functionAddress, lhs, rhs);
    }

    public static void objc_enumerationMutation(long obj) {
        long __functionAddress = Functions.objc_enumerationMutation;
        if (Checks.CHECKS) {
            Checks.checkPointer(obj);
        }
        JNI.invokePV(__functionAddress, obj);
    }

    public static void nobjc_setEnumerationMutationHandler(long handler) {
        long __functionAddress = Functions.objc_setEnumerationMutationHandler;
        JNI.invokePV(__functionAddress, handler);
    }

    public static void objc_setEnumerationMutationHandler(EnumerationMutationHandlerI handler) {
        ObjCRuntime.nobjc_setEnumerationMutationHandler(handler.address());
    }

    public static long imp_implementationWithBlock(long block) {
        long __functionAddress = Functions.imp_implementationWithBlock;
        if (Checks.CHECKS) {
            Checks.checkPointer(block);
        }
        return JNI.invokePP(__functionAddress, block);
    }

    public static long imp_getBlock(long anImp) {
        long __functionAddress = Functions.imp_getBlock;
        if (Checks.CHECKS) {
            Checks.checkPointer(anImp);
        }
        return JNI.invokePP(__functionAddress, anImp);
    }

    public static boolean imp_removeBlock(long anImp) {
        long __functionAddress = Functions.imp_removeBlock;
        if (Checks.CHECKS) {
            Checks.checkPointer(anImp);
        }
        return JNI.invokePZ(__functionAddress, anImp);
    }

    public static long nobjc_loadWeak(long location) {
        long __functionAddress = Functions.objc_loadWeak;
        return JNI.invokePP(__functionAddress, location);
    }

    public static long objc_loadWeak(PointerBuffer location) {
        return ObjCRuntime.nobjc_loadWeak(MemoryUtil.memAddressSafe(location));
    }

    public static long nobjc_storeWeak(long location, long obj) {
        long __functionAddress = Functions.objc_storeWeak;
        if (Checks.CHECKS) {
            Checks.checkPointer(obj);
        }
        return JNI.invokePPP(__functionAddress, location, obj);
    }

    public static long objc_storeWeak(PointerBuffer location, long obj) {
        return ObjCRuntime.nobjc_storeWeak(MemoryUtil.memAddress(location), obj);
    }

    public static void objc_setAssociatedObject(long object, long key, long value, long policy) {
        long __functionAddress = Functions.objc_setAssociatedObject;
        if (Checks.CHECKS) {
            Checks.checkPointer(object);
            Checks.checkPointer(key);
            Checks.checkPointer(value);
        }
        JNI.invokePPPPV(__functionAddress, object, key, value, policy);
    }

    public static long objc_getAssociatedObject(long object, long key) {
        long __functionAddress = Functions.objc_getAssociatedObject;
        if (Checks.CHECKS) {
            Checks.checkPointer(object);
            Checks.checkPointer(key);
        }
        return JNI.invokePPP(__functionAddress, object, key);
    }

    public static void objc_removeAssociatedObjects(long object) {
        long __functionAddress = Functions.objc_removeAssociatedObjects;
        if (Checks.CHECKS) {
            Checks.checkPointer(object);
        }
        JNI.invokePV(__functionAddress, object);
    }

    static /* synthetic */ SharedLibrary access$000() {
        return OBJC;
    }

    public static final class Functions {
        public static final long object_copy = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "object_copy");
        public static final long object_dispose = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "object_dispose");
        public static final long object_getClass = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "object_getClass");
        public static final long object_setClass = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "object_setClass");
        public static final long object_getClassName = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "object_getClassName");
        public static final long object_getIndexedIvars = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "object_getIndexedIvars");
        public static final long object_getIvar = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "object_getIvar");
        public static final long object_setIvar = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "object_setIvar");
        public static final long object_setInstanceVariable = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "object_setInstanceVariable");
        public static final long object_getInstanceVariable = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "object_getInstanceVariable");
        public static final long objc_getClass = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "objc_getClass");
        public static final long objc_getMetaClass = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "objc_getMetaClass");
        public static final long objc_lookUpClass = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "objc_lookUpClass");
        public static final long objc_getRequiredClass = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "objc_getRequiredClass");
        public static final long objc_getClassList = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "objc_getClassList");
        public static final long objc_copyClassList = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "objc_copyClassList");
        public static final long class_getName = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "class_getName");
        public static final long class_isMetaClass = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "class_isMetaClass");
        public static final long class_getSuperclass = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "class_getSuperclass");
        public static final long class_getVersion = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "class_getVersion");
        public static final long class_setVersion = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "class_setVersion");
        public static final long class_getInstanceSize = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "class_getInstanceSize");
        public static final long class_getInstanceVariable = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "class_getInstanceVariable");
        public static final long class_getClassVariable = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "class_getClassVariable");
        public static final long class_copyIvarList = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "class_copyIvarList");
        public static final long class_getInstanceMethod = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "class_getInstanceMethod");
        public static final long class_getClassMethod = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "class_getClassMethod");
        public static final long class_getMethodImplementation = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "class_getMethodImplementation");
        public static final long class_respondsToSelector = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "class_respondsToSelector");
        public static final long class_copyMethodList = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "class_copyMethodList");
        public static final long class_conformsToProtocol = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "class_conformsToProtocol");
        public static final long class_copyProtocolList = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "class_copyProtocolList");
        public static final long class_getProperty = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "class_getProperty");
        public static final long class_copyPropertyList = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "class_copyPropertyList");
        public static final long class_getIvarLayout = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "class_getIvarLayout");
        public static final long class_getWeakIvarLayout = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "class_getWeakIvarLayout");
        public static final long class_addMethod = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "class_addMethod");
        public static final long class_replaceMethod = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "class_replaceMethod");
        public static final long class_addIvar = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "class_addIvar");
        public static final long class_addProtocol = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "class_addProtocol");
        public static final long class_addProperty = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "class_addProperty");
        public static final long class_replaceProperty = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "class_replaceProperty");
        public static final long class_setIvarLayout = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "class_setIvarLayout");
        public static final long class_setWeakIvarLayout = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "class_setWeakIvarLayout");
        public static final long class_createInstance = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "class_createInstance");
        public static final long objc_constructInstance = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "objc_constructInstance");
        public static final long objc_destructInstance = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "objc_destructInstance");
        public static final long objc_allocateClassPair = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "objc_allocateClassPair");
        public static final long objc_registerClassPair = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "objc_registerClassPair");
        public static final long objc_disposeClassPair = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "objc_disposeClassPair");
        public static final long method_getName = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "method_getName");
        public static final long method_getImplementation = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "method_getImplementation");
        public static final long method_getTypeEncoding = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "method_getTypeEncoding");
        public static final long method_getNumberOfArguments = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "method_getNumberOfArguments");
        public static final long method_copyReturnType = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "method_copyReturnType");
        public static final long method_copyArgumentType = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "method_copyArgumentType");
        public static final long method_getReturnType = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "method_getReturnType");
        public static final long method_getArgumentType = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "method_getArgumentType");
        public static final long method_setImplementation = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "method_setImplementation");
        public static final long method_exchangeImplementations = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "method_exchangeImplementations");
        public static final long ivar_getName = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "ivar_getName");
        public static final long ivar_getTypeEncoding = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "ivar_getTypeEncoding");
        public static final long ivar_getOffset = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "ivar_getOffset");
        public static final long property_getName = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "property_getName");
        public static final long property_getAttributes = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "property_getAttributes");
        public static final long property_copyAttributeList = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "property_copyAttributeList");
        public static final long property_copyAttributeValue = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "property_copyAttributeValue");
        public static final long objc_getProtocol = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "objc_getProtocol");
        public static final long objc_copyProtocolList = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "objc_copyProtocolList");
        public static final long protocol_conformsToProtocol = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "protocol_conformsToProtocol");
        public static final long protocol_isEqual = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "protocol_isEqual");
        public static final long protocol_getName = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "protocol_getName");
        public static final long protocol_getMethodDescription = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "protocol_getMethodDescription");
        public static final long protocol_copyMethodDescriptionList = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "protocol_copyMethodDescriptionList");
        public static final long protocol_getProperty = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "protocol_getProperty");
        public static final long protocol_copyPropertyList = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "protocol_copyPropertyList");
        public static final long protocol_copyProtocolList = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "protocol_copyProtocolList");
        public static final long objc_allocateProtocol = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "objc_allocateProtocol");
        public static final long objc_registerProtocol = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "objc_registerProtocol");
        public static final long protocol_addMethodDescription = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "protocol_addMethodDescription");
        public static final long protocol_addProtocol = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "protocol_addProtocol");
        public static final long protocol_addProperty = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "protocol_addProperty");
        public static final long objc_copyImageNames = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "objc_copyImageNames");
        public static final long class_getImageName = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "class_getImageName");
        public static final long objc_copyClassNamesForImage = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "objc_copyClassNamesForImage");
        public static final long sel_getName = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "sel_getName");
        public static final long sel_getUid = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "sel_getUid");
        public static final long sel_registerName = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "sel_registerName");
        public static final long sel_isEqual = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "sel_isEqual");
        public static final long objc_enumerationMutation = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "objc_enumerationMutation");
        public static final long objc_setEnumerationMutationHandler = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "objc_setEnumerationMutationHandler");
        public static final long imp_implementationWithBlock = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "imp_implementationWithBlock");
        public static final long imp_getBlock = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "imp_getBlock");
        public static final long imp_removeBlock = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "imp_removeBlock");
        public static final long objc_loadWeak = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "objc_loadWeak");
        public static final long objc_storeWeak = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "objc_storeWeak");
        public static final long objc_setAssociatedObject = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "objc_setAssociatedObject");
        public static final long objc_getAssociatedObject = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "objc_getAssociatedObject");
        public static final long objc_removeAssociatedObjects = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "objc_removeAssociatedObjects");

        private Functions() {
        }
    }
}

