/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SECURITY_ATTRIBUTES
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NLENGTH;
    public static final int LPSECURITYDESCRIPTOR;
    public static final int BINHERITHANDLE;

    SECURITY_ATTRIBUTES(long address, ByteBuffer container) {
        super(address, container);
    }

    public SECURITY_ATTRIBUTES(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), SECURITY_ATTRIBUTES.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int nLength() {
        return SECURITY_ATTRIBUTES.nnLength(this.address());
    }

    public long lpSecurityDescriptor() {
        return SECURITY_ATTRIBUTES.nlpSecurityDescriptor(this.address());
    }

    public boolean bInheritHandle() {
        return SECURITY_ATTRIBUTES.nbInheritHandle(this.address()) != 0;
    }

    public SECURITY_ATTRIBUTES nLength(int value) {
        SECURITY_ATTRIBUTES.nnLength(this.address(), value);
        return this;
    }

    public SECURITY_ATTRIBUTES lpSecurityDescriptor(long value) {
        SECURITY_ATTRIBUTES.nlpSecurityDescriptor(this.address(), value);
        return this;
    }

    public SECURITY_ATTRIBUTES bInheritHandle(boolean value) {
        SECURITY_ATTRIBUTES.nbInheritHandle(this.address(), value ? 1 : 0);
        return this;
    }

    public SECURITY_ATTRIBUTES set(int nLength, long lpSecurityDescriptor, boolean bInheritHandle) {
        this.nLength(nLength);
        this.lpSecurityDescriptor(lpSecurityDescriptor);
        this.bInheritHandle(bInheritHandle);
        return this;
    }

    public SECURITY_ATTRIBUTES nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public SECURITY_ATTRIBUTES set(SECURITY_ATTRIBUTES src) {
        return this.nset(src.address());
    }

    public static SECURITY_ATTRIBUTES malloc() {
        return SECURITY_ATTRIBUTES.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static SECURITY_ATTRIBUTES calloc() {
        return SECURITY_ATTRIBUTES.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static SECURITY_ATTRIBUTES create() {
        return new SECURITY_ATTRIBUTES(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static SECURITY_ATTRIBUTES create(long address) {
        return address == 0L ? null : new SECURITY_ATTRIBUTES(address, null);
    }

    public static Buffer malloc(int capacity) {
        return SECURITY_ATTRIBUTES.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return SECURITY_ATTRIBUTES.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static SECURITY_ATTRIBUTES mallocStack() {
        return SECURITY_ATTRIBUTES.mallocStack(MemoryStack.stackGet());
    }

    public static SECURITY_ATTRIBUTES callocStack() {
        return SECURITY_ATTRIBUTES.callocStack(MemoryStack.stackGet());
    }

    public static SECURITY_ATTRIBUTES mallocStack(MemoryStack stack) {
        return SECURITY_ATTRIBUTES.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static SECURITY_ATTRIBUTES callocStack(MemoryStack stack) {
        return SECURITY_ATTRIBUTES.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return SECURITY_ATTRIBUTES.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return SECURITY_ATTRIBUTES.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return SECURITY_ATTRIBUTES.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return SECURITY_ATTRIBUTES.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nnLength(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NLENGTH);
    }

    public static long nlpSecurityDescriptor(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)LPSECURITYDESCRIPTOR);
    }

    public static int nbInheritHandle(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BINHERITHANDLE);
    }

    public static void nnLength(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)NLENGTH, value);
    }

    public static void nlpSecurityDescriptor(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)LPSECURITYDESCRIPTOR, Checks.checkPointer(value));
    }

    public static void nbInheritHandle(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)BINHERITHANDLE, value);
    }

    public static void validate(long struct) {
        Checks.checkPointer(MemoryUtil.memGetAddress(struct + (long)LPSECURITYDESCRIPTOR));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            SECURITY_ATTRIBUTES.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = SECURITY_ATTRIBUTES.__struct(SECURITY_ATTRIBUTES.__member(4), SECURITY_ATTRIBUTES.__member(POINTER_SIZE), SECURITY_ATTRIBUTES.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NLENGTH = layout.offsetof(0);
        LPSECURITYDESCRIPTOR = layout.offsetof(1);
        BINHERITHANDLE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<SECURITY_ATTRIBUTES, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected SECURITY_ATTRIBUTES newInstance(long address) {
            return new SECURITY_ATTRIBUTES(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int nLength() {
            return SECURITY_ATTRIBUTES.nnLength(this.address());
        }

        public long lpSecurityDescriptor() {
            return SECURITY_ATTRIBUTES.nlpSecurityDescriptor(this.address());
        }

        public boolean bInheritHandle() {
            return SECURITY_ATTRIBUTES.nbInheritHandle(this.address()) != 0;
        }

        public Buffer nLength(int value) {
            SECURITY_ATTRIBUTES.nnLength(this.address(), value);
            return this;
        }

        public Buffer lpSecurityDescriptor(long value) {
            SECURITY_ATTRIBUTES.nlpSecurityDescriptor(this.address(), value);
            return this;
        }

        public Buffer bInheritHandle(boolean value) {
            SECURITY_ATTRIBUTES.nbInheritHandle(this.address(), value ? 1 : 0);
            return this;
        }
    }
}

