varying vec2 tex_coord;
uniform sampler2D u_texture;
uniform int rubyFrameCount;
varying vec2 pix_no;

#define PI 3.14159265
#define CHROMA_MOD_FREQ (0.4 * PI)
#define CHROMA_AMP 1.0
#define ENCODE_GAMMA (1.0 / 2.2)

const mat3 yiq_mat = mat3(
 0.2989, 0.5959, 0.2115,
 0.5870, -0.2744, -0.5229,
 0.1140, -0.3216, 0.3114);

vec3 rgb2yiq(vec3 col)
{
 return yiq_mat * col;
}

void main()
{
 vec3 col = texture2D(u_texture, tex_coord).rgb;
 vec3 yiq = rgb2yiq(pow(col, vec3(ENCODE_GAMMA)));

 float chroma_phase = 0.6667 * PI * mod(pix_no.y + float(rubyFrameCount), 3.0);
 float mod_phase = chroma_phase + pix_no.x * CHROMA_MOD_FREQ;

 float i_mod = CHROMA_AMP * cos(mod_phase);
 float q_mod = CHROMA_AMP * sin(mod_phase);

 yiq = vec3(yiq.x, yiq.y * i_mod, yiq.z * q_mod);
 gl_FragColor = vec4(yiq, 1.0);
}