# Emu80 4.x emulator source code

For license info, see the file "COPYING.txt"

## Назначение
Эмулятор поддерживает ПК Радио-86РК, Апогей, Партнёр, Микроша, Электроника КР-04, Специалист, Eureka, Специалист-MX, Орион, Микроша, ПК-8000, Вектор, Львов, Корвет, ZX Spectrum и некоторые их модификации

## Ссылки
* Сайт проекта: [http://emu80.org](http://emu80.org)
* Обсуждение на форуме zx-pk.ru: [http://zx-pk.ru/threads/27488-emu80-v-4.html](http://zx-pk.ru/threads/27488-emu80-v-4.html)
* Обсуждение на форуме nedopc.org: [http://www.nedopc.org/forum/viewtopic.php?f=43&t=17234](http://www.nedopc.org/forum/viewtopic.php?f=43&t=17234)

## Версии
Эмулятор может быть собран в одной из версий:

* **Qt-версия** (рекомендуется). Обладает дружественным интерфейсом, некоторые возможности присутствуют только в этой версии.
* **SDL/wx-версия**. Менее требовательна к аппаратной части. Рекомендуется при наличии проблем с Qt-версией.
* **Lite-версия**. В данной версии отстутствует пользовательский интерфейс, управление может осуществляться с помощью командной строки и конфигурационных файлов.
* **WebAssembly-версия**. Предназначена для запуска в браузере и использования на web-сайтах

## Сборка и установка под Linux:

#### Требования и зависимости:
* Компилятор C++ с поддержкой стандарта С++11 (gсс требуется v. 5.1 и выше)
* libSDL v. 2.0.5 и выше (для Lite и SDL/wx-версий)
* wxWidgets v. 3.x (желательно 3.0.x, c некоторыми версиями 3.1.x под Linux наблюдались небольшие проблемы) (для SDL/wx-версии)
* Qt v. 5.6 и выше (для Qt-версии)

#### Порядок компиляции и установки Qt-версии (рекомендуется):
    git clone https://github.com/vpyk/emu80v4.git
    cd emu80v4
    qmake src/Emu80qt.pro
    make
    make install

В зависимости от дистрибутива Linux и желаемой версии Qt, необходимая версия qmake может содержаться в нем под именем qmake-qt5, qmake6 и т.п.

#### Порядок компиляции и установки SDL/wx-версии:
    git clone https://github.com/vpyk/emu80v4.git
    cd emu80v4    
    make -f Makefile.sdlwx
    make install -f Makefile.sdlwx

#### Порядок компиляции и установки lite-версии:
    git clone https://github.com/vpyk/emu80v4.git
    cd emu80v4    
    make -f Makefile.lite
    make install -f Makefile.lite

Производится portable-установка в поддиректорию `emu80` в домашней директории пользователя: `~/emu80`, после чего программа может быть перемещена в любое другое место с условием сохранения доступа на запись в директорию с программой.

Для "чистой" установки можно предварительно удалить директорию `~/emu80`. Без удаления будет произведено обновление файлов. Все три версии могут быть установлены в одну директорию одновременно.

Кроме того, с исходным текстом поставляются файлы проектов `src/Emu80qt.pro` для среды разработки Qt Creator и `src/Emu80lnx.cbp` для среды разработки Code::Blocks.

Для работы необходимо размещение файлов из директории dist (emu80.conf и т.д.) в директории, где располагается исполняемый файл. Make install обеспечивает автоматическое копирование нужных файлов.

## Сборка под Windows

Для сборки под Windows могут быть использованы файлы проектов `src/Emu80qt.pro` для среды разработки Qt Creator и `src/Emu80.cbp` для среды разработки Code::Blocks.

## Сборка WebAssembly-версии

#### Требования и зависимости:
* Emscripten (остальные зависимости будут загружены автоматически)

#### Порядок компиляции:
    git clone https://github.com/vpyk/emu80v4.git
    cd emu80v4    
    make -f Makefile.wasm

Результирующие файлы будут находиться в директории wasm_build. Пояснения по использованию - в файле wasm_build/readme.txt
