#include <snes/snes.hpp>

#define SMPCORE_CPP
namespace SNES {

#include "algorithms.cpp"
#include "opcodes.cpp"
#include "disassembler.cpp"
#include "serialization.cpp"

void SMPcore::op_step() {
  switch(opcode = op_readpc()) {
  case 0x00: return op_nop();
  case 0x01: return op_jst();
  case 0x02: return op_set_bit();
  case 0x03: return op_branch_bit();
  case 0x04: return op_read_dp<&SMPcore::op_or>(regs.a);
  case 0x05: return op_read_addr<&SMPcore::op_or>(regs.a);
  case 0x06: return op_read_ix<&SMPcore::op_or>();
  case 0x07: return op_read_idpx<&SMPcore::op_or>();
  case 0x08: return op_read_const<&SMPcore::op_or>(regs.a);
  case 0x09: return op_write_dp_dp<&SMPcore::op_or>();
  case 0x0a: return op_set_addr_bit();
  case 0x0b: return op_adjust_dp<&SMPcore::op_asl>();
  case 0x0c: return op_adjust_addr<&SMPcore::op_asl>();
  case 0x0d: return op_push(regs.p);
  case 0x0e: return op_test_addr(1);
  case 0x0f: return op_brk();
  case 0x10: return op_branch(regs.p.n == 0);
  case 0x11: return op_jst();
  case 0x12: return op_set_bit();
  case 0x13: return op_branch_bit();
  case 0x14: return op_read_dpi<&SMPcore::op_or>(regs.a, regs.x);
  case 0x15: return op_read_addri<&SMPcore::op_or>(regs.x);
  case 0x16: return op_read_addri<&SMPcore::op_or>(regs.y);
  case 0x17: return op_read_idpy<&SMPcore::op_or>();
  case 0x18: return op_write_dp_const<&SMPcore::op_or>();
  case 0x19: return op_write_ix_iy<&SMPcore::op_or>();
  case 0x1a: return op_adjust_dpw(-1);
  case 0x1b: return op_adjust_dpx<&SMPcore::op_asl>();
  case 0x1c: return op_adjust<&SMPcore::op_asl>(regs.a);
  case 0x1d: return op_adjust<&SMPcore::op_dec>(regs.x);
  case 0x1e: return op_read_addr<&SMPcore::op_cmp>(regs.x);
  case 0x1f: return op_jmp_iaddrx();
  case 0x20: return op_set_flag(regs.p.p, 0);
  case 0x21: return op_jst();
  case 0x22: return op_set_bit();
  case 0x23: return op_branch_bit();
  case 0x24: return op_read_dp<&SMPcore::op_and>(regs.a);
  case 0x25: return op_read_addr<&SMPcore::op_and>(regs.a);
  case 0x26: return op_read_ix<&SMPcore::op_and>();
  case 0x27: return op_read_idpx<&SMPcore::op_and>();
  case 0x28: return op_read_const<&SMPcore::op_and>(regs.a);
  case 0x29: return op_write_dp_dp<&SMPcore::op_and>();
  case 0x2a: return op_set_addr_bit();
  case 0x2b: return op_adjust_dp<&SMPcore::op_rol>();
  case 0x2c: return op_adjust_addr<&SMPcore::op_rol>();
  case 0x2d: return op_push(regs.a);
  case 0x2e: return op_bne_dp();
  case 0x2f: return op_branch(true);
  case 0x30: return op_branch(regs.p.n == 1);
  case 0x31: return op_jst();
  case 0x32: return op_set_bit();
  case 0x33: return op_branch_bit();
  case 0x34: return op_read_dpi<&SMPcore::op_and>(regs.a, regs.x);
  case 0x35: return op_read_addri<&SMPcore::op_and>(regs.x);
  case 0x36: return op_read_addri<&SMPcore::op_and>(regs.y);
  case 0x37: return op_read_idpy<&SMPcore::op_and>();
  case 0x38: return op_write_dp_const<&SMPcore::op_and>();
  case 0x39: return op_write_ix_iy<&SMPcore::op_and>();
  case 0x3a: return op_adjust_dpw(+1);
  case 0x3b: return op_adjust_dpx<&SMPcore::op_rol>();
  case 0x3c: return op_adjust<&SMPcore::op_rol>(regs.a);
  case 0x3d: return op_adjust<&SMPcore::op_inc>(regs.x);
  case 0x3e: return op_read_dp<&SMPcore::op_cmp>(regs.x);
  case 0x3f: return op_jsr_addr();
  case 0x40: return op_set_flag(regs.p.p, 1);
  case 0x41: return op_jst();
  case 0x42: return op_set_bit();
  case 0x43: return op_branch_bit();
  case 0x44: return op_read_dp<&SMPcore::op_eor>(regs.a);
  case 0x45: return op_read_addr<&SMPcore::op_eor>(regs.a);
  case 0x46: return op_read_ix<&SMPcore::op_eor>();
  case 0x47: return op_read_idpx<&SMPcore::op_eor>();
  case 0x48: return op_read_const<&SMPcore::op_eor>(regs.a);
  case 0x49: return op_write_dp_dp<&SMPcore::op_eor>();
  case 0x4a: return op_set_addr_bit();
  case 0x4b: return op_adjust_dp<&SMPcore::op_lsr>();
  case 0x4c: return op_adjust_addr<&SMPcore::op_lsr>();
  case 0x4d: return op_push(regs.x);
  case 0x4e: return op_test_addr(0);
  case 0x4f: return op_jsp_dp();
  case 0x50: return op_branch(regs.p.v == 0);
  case 0x51: return op_jst();
  case 0x52: return op_set_bit();
  case 0x53: return op_branch_bit();
  case 0x54: return op_read_dpi<&SMPcore::op_eor>(regs.a, regs.x);
  case 0x55: return op_read_addri<&SMPcore::op_eor>(regs.x);
  case 0x56: return op_read_addri<&SMPcore::op_eor>(regs.y);
  case 0x57: return op_read_idpy<&SMPcore::op_eor>();
  case 0x58: return op_write_dp_const<&SMPcore::op_eor>();
  case 0x59: return op_write_ix_iy<&SMPcore::op_eor>();
  case 0x5a: return op_read_dpw<&SMPcore::op_cpw>();
  case 0x5b: return op_adjust_dpx<&SMPcore::op_lsr>();
  case 0x5c: return op_adjust<&SMPcore::op_lsr>(regs.a);
  case 0x5d: return op_transfer(regs.a, regs.x);
  case 0x5e: return op_read_addr<&SMPcore::op_cmp>(regs.y);
  case 0x5f: return op_jmp_addr();
  case 0x60: return op_set_flag(regs.p.c, 0);
  case 0x61: return op_jst();
  case 0x62: return op_set_bit();
  case 0x63: return op_branch_bit();
  case 0x64: return op_read_dp<&SMPcore::op_cmp>(regs.a);
  case 0x65: return op_read_addr<&SMPcore::op_cmp>(regs.a);
  case 0x66: return op_read_ix<&SMPcore::op_cmp>();
  case 0x67: return op_read_idpx<&SMPcore::op_cmp>();
  case 0x68: return op_read_const<&SMPcore::op_cmp>(regs.a);
  case 0x69: return op_write_dp_dp<&SMPcore::op_cmp>();
  case 0x6a: return op_set_addr_bit();
  case 0x6b: return op_adjust_dp<&SMPcore::op_ror>();
  case 0x6c: return op_adjust_addr<&SMPcore::op_ror>();
  case 0x6d: return op_push(regs.y);
  case 0x6e: return op_bne_dpdec();
  case 0x6f: return op_rts();
  case 0x70: return op_branch(regs.p.v == 1);
  case 0x71: return op_jst();
  case 0x72: return op_set_bit();
  case 0x73: return op_branch_bit();
  case 0x74: return op_read_dpi<&SMPcore::op_cmp>(regs.a, regs.x);
  case 0x75: return op_read_addri<&SMPcore::op_cmp>(regs.x);
  case 0x76: return op_read_addri<&SMPcore::op_cmp>(regs.y);
  case 0x77: return op_read_idpy<&SMPcore::op_cmp>();
  case 0x78: return op_write_dp_const<&SMPcore::op_cmp>();
  case 0x79: return op_write_ix_iy<&SMPcore::op_cmp>();
  case 0x7a: return op_read_dpw<&SMPcore::op_adw>();
  case 0x7b: return op_adjust_dpx<&SMPcore::op_ror>();
  case 0x7c: return op_adjust<&SMPcore::op_ror>(regs.a);
  case 0x7d: return op_transfer(regs.x, regs.a);
  case 0x7e: return op_read_dp<&SMPcore::op_cmp>(regs.y);
  case 0x7f: return op_rti();
  case 0x80: return op_set_flag(regs.p.c, 1);
  case 0x81: return op_jst();
  case 0x82: return op_set_bit();
  case 0x83: return op_branch_bit();
  case 0x84: return op_read_dp<&SMPcore::op_adc>(regs.a);
  case 0x85: return op_read_addr<&SMPcore::op_adc>(regs.a);
  case 0x86: return op_read_ix<&SMPcore::op_adc>();
  case 0x87: return op_read_idpx<&SMPcore::op_adc>();
  case 0x88: return op_read_const<&SMPcore::op_adc>(regs.a);
  case 0x89: return op_write_dp_dp<&SMPcore::op_adc>();
  case 0x8a: return op_set_addr_bit();
  case 0x8b: return op_adjust_dp<&SMPcore::op_dec>();
  case 0x8c: return op_adjust_addr<&SMPcore::op_dec>();
  case 0x8d: return op_read_const<&SMPcore::op_ld>(regs.y);
  case 0x8e: return op_plp();
  case 0x8f: return op_write_dp_const<&SMPcore::op_st>();
  case 0x90: return op_branch(regs.p.c == 0);
  case 0x91: return op_jst();
  case 0x92: return op_set_bit();
  case 0x93: return op_branch_bit();
  case 0x94: return op_read_dpi<&SMPcore::op_adc>(regs.a, regs.x);
  case 0x95: return op_read_addri<&SMPcore::op_adc>(regs.x);
  case 0x96: return op_read_addri<&SMPcore::op_adc>(regs.y);
  case 0x97: return op_read_idpy<&SMPcore::op_adc>();
  case 0x98: return op_write_dp_const<&SMPcore::op_adc>();
  case 0x99: return op_write_ix_iy<&SMPcore::op_adc>();
  case 0x9a: return op_read_dpw<&SMPcore::op_sbw>();
  case 0x9b: return op_adjust_dpx<&SMPcore::op_dec>();
  case 0x9c: return op_adjust<&SMPcore::op_dec>(regs.a);
  case 0x9d: return op_transfer(regs.s, regs.x);
  case 0x9e: return op_div_ya_x();
  case 0x9f: return op_xcn();
  case 0xa0: return op_set_flag(regs.p.i, 1);
  case 0xa1: return op_jst();
  case 0xa2: return op_set_bit();
  case 0xa3: return op_branch_bit();
  case 0xa4: return op_read_dp<&SMPcore::op_sbc>(regs.a);
  case 0xa5: return op_read_addr<&SMPcore::op_sbc>(regs.a);
  case 0xa6: return op_read_ix<&SMPcore::op_sbc>();
  case 0xa7: return op_read_idpx<&SMPcore::op_sbc>();
  case 0xa8: return op_read_const<&SMPcore::op_sbc>(regs.a);
  case 0xa9: return op_write_dp_dp<&SMPcore::op_sbc>();
  case 0xaa: return op_set_addr_bit();
  case 0xab: return op_adjust_dp<&SMPcore::op_inc>();
  case 0xac: return op_adjust_addr<&SMPcore::op_inc>();
  case 0xad: return op_read_const<&SMPcore::op_cmp>(regs.y);
  case 0xae: return op_pull(regs.a);
  case 0xaf: return op_sta_ixinc();
  case 0xb0: return op_branch(regs.p.c == 1);
  case 0xb1: return op_jst();
  case 0xb2: return op_set_bit();
  case 0xb3: return op_branch_bit();
  case 0xb4: return op_read_dpi<&SMPcore::op_sbc>(regs.a, regs.x);
  case 0xb5: return op_read_addri<&SMPcore::op_sbc>(regs.x);
  case 0xb6: return op_read_addri<&SMPcore::op_sbc>(regs.y);
  case 0xb7: return op_read_idpy<&SMPcore::op_sbc>();
  case 0xb8: return op_write_dp_const<&SMPcore::op_sbc>();
  case 0xb9: return op_write_ix_iy<&SMPcore::op_sbc>();
  case 0xba: return op_read_dpw<&SMPcore::op_ldw>();
  case 0xbb: return op_adjust_dpx<&SMPcore::op_inc>();
  case 0xbc: return op_adjust<&SMPcore::op_inc>(regs.a);
  case 0xbd: return op_transfer(regs.x, regs.s);
  case 0xbe: return op_das();
  case 0xbf: return op_lda_ixinc();
  case 0xc0: return op_set_flag(regs.p.i, 0);
  case 0xc1: return op_jst();
  case 0xc2: return op_set_bit();
  case 0xc3: return op_branch_bit();
  case 0xc4: return op_write_dp(regs.a);
  case 0xc5: return op_write_addr(regs.a);
  case 0xc6: return op_sta_ix();
  case 0xc7: return op_sta_idpx();
  case 0xc8: return op_read_const<&SMPcore::op_cmp>(regs.x);
  case 0xc9: return op_write_addr(regs.x);
  case 0xca: return op_set_addr_bit();
  case 0xcb: return op_write_dp(regs.y);
  case 0xcc: return op_write_addr(regs.y);
  case 0xcd: return op_read_const<&SMPcore::op_ld>(regs.x);
  case 0xce: return op_pull(regs.x);
  case 0xcf: return op_mul_ya();
  case 0xd0: return op_branch(regs.p.z == 0);
  case 0xd1: return op_jst();
  case 0xd2: return op_set_bit();
  case 0xd3: return op_branch_bit();
  case 0xd4: return op_write_dpi(regs.a, regs.x);
  case 0xd5: return op_write_addri(regs.x);
  case 0xd6: return op_write_addri(regs.y);
  case 0xd7: return op_sta_idpy();
  case 0xd8: return op_write_dp(regs.x);
  case 0xd9: return op_write_dpi(regs.x, regs.y);
  case 0xda: return op_stw_dp();
  case 0xdb: return op_write_dpi(regs.y, regs.x);
  case 0xdc: return op_adjust<&SMPcore::op_dec>(regs.y);
  case 0xdd: return op_transfer(regs.y, regs.a);
  case 0xde: return op_bne_dpx();
  case 0xdf: return op_daa();
  case 0xe0: return op_clv();
  case 0xe1: return op_jst();
  case 0xe2: return op_set_bit();
  case 0xe3: return op_branch_bit();
  case 0xe4: return op_read_dp<&SMPcore::op_ld>(regs.a);
  case 0xe5: return op_read_addr<&SMPcore::op_ld>(regs.a);
  case 0xe6: return op_read_ix<&SMPcore::op_ld>();
  case 0xe7: return op_read_idpx<&SMPcore::op_ld>();
  case 0xe8: return op_read_const<&SMPcore::op_ld>(regs.a);
  case 0xe9: return op_read_addr<&SMPcore::op_ld>(regs.x);
  case 0xea: return op_set_addr_bit();
  case 0xeb: return op_read_dp<&SMPcore::op_ld>(regs.y);
  case 0xec: return op_read_addr<&SMPcore::op_ld>(regs.y);
  case 0xed: return op_cmc();
  case 0xee: return op_pull(regs.y);
  case 0xef: return op_wait();
  case 0xf0: return op_branch(regs.p.z == 1);
  case 0xf1: return op_jst();
  case 0xf2: return op_set_bit();
  case 0xf3: return op_branch_bit();
  case 0xf4: return op_read_dpi<&SMPcore::op_ld>(regs.a, regs.x);
  case 0xf5: return op_read_addri<&SMPcore::op_ld>(regs.x);
  case 0xf6: return op_read_addri<&SMPcore::op_ld>(regs.y);
  case 0xf7: return op_read_idpy<&SMPcore::op_ld>();
  case 0xf8: return op_read_dp<&SMPcore::op_ld>(regs.x);
  case 0xf9: return op_read_dpi<&SMPcore::op_ld>(regs.x, regs.y);
  case 0xfa: return op_write_dp_dp<&SMPcore::op_st>();
  case 0xfb: return op_read_dpi<&SMPcore::op_ld>(regs.y, regs.x);
  case 0xfc: return op_adjust<&SMPcore::op_inc>(regs.y);
  case 0xfd: return op_transfer(regs.a, regs.y);
  case 0xfe: return op_bne_ydec();
  case 0xff: return op_wait();
  }
}

void SMPcore::powercycle()
{
  opcode = 0;
  dp.w = 0;
  sp.w = 0;
  rd.w = 0;
  wr.w = 0;
  bit.w = 0;
  ya.w = 0;
}

}
