#ifndef __6809_h
#define __6809_h

typedef unsigned char Byte;
typedef unsigned short Word;

/* macros de ops emulados sin usar CREA */
#define RTI 0x3b

/* Macros que definen el bit dentro del CC */
#define CC_E 0X80
#define CC_F 0x40
#define CC_H 0x20
#define CC_I 0x10
#define CC_N 8
#define CC_Z 4
#define CC_V 2
#define CC_C 1


/* macros usadas para las pilas */
#define R_PC 0x80
#define R_U  0x40
#define R_S  0x40
#define R_Y  0x20
#define R_X  0x10
#define R_DP 8
#define R_B  4
#define R_A  2
#define R_CC 1

/* macros de acceso a memoria */
#define INM8 ram[ pc++ ]
#define INM16 ( ram[pc]*256+ram[pc+1] ),pc+=2
#define LEE16( a_ ) ( ram[a_]*256+ram[a_+1] )

#define SACAS8  ram[s++]
#define SACAU8  ram[u++]
#define SACAS16 (ram[s]<<8)+ram[s+1],s+=2
#define SACAU16 (ram[u]<<8)+ram[u+1],u+=2
#define METES16(a_) {ram[--s] = (Byte)a_; ram[--s] = (Byte)(a_>>8);}
#define METEU16(a_) {ram[--u] = (Byte)a_; ram[--u] = (Byte)(a_>>8);}
#define METES8(a_) ram[--s] = a_
#define METEU8(a_) ram[--u] = a_

#define ASIGNA_D(D) { b = D; a = ( D>>8 ); }
/* variables */
extern unsigned char *ram;
extern Byte a,b,cc,dp;
extern Word x,y,u,s,pc;

/* funciones */
/* 1 en ensamblador */
int Inicia6809();
void ejecuta( unsigned num );
void reset();

/* las funciones CCF <-> cc sirven para pasar del registro del 6809 al
   mdelo empleado por el emulador y viceversa. Si se necesita leer el
   valor de cc ser necesario emplear de_CCF_a_cc antes, y si se quiere
   cargar algn valor en cc habr que usar de_cc_a_CCF despus de asignar
   el valor en cc.*/
void de_CCF_a_cc();
void de_cc_a_CCF();
/* 2 en C*/
void vuelca_regs();
int irq();
#endif
