   .text
   .equ CC_E, 0X80
   .equ CC_F, 0x40
   .equ CC_H, 0x20
   .equ CC_I, 0x10
   .equ CC_N, 8
   .equ CC_Z, 4
   .equ CC_V, 2
   .equ CC_C, 1

   .macro RELLENA nombre,codigo
   lea   \nombre,%eax
   movl   %eax,\codigo*4(%ebx)
   .endm


   .macro RELLENA10 nombre,codigo
   lea    \nombre,%eax
   movl   %eax,\codigo*4(%ecx)
   .endm

   .macro RELLENA11 nombre,codigo
   lea    \nombre,%eax
   movl   %eax,\codigo*4(%edx)
   .endm

.include "ops.s"
.include "index.s"
.include "tfr.s"
.include "exg.s"
.include "pshs.s"
.include "pshu.s"
.include "puls.s"
.include "pulu.s"

   .align 4
_Inicia6809:.globl _Inicia6809
   pushl   $0x10001
   call    _malloc
   add     $4,%esp
   cmpl    $0,%eax
   jne     reser
   ret
reser:
   movl    %eax,_ram
   movl    %eax,%edi    #Rellena la RAM con ceros
   movl    $0x10000/4,%ecx
   movl    $0,%eax
   rep
   stosl
   # operaciones
   movl    $256,%ecx
   lea     opIlegal,%eax
   lea     _ops,%edi
   rep
   stosl
   # operaciones con prebyte 10
   movl    $256,%ecx
   lea     opIlegal,%eax
   lea     _ops10,%edi
   rep
   stosl
   # operaciones con prebyte 11
   movl    $256,%ecx
   lea     opIlegal,%eax
   lea     _ops11,%edi
   rep
   stosl
   # indexado
   movl    $256,%ecx
   lea     opIlegal,%eax
   lea     _index,%edi
   rep
   stosl
   # tfr
   movl    $256,%ecx
   lea     opIlegal,%eax
   lea     _tfrTabla,%edi
   rep
   stosl
   # exg
   movl    $256,%ecx
   lea     opIlegal,%eax
   lea     _exgTabla,%edi
   rep
   stosl
   # pshs
   movl    $256,%ecx
   lea     opIlegal,%eax
   lea     _pshsTabla,%edi
   rep
   stosl
   # pshu
   movl    $256,%ecx
   lea     opIlegal,%eax
   lea     _pshuTabla,%edi
   rep
   stosl
   # puls
   movl    $256,%ecx
   lea     opIlegal,%eax
   lea     _pulsTabla,%edi
   rep
   stosl
   # pulu
   movl    $256,%ecx
   lea     opIlegal,%eax
   lea     _puluTabla,%edi
   rep
   stosl

   lea     _ops,%ebx
   lea     _ops10,%ecx
   lea     _ops11,%edx
   .include "rellena.s"
   RELLENA pre10,0x10
   RELLENA pre11,0x11
   RELLENA _pshs,0x34
   RELLENA _puls,0x35
   RELLENA _pshu,0x36
   RELLENA _pulu,0x37
   RELLENA _rti,0x3B
   RELLENA _tfr,0X1f
   RELLENA _exg,0X1e
   #movl    _ram,%eax   #devuelve el puntero a la RAM
   lea     _index,%ebx
   .include "index.re"
   lea     _tfrTabla,%ebx
   .include "tfr.re"
   lea     _exgTabla,%ebx
   .include "exg.re"
   lea     _pshsTabla,%ebx
   .include "pshs.re"
   lea     _pshuTabla,%ebx
   .include "pshu.re"
   lea     _pulsTabla,%ebx
   .include "puls.re"
   lea     _puluTabla,%ebx
   .include "pulu.re"
   ret

   .align 4
_reset: .globl _reset
   # reinicia el 6809
   movb       $CC_F+CC_I,_cc
   movl       $0xfffe,%eax
   movl       _ram,%ebx
   movw       (%ebx,%eax),%ax
   xchgb      %al,%ah
   movw       %ax,_pc
   pushfl
   popl       CCF       #preparamos la variable CCF
   andl       $0xfffff72e,CCF #A cero los bits aritmticos
   ret

   .align 4
_ejecuta:.globl _ejecuta
   #ejecuta un n determinado de instrucciones del 6809
   #void ejecuta( unsigned num )
   #durante la ejecucin de las instrucciones algunos registros del 80386
   #emulan algunos del 6809
   # A        BH
   # B        BL
   # PC+Base de la Ram ESI
   # Operando AX
   # Base RAM EBP
   # CC       Se emula directamente a partir de los bits del CC del 80x86
   # para ello antes de cada operacin se apila su valor push CCF popf y
   # despus se recupera pushf pop CCF actualizado los bits E,F,I que de
   # esta manera no se pueden emular se guardan directamente en _cc en
   # sus posiciones correctas. Al salir de la funcin "ejecuta" se alamacena
   # el valor correcto del CC en _cc a partir de CCF.
   # Las operacioes no pueden modificar EDI, que se usar como contador
   # del n de instrucciones por ejecutar
   # los registros: EAX,ECX y EDX pueden ser alterados por las operaciones
   pushl %esi
   pushl %edi
   pushl %ebp

   movl     16(%esp),%eax  #n de instrucciones a ejecutar
   movl     %eax,contador
   # copia los registros que se emulan en el procesador
   movb     _a,%bh
   movb     _b,%bl
   movl     _ram,%ebp
   xor      %esi,%esi
   movw     _pc,%si

otra_instruccion:
   xor  %eax,%eax
   movb (%ebp,%esi),%al #es ms rpido que hacer movz
   lea        _ops,%ecx
   inc %si
   call       (%ecx,%eax,4)      #salta a la instruccin apropiada
   decl       contador
   jnz        otra_instruccion

   # salva los registros que se emulan en el procesador
   movb    %bh,_a
   movb    %bl,_b
   movw    %si,_pc

   popl %ebp
   popl %edi
   popl %esi
   ret

   .align 4
_de_CCF_a_cc:.global _de_CCF_a_cc
   pushl    %eax
   movl     CCF,%eax
   andb     $0xd0, _cc  #ponemos a cero H,NZVC
   test     $1,%eax
   jz       cc1
   orb      $CC_C, _cc
cc1:test    $0x10,%eax
   jz       cc2
   orb      $CC_H, _cc
cc2:test    $0x40,%eax
   jz       cc3
   orb      $CC_Z, _cc
cc3:test    $0x80, %eax
   jz       cc4
   orb      $CC_N, _cc
cc4:test    $0x800,%eax
   jz       cc5
   orb      $CC_V, _cc
cc5:
   popl     %eax
   ret

   .align 4
_de_cc_a_CCF:.global _de_cc_a_CCF
   pushl    %eax
   pushl    %ecx
   pushfl
   popl     %eax
   andl     $0b1111011100101110,%eax
   movb     _cc,%cl
   test     $CC_C,%cl
   jz       CC1
   orl      $1,%eax
CC1:test    $CC_V,%cl
   jz       CC2
   orl      $0x800,%eax
CC2:test    $CC_Z,%cl
   jz       CC3
   orl      $0x40,%eax
CC3:test    $CC_N,%cl
   jz       CC4
   orl      $0x80,%eax
CC4:test    $CC_H,%cl
   jz       CC5
   orl      $0x10,%eax
CC5:
   movl     %eax,CCF
   popl     %ecx
   popl     %eax
   ret

   .align 4
opIlegal:
   pushal

   movb   %bh,_a
   movb   %bl,_b
   movw   %si,_pc

   call   _ilegalC

   popal
   ret

   .align 4
_eaIndex:
   xor  %eax,%eax
   movb (%ebp,%esi),%al
   lea        _index,%ecx
   incw %si
   jmp        (%ecx,%eax,4)      #salta a la instruccin apropiada

   .align 4
_tfr:
   xor  %eax,%eax
   movb (%ebp,%esi),%al
   lea        _tfrTabla,%ecx
   incw %si
   jmp        (%ecx,%eax,4)      #salta a la instruccin apropiada

   .align 4
_exg:
   xor  %eax,%eax
   movb (%ebp,%esi),%al
   lea        _exgTabla,%ecx
   incw %si
   jmp        (%ecx,%eax,4)      #salta a la instruccin apropiada

   .align 4
_pshs:
   xor  %eax,%eax
   movb (%ebp,%esi),%al
   lea        _pshsTabla,%ecx
   incw %si
   jmp        (%ecx,%eax,4)      #salta a la instruccin apropiada

   .align 4
_puls:
   xor  %eax,%eax
   movb (%ebp,%esi),%al
   lea        _pulsTabla,%ecx
   incw %si
   jmp        (%ecx,%eax,4)      #salta a la instruccin apropiada

   .align 4
_pshu:
   xor  %eax,%eax
   movb (%ebp,%esi),%al
   lea        _pshuTabla,%ecx
   incw %si
   jmp        (%ecx,%eax,4)      #salta a la instruccin apropiada

   .align 4
_pulu:
   xor  %eax,%eax
   movb (%ebp,%esi),%al
   lea        _puluTabla,%ecx
   incw %si
   jmp        (%ecx,%eax,4)      #salta a la instruccin apropiada

   .align 4
pre10:
   movzbl     (%ebp,%esi),%eax   #carga el OP
   inc        %si
   lea        _ops10,%ecx
   jmp        (%ecx,%eax,4)      #salta a la instruccin apropiada

   .align 4
pre11:
   movzbl     (%ebp,%esi),%eax   #carga el OP
   inc        %si
   lea        _ops11,%ecx
   jmp        (%ecx,%eax,4)      #salta a la instruccin apropiada

   .align 4
_rti:
   xor %edx,%edx
   movw    _s,%dx
   movb   (%ebp,%edx),%al  #saca CC
   inc    %dx
   movb   %al,_cc
   test   $CC_E,%al
   jz     _rti1   #salta si no se ha guardado todo el estado
   movb    (%ebp,%edx),%bh #saca a
   movb   1(%ebp,%edx),%bl #saca b
   movb   2(%ebp,%edx),%al
   movb   %al,_dp          #saca el dp
   movw   3(%ebp,%edx),%ax
   xchg   %ah,%al
   movw   %ax,_x           #saca x
   movw   5(%ebp,%edx),%ax
   xchg   %ah,%al
   movw   %ax,_y           #saca y
   movw   7(%ebp,%edx),%ax
   xchg   %ah,%al
   movw   %ax,_u           #saca u
   add    $9,%dx
_rti1:
   movw   (%ebp,%edx),%ax
   xchg   %ah,%al
   xor    %esi,%esi
   movw   %ax,%si        #saca el PC
   add    $2,%dx
   movw   %dx,_s  #guarda la pila
   jmp    _de_cc_a_CCF #ajusta el CCF y acaba


.align 4
_braI:
#bra Inmediato
movsbw 	(%ebp,%esi),%ax #carga en EAX el byte dado
inc   	%si #ajusta el PC
add   %ax,%si
cmpw  $0x8126,%si
je   _bra_fin
ret
_bra_fin:
   addl $4,%esp
   # salva los registros que se emulan en el procesador
   movb    %bh,_a
   movb    %bl,_b
   movw    %si,_pc

   popl %ebp
   popl %edi
   popl %esi
   ret

   .align 4
   _prueba: .global _prueba
pagina:
   cmpw   $0x7000,%ax
   je _cambia
   ret
_cambia:
   pushl %esi
   xor %eax,%eax
   movb 0x7000(%ebp),%al
   lea  _paginas,%esi
   movl (%esi,%eax,4),%esi
   movl $0x6000,%edi
   addl %ebp,%edi
   movl $8*1024/4,%ecx
   rep
   movsl
   popl %esi
   ret

   .data
   .align 4
_ram:.globl _ram
     .long 0
     .align 4
contador:
     .long 0
     .align 4
     .align 4
msj_ilegal: .string "Op ilegal = %X\n"
   #registro de concidiciones
   .align 4
CCF: .long 0
   #registros
     .align 4
_pc: .word 0
     .align 4
_x : .word 0
     .align 4
_y : .word 0
     .align 4
_u : .word 0
     .align 4
_s : .word 0
     .align 4
_dp: .byte 0
     .align 4
_cc: .byte 0
     .align 4
_b : .byte 0
     .align 4
_a : .byte 0
   .global _pc
   .global _x
   .global _y
   .global _u
   .global _s
   .global _dp
   .global _cc
   .global _b
   .global _a
   #vector de vectores de funcin
   .align 4
_ops:  .fill 256,4,0
   .align 4
_ops10:.fill 256,4,0
   .align 4
_ops11:.fill 256,4,0
   .align 4
_index:.fill 256,4,0
   .align 4
_tfrTabla:.fill 256,4,0
   .align 4
_exgTabla:.fill 256,4,0
   .align 4
_pshsTabla:.fill 256,4,0
   .align 4
_pshuTabla:.fill 256,4,0
   .align 4
_pulsTabla:.fill 256,4,0
   .align 4
_puluTabla:.fill 256,4,0
old_esi:.long 4
old_edi:.long 4
old_ebp:.long 4
