#include "gry_graf.h"
#include <allegro.h>

extern void vuelca_pantalla();

int DESP_Y= 0x3426;

extern char *vga;
extern char *rom[17];
extern char *fondo[7];
unsigned char *mun;
extern unsigned char *ram;
extern char *carac1;
extern int dibuja_fondo2;
extern int n;
extern int n2;
//extern int paleta_real[16];

int tabla[8]={ 2,5,7,3,2,2,2,2 };


BITMAP *fondo1,*fondo2,*marcador,*pantalla;

void vuelca_sin_negro( BITMAP *ori, BITMAP *dest, int xo, int yo, int xd, int yd, int ancho, int alto);
void paleta(void);

void decodifica_los_graficos()
 {
 int con, valor, act,x,y;
 char *f,*def;

 f = malloc( 2*64*1024*7 );
 //def = malloc( 2*64*1024*7);
 //if ( (!f) || (!def) ) { puts("No hay memoria para los bloques de fondo."); exit(1); }
 memset( f, 0, 7*2*64*1024 );

 for(act= 3; act<10; act++ )
 {
 fondo[act-3] = f;

 for( con = 0; con < 64*1024;  ) /* 1024 bloques */
  {
  f+=7;
  for( x=0; x <8; x++ )
   {
   for ( y=0; y < 4; y++)
    {
    valor = rom[act][con++];
    *f = (valor&0xf0) >> 4;
    *(f+8) = valor &0xf;
    f+=16;
    }
    f-=65;
   }
   f+=65;
  }
 }

 mun = malloc( 2*64*1024*8 );
 f = mun;
 if (!f) { puts("No hay memoria para los muecos."); exit(1); }
 memset( f, 0, 7*2*64*1024 );

 for(act= 10; act<18; act++ )
 for( con = 0; con < 64*1024;  ) /* 1024 bloques */
  {
  f+=7;
  for( x=0; x <8; x++ )
   {
   for ( y=0; y < 4; y++)
    {
    valor = rom[act][con++];
    *f = (valor&0xf0) >> 4;
    *(f+8) = valor &0xf;
    f+=16;
    }
    f-=65;
   }
   f+=65;
  }
 }

void pon_bloque( char *p, int num, int x, int y, int color )
 {
 char *pan;
 char *fon;
 int cx,cy;

 pan = vga+ (/*y*256*/y<<8)+x;
 fon = (char*)(p + /*num*8*8*/(num<<6));
 for( cy = 0; cy < 8; cy++ )
  {
  for( cx = 0; cx < 8; cx++ )
    if ( *fon ) { *pan++ = (*fon++) | color; } /* slo pinta si es distinto a cero */
     else { ++pan; ++fon; }
  pan+=256-8;
  }
 }

void pon_bloque_bruto( char *p, int num, int x, int y, int color )
 {
 char *pan;
 char *fon;
 int cx,cy;
     /********************************/
        // color = 0;
     /********************************/
 pan = vga+ (/*y*256*/y<<8)+x;
 fon = (char*)(p + /*num*8*8*/(num<<6));
 for( cy = 0; cy < 8; cy++ )
  {
  for( cx = 0; cx < 8; cx++ ) *pan++ = (*fon++)+color;
  pan+=256-8;
  }
 }


/* dibuja el bloque invertido */
void pon_bloque_i( char *p, int num, int x, int y, int color )
 {
 char *pan;
 char *fon;
 int cx,cy;

 pan = vga+ (/*y*256*/y<<8)+x;
 fon = (char*)(p + /*num*8*8*/(num<<6));
 for( cy = 0; cy < 8; cy++ )
  {
  for( cx = 0; cx <8 ; cx++ )
    if ( *fon ) { *(pan+7-cx) = (*fon++) | color ; }/* slo pinta si es distinto a cero */
     else ++fon;
  pan+=256;
  }
 }
/* La zona "carac1" contiene el 1er plano de fondo, ocupa 256x256 puntos y
   sita en 0x2400 = Bloques, 0x2000 Atributos
        en 0x2c00 Estn las cinco primeras lneas de la pantalla */
void vuelca_carac1()
 {
 int x,y;
 int explo;
 int attr;
 int color,aux;
 int b3,b2;
/*
  El color est en los dos LSB del atributo:
  Bits  Paleta
  00 -> 2
  01 -> 5
  10 -> 7
  11 -> 3
*/
 /* pinta primero las cinco lneas en 0x2c00 */
 explo = 0x2c00;
 vga = marcador->line[0];
 for( x=0x1F; x>=0; x--, explo+=0x20-5 )
  for( y=0; y<5; y++,explo++ )
  {
  attr = ram[explo-0x400];
  color = ((attr)&3);
  pon_bloque_bruto( fondo[3],ram[explo], x<<3, y<<3,tabla[color]<<4 );
  }
 /* pinta ahora el resto de lneas */
 vga = fondo1->line[0];
 explo = 0x2400;
 for( x=0x1F; x>=0; x-- )
  for( y=0; y < 0x20; y++,explo++ )
  {
  /* los transparentes no se pintan
  if ( ram[explo-0x400] == 0x80 && ram[explo] == 0 ) continue;
  if ( ram[explo-0x400] == 0x0  && ram[explo] == 0x10 ) continue;
  if ( ram[explo-0x400] == 0xa0  && ram[explo] == 0 ) continue;*/
  attr = ram[explo-0x400];
  /* color */
  color = ((attr)&3);
  /* juego de caracteres */
  attr = (attr&0xf8)>>3;
  b3 = (attr & 0x8)<<1;
  b2 = (attr & 0x4)<<2;
  aux = (attr&0x10) >> 4;
  attr = ((attr<<1)+aux)&0x1f;
  attr &= 0xf;
  attr |= (b3^b2);
  pon_bloque_bruto( fondo[3],ram[explo]+(attr<<8), x<<3, y<<3, tabla[color]<<4 );
  }
 }

/* La zona "carac2" contiene el 2do plano de fondo, ocupa 256x256 puntos y
   sita en 0x4400 = Bloques, 0x4000 Atributos */
void vuelca_carac2()
 {
 int x,y;
 int explo = 0x4400;
 int attr;
 int aux;

 vga = fondo2->line[0];
 for( x=0x1F; x>=0; x-- )
  for( y=0; y<0x20; y++,explo++ )
  {
  attr = ram[explo-0x400];
  // Parece ser que el 2 fondo tiene la paleta fija
  attr = (attr&0xf8)>>3;
  aux = (attr&0x10) >> 4;
  attr = ((attr<<1)+aux)&0x1f;
  pon_bloque_bruto( fondo[0], ram[explo]+/*bloque[attr]*/(attr<<8), x<<3, y<<3, 6<<4 );
  }
 }

void cuadrado( int x, int y )
 {
 char *pan;
 int cx,cy;

 pan = vga+ (/*y*256*/y<<8)+x;
 for( cy = y; cy < y+16 && cy<296; cy++ )
  {
  for( cx = x; cx < x+16 && x<256; cx++ ) *pan++ = 255;
  pan+=256-16;
  }
 }

void pinta_munecos()
 {
 int explo;
 int con;
 int bloque,attr;
 int x=0,y=0;
 int zona[4]={0x3000,0x3800,0x5000,0x5800};
 int color_zona[4]={0,0,4<<4,4<<4};
 int con_zona;
 int color;

 vga = pantalla->line[0];
 for( con_zona=1; con_zona<3;con_zona++ )
  {
  color = color_zona[ con_zona ];
  for( con=0,explo = zona[con_zona]; con<100 ;explo+=5 )
  {
  if ( (!ram[explo]) && (!ram[explo+1]) && (!ram[explo+2]) && (!ram[explo+3]) && (!ram[explo+4]) ) break;
  if ( ram[explo+4]&1 ) continue; // se sale de la pantalla
  x = (~ram[explo+2])&0xff;
  x -= 8;
  if ( x<8 || x>240 ) continue;
  y = ram[explo+3]+40;
  if ( y < 40 ) y = 296 - (40-y) ;
  attr = (ram[explo+1]&0x7)<<8;
  bloque = (ram[explo]+attr)<<2;
  if ( con_zona<2) bloque+=2048*4;
  if ( ram[ explo+4 ] &0x40 ) bloque+=1024*4;
  if ( (ram[explo+4]&0x20) ^ ((ram[explo+4]&0x10)<<1) )
    { /* invertido */
    if ( !(ram[explo+4]&0x8) )
     {
     pon_bloque_i( mun, bloque+2, x+8, y, color );
     pon_bloque_i( mun, bloque  , x, y, color );
     pon_bloque_i( mun, bloque+3, x+8, y+8, color );
     pon_bloque_i( mun, bloque+1, x, y+8, color );
     }
    else
     {
     pon_bloque_i( mun, bloque+2, x-8 , y, color   );
     pon_bloque_i( mun, bloque  , x-16, y, color   );
     pon_bloque_i( mun, bloque+3, x-8 , y+8, color );
     pon_bloque_i( mun, bloque+1, x-16, y+8, color );
     bloque+=4;
     pon_bloque_i( mun, bloque+2, x-8 , y+16, color);
     pon_bloque_i( mun, bloque  , x-16, y+16, color);
     pon_bloque_i( mun, bloque+3, x-8 , y+24, color);
     pon_bloque_i( mun, bloque+1, x-16, y+24, color);
     bloque+=4;
     pon_bloque_i( mun, bloque+2, x+8 , y, color   );
     pon_bloque_i( mun, bloque  , x   , y, color   );
     pon_bloque_i( mun, bloque+3, x+8 , y+8, color );
     pon_bloque_i( mun, bloque+1, x   , y+8, color );
     bloque+=4;
     pon_bloque_i( mun, bloque+2, x+8 , y+16, color);
     pon_bloque_i( mun, bloque  , x   , y+16, color);
     pon_bloque_i( mun, bloque+3, x+8 , y+24, color);
     pon_bloque_i( mun, bloque+1, x   , y+24, color);
     }
    }
   else /* no invertido */
    {
    if ( !(ram[explo+4]&0x8) )
     {
     pon_bloque( mun, bloque+2, x, y, color );
     pon_bloque( mun, bloque  , x+8, y, color );
     pon_bloque( mun, bloque+3, x, y+8, color );
     pon_bloque( mun, bloque+1, x+8, y+8, color );
     }
     else
     {
     pon_bloque( mun, bloque+2, x   , y, color   );
     pon_bloque( mun, bloque  , x+8 , y, color   );
     pon_bloque( mun, bloque+3, x   , y+8, color );
     pon_bloque( mun, bloque+1, x+8 , y+8, color );
     bloque+=4;
     pon_bloque( mun, bloque+2, x   , y+16, color);
     pon_bloque( mun, bloque  , x+8 , y+16, color);
     pon_bloque( mun, bloque+3, x   , y+24, color);
     pon_bloque( mun, bloque+1, x+8 , y+24, color);
     bloque+=4;
     pon_bloque( mun, bloque+2, x-16, y, color   );
     pon_bloque( mun, bloque  , x-8 , y, color   );
     pon_bloque( mun, bloque+3, x-16, y+8, color );
     pon_bloque( mun, bloque+1, x-8 , y+8, color );
     bloque+=4;
     pon_bloque( mun, bloque+2, x-16, y+16, color);
     pon_bloque( mun, bloque  , x-8 , y+16, color);
     pon_bloque( mun, bloque+3, x-16, y+24, color);
     pon_bloque( mun, bloque+1, x-8 , y+24, color);
     }
    }
  }
  }
 }


void inicia_graficos()
 {
 RGB blanco = {0xff,0xff,0xff };
 decodifica_los_graficos();
 __djgpp_nearptr_enable();
 pantalla = create_bitmap( 256,296 );
 clear( pantalla );
 /* 2 fondo */
 fondo2 = create_bitmap( 256, 256 );
 clear( pantalla );
 /* 1er fondo */
 fondo1 = create_bitmap( 256,356 );
 /* marcador */
 marcador = create_bitmap( 256,40 );
 clear( fondo1 );
 vga = pantalla->line[0];
 set_color( 255,&blanco );
 }

void vuelca_sin_negro( BITMAP *ori, BITMAP *dest, int xo, int yo, int xd, int yd, int ancho, int alto)
 {
 int x,y,v;

 for( y=0; y<alto; y++ )
  for( x=0; x<ancho; x++ )
   {
   v = ori->line[y+yo][x+xo];
   if ( (v&0xf)!=0 ) dest->line[y+yd][x+xd] = v;
   }
 }

void paleta(void)
 {
 PALETTE pal;
 RGB rgb;
 int con,c2,aux;
 int modo;
 int paleta;

 modo = 1;

 for( paleta = 0; paleta < 8; paleta++ )
  {
  for( con=0; con<32; con+=2 )
   {
   aux = ram[con+0xc00+paleta*32];
   rgb.r = aux&0x1f;
   rgb.g = (aux&0xE0)>>5;
   aux = ram[con+0xc01+paleta*32];
   rgb.b = (aux&0x7c)>>2;
   rgb.g |= (aux&0x3)<<3;

   rgb.r <<= 1;
   rgb.g <<= 1;
   rgb.b <<= 1;
   pal[ (con>>1) + paleta*32 ]=rgb;
   }
  }
 set_palette( pal );
 }
