// 1 versin pblica 15/II/98
// 2 versin pblica 8/VI/98
const char programa[] = "\nEmulador de Gryzor 1.0\n8/VI/1998 Jos Tejada Gmez";

#include <stdio.h>  /* salidas por pantalla */
#include <stdlib.h> /* malloc */
#include <string.h> /* strcpy */
//#include <unistd.h> /* funciones de directorio */
//#include <sys\nearptr.h> /* acceso a la vga */
#include <conio.h>
#include <dos.h>

#include "6809/6809.h"
#include "graf/gry_graf.h"
//#include <allegro.h>

//#define MAPA
//#define DEPURA
//#define MUESTRA_SI

/* definiciones */
#define NO_VGA  -4
#define NO_RAM  -3
#define NO_ROM  -2
#define NO_FILE -1

/* prototipos de funciones */
void presentacion(void);
int carga_rom( unsigned char *rom[],char *dd_dir );
void libera_rom( unsigned char *rom[] );
void imprime_error( unsigned error );
int decodifica_graficos( char *rom[] );
void prepara_memoria();
void cmdline( int, char ** );
int teclado();
int depura( int *,int *);
#ifdef MAPA
 void muestra_mapa();
#endif
void salva( char *sz );
void carga( char *sz );
void muestra_munecos();

#define DEP_NORMAL 0
#define DEP_IR_A   1
#define DEP_NUMERO 2
#define DEP_FINAL -1

#define DIP1 0x14
#define DIP2 0x15
#define DIP3 0x16

const int IPS=60;

int cambios_pag=0;

//#define DEPURA
//#define RATON

void vuelca_ram();

unsigned char *rom[17];
unsigned char *fondo[7];
unsigned char *carac1;
unsigned char *paginas[12];
char directorio[128]; /* dir. donde estn las EPROM */
int inicio=0;
char *vga;
#ifdef MAPA
 unsigned char *mapa;
#endif

int n=0x3b00;
int n2=0;
int si=2;
int pausa=0;
int dibuja_fondo2=1;

void vuelca_mun();

#define MAX_COLOR 30
char colores[MAX_COLOR][100];
char color_actual=0;

volatile int ips_ideal=0; /* temporizador que se incrementa a 60Hz*/
int ips_real=0; /* imgenes por segundo reales */
int ips_media=0; /* media del ips anterior y el actual */


void temporizador()
 {
 ips_ideal++;
 }


END_OF_FUNCTION( temporizador )


void muestra_color()
 {
 int con=0xc00;
 int x,y,aux;
 char numero[9];

 for( y=0; y <16;y++ )
  {
  printf("\n\t%X ",con);
  for( x=0; x<16;x++,con++) printf("%3X",ram[con] );
  }

 for( y=0,con=0xc00; y <16;y++ )
  {
  printf("\n\t%X ",con);
  for( x=0; x<16;x++,con++)
   {
   itoa( ram[con], numero, 2 );
   for(aux=8; aux>strlen( numero ); aux-- ) putchar('0');
   printf("%s ",numero);
   }
  }
 for( y=0; colores[y][0]; y++ )
  {
  printf("\n%s",colores[y]);
  }
 }

int main(int argc, char *argv[])
 {
 /* variables */
 int error, modo,dato, si_con=1;
 union REGS regs;
 char *aux; int con;
 int x,y;
 char frase[100];
 int pintadas[2] = {0,0};
 /* programa */
 presentacion();
 strcpy( directorio,".");
 /* lnea de parmetros */
 cmdline( argc, argv );
 error = carga_rom( rom, directorio );
 if ( error == 0 )
  {
  if ( Inicia6809() == 0 ) { error = NO_RAM; imprime_error( error ); return -1; }
  prepara_memoria();
  LOCK_VARIABLE( ips_ideal );
  LOCK_FUNCTION( temporizador );
  install_timer();
  install_int( temporizador, (1.0/IPS)*1000.0 );
  reset();
  carac1 = fondo[3]; /* letras */

  ram[0x14] = 0xcf; /* DIP 1 */
  ram[0x15] = 0x3f; /* DIP 2 */
  ram[0x16] = 0x20; /* DIP 3 */

  modo = DEP_NORMAL;
  dato = 0;

  allegro_init();
  install_keyboard();
  initialise_joystick();
  install_timer();
  #ifndef DEPURA
   set_gfx_mode( GFX_MODEX,320,240,320,280*2 );
  #else
   set_gfx_mode( GFX_AUTODETECT,640,480,0,0 );
  #endif
  inicia_graficos();

  #ifdef RATON
   install_mouse();
   show_mouse(screen);
  #endif


 error = 0;
  do
   {
    if ( !pausa)
     {
     irq();
     ejecuta( 0x4000 );
     }
    if ( (si_con % si) == 0 )
     {
     #ifdef DEPURA
     //vuelca_mun();
     vuelca_ram();
     #endif
     vuelca_pantalla();
     pintadas[0]++;
     #ifdef MUESTRA_SI
     sprintf( frase,"SI=%X N2=%X N=%X DY = %X",si,n2,n,ram[0x3426]);
     //sprintf( frase, "H2 = %d", ram[0x62] );
     textout( screen, font,frase,256,200,255);
     #endif
     }
    ips_real++; si_con++;
    if ( ips_ideal > IPS )
     {
     ips_ideal=0;
     ips_media += ips_real; ips_media >>=1;
     ips_real = 0;
     pintadas[1] = pintadas[0];
     pintadas[0] = 0;
     #ifndef DEPURA
     sprintf( frase,"%d/%d/%d  ",ips_media, pintadas[1],cambios_pag/60 );
     cambios_pag=0;
     textout( screen, font,frase,240,120,255);
     #endif
     }
   }while ( teclado() );
  libera_rom( rom );
  remove_timer();
  remove_keyboard();
  remove_mouse();
  set_gfx_mode( GFX_TEXT, 0,0,0,0 );
  #ifdef MAPA
   muestra_mapa();
  #endif
  //muestra_color();
  //muestra_munecos();
  puts("Has usado GRYTRA 1.0 de Pepe Tejada (jotego@teleco.upv.es)");
  puts("Agradecimientos a: \n\tRoberto Ventura\n\tEric Hustvedt\n\tPhil Stroffolino\n\tEric Phister\n\tLewin A.R.W. Edwards");
  puts("Este emulador es gratuito, si te han cobrado por l, has sido timado.");
  return 0;
  }
 imprime_error( error );
 return -1;          /* ha habido algn error */
 }


void presentacion(void)
 {
 puts( programa );
 }

void prepara_memoria()
 {
 unsigned con, aux;
 #ifdef DEBUG
 char sz[]="res ";
 for( con=0,aux=0; con<=64*1024;con++ )
  {
  ram[ con ] = sz[aux];
  aux = sz[aux+1]? aux+1:0;
  }
 #else
  memset( ram, 0xff, 64*1024 );
 #endif
 memcpy( ram + 0x8000, rom[1]+0x8000, 0x8000 ); /* cdigo principal */
 /* pginas */
 for ( con=0; con < 8; con++ ) paginas[con] = rom[2]+0x2000*con;
 paginas[8] = rom[1];
 paginas[9] = rom[1]+0x2000;
 paginas[10] = rom[1]+2*0x2000;
 paginas[11] = rom[1]+3*0x2000;

 memcpy( ram + 0x6000, paginas[0], 0X2000 ); /* pgina cero */

 /* parche para saltarse la comprobacin de la RAM/ROM */
 //ram[ 0x800a] = 0x63;
 //ram[ 0x800b] = 0xe7;
 #ifdef MAPA
  mapa = malloc( 64*1024 );
  memset( mapa, 0 , 64*1024 );
 #endif
 }

int carga_rom( unsigned char *rom[],char *dd_dir )
 {
 static char nombres[18][13] =
  {
  "G-1.ROM","G-2.ROM","G-3.ROM","G-4.ROM","G-5.ROM",
  "G-6.ROM","G-7.ROM","G-8.ROM","G-9.ROM","G-10.ROM",
  "G-11.ROM","G-12.ROM","G-13.ROM","G-14.ROM","G-15.ROM",
  "G-16.ROM","G-17.ROM","G-18.ROM"
  };
 FILE *f; unsigned con;
 char dir_actual[100];

 printf("Leyendo EPROMs, Reading EPROMs, Legente EPROMa: "); /* indicativo de estado */
 getcwd( dir_actual, 100 ); /* guardamos el directorio actual para restaurarlo */

 if ( chdir( dd_dir )==0 )
  {
  for( con=0; con<18; con++)
   {
   if ( nombres[con][0] == 0 ) continue;
   f = fopen( nombres[con], "rb" );
   rom[con] = malloc( 0x10000 );
   if ( f == NULL ) {  puts( nombres[con] );chdir(dir_actual); return NO_FILE; }/* error abriendo el archivo */
   if ( rom[con] == NULL ) { chdir(dir_actual);return NO_RAM; }/* error reservando la memoria */
   rom[con] = realloc( rom[con], fread( rom[con], 1, 0xfffff, f ) ); /*reajusta el tamao */
   if ( rom[con] == NULL ) { chdir(dir_actual);return NO_ROM; }/* error reasignando la memoria */
   fclose( f );
   putchar('.'); /* un simple indicativo de que ha ledo el fichero */
   fflush( stdout ); /* si no, no se ver el punto */
   }
  chdir(dir_actual);
  return 0;
  }
  else return NO_FILE;
 }

void libera_rom( unsigned char *rom[] )
 {
 unsigned con;
 for( con=0; con<17; con++) free( rom[con] );
 }

void imprime_error( unsigned error )
 {
 switch( error )
      {
      case NO_RAM: puts("No hay suficiente memoria disponible.");
                   puts("Cierre algunos programas y vuelva a intentarlo");
                   break;
      case NO_ROM: puts("No se pudo reasignar la memoria reservada.");
                   break;
      case NO_FILE:puts("No se encontraron los ficheros de la ROM");
                   break;
      case NO_VGA: puts("No se pudo desproteger la memoria de vdeo.");
                   break;
      default:     puts("Error desconocido"); break;
      }
 }

void cmdline( int argc, char *argv[])
 {
 unsigned error; /* contador */
 if ( argc > 1 )
  {
  for( error = 1; error < argc; error++ )
   {
    strlwr( argv[error] );
    if ( strstr(argv[error],"-dir") ) strcpy( directorio, argv[++error] );
   }
  }
 }

int teclado()
 {
 char frase[256];
 char aux[33];
 char numero[16];
 int  puntero,con;
 PALETTE pal;
 BITMAP *bmp;
 #define INI 0X400
 if ( key[1] ) return 0;
 if ( key[0x4e] && !(key_shifts&KB_ALT_FLAG))
    { //while( key[0x4e] );
      n+=16; if (si<10) si++; }
 if ( key[0x4a] && !(key_shifts&KB_ALT_FLAG) )
    { //while( key[0x4a] );
      n-=16; if ( si>2) si--; }
 if ( key[0x4e] && (key_shifts&KB_ALT_FLAG) )
    { while( key[0x4e] );
      n2++; }
 if ( key[0x4a] && (key_shifts&KB_ALT_FLAG))
    { while( key[0x4a] );
      n2--; }
 /* si */
 if ( key[0x3b] ) si = 1;
 if ( key[0x3c] ) si = 3;
 if ( key[0x3d] ) si = 5;
 if ( key[0x3e] ) si = 9;
 /* modo de prueba */
 if ( key[0x14] ) ram[DIP3] &= 0xf0; else ram[DIP3] |= 0xff;
 /* pausa */
 if ( key[0x19]) { while(key[0x19]); pausa = !pausa; }
 /* reinicio */
 if ( key[0x13] ) reset();
 /* activar y desactivar fondos */
 if ((key_shifts&KB_ALT_FLAG)&&key[3]) { while( key[3] ); dibuja_fondo2 = !dibuja_fondo2; }
 /* guardar y recuperar la partida */
 if ( key[0x3f] ) salva("rapido"); /* F5 */
 if ( key[0x40] ) carga("rapido"); /* F6 */
 /* ratn */
 #ifdef RATON
 puntero = 0x27e0 -(mouse_x/8*0x20)+(mouse_y-40)/8;
 sprintf( frase,"%X, %x, %x   ", puntero, ram[puntero], ram[puntero-0x400] );
 textout(screen, font, frase, 0, 300,255);
 puntero = 0x47e0 -(mouse_x/8*0x20)+(mouse_y-40)/8; // 2 plano
 sprintf( frase,"%X, %x, %x   ", puntero, ram[puntero], ram[puntero-0x400] );
 textout(screen, font, frase, 0, 308,255);
 #endif
 /* insertar moneda */
 if ( key[2] ) ram[0x10] &=~0x8; else ram[0x10] |=0x8; //1-player
 if ( key[3] ) ram[0x10] &=~0x10; else ram[0x10] |=0x10; //2-player
 if ( key[4] ) ram[0x10] &=~0x1; else ram[0x10] |=1; //1-coin
 if ( key[5] ) ram[0x10] &=~0x2; else ram[0x10] |=2; //2-coin
 /* movimiento del personaje */
 poll_joystick();
 if ( key[0x4d] ) ram[0x11]&=0xfd; else ram[0x11]|=2;
 if ( joy_right ) ram[0x12]&=0xfd; else ram[0x12]|=2;
 if ( key[0x4b]) ram[0x11]&=0xfe; else ram[0x11]|=1;
 if ( joy_left ) ram[0x12]&=0xfe; else ram[0x12]|=1;
 if ( key[0x48]) ram[0x11]&=0xfb; else ram[0x11]|=4;
 if ( joy_up ) ram[0x12]&=0xfb; else ram[0x12]|=4;
 if ( key[0x50] ) ram[0x11]&=0xf7; else ram[0x11]|=8;
 if ( joy_down ) ram[0x12]&=0xf7; else ram[0x12]|=8;
 if ( key_shifts&KB_ALT_FLAG ) ram[0x11]&=0xef; else ram[0x11]|=0x10;
 if ( joy_b1) ram[0x12]&=0xef; else ram[0x12]|=0x10;
 if ( (key_shifts&KB_CTRL_FLAG) ) ram[0x11]&=0xdf; else ram[0x11]|=0x20;
 if ( joy_b2 ) ram[0x12]&=0xdf; else ram[0x12]|=0x20;
 /* grabar la paleta */
 if (key[0x39] && color_actual < MAX_COLOR)
  {
  while( key[0x39] );
  sprintf( colores[color_actual],"%3X ", color_actual );
  for (puntero =0; puntero <16; puntero++ )
   {
   itoa( ram[0xc70+puntero], numero, 2 );
   for(con=8; con>strlen( numero ); con-- ) strcat(colores[color_actual],"0" );
   strcat(colores[color_actual], numero);
   strcat( colores[color_actual],"-");
   }
  ++color_actual;
  }
 /* salvar la pantalla */
 if (key[0x1f])
  {
  get_palette( pal );
  bmp = create_sub_bitmap(screen, 0, 0, 240, 280);
  save_bitmap("gryzor.pcx", screen, pal);
  destroy_bitmap(bmp);
  }
 return 1;
 }
#ifdef MAPA
void muestra_mapa()
 {
 int con;

 printf("Lectura:\n");
 for( con=0; con < 64*1024; con++ )
  {
   if( mapa[con] == 1 ) printf("*%X\t",con );
  }

 printf("\nEscritura:\n");
 for( con=0; con < 64*1024; con++ )
  {
   if( mapa[con] == 2 ) printf("*%X\t",con );
  }

 printf("\nAmbas:\n");
 for( con=0; con < 64*1024; con++ )
  {
   if( mapa[con] == 3 ) printf("*%X\t",con );
  }
 }
#endif

void salva(char *sz)
 {
 FILE *back;
 char nombre[30];

 strcpy( nombre, sz );
 strcat( nombre, ".ram" );
 back = fopen(nombre,"wb+");
 if ( !back ) return;
 fwrite( ram,64,1024, back );
 fclose(back);

 strcpy( nombre, sz );
 strcat( nombre, ".reg" );
 back = fopen(nombre,"wb+");
 if ( !back ) return;
 fwrite( &pc,9,4,back );
 fclose(back);
 }

void carga(char *sz)
 {
 char nombre[40];
 FILE *back;

 strcpy( nombre, sz );
 strcat( nombre, ".ram" );
 back = fopen( nombre,"rb+");
 if ( !back ) return;
 fread( ram,64,1024, back );
 fclose(back);

 strcpy( nombre, sz );
 strcat( nombre, ".reg" );
 back = fopen( nombre,"rb+");
 if ( !back ) return;
 fread( &pc,9,4,back );
 fclose(back);
 }

void vuelca_ram()
 {
 int c1,c2;
 char frase[255];
 int c;

 c=n;
 for( c1 = 0; c1 < (SCREEN_H-24)/16; c1++ )
  {
  sprintf( frase, "%4X ",c1*16+c );
  textout( screen, font, frase, 280, c1*8+24, 255 );
  for( c2 = 0; c2 < 0x10; c2++ )
   {
   sprintf( frase, "%2X ", ram[c+c1*16+c2]);
   textout( screen, font, frase, 280+c2*8*3+8*6, c1*8+24, 255 );
   }
  }
 }

void muestra_munecos()
 {
 int c1,c2, mun[4]={0x3000,0x3800,0x5000,0x5800},c3;
 char numero[10];
 int aux;

 for ( c3=0; c3<4; c3++)
  {
  printf("\n\nDe $%X a $%X",mun[c3],mun[c3]+20*5 );
  for( c1 = 0; c1 < 20; c1++ )
   {
   printf( "\n%4X ",c1*5+mun[c3] );
   for( c2 = 0; c2 < 5; c2++ )
    { /* binario */
    itoa( ram[mun[c3]+c1*5+c2], numero, 2 );
    for(aux=8; aux>strlen( numero ); aux-- ) putchar('0');
    printf("%s ",numero);
    }
   printf("\n     ");
   for( c2 = 0; c2 < 5; c2++ )
    { /* hexadecimal */
    itoa( ram[mun[c3]+c1*5+c2], numero, 16 );
    for(aux=2; aux>strlen( numero ); aux-- ) putchar('0');
    printf("%-8s ",numero);
    }
   }
  }
 }

void vuelca_mun()
 {
 int c1,c2;
 char frase[255];

 for( c1 = 0; c1 < 20; c1++ )
  {
  sprintf( frase, "%4X ",c1*5+n );
  textout( screen, font, frase, 256, c1*8+16, 255 );
  for( c2 = 0; c2 < 5; c2++ )
   {
   sprintf( frase, "%2X ", ram[n+c1*5+c2]);
   textout( screen, font, frase, 256+c2*8*3+8*6, c1*8+16, 255 );
   }
  }
 }
