/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.CPU_6502;
import core.NesSettings;
import core.audio.AudioMixer;
import core.audio.Channel;
import core.audio.DMC;
import core.audio.Noise;
import core.audio.Pulse;
import core.audio.Triangle;
import core.mappers.Mapper;
import java.io.Serializable;
import java.util.ArrayList;

public class APU
implements Serializable {
    private static final long serialVersionUID = 2400733667863038798L;
    private final Mapper map;
    private Triangle triangle;
    private Pulse pulse1 = new Pulse(true, 0);
    private Pulse pulse2 = new Pulse(false, 1);
    private Noise noise;
    private DMC dmc;
    private ArrayList<Channel> expansionAudio;
    private double cyclespersample;
    private int intcyclespersample;
    private double samplenum;
    public int[] samples;
    int sampleptr;
    public final AudioMixer mixer;
    private boolean stepmode4 = true;
    int stepcycle;
    private boolean irqInhibit;
    private boolean frameInterrupt;
    boolean doFrameStep;
    private boolean evenclock = false;
    private int block;
    private int stepNumber;
    private int delay = -1;
    public int framecounter;
    private int cpucounter;
    public long cyclenum;
    private boolean expansion;
    Object[][] freq;
    public static int samplecounter = 0;

    public APU(Mapper m) {
        this.triangle = new Triangle(2);
        this.noise = new Noise(3);
        this.map = m;
        this.dmc = new DMC(this.map, 4);
        this.expansionAudio = new ArrayList();
        this.cyclespersample = 1789773.0 / (double)NesSettings.sampleRate;
        this.intcyclespersample = (int)this.cyclespersample;
        this.cpucounter = 10;
        this.expansion = false;
        this.writeRegister(16405, (byte)0);
        this.freq = new Object[3][2];
        this.samples = new int[1000];
        this.mixer = new AudioMixer(this.pulse1, this.pulse2, this.triangle, this.noise, this.dmc, this.expansionAudio, m);
    }

    public void addExpansionChannel(Channel chan) {
        this.expansionAudio.add(chan);
        this.expansion = true;
        this.freq = new Object[3 + this.expansionAudio.size()][];
    }

    public int requestNewOutputLocation() {
        return this.mixer.requestNewOutputLocation();
    }

    public void setSampleRate(int rate) {
        this.cyclespersample = 1789773.0 / (double)rate;
        this.intcyclespersample = (int)this.cyclespersample;
        this.mixer.updateAudioSettings();
    }

    public void writeRegister(int index, byte b) {
        if (index >= 16384 && index < 16388) {
            this.pulse1.registerWrite(index, b, this.cpucounter);
        } else if (index >= 16388 && index < 16392) {
            this.pulse2.registerWrite(index, b, this.cpucounter);
        } else if (index >= 16392 && index < 16396) {
            this.triangle.registerWrite(index, b, this.cpucounter);
        } else if (index >= 16396 && index < 16400) {
            this.noise.registerWrite(index, b, this.cpucounter);
        } else if (index >= 16400 && index < 16404) {
            this.dmc.registerWrite(index, b);
        } else if (index == 16405) {
            if ((b & 1) == 0) {
                this.pulse1.disable();
            } else {
                this.pulse1.enable();
            }
            if ((b & 2) == 0) {
                this.pulse2.disable();
            } else {
                this.pulse2.enable();
            }
            if ((b & 4) == 0) {
                this.triangle.disable();
            } else {
                this.triangle.enable();
            }
            if ((b & 8) == 0) {
                this.noise.disable();
            } else {
                this.noise.enable();
            }
            if ((b & 0x10) == 0) {
                this.dmc.sampleremaining = 0;
                this.dmc.silence = true;
            } else if (this.dmc.sampleremaining == 0) {
                this.dmc.restart();
            }
            this.dmc.clearFlag();
        } else if (index == 16407) {
            this.stepmode4 = (b & 0x80) == 0;
            this.stepNumber = 0;
            if ((b & 0x80) != 0) {
                this.stepNumber = 2;
                this.frameClock();
                this.cpucounter = 0;
                this.block = 1;
            }
            boolean bl = this.irqInhibit = (b & 0x40) != 0;
            if (this.irqInhibit && this.frameInterrupt) {
                this.frameInterrupt = false;
                this.map.cpu.removeIRQ(CPU_6502.IRQSource.FrameCounter);
            }
            this.delay = !this.evenclock ? 0 : 1;
            this.cpucounter = 0;
        }
    }

    public byte readRegisters(int index) {
        if (index == 16405) {
            byte b = 0;
            b = (byte)(b | (this.pulse1.lengthCount > 0 ? 1 : 0));
            b = (byte)(b | (this.pulse2.lengthCount > 0 ? 2 : 0));
            b = (byte)(b | (this.triangle.lengthCount > 0 ? 4 : 0));
            b = (byte)(b | (this.noise.lengthCount > 0 ? 8 : 0));
            b = (byte)(b | (this.dmc.sampleremaining > 0 ? 16 : 0));
            b = (byte)(b | (this.frameInterrupt ? 64 : 0));
            this.frameInterrupt = false;
            this.map.cpu.removeIRQ(CPU_6502.IRQSource.FrameCounter);
            b = (byte)(b | (this.dmc.irqflag ? 128 : 0));
            return b;
        }
        return 0;
    }

    private void frameClock() {
        if (this.stepmode4) {
            if (this.stepNumber % 4 == 1 || this.stepNumber % 4 == 3) {
                this.pulse1.lengthClock();
                this.pulse1.sweepClock();
                this.pulse2.lengthClock();
                this.pulse2.sweepClock();
                this.triangle.lengthClock();
                this.noise.lengthClock();
            }
            this.pulse1.envelopeClock();
            this.pulse2.envelopeClock();
            this.triangle.linearClock();
            this.noise.envelopeClock();
            if (this.stepNumber % 4 == 3) {
                this.setIRQ();
            }
        } else if (this.stepNumber == 2) {
            this.pulse1.lengthClock();
            this.pulse1.sweepClock();
            this.pulse2.lengthClock();
            this.pulse2.sweepClock();
            this.triangle.lengthClock();
            this.noise.lengthClock();
            this.pulse1.envelopeClock();
            this.pulse2.envelopeClock();
            this.triangle.linearClock();
            this.noise.envelopeClock();
        } else if (this.stepNumber == 1) {
            this.pulse1.envelopeClock();
            this.pulse2.envelopeClock();
            this.triangle.linearClock();
            this.noise.envelopeClock();
        }
    }

    private void setIRQ() {
        if (!this.irqInhibit) {
            this.frameInterrupt = true;
            this.map.cpu.setIRQ(CPU_6502.IRQSource.FrameCounter);
        }
    }

    public Object[][] channelInfo() {
        this.freq[0] = this.pulse1.getInfo();
        this.freq[1] = this.pulse2.getInfo();
        this.freq[2] = this.triangle.getInfo();
        int i = 3;
        for (Channel chan : this.expansionAudio) {
            this.freq[i++] = chan.getInfo();
        }
        return this.freq;
    }

    public void doCycle() {
        if (this.delay > 0) {
            --this.delay;
        } else if (this.delay == 0) {
            this.cpucounter = 0;
            this.delay = -1;
        }
        this.triangle.clockTimer();
        this.noise.clockTimer();
        if (this.evenclock) {
            this.pulse1.clockTimer();
            this.pulse2.clockTimer();
            this.dmc.clockTimer();
            ++this.cyclenum;
        }
        boolean bl = this.evenclock = !this.evenclock;
        if (this.expansion) {
            for (Channel chan : this.expansionAudio) {
                chan.clockTimer();
            }
        }
        if (this.stepmode4) {
            switch (this.cpucounter) {
                case 7459: {
                    this.stepNumber = 0;
                    this.frameClock();
                    break;
                }
                case 14915: {
                    this.stepNumber = 1;
                    this.frameClock();
                    break;
                }
                case 22373: {
                    this.stepNumber = 2;
                    this.frameClock();
                    break;
                }
                case 29830: {
                    this.setIRQ();
                    break;
                }
                case 29831: {
                    this.stepNumber = 3;
                    this.frameClock();
                    break;
                }
                case 29832: {
                    this.setIRQ();
                    break;
                }
                case 37289: {
                    this.stepNumber = 0;
                    this.frameClock();
                    this.cpucounter = 7459;
                    break;
                }
            }
        } else {
            switch (this.cpucounter) {
                case 1: {
                    if (this.block <= 0) {
                        this.stepNumber = 2;
                        this.frameClock();
                        break;
                    }
                    --this.block;
                    break;
                }
                case 7459: {
                    this.stepNumber = 1;
                    this.frameClock();
                    break;
                }
                case 14915: {
                    this.stepNumber = 2;
                    this.frameClock();
                    break;
                }
                case 22373: {
                    this.stepNumber = 1;
                    this.frameClock();
                    break;
                }
                case 29829: {
                    break;
                }
                case 37283: {
                    this.stepNumber = 2;
                    this.frameClock();
                    this.cpucounter = 1;
                    break;
                }
            }
        }
        ++this.cpucounter;
        this.samplenum += 1.0;
        ++samplecounter;
        if (NesSettings.highQualitySampling) {
            this.mixer.mixHighQualitySample();
        } else if (this.samplenum - this.cyclespersample > 0.0) {
            this.mixer.mixSample();
            samplecounter = 0;
            this.samplenum -= this.cyclespersample;
        }
    }
}

