/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.mappers.Mapper;
import java.io.Serializable;

public class CPU_6502
implements Serializable {
    private static final long serialVersionUID = -5451202977751017819L;
    private boolean[] irqs = new boolean[3];
    final Mapper map;
    boolean showInvalid = false;
    public int program_counter;
    private byte stack_pointer;
    public byte accumulator;
    public byte x_index_register;
    private byte y_index_register;
    private boolean NFlag;
    private boolean VFlag;
    private boolean BFlag;
    private boolean DFlag;
    private boolean IFlag;
    private boolean ZFlag;
    private boolean CFlag;
    private boolean doOp = false;
    private boolean brokenaddress = false;
    public int instruction_cycle;
    public byte current_instruction;
    private byte tempregister;
    int address;
    private int pointer;
    private boolean branchtaken;
    int lowpc;
    public boolean writeDMA = false;
    public int dmac = 0;
    int dmain = 0;
    public int dxx = 0;
    int cpuinc = 0;
    public boolean doNMI = false;
    public int doIRQ = 0;
    boolean nmiInterrupt;
    boolean irqInterrupt;
    boolean nmihijack;
    boolean oldnmi = false;
    boolean nmi = false;
    public final String[] inst_name = new String[]{"BRK", "ORA", "NMI", "SLO", "SKB", "ORA", "ASL", "SLO", "PHP", "ORA", "ASL", "AAC", "SKW", "ORA", "ASL", "SLO", "BPL", "ORA", "IRQ", "SLO", "SKB", "ORA", "ASL", "SLO", "CLC", "ORA", "NOP12", "SLO", "SKW", "ORA", "ASL", "SLO", "JSR", "AND", "", "RLA", "BIT", "AND", "ROL", "RLA", "PLP", "AND", "ROL", "AAC", "BIT", "AND", "ROL", "RLA", "BMI", "AND", "HLT", "RLA", "SKB", "AND", "ROL", "RLA", "SEC", "AND", "NOP13", "RLA", "SKW", "AND", "ROL", "RLA", "RTI", "EOR", "", "SRE", "SKB", "EOR", "LSR", "SRE", "PHA", "EOR", "LSR", "ASR", "JMP_A", "EOR", "LSR", "SRE", "BVC", "EOR", "", "SRE", "SKB", "EOR", "LSR", "SRE", "CLI", "EOR", "NOP14", "SRE", "SKW", "EOR", "LSR", "SRE", "RTS", "ADC", "", "RRA", "SKB", "ADC", "ROR", "RRA", "PLA", "ADC", "ROR", "ARR", "JMP", "ADC", "ROR", "RRA", "BVS", "ADC", "", "RRA", "SKB", "ADC", "ROR", "RRA", "SEI", "ADC", "NOP15", "RRA", "SKW", "ADC", "ROR", "RRA", "SKB", "STA", "SKB", "SAX", "STY", "STA", "STX", "SAX", "DEY", "SKB", "TXA", "ANE", "STY", "STA", "STX", "SAX", "BCC", "STA", "", "SHA", "STY", "STA", "STX", "SAX", "TYA", "STA", "TXS", "SHS", "SHY", "STA", "SHX", "SHA", "LDY", "LDA", "LDX", "LAX", "LDY", "LDA", "LDX", "LAX", "TAY", "LDA", "TAX", "ATX", "LDY", "LDA", "LDX", "LAX", "BCS", "LDA", "", "LAX", "LDY", "LDA", "LDX", "LAX", "CLV", "LDA", "TSX", "LAS", "LDY", "LDA", "LDX", "LAX", "CPY", "CMP", "SKB", "DCP", "CPY", "CMP", "DEC", "DCP", "INY", "CMP", "DEX", "AXS", "CPY", "CMP", "DEC", "DCP", "BNE", "CMP", "", "DCP", "SKB", "CMP", "DEC", "DCP", "CLD", "CMP", "NOP16", "DCP", "SKW", "CMP", "DEC", "DCP", "CPX", "SBC", "SKB", "ISB", "CPX", "SBC", "INC", "ISB", "INX", "SBC", "NOP", "SBC", "CPX", "SBC", "INC", "ISB", "BEQ", "SBC", "", "ISB", "SKB", "SBC", "INC", "ISB", "SED", "SBC", "NOP17", "ISB", "SKW", "SBC", "INC", "ISB"};
    private int stallcount;
    private byte dmadata;

    public CPU_6502(Mapper mapper) {
        this.map = mapper;
        this.instruction_cycle = 1;
        this.stack_pointer = (byte)-3;
        this.setFlags((byte)52);
    }

    public void stall(int i) {
        this.stallcount = i;
    }

    public void run_cycle() {
        if (this.stallcount > 0) {
            --this.stallcount;
            return;
        }
        if (this.writeDMA) {
            this.dma();
        } else {
            this.executeInstruction();
        }
    }

    private void dma() {
        if (this.dmac == 513) {
            this.dmac = 0;
            this.dmain = 0;
            this.cpuinc = 0;
            this.writeDMA = false;
        } else if (this.dmac == 0) {
            ++this.dmac;
            this.dmadata = this.map.cpuread(this.dxx + this.cpuinc);
            this.dmain = this.map.ppu.OAMADDR;
        } else if (this.dmac % 2 == 1) {
            ++this.dmac;
            this.dmadata = this.map.cpuread(this.dxx + this.cpuinc);
        } else {
            this.map.cpuwriteoam(this.dmain, this.dmadata);
            this.dmain = this.dmain == 255 ? 0 : ++this.dmain;
            ++this.cpuinc;
            ++this.dmac;
        }
    }

    private void pollInterrupts() {
        if (this.doNMI && !this.oldnmi) {
            this.nmi = true;
        }
        this.oldnmi = this.doNMI;
        if (this.nmi) {
            this.nmiInterrupt = true;
            this.nmi = false;
        } else if (this.doIRQ > 0 && !this.IFlag) {
            this.irqInterrupt = true;
        }
    }

    public void setIRQ(IRQSource irq) {
        switch (irq) {
            case External: {
                if (this.irqs[0]) break;
                this.irqs[0] = true;
                ++this.doIRQ;
                break;
            }
            case FrameCounter: {
                if (this.irqs[1]) break;
                this.irqs[1] = true;
                ++this.doIRQ;
                break;
            }
            case DMC: {
                if (this.irqs[2]) break;
                this.irqs[2] = true;
                ++this.doIRQ;
            }
        }
    }

    public void removeIRQ(IRQSource irq) {
        switch (irq) {
            case External: {
                if (!this.irqs[0]) break;
                this.irqs[0] = false;
                --this.doIRQ;
                break;
            }
            case FrameCounter: {
                if (!this.irqs[1]) break;
                this.irqs[1] = false;
                --this.doIRQ;
                break;
            }
            case DMC: {
                if (!this.irqs[2]) break;
                this.irqs[2] = false;
                --this.doIRQ;
            }
        }
    }

    public void setNMI(boolean donmi) {
        this.doNMI = donmi;
        if (donmi && !this.oldnmi) {
            this.nmi = true;
        }
        this.oldnmi = donmi;
    }

    public void setPC(int i) {
        this.program_counter = i;
    }

    private byte getNextInstruction() {
        if (this.nmiInterrupt) {
            --this.program_counter;
            this.nmiInterrupt = false;
            return 2;
        }
        if (this.irqInterrupt) {
            this.irqInterrupt = false;
            --this.program_counter;
            return 18;
        }
        return this.map.cpuread(this.program_counter);
    }

    public Object[] getDebugInfo() {
        String name = this.instruction_cycle == 1 ? this.inst_name[this.map.cpureadu(this.program_counter)] : this.inst_name[this.current_instruction & 0xFF];
        return new Object[]{this.program_counter, name, this.instruction_cycle, Byte.toUnsignedInt(this.stack_pointer), Byte.toUnsignedInt(this.accumulator), Byte.toUnsignedInt(this.x_index_register), Byte.toUnsignedInt(this.y_index_register), this.NFlag, this.VFlag, this.DFlag, this.IFlag, this.ZFlag, this.CFlag, this.irqs, this.nmiInterrupt};
    }

    private byte buildFlags() {
        byte temp = 0;
        temp = (byte)(temp | (this.CFlag ? 1 : 0));
        temp = (byte)(temp | (this.ZFlag ? 2 : 0));
        temp = (byte)(temp | (this.IFlag ? 4 : 0));
        temp = (byte)(temp | (this.DFlag ? 8 : 0));
        temp = (byte)(temp | (this.BFlag ? 16 : 0));
        temp = (byte)(temp | 0x20);
        temp = (byte)(temp | (this.VFlag ? 64 : 0));
        temp = (byte)(temp | (this.NFlag ? 128 : 0));
        return temp;
    }

    private void setFlags(byte x) {
        this.NFlag = x < 0;
        this.VFlag = (x & 0x40) > 0;
        this.BFlag = (x & 0x10) > 0;
        this.DFlag = (x & 8) > 0;
        this.IFlag = (x & 4) > 0;
        this.ZFlag = (x & 2) > 0;
        this.CFlag = (x & 1) > 0;
    }

    public int getCurrentInstruction() {
        return Byte.toUnsignedInt(this.current_instruction);
    }

    private void executeInstruction() {
        if (this.instruction_cycle == 1) {
            if (this.doOp) {
                this.executeOp();
                this.doOp = false;
            }
            this.current_instruction = this.getNextInstruction();
            ++this.program_counter;
            this.map.cpuread(this.program_counter);
        }
        switch (Byte.toUnsignedInt(this.current_instruction)) {
            case 0: {
                this.brk();
                break;
            }
            case 1: {
                this.indx_r();
                break;
            }
            case 2: {
                this.nmi();
                break;
            }
            case 3: {
                this.indx_rw();
                break;
            }
            case 4: {
                this.zero_r();
                break;
            }
            case 5: {
                this.zero_r();
                break;
            }
            case 6: {
                this.zero_rw();
                break;
            }
            case 7: {
                this.zero_rw();
                break;
            }
            case 8: {
                this.php();
                break;
            }
            case 9: {
                this.immediate();
                break;
            }
            case 10: {
                this.accumulator();
                break;
            }
            case 11: {
                this.immediate();
                break;
            }
            case 12: {
                this.abs_r();
                break;
            }
            case 13: {
                this.abs_r();
                break;
            }
            case 14: {
                this.abs_rw();
                break;
            }
            case 15: {
                this.abs_rw();
                break;
            }
            case 16: {
                this.relative();
                break;
            }
            case 17: {
                this.indy_r();
                break;
            }
            case 18: {
                this.irq();
                break;
            }
            case 19: {
                this.indy_rw();
                break;
            }
            case 20: {
                this.zerox_r();
                break;
            }
            case 21: {
                this.zerox_r();
                break;
            }
            case 22: {
                this.zerox_rw();
                break;
            }
            case 23: {
                this.zerox_rw();
                break;
            }
            case 24: {
                this.clc();
                break;
            }
            case 25: {
                this.abs_y_r();
                break;
            }
            case 26: {
                this.nop();
                break;
            }
            case 27: {
                this.abs_y_rw();
                break;
            }
            case 28: {
                this.abs_x_r();
                break;
            }
            case 29: {
                this.abs_x_r();
                break;
            }
            case 30: {
                this.abs_x_rw();
                break;
            }
            case 31: {
                this.abs_x_rw();
                break;
            }
            case 32: {
                this.jsr();
                break;
            }
            case 33: {
                this.indx_r();
                break;
            }
            case 34: {
                break;
            }
            case 35: {
                this.indx_rw();
                break;
            }
            case 36: {
                this.zero_r();
                break;
            }
            case 37: {
                this.zero_r();
                break;
            }
            case 38: {
                this.zero_rw();
                break;
            }
            case 39: {
                this.zero_rw();
                break;
            }
            case 40: {
                this.plp();
                break;
            }
            case 41: {
                this.immediate();
                break;
            }
            case 42: {
                this.accumulator();
                break;
            }
            case 43: {
                this.immediate();
                break;
            }
            case 44: {
                this.abs_r();
                break;
            }
            case 45: {
                this.abs_r();
                break;
            }
            case 46: {
                this.abs_rw();
                break;
            }
            case 47: {
                this.abs_rw();
                break;
            }
            case 48: {
                this.relative();
                break;
            }
            case 49: {
                this.indy_r();
                break;
            }
            case 50: {
                this.hlt();
                break;
            }
            case 51: {
                this.indy_rw();
                break;
            }
            case 52: {
                this.zerox_r();
                break;
            }
            case 53: {
                this.zerox_r();
                break;
            }
            case 54: {
                this.zerox_rw();
                break;
            }
            case 55: {
                this.zerox_rw();
                break;
            }
            case 56: {
                this.sec();
                break;
            }
            case 57: {
                this.abs_y_r();
                break;
            }
            case 58: {
                this.nop();
                break;
            }
            case 59: {
                this.abs_y_rw();
                break;
            }
            case 60: {
                this.abs_x_r();
                break;
            }
            case 61: {
                this.abs_x_r();
                break;
            }
            case 62: {
                this.abs_x_rw();
                break;
            }
            case 63: {
                this.abs_x_rw();
                break;
            }
            case 64: {
                this.rti();
                break;
            }
            case 65: {
                this.indx_r();
                break;
            }
            case 66: {
                break;
            }
            case 67: {
                this.indx_rw();
                break;
            }
            case 68: {
                this.zero_r();
                break;
            }
            case 69: {
                this.zero_r();
                break;
            }
            case 70: {
                this.zero_rw();
                break;
            }
            case 71: {
                this.zero_rw();
                break;
            }
            case 72: {
                this.pha();
                break;
            }
            case 73: {
                this.immediate();
                break;
            }
            case 74: {
                this.accumulator();
                break;
            }
            case 75: {
                this.immediate();
                break;
            }
            case 76: {
                this.jmp_a();
                break;
            }
            case 77: {
                this.abs_r();
                break;
            }
            case 78: {
                this.abs_rw();
                break;
            }
            case 79: {
                this.abs_rw();
                break;
            }
            case 80: {
                this.relative();
                break;
            }
            case 81: {
                this.indy_r();
                break;
            }
            case 82: {
                break;
            }
            case 83: {
                this.indy_rw();
                break;
            }
            case 84: {
                this.zerox_r();
                break;
            }
            case 85: {
                this.zerox_r();
                break;
            }
            case 86: {
                this.zerox_rw();
                break;
            }
            case 87: {
                this.zerox_rw();
                break;
            }
            case 88: {
                this.cli();
                break;
            }
            case 89: {
                this.abs_y_r();
                break;
            }
            case 90: {
                this.nop();
                break;
            }
            case 91: {
                this.abs_y_rw();
                break;
            }
            case 92: {
                this.abs_x_r();
                break;
            }
            case 93: {
                this.abs_x_r();
                break;
            }
            case 94: {
                this.abs_x_rw();
                break;
            }
            case 95: {
                this.abs_x_rw();
                break;
            }
            case 96: {
                this.rts();
                break;
            }
            case 97: {
                this.indx_r();
                break;
            }
            case 98: {
                break;
            }
            case 99: {
                this.indx_rw();
                break;
            }
            case 100: {
                this.zero_r();
                break;
            }
            case 101: {
                this.zero_r();
                break;
            }
            case 102: {
                this.zero_rw();
                break;
            }
            case 103: {
                this.zero_rw();
                break;
            }
            case 104: {
                this.pla();
                break;
            }
            case 105: {
                this.immediate();
                break;
            }
            case 106: {
                this.accumulator();
                break;
            }
            case 107: {
                this.immediate();
                break;
            }
            case 108: {
                this.jmp();
                break;
            }
            case 109: {
                this.abs_r();
                break;
            }
            case 110: {
                this.abs_rw();
                break;
            }
            case 111: {
                this.abs_rw();
                break;
            }
            case 112: {
                this.relative();
                break;
            }
            case 113: {
                this.indy_r();
                break;
            }
            case 114: {
                break;
            }
            case 115: {
                this.indy_rw();
                break;
            }
            case 116: {
                this.zerox_r();
                break;
            }
            case 117: {
                this.zerox_r();
                break;
            }
            case 118: {
                this.zerox_rw();
                break;
            }
            case 119: {
                this.zerox_rw();
                break;
            }
            case 120: {
                this.sei();
                break;
            }
            case 121: {
                this.abs_y_r();
                break;
            }
            case 122: {
                this.nop();
                break;
            }
            case 123: {
                this.abs_y_rw();
                break;
            }
            case 124: {
                this.abs_x_r();
                break;
            }
            case 125: {
                this.abs_x_r();
                break;
            }
            case 126: {
                this.abs_x_rw();
                break;
            }
            case 127: {
                this.abs_x_rw();
                break;
            }
            case 128: {
                this.immediate();
                break;
            }
            case 129: {
                this.indx_w();
                break;
            }
            case 130: {
                this.immediate();
                break;
            }
            case 131: {
                this.indx_w();
                break;
            }
            case 132: {
                this.zero_w();
                break;
            }
            case 133: {
                this.zero_w();
                break;
            }
            case 134: {
                this.zero_w();
                break;
            }
            case 135: {
                this.zero_w();
                break;
            }
            case 136: {
                this.dey();
                break;
            }
            case 137: {
                this.immediate();
                break;
            }
            case 138: {
                this.txa();
                break;
            }
            case 139: {
                this.immediate();
                break;
            }
            case 140: {
                this.abs_w();
                break;
            }
            case 141: {
                this.abs_w();
                break;
            }
            case 142: {
                this.abs_w();
                break;
            }
            case 143: {
                this.abs_w();
                break;
            }
            case 144: {
                this.relative();
                break;
            }
            case 145: {
                this.indy_w();
                break;
            }
            case 146: {
                break;
            }
            case 147: {
                this.indy_w();
                break;
            }
            case 148: {
                this.zerox_w();
                break;
            }
            case 149: {
                this.zerox_w();
                break;
            }
            case 150: {
                this.zeroy_w();
                break;
            }
            case 151: {
                this.zeroy_w();
                break;
            }
            case 152: {
                this.tya();
                break;
            }
            case 153: {
                this.abs_y_w();
                break;
            }
            case 154: {
                this.txs();
                break;
            }
            case 155: {
                this.abs_y_w();
                break;
            }
            case 156: {
                this.shy();
                break;
            }
            case 157: {
                this.abs_x_w();
                break;
            }
            case 158: {
                this.shx();
                break;
            }
            case 159: {
                this.abs_y_w();
                break;
            }
            case 160: {
                this.immediate();
                break;
            }
            case 161: {
                this.indx_r();
                break;
            }
            case 162: {
                this.immediate();
                break;
            }
            case 163: {
                this.indx_r();
                break;
            }
            case 164: {
                this.zero_r();
                break;
            }
            case 165: {
                this.zero_r();
                break;
            }
            case 166: {
                this.zero_r();
                break;
            }
            case 167: {
                this.zero_r();
                break;
            }
            case 168: {
                this.tay();
                break;
            }
            case 169: {
                this.immediate();
                break;
            }
            case 170: {
                this.tax();
                break;
            }
            case 171: {
                this.immediate();
                break;
            }
            case 172: {
                this.abs_r();
                break;
            }
            case 173: {
                this.abs_r();
                break;
            }
            case 174: {
                this.abs_r();
                break;
            }
            case 175: {
                this.abs_r();
                break;
            }
            case 176: {
                this.relative();
                break;
            }
            case 177: {
                this.indy_r();
                break;
            }
            case 178: {
                break;
            }
            case 179: {
                this.indy_r();
                break;
            }
            case 180: {
                this.zerox_r();
                break;
            }
            case 181: {
                this.zerox_r();
                break;
            }
            case 182: {
                this.zeroy_r();
                break;
            }
            case 183: {
                this.zeroy_r();
                break;
            }
            case 184: {
                this.clv();
                break;
            }
            case 185: {
                this.abs_y_r();
                break;
            }
            case 186: {
                this.tsx();
                break;
            }
            case 187: {
                this.abs_y_r();
                break;
            }
            case 188: {
                this.abs_x_r();
                break;
            }
            case 189: {
                this.abs_x_r();
                break;
            }
            case 190: {
                this.abs_y_r();
                break;
            }
            case 191: {
                this.abs_y_r();
                break;
            }
            case 192: {
                this.immediate();
                break;
            }
            case 193: {
                this.indx_r();
                break;
            }
            case 194: {
                this.immediate();
                break;
            }
            case 195: {
                this.indx_rw();
                break;
            }
            case 196: {
                this.zero_r();
                break;
            }
            case 197: {
                this.zero_r();
                break;
            }
            case 198: {
                this.zero_rw();
                break;
            }
            case 199: {
                this.zero_rw();
                break;
            }
            case 200: {
                this.iny();
                break;
            }
            case 201: {
                this.immediate();
                break;
            }
            case 202: {
                this.dex();
                break;
            }
            case 203: {
                this.immediate();
                break;
            }
            case 204: {
                this.abs_r();
                break;
            }
            case 205: {
                this.abs_r();
                break;
            }
            case 206: {
                this.abs_rw();
                break;
            }
            case 207: {
                this.abs_rw();
                break;
            }
            case 208: {
                this.relative();
                break;
            }
            case 209: {
                this.indy_r();
                break;
            }
            case 210: {
                break;
            }
            case 211: {
                this.indy_rw();
                break;
            }
            case 212: {
                this.zerox_r();
                break;
            }
            case 213: {
                this.zerox_r();
                break;
            }
            case 214: {
                this.zerox_rw();
                break;
            }
            case 215: {
                this.zerox_rw();
                break;
            }
            case 216: {
                this.cld();
                break;
            }
            case 217: {
                this.abs_y_r();
                break;
            }
            case 218: {
                this.nop();
                break;
            }
            case 219: {
                this.abs_y_rw();
                break;
            }
            case 220: {
                this.abs_x_r();
                break;
            }
            case 221: {
                this.abs_x_r();
                break;
            }
            case 222: {
                this.abs_x_rw();
                break;
            }
            case 223: {
                this.abs_x_rw();
                break;
            }
            case 224: {
                this.immediate();
                break;
            }
            case 225: {
                this.indx_r();
                break;
            }
            case 226: {
                this.immediate();
                break;
            }
            case 227: {
                this.indx_rw();
                break;
            }
            case 228: {
                this.zero_r();
                break;
            }
            case 229: {
                this.zero_r();
                break;
            }
            case 230: {
                this.zero_rw();
                break;
            }
            case 231: {
                this.zero_rw();
                break;
            }
            case 232: {
                this.inx();
                break;
            }
            case 233: {
                this.immediate();
                break;
            }
            case 234: {
                this.nop();
                break;
            }
            case 235: {
                this.immediate();
                break;
            }
            case 236: {
                this.abs_r();
                break;
            }
            case 237: {
                this.abs_r();
                break;
            }
            case 238: {
                this.abs_rw();
                break;
            }
            case 239: {
                this.abs_rw();
                break;
            }
            case 240: {
                this.relative();
                break;
            }
            case 241: {
                this.indy_r();
                break;
            }
            case 242: {
                break;
            }
            case 243: {
                this.indy_rw();
                break;
            }
            case 244: {
                this.zerox_r();
                break;
            }
            case 245: {
                this.zerox_r();
                break;
            }
            case 246: {
                this.zerox_rw();
                break;
            }
            case 247: {
                this.zerox_rw();
                break;
            }
            case 248: {
                this.sed();
                break;
            }
            case 249: {
                this.abs_y_r();
                break;
            }
            case 250: {
                this.nop();
                break;
            }
            case 251: {
                this.abs_y_rw();
                break;
            }
            case 252: {
                this.abs_x_r();
                break;
            }
            case 253: {
                this.abs_x_r();
                break;
            }
            case 254: {
                this.abs_x_rw();
                break;
            }
            case 255: {
                this.abs_x_rw();
            }
        }
    }

    private void executeOp() {
        switch (Byte.toUnsignedInt(this.current_instruction)) {
            case 0: {
                this.brk();
                break;
            }
            case 1: {
                this.ora();
                break;
            }
            case 2: {
                this.nmi();
                break;
            }
            case 3: {
                this.slo();
                break;
            }
            case 4: {
                this.skb();
                break;
            }
            case 5: {
                this.ora();
                break;
            }
            case 6: {
                this.asl();
                break;
            }
            case 7: {
                this.slo();
                break;
            }
            case 8: {
                this.php();
                break;
            }
            case 9: {
                this.ora();
                break;
            }
            case 10: {
                this.asl();
                break;
            }
            case 11: {
                this.aac();
                break;
            }
            case 12: {
                this.skw();
                break;
            }
            case 13: {
                this.ora();
                break;
            }
            case 14: {
                this.asl();
                break;
            }
            case 15: {
                this.slo();
                break;
            }
            case 16: {
                this.bpl();
                break;
            }
            case 17: {
                this.ora();
                break;
            }
            case 18: {
                this.irq();
                break;
            }
            case 19: {
                this.slo();
                break;
            }
            case 20: {
                this.skb();
                break;
            }
            case 21: {
                this.ora();
                break;
            }
            case 22: {
                this.asl();
                break;
            }
            case 23: {
                this.slo();
                break;
            }
            case 24: {
                this.clc();
                break;
            }
            case 25: {
                this.ora();
                break;
            }
            case 26: {
                this.nop();
                break;
            }
            case 27: {
                this.slo();
                break;
            }
            case 28: {
                this.skw();
                break;
            }
            case 29: {
                this.ora();
                break;
            }
            case 30: {
                this.asl();
                break;
            }
            case 31: {
                this.slo();
                break;
            }
            case 32: {
                this.jsr();
                break;
            }
            case 33: {
                this.and();
                break;
            }
            case 34: {
                break;
            }
            case 35: {
                this.rla();
                break;
            }
            case 36: {
                this.bit();
                break;
            }
            case 37: {
                this.and();
                break;
            }
            case 38: {
                this.rol();
                break;
            }
            case 39: {
                this.rla();
                break;
            }
            case 40: {
                this.plp();
                break;
            }
            case 41: {
                this.and();
                break;
            }
            case 42: {
                this.rol();
                break;
            }
            case 43: {
                this.aac();
                break;
            }
            case 44: {
                this.bit();
                break;
            }
            case 45: {
                this.and();
                break;
            }
            case 46: {
                this.rol();
                break;
            }
            case 47: {
                this.rla();
                break;
            }
            case 48: {
                this.bmi();
                break;
            }
            case 49: {
                this.and();
                break;
            }
            case 50: {
                this.hlt();
                break;
            }
            case 51: {
                this.rla();
                break;
            }
            case 52: {
                this.skb();
                break;
            }
            case 53: {
                this.and();
                break;
            }
            case 54: {
                this.rol();
                break;
            }
            case 55: {
                this.rla();
                break;
            }
            case 56: {
                this.sec();
                break;
            }
            case 57: {
                this.and();
                break;
            }
            case 58: {
                this.nop();
                break;
            }
            case 59: {
                this.rla();
                break;
            }
            case 60: {
                this.skw();
                break;
            }
            case 61: {
                this.and();
                break;
            }
            case 62: {
                this.rol();
                break;
            }
            case 63: {
                this.rla();
                break;
            }
            case 64: {
                this.rti();
                break;
            }
            case 65: {
                this.eor();
                break;
            }
            case 66: {
                break;
            }
            case 67: {
                this.sre();
                break;
            }
            case 68: {
                this.skb();
                break;
            }
            case 69: {
                this.eor();
                break;
            }
            case 70: {
                this.lsr();
                break;
            }
            case 71: {
                this.sre();
                break;
            }
            case 72: {
                this.pha();
                break;
            }
            case 73: {
                this.eor();
                break;
            }
            case 74: {
                this.lsr();
                break;
            }
            case 75: {
                this.asr();
                break;
            }
            case 76: {
                this.jmp_a();
                break;
            }
            case 77: {
                this.eor();
                break;
            }
            case 78: {
                this.lsr();
                break;
            }
            case 79: {
                this.sre();
                break;
            }
            case 80: {
                this.bvc();
                break;
            }
            case 81: {
                this.eor();
                break;
            }
            case 82: {
                break;
            }
            case 83: {
                this.sre();
                break;
            }
            case 84: {
                this.skb();
                break;
            }
            case 85: {
                this.eor();
                break;
            }
            case 86: {
                this.lsr();
                break;
            }
            case 87: {
                this.sre();
                break;
            }
            case 88: {
                this.cli();
                break;
            }
            case 89: {
                this.eor();
                break;
            }
            case 90: {
                this.nop();
                break;
            }
            case 91: {
                this.sre();
                break;
            }
            case 92: {
                this.skw();
                break;
            }
            case 93: {
                this.eor();
                break;
            }
            case 94: {
                this.lsr();
                break;
            }
            case 95: {
                this.sre();
                break;
            }
            case 96: {
                this.rts();
                break;
            }
            case 97: {
                this.adc();
                break;
            }
            case 98: {
                break;
            }
            case 99: {
                this.rra();
                break;
            }
            case 100: {
                this.skb();
                break;
            }
            case 101: {
                this.adc();
                break;
            }
            case 102: {
                this.ror();
                break;
            }
            case 103: {
                this.rra();
                break;
            }
            case 104: {
                this.pla();
                break;
            }
            case 105: {
                this.adc();
                break;
            }
            case 106: {
                this.ror();
                break;
            }
            case 107: {
                this.arr();
                break;
            }
            case 108: {
                this.jmp();
                break;
            }
            case 109: {
                this.adc();
                break;
            }
            case 110: {
                this.ror();
                break;
            }
            case 111: {
                this.rra();
                break;
            }
            case 112: {
                this.bvs();
                break;
            }
            case 113: {
                this.adc();
                break;
            }
            case 114: {
                break;
            }
            case 115: {
                this.rra();
                break;
            }
            case 116: {
                this.skb();
                break;
            }
            case 117: {
                this.adc();
                break;
            }
            case 118: {
                this.ror();
                break;
            }
            case 119: {
                this.rra();
                break;
            }
            case 120: {
                this.sei();
                break;
            }
            case 121: {
                this.adc();
                break;
            }
            case 122: {
                this.nop();
                break;
            }
            case 123: {
                this.rra();
                break;
            }
            case 124: {
                this.skw();
                break;
            }
            case 125: {
                this.adc();
                break;
            }
            case 126: {
                this.ror();
                break;
            }
            case 127: {
                this.rra();
                break;
            }
            case 128: {
                this.skb();
                break;
            }
            case 129: {
                this.sta();
                break;
            }
            case 130: {
                this.skb();
                break;
            }
            case 131: {
                this.sax();
                break;
            }
            case 132: {
                this.sty();
                break;
            }
            case 133: {
                this.sta();
                break;
            }
            case 134: {
                this.stx();
                break;
            }
            case 135: {
                this.sax();
                break;
            }
            case 136: {
                this.dey();
                break;
            }
            case 137: {
                this.skb();
                break;
            }
            case 138: {
                this.txa();
                break;
            }
            case 139: {
                this.ane();
                break;
            }
            case 140: {
                this.sty();
                break;
            }
            case 141: {
                this.sta();
                break;
            }
            case 142: {
                this.stx();
                break;
            }
            case 143: {
                this.sax();
                break;
            }
            case 144: {
                this.bcc();
                break;
            }
            case 145: {
                this.sta();
                break;
            }
            case 146: {
                break;
            }
            case 147: {
                this.sha();
                break;
            }
            case 148: {
                this.sty();
                break;
            }
            case 149: {
                this.sta();
                break;
            }
            case 150: {
                this.stx();
                break;
            }
            case 151: {
                this.sax();
                break;
            }
            case 152: {
                this.tya();
                break;
            }
            case 153: {
                this.sta();
                break;
            }
            case 154: {
                this.txs();
                break;
            }
            case 155: {
                this.shs();
                break;
            }
            case 156: {
                this.shy();
                break;
            }
            case 157: {
                this.sta();
                break;
            }
            case 158: {
                this.shx();
                break;
            }
            case 159: {
                this.sha();
                break;
            }
            case 160: {
                this.ldy();
                break;
            }
            case 161: {
                this.lda();
                break;
            }
            case 162: {
                this.ldx();
                break;
            }
            case 163: {
                this.lax();
                break;
            }
            case 164: {
                this.ldy();
                break;
            }
            case 165: {
                this.lda();
                break;
            }
            case 166: {
                this.ldx();
                break;
            }
            case 167: {
                this.lax();
                break;
            }
            case 168: {
                this.tay();
                break;
            }
            case 169: {
                this.lda();
                break;
            }
            case 170: {
                this.tax();
                break;
            }
            case 171: {
                this.atx();
                break;
            }
            case 172: {
                this.ldy();
                break;
            }
            case 173: {
                this.lda();
                break;
            }
            case 174: {
                this.ldx();
                break;
            }
            case 175: {
                this.lax();
                break;
            }
            case 176: {
                this.bcs();
                break;
            }
            case 177: {
                this.lda();
                break;
            }
            case 178: {
                break;
            }
            case 179: {
                this.lax();
                break;
            }
            case 180: {
                this.ldy();
                break;
            }
            case 181: {
                this.lda();
                break;
            }
            case 182: {
                this.ldx();
                break;
            }
            case 183: {
                this.lax();
                break;
            }
            case 184: {
                this.clv();
                break;
            }
            case 185: {
                this.lda();
                break;
            }
            case 186: {
                this.tsx();
                break;
            }
            case 187: {
                this.las();
                break;
            }
            case 188: {
                this.ldy();
                break;
            }
            case 189: {
                this.lda();
                break;
            }
            case 190: {
                this.ldx();
                break;
            }
            case 191: {
                this.lax();
                break;
            }
            case 192: {
                this.cpy();
                break;
            }
            case 193: {
                this.cmp();
                break;
            }
            case 194: {
                this.skb();
                break;
            }
            case 195: {
                this.dcp();
                break;
            }
            case 196: {
                this.cpy();
                break;
            }
            case 197: {
                this.cmp();
                break;
            }
            case 198: {
                this.dec();
                break;
            }
            case 199: {
                this.dcp();
                break;
            }
            case 200: {
                this.iny();
                break;
            }
            case 201: {
                this.cmp();
                break;
            }
            case 202: {
                this.dex();
                break;
            }
            case 203: {
                this.axs();
                break;
            }
            case 204: {
                this.cpy();
                break;
            }
            case 205: {
                this.cmp();
                break;
            }
            case 206: {
                this.dec();
                break;
            }
            case 207: {
                this.dcp();
                break;
            }
            case 208: {
                this.bne();
                break;
            }
            case 209: {
                this.cmp();
                break;
            }
            case 210: {
                break;
            }
            case 211: {
                this.dcp();
                break;
            }
            case 212: {
                this.skb();
                break;
            }
            case 213: {
                this.cmp();
                break;
            }
            case 214: {
                this.dec();
                break;
            }
            case 215: {
                this.dcp();
                break;
            }
            case 216: {
                this.cld();
                break;
            }
            case 217: {
                this.cmp();
                break;
            }
            case 218: {
                this.nop();
                break;
            }
            case 219: {
                this.dcp();
                break;
            }
            case 220: {
                this.skw();
                break;
            }
            case 221: {
                this.cmp();
                break;
            }
            case 222: {
                this.dec();
                break;
            }
            case 223: {
                this.dcp();
                break;
            }
            case 224: {
                this.cpx();
                break;
            }
            case 225: {
                this.sbc();
                break;
            }
            case 226: {
                this.skb();
                break;
            }
            case 227: {
                this.isb();
                break;
            }
            case 228: {
                this.cpx();
                break;
            }
            case 229: {
                this.sbc();
                break;
            }
            case 230: {
                this.inc();
                break;
            }
            case 231: {
                this.isb();
                break;
            }
            case 232: {
                this.inx();
                break;
            }
            case 233: {
                this.sbc();
                break;
            }
            case 234: {
                this.nop();
                break;
            }
            case 235: {
                this.sbc();
                break;
            }
            case 236: {
                this.cpx();
                break;
            }
            case 237: {
                this.sbc();
                break;
            }
            case 238: {
                this.inc();
                break;
            }
            case 239: {
                this.isb();
                break;
            }
            case 240: {
                this.beq();
                break;
            }
            case 241: {
                this.sbc();
                break;
            }
            case 242: {
                break;
            }
            case 243: {
                this.isb();
                break;
            }
            case 244: {
                this.skb();
                break;
            }
            case 245: {
                this.sbc();
                break;
            }
            case 246: {
                this.inc();
                break;
            }
            case 247: {
                this.isb();
                break;
            }
            case 248: {
                this.sed();
                break;
            }
            case 249: {
                this.sbc();
                break;
            }
            case 250: {
                this.nop();
                break;
            }
            case 251: {
                this.isb();
                break;
            }
            case 252: {
                this.skw();
                break;
            }
            case 253: {
                this.sbc();
                break;
            }
            case 254: {
                this.inc();
                break;
            }
            case 255: {
                this.isb();
            }
        }
    }

    private void immediate() {
        switch (this.instruction_cycle) {
            case 1: {
                this.pollInterrupts();
                ++this.instruction_cycle;
                break;
            }
            case 2: {
                this.tempregister = this.map.cpuread(this.program_counter);
                ++this.program_counter;
                this.doOp = true;
                this.instruction_cycle = 1;
            }
        }
    }

    private void zero_r() {
        switch (this.instruction_cycle) {
            case 1: {
                ++this.instruction_cycle;
                break;
            }
            case 2: {
                this.address = this.map.cpureadu(this.program_counter);
                ++this.program_counter;
                ++this.instruction_cycle;
                this.pollInterrupts();
                break;
            }
            case 3: {
                this.tempregister = this.map.cpuread(this.address);
                this.instruction_cycle = 1;
                this.doOp = true;
            }
        }
    }

    private void zero_rw() {
        switch (this.instruction_cycle) {
            case 1: {
                ++this.instruction_cycle;
                break;
            }
            case 2: {
                this.address = this.map.cpureadu(this.program_counter);
                ++this.program_counter;
                ++this.instruction_cycle;
                break;
            }
            case 3: {
                this.tempregister = this.map.cpuread(this.address);
                ++this.instruction_cycle;
                break;
            }
            case 4: {
                this.map.cpuwrite(this.address, this.tempregister);
                this.executeOp();
                this.pollInterrupts();
                ++this.instruction_cycle;
                break;
            }
            case 5: {
                this.map.cpuwrite(this.address, this.tempregister);
                this.address = 0;
                this.instruction_cycle = 1;
            }
        }
    }

    private void zero_w() {
        switch (this.instruction_cycle) {
            case 1: {
                ++this.instruction_cycle;
                break;
            }
            case 2: {
                this.address = this.map.cpureadu(this.program_counter);
                ++this.program_counter;
                this.pollInterrupts();
                ++this.instruction_cycle;
                break;
            }
            case 3: {
                this.executeOp();
                this.address = 0;
                this.instruction_cycle = 1;
            }
        }
    }

    private void zerox_r() {
        switch (this.instruction_cycle) {
            case 1: {
                ++this.instruction_cycle;
                break;
            }
            case 2: {
                this.address = this.map.cpureadu(this.program_counter);
                ++this.program_counter;
                ++this.instruction_cycle;
                break;
            }
            case 3: {
                this.address += Byte.toUnsignedInt(this.x_index_register);
                ++this.instruction_cycle;
                this.pollInterrupts();
                break;
            }
            case 4: {
                this.address &= 0xFF;
                this.tempregister = this.map.cpuread(this.address);
                this.instruction_cycle = 1;
                this.doOp = true;
            }
        }
    }

    private void zerox_rw() {
        switch (this.instruction_cycle) {
            case 1: {
                ++this.instruction_cycle;
                break;
            }
            case 2: {
                this.address = this.map.cpureadu(this.program_counter);
                ++this.program_counter;
                ++this.instruction_cycle;
                break;
            }
            case 3: {
                this.address += Byte.toUnsignedInt(this.x_index_register);
                ++this.instruction_cycle;
                break;
            }
            case 4: {
                this.address &= 0xFF;
                this.tempregister = this.map.cpuread(this.address);
                ++this.instruction_cycle;
                break;
            }
            case 5: {
                this.map.cpuwrite(this.address, this.tempregister);
                this.executeOp();
                this.pollInterrupts();
                ++this.instruction_cycle;
                break;
            }
            case 6: {
                this.map.cpuwrite(this.address, this.tempregister);
                this.instruction_cycle = 1;
                this.address = 0;
            }
        }
    }

    private void zerox_w() {
        switch (this.instruction_cycle) {
            case 1: {
                ++this.instruction_cycle;
                break;
            }
            case 2: {
                this.address = this.map.cpureadu(this.program_counter);
                ++this.program_counter;
                ++this.instruction_cycle;
                break;
            }
            case 3: {
                this.address += Byte.toUnsignedInt(this.x_index_register);
                ++this.instruction_cycle;
                this.pollInterrupts();
                break;
            }
            case 4: {
                this.address &= 0xFF;
                this.executeOp();
                this.instruction_cycle = 1;
            }
        }
    }

    private void zeroy_r() {
        switch (this.instruction_cycle) {
            case 1: {
                ++this.instruction_cycle;
                break;
            }
            case 2: {
                this.address = this.map.cpureadu(this.program_counter);
                ++this.program_counter;
                ++this.instruction_cycle;
                break;
            }
            case 3: {
                this.address += Byte.toUnsignedInt(this.y_index_register);
                ++this.instruction_cycle;
                this.pollInterrupts();
                break;
            }
            case 4: {
                this.address &= 0xFF;
                this.tempregister = this.map.cpuread(this.address);
                this.instruction_cycle = 1;
                this.doOp = true;
            }
        }
    }

    private void zeroy_w() {
        switch (this.instruction_cycle) {
            case 1: {
                ++this.instruction_cycle;
                break;
            }
            case 2: {
                this.address = this.map.cpureadu(this.program_counter);
                ++this.program_counter;
                ++this.instruction_cycle;
                break;
            }
            case 3: {
                this.address += Byte.toUnsignedInt(this.y_index_register);
                ++this.instruction_cycle;
                this.pollInterrupts();
                break;
            }
            case 4: {
                this.address &= 0xFF;
                this.executeOp();
                this.instruction_cycle = 1;
            }
        }
    }

    private void abs_r() {
        switch (this.instruction_cycle) {
            case 1: {
                ++this.instruction_cycle;
                break;
            }
            case 2: {
                this.address = this.map.cpureadu(this.program_counter);
                ++this.program_counter;
                ++this.instruction_cycle;
                break;
            }
            case 3: {
                this.address |= this.map.cpureadu(this.program_counter) << 8;
                ++this.program_counter;
                ++this.instruction_cycle;
                this.pollInterrupts();
                break;
            }
            case 4: {
                this.tempregister = this.map.cpuread(this.address);
                this.instruction_cycle = 1;
                this.doOp = true;
            }
        }
    }

    private void abs_rw() {
        switch (this.instruction_cycle) {
            case 1: {
                ++this.instruction_cycle;
                break;
            }
            case 2: {
                this.address = this.map.cpureadu(this.program_counter);
                ++this.program_counter;
                ++this.instruction_cycle;
                break;
            }
            case 3: {
                this.address |= this.map.cpureadu(this.program_counter) << 8;
                ++this.program_counter;
                ++this.instruction_cycle;
                break;
            }
            case 4: {
                this.tempregister = this.map.cpuread(this.address);
                ++this.instruction_cycle;
                break;
            }
            case 5: {
                this.map.cpuwrite(this.address, this.tempregister);
                this.executeOp();
                this.pollInterrupts();
                ++this.instruction_cycle;
                break;
            }
            case 6: {
                this.map.cpuwrite(this.address, this.tempregister);
                this.instruction_cycle = 1;
                this.address = 0;
            }
        }
    }

    private void abs_w() {
        switch (this.instruction_cycle) {
            case 1: {
                ++this.instruction_cycle;
                break;
            }
            case 2: {
                this.address = this.map.cpureadu(this.program_counter);
                ++this.program_counter;
                ++this.instruction_cycle;
                break;
            }
            case 3: {
                this.address |= this.map.cpureadu(this.program_counter) << 8;
                ++this.program_counter;
                ++this.instruction_cycle;
                this.pollInterrupts();
                break;
            }
            case 4: {
                this.executeOp();
                this.address = 0;
                this.instruction_cycle = 1;
            }
        }
    }

    private void abs_x_r() {
        switch (this.instruction_cycle) {
            case 1: {
                ++this.instruction_cycle;
                break;
            }
            case 2: {
                this.address = this.map.cpureadu(this.program_counter);
                ++this.program_counter;
                ++this.instruction_cycle;
                break;
            }
            case 3: {
                this.address |= this.map.cpureadu(this.program_counter) << 8;
                this.lowpc = this.address & 0xFF00;
                this.address += Byte.toUnsignedInt(this.x_index_register);
                ++this.program_counter;
                if (this.lowpc == (this.address & 0xFF00)) {
                    this.pollInterrupts();
                }
                ++this.instruction_cycle;
                break;
            }
            case 4: {
                if (this.lowpc != (this.address & 0xFF00)) {
                    this.address &= 0xFFFF;
                    this.pollInterrupts();
                    this.tempregister = this.map.cpuread(this.address & 0xFF | this.lowpc);
                    ++this.instruction_cycle;
                    break;
                }
                this.address &= 0xFFFF;
                this.tempregister = this.map.cpuread(this.address);
                this.instruction_cycle = 1;
                this.doOp = true;
                break;
            }
            case 5: {
                this.tempregister = this.map.cpuread(this.address);
                this.instruction_cycle = 1;
                this.doOp = true;
            }
        }
    }

    private void abs_x_rw() {
        switch (this.instruction_cycle) {
            case 1: {
                ++this.instruction_cycle;
                break;
            }
            case 2: {
                this.address = 0;
                this.address |= this.map.cpureadu(this.program_counter);
                ++this.program_counter;
                ++this.instruction_cycle;
                break;
            }
            case 3: {
                this.address |= this.map.cpureadu(this.program_counter) << 8;
                this.lowpc = this.address & 0xFF00;
                this.address += Byte.toUnsignedInt(this.x_index_register);
                ++this.program_counter;
                ++this.instruction_cycle;
                break;
            }
            case 4: {
                this.address &= 0xFFFF;
                this.tempregister = this.map.cpuread(this.address & 0xFF | this.lowpc);
                ++this.instruction_cycle;
                break;
            }
            case 5: {
                this.tempregister = this.map.cpuread(this.address);
                ++this.instruction_cycle;
                break;
            }
            case 6: {
                this.map.cpuwrite(this.address, this.tempregister);
                this.executeOp();
                this.pollInterrupts();
                ++this.instruction_cycle;
                break;
            }
            case 7: {
                this.map.cpuwrite(this.address, this.tempregister);
                this.instruction_cycle = 1;
            }
        }
    }

    private void abs_x_w() {
        switch (this.instruction_cycle) {
            case 1: {
                ++this.instruction_cycle;
                break;
            }
            case 2: {
                this.address = this.map.cpureadu(this.program_counter);
                ++this.program_counter;
                ++this.instruction_cycle;
                break;
            }
            case 3: {
                this.address |= this.map.cpureadu(this.program_counter) << 8;
                this.lowpc = this.address & 0xFF00;
                this.address += Byte.toUnsignedInt(this.x_index_register);
                ++this.program_counter;
                ++this.instruction_cycle;
                break;
            }
            case 4: {
                this.address &= 0xFFFF;
                this.tempregister = this.map.cpuread(this.address & 0xFF | this.lowpc);
                this.pollInterrupts();
                ++this.instruction_cycle;
                break;
            }
            case 5: {
                this.executeOp();
                this.instruction_cycle = 1;
            }
        }
    }

    private void abs_y_r() {
        switch (this.instruction_cycle) {
            case 1: {
                ++this.instruction_cycle;
                break;
            }
            case 2: {
                this.address = 0;
                this.address = this.map.cpureadu(this.program_counter);
                ++this.program_counter;
                ++this.instruction_cycle;
                break;
            }
            case 3: {
                this.address |= this.map.cpureadu(this.program_counter) << 8;
                this.lowpc = this.address & 0xFF00;
                this.address += Byte.toUnsignedInt(this.y_index_register);
                ++this.program_counter;
                if (this.lowpc == (this.address & 0xFF00)) {
                    this.pollInterrupts();
                }
                ++this.instruction_cycle;
                break;
            }
            case 4: {
                if (this.lowpc != (this.address & 0xFF00)) {
                    this.brokenaddress = true;
                    this.address &= 0xFFFF;
                    this.tempregister = this.map.cpuread(this.address & 0xFF | this.lowpc);
                    this.pollInterrupts();
                    ++this.instruction_cycle;
                    break;
                }
                this.address &= 0xFFFF;
                this.tempregister = this.map.cpuread(this.address);
                this.instruction_cycle = 1;
                this.doOp = true;
                break;
            }
            case 5: {
                this.tempregister = this.map.cpuread(this.address);
                this.brokenaddress = false;
                this.instruction_cycle = 1;
                this.doOp = true;
            }
        }
    }

    private void abs_y_rw() {
        switch (this.instruction_cycle) {
            case 1: {
                ++this.instruction_cycle;
                break;
            }
            case 2: {
                this.address = 0;
                this.address |= this.map.cpureadu(this.program_counter);
                ++this.program_counter;
                ++this.instruction_cycle;
                break;
            }
            case 3: {
                this.address |= this.map.cpureadu(this.program_counter) << 8;
                this.lowpc = this.address & 0xFF00;
                this.address += Byte.toUnsignedInt(this.y_index_register);
                ++this.program_counter;
                ++this.instruction_cycle;
                break;
            }
            case 4: {
                this.address &= 0xFFFF;
                this.tempregister = this.map.cpuread(this.address & 0xFF | this.lowpc);
                ++this.instruction_cycle;
                break;
            }
            case 5: {
                this.tempregister = this.map.cpuread(this.address);
                ++this.instruction_cycle;
                break;
            }
            case 6: {
                this.map.cpuwrite(this.address, this.tempregister);
                this.executeOp();
                this.pollInterrupts();
                ++this.instruction_cycle;
                break;
            }
            case 7: {
                this.map.cpuwrite(this.address, this.tempregister);
                this.instruction_cycle = 1;
            }
        }
    }

    private void abs_y_w() {
        switch (this.instruction_cycle) {
            case 1: {
                ++this.instruction_cycle;
                break;
            }
            case 2: {
                this.address = this.map.cpureadu(this.program_counter);
                ++this.program_counter;
                ++this.instruction_cycle;
                break;
            }
            case 3: {
                this.address |= this.map.cpureadu(this.program_counter) << 8;
                this.lowpc = this.address & 0xFF00;
                this.address += Byte.toUnsignedInt(this.y_index_register);
                ++this.program_counter;
                ++this.instruction_cycle;
                break;
            }
            case 4: {
                this.address &= 0xFFFF;
                this.tempregister = this.map.cpuread(this.address & 0xFF | this.lowpc);
                this.pollInterrupts();
                ++this.instruction_cycle;
                break;
            }
            case 5: {
                this.executeOp();
                this.instruction_cycle = 1;
            }
        }
    }

    private void indx_r() {
        switch (this.instruction_cycle) {
            case 1: {
                ++this.instruction_cycle;
                break;
            }
            case 2: {
                this.pointer = this.map.cpureadu(this.program_counter);
                ++this.program_counter;
                ++this.instruction_cycle;
                break;
            }
            case 3: {
                this.pointer += Byte.toUnsignedInt(this.x_index_register);
                ++this.instruction_cycle;
                break;
            }
            case 4: {
                this.pointer &= 0xFF;
                this.address = this.map.cpureadu(this.pointer);
                ++this.instruction_cycle;
                break;
            }
            case 5: {
                ++this.pointer;
                this.pointer &= 0xFF;
                this.address |= this.map.cpureadu(this.pointer) << 8;
                this.pollInterrupts();
                ++this.instruction_cycle;
                break;
            }
            case 6: {
                this.tempregister = this.map.cpuread(this.address);
                this.instruction_cycle = 1;
                this.doOp = true;
            }
        }
    }

    private void indx_rw() {
        switch (this.instruction_cycle) {
            case 1: {
                ++this.instruction_cycle;
                break;
            }
            case 2: {
                this.pointer = this.map.cpureadu(this.program_counter);
                ++this.program_counter;
                ++this.instruction_cycle;
                break;
            }
            case 3: {
                this.pointer += Byte.toUnsignedInt(this.x_index_register);
                ++this.instruction_cycle;
                break;
            }
            case 4: {
                this.pointer &= 0xFF;
                this.address = this.map.cpureadu(this.pointer);
                ++this.instruction_cycle;
                break;
            }
            case 5: {
                ++this.pointer;
                this.pointer &= 0xFF;
                this.address |= this.map.cpureadu(this.pointer) << 8;
                ++this.instruction_cycle;
                break;
            }
            case 6: {
                this.tempregister = this.map.cpuread(this.address);
                ++this.instruction_cycle;
                break;
            }
            case 7: {
                this.map.cpuwrite(this.address, this.tempregister);
                this.executeOp();
                this.pollInterrupts();
                ++this.instruction_cycle;
                break;
            }
            case 8: {
                this.map.cpuwrite(this.address, this.tempregister);
                this.instruction_cycle = 1;
            }
        }
    }

    private void indx_w() {
        switch (this.instruction_cycle) {
            case 1: {
                ++this.instruction_cycle;
                break;
            }
            case 2: {
                this.pointer = this.map.cpureadu(this.program_counter);
                ++this.program_counter;
                ++this.instruction_cycle;
                break;
            }
            case 3: {
                this.pointer += Byte.toUnsignedInt(this.x_index_register);
                ++this.instruction_cycle;
                break;
            }
            case 4: {
                this.pointer &= 0xFF;
                this.address = this.map.cpureadu(this.pointer);
                ++this.instruction_cycle;
                break;
            }
            case 5: {
                ++this.pointer;
                this.pointer &= 0xFF;
                this.address |= this.map.cpureadu(this.pointer) << 8;
                this.pollInterrupts();
                ++this.instruction_cycle;
                break;
            }
            case 6: {
                this.tempregister = 0;
                this.executeOp();
                this.instruction_cycle = 1;
            }
        }
    }

    private void indy_r() {
        switch (this.instruction_cycle) {
            case 1: {
                ++this.instruction_cycle;
                break;
            }
            case 2: {
                this.pointer = this.map.cpureadu(this.program_counter);
                ++this.program_counter;
                ++this.instruction_cycle;
                break;
            }
            case 3: {
                this.address = this.map.cpureadu(this.pointer);
                ++this.instruction_cycle;
                break;
            }
            case 4: {
                this.address = this.pointer + 1 > 255 ? (this.address |= this.map.cpureadu(0) << 8) : (this.address |= this.map.cpureadu(this.pointer + 1) << 8);
                this.lowpc = this.address & 0xFF00;
                this.address += Byte.toUnsignedInt(this.y_index_register);
                if (this.lowpc != (this.address & 0xFF00)) {
                    this.brokenaddress = true;
                } else {
                    this.pollInterrupts();
                }
                ++this.instruction_cycle;
                break;
            }
            case 5: {
                if (this.brokenaddress) {
                    this.brokenaddress = false;
                    this.tempregister = this.map.cpuread(this.address & 0xFF | this.lowpc);
                    this.address &= 0xFFFF;
                    this.pollInterrupts();
                    ++this.instruction_cycle;
                    break;
                }
                this.tempregister = this.map.cpuread(this.address);
                this.instruction_cycle = 1;
                this.doOp = true;
                break;
            }
            case 6: {
                this.tempregister = this.map.cpuread(this.address);
                this.instruction_cycle = 1;
                this.doOp = true;
            }
        }
    }

    private void indy_rw() {
        switch (this.instruction_cycle) {
            case 1: {
                ++this.instruction_cycle;
                break;
            }
            case 2: {
                this.pointer = this.map.cpureadu(this.program_counter);
                ++this.program_counter;
                ++this.instruction_cycle;
                break;
            }
            case 3: {
                this.address = this.map.cpureadu(this.pointer);
                ++this.instruction_cycle;
                break;
            }
            case 4: {
                this.address = this.pointer + 1 > 255 ? (this.address |= this.map.cpureadu(0) << 8) : (this.address |= this.map.cpureadu(this.pointer + 1) << 8);
                this.lowpc = this.address & 0xFF00;
                this.address += Byte.toUnsignedInt(this.y_index_register);
                ++this.instruction_cycle;
                break;
            }
            case 5: {
                if (this.address > 65535) {
                    this.address &= 0xFFFF;
                }
                this.tempregister = this.map.cpuread(this.address & 0xFF | this.lowpc);
                ++this.instruction_cycle;
                break;
            }
            case 6: {
                this.tempregister = this.map.cpuread(this.address);
                ++this.instruction_cycle;
                break;
            }
            case 7: {
                this.map.cpuwrite(this.address, this.tempregister);
                this.executeOp();
                this.pollInterrupts();
                ++this.instruction_cycle;
                break;
            }
            case 8: {
                this.map.cpuwrite(this.address, this.tempregister);
                this.instruction_cycle = 1;
            }
        }
    }

    private void indy_w() {
        switch (this.instruction_cycle) {
            case 1: {
                ++this.instruction_cycle;
                break;
            }
            case 2: {
                this.pointer = this.map.cpureadu(this.program_counter);
                ++this.program_counter;
                ++this.instruction_cycle;
                break;
            }
            case 3: {
                this.address = this.map.cpureadu(this.pointer);
                ++this.instruction_cycle;
                break;
            }
            case 4: {
                this.address = this.pointer + 1 > 255 ? (this.address |= this.map.cpureadu(0) << 8) : (this.address |= this.map.cpureadu(this.pointer + 1) << 8);
                this.lowpc = this.address & 0xFF00;
                this.address += Byte.toUnsignedInt(this.y_index_register);
                ++this.instruction_cycle;
                break;
            }
            case 5: {
                this.tempregister = this.map.cpuread(this.address & 0xFF | this.lowpc);
                ++this.instruction_cycle;
                this.pollInterrupts();
                break;
            }
            case 6: {
                this.executeOp();
                this.instruction_cycle = 1;
            }
        }
    }

    private void accumulator() {
        switch (this.instruction_cycle) {
            case 1: {
                this.pollInterrupts();
                ++this.instruction_cycle;
                break;
            }
            case 2: {
                this.tempregister = this.accumulator;
                this.executeOp();
                this.accumulator = this.tempregister;
                this.instruction_cycle = 1;
            }
        }
    }

    private void relative() {
        switch (this.instruction_cycle) {
            case 1: {
                this.pollInterrupts();
                ++this.instruction_cycle;
                break;
            }
            case 2: {
                this.tempregister = this.map.cpuread(this.program_counter);
                ++this.program_counter;
                this.executeOp();
                if (this.branchtaken) {
                    ++this.instruction_cycle;
                    break;
                }
                this.instruction_cycle = 1;
                break;
            }
            case 3: {
                if ((this.program_counter & 0xFF00) == (this.program_counter + this.tempregister & 0xFF00)) {
                    this.program_counter += this.tempregister;
                    this.program_counter &= 0xFFFF;
                    this.instruction_cycle = 1;
                    break;
                }
                this.pollInterrupts();
                this.program_counter += this.tempregister;
                this.program_counter &= 0xFFFF;
                ++this.instruction_cycle;
                break;
            }
            case 4: {
                this.instruction_cycle = 1;
            }
        }
    }

    private void aac() {
        if (this.showInvalid) {
            System.out.println("Invalid instruction AAC");
        }
        this.accumulator = (byte)(this.accumulator & this.tempregister);
        this.ZFlag = this.accumulator == 0;
        this.CFlag = this.NFlag = this.accumulator < 0;
    }

    private void adc() {
        int sum = Byte.toUnsignedInt(this.accumulator) + Byte.toUnsignedInt(this.tempregister) + (this.CFlag ? 1 : 0);
        this.CFlag = sum > 255;
        this.VFlag = (~(this.accumulator ^ this.tempregister) & (this.accumulator ^ sum) & 0x80) != 0;
        this.accumulator = (byte)sum;
        this.NFlag = this.accumulator < 0;
        this.ZFlag = this.accumulator == 0;
    }

    private void and() {
        this.accumulator = (byte)(this.accumulator & this.tempregister);
        this.ZFlag = this.accumulator == 0;
        this.NFlag = this.accumulator < 0;
    }

    private void ane() {
    }

    private void arr() {
        if (this.showInvalid) {
            System.out.println("Invalid instruction ARR");
        }
        this.accumulator = (byte)(this.accumulator & this.tempregister);
        int result = Byte.toUnsignedInt(this.accumulator);
        result >>= 1;
        if (this.CFlag) {
            result |= 0x80;
        }
        this.accumulator = (byte)result;
        this.NFlag = this.accumulator < 0;
        this.ZFlag = result == 0;
        this.CFlag = (this.accumulator & 0x40) != 0;
        this.VFlag = this.CFlag ^ (this.accumulator & 0x20) != 0;
    }

    private void asl() {
        int temp = Byte.toUnsignedInt(this.tempregister);
        this.CFlag = (this.tempregister & 0x80) != 0;
        this.tempregister = (byte)(temp << 1);
        this.ZFlag = this.tempregister == 0;
        this.NFlag = this.tempregister < 0;
    }

    private void asr() {
        this.accumulator = (byte)(this.accumulator & this.tempregister);
        this.CFlag = (this.accumulator & 1) != 0;
        this.accumulator = (byte)(Byte.toUnsignedInt(this.accumulator) >> 1);
        this.ZFlag = this.accumulator == 0;
        this.NFlag = this.accumulator < 0;
    }

    private void atx() {
        if (this.showInvalid) {
            System.out.println("Invalid instruction ATX");
        }
        this.x_index_register = this.accumulator = this.tempregister;
        this.ZFlag = this.accumulator == 0;
        this.NFlag = this.accumulator < 0;
    }

    private void axs() {
        if (this.showInvalid) {
            System.out.println("Invalid instruction AXS");
        }
        int result = Byte.toUnsignedInt(this.x_index_register);
        this.CFlag = (result &= Byte.toUnsignedInt(this.accumulator)) >= Byte.toUnsignedInt(this.tempregister);
        this.x_index_register = (byte)(result -= this.tempregister);
        this.NFlag = this.x_index_register < 0;
        this.ZFlag = this.x_index_register == 0;
    }

    private void bcc() {
        this.branchtaken = !this.CFlag;
    }

    private void bcs() {
        this.branchtaken = this.CFlag;
    }

    private void beq() {
        this.branchtaken = this.ZFlag;
    }

    private void bit() {
        this.ZFlag = (this.accumulator & this.tempregister) == 0;
        this.NFlag = (this.tempregister & 0x80) != 0;
        this.VFlag = (this.tempregister & 0x40) != 0;
    }

    private void bmi() {
        this.branchtaken = this.NFlag;
    }

    private void bne() {
        this.branchtaken = !this.ZFlag;
    }

    private void bpl() {
        this.branchtaken = !this.NFlag;
    }

    private void brk() {
        switch (this.instruction_cycle) {
            case 1: {
                ++this.instruction_cycle;
                break;
            }
            case 2: {
                ++this.program_counter;
                ++this.instruction_cycle;
                break;
            }
            case 3: {
                this.map.cpuwrite(Byte.toUnsignedInt(this.stack_pointer) + 256, (byte)(this.program_counter >> 8));
                this.stack_pointer = (byte)(this.stack_pointer - 1);
                ++this.instruction_cycle;
                break;
            }
            case 4: {
                this.map.cpuwrite(Byte.toUnsignedInt(this.stack_pointer) + 256, (byte)(this.program_counter & 0xFF));
                this.stack_pointer = (byte)(this.stack_pointer - 1);
                ++this.instruction_cycle;
                this.pollInterrupts();
                if (!this.nmiInterrupt) break;
                this.nmihijack = true;
                this.nmiInterrupt = false;
                this.irqInterrupt = false;
                break;
            }
            case 5: {
                this.BFlag = true;
                this.map.cpuwrite(Byte.toUnsignedInt(this.stack_pointer) + 256, this.buildFlags());
                this.BFlag = false;
                if (this.nmihijack) {
                    this.current_instruction = (byte)2;
                    this.nmihijack = false;
                }
                this.stack_pointer = (byte)(this.stack_pointer - 1);
                ++this.instruction_cycle;
                break;
            }
            case 6: {
                this.program_counter = this.map.cpureadu(65534);
                ++this.instruction_cycle;
                break;
            }
            case 7: {
                this.program_counter |= this.map.cpureadu(65535) << 8;
                this.IFlag = true;
                this.instruction_cycle = 1;
            }
        }
    }

    private void bvc() {
        this.branchtaken = !this.VFlag;
    }

    private void bvs() {
        this.branchtaken = this.VFlag;
    }

    private void clc() {
        switch (this.instruction_cycle) {
            case 1: {
                this.pollInterrupts();
                ++this.instruction_cycle;
                break;
            }
            case 2: {
                this.CFlag = false;
                this.instruction_cycle = 1;
            }
        }
    }

    private void cld() {
        switch (this.instruction_cycle) {
            case 1: {
                this.pollInterrupts();
                ++this.instruction_cycle;
                break;
            }
            case 2: {
                this.DFlag = false;
                this.instruction_cycle = 1;
            }
        }
    }

    private void cli() {
        switch (this.instruction_cycle) {
            case 1: {
                this.pollInterrupts();
                ++this.instruction_cycle;
                break;
            }
            case 2: {
                this.IFlag = false;
                this.instruction_cycle = 1;
            }
        }
    }

    private void clv() {
        switch (this.instruction_cycle) {
            case 1: {
                this.pollInterrupts();
                ++this.instruction_cycle;
                break;
            }
            case 2: {
                this.VFlag = false;
                this.instruction_cycle = 1;
            }
        }
    }

    private void cmp() {
        this.CFlag = Byte.toUnsignedInt(this.accumulator) >= Byte.toUnsignedInt(this.tempregister);
        this.ZFlag = this.accumulator == this.tempregister;
        this.NFlag = (Byte.toUnsignedInt(this.accumulator) - Byte.toUnsignedInt(this.tempregister) & 0x80) != 0;
    }

    private void cpx() {
        this.CFlag = Byte.toUnsignedInt(this.x_index_register) >= Byte.toUnsignedInt(this.tempregister);
        this.ZFlag = this.x_index_register == this.tempregister;
        this.NFlag = (Byte.toUnsignedInt(this.x_index_register) - Byte.toUnsignedInt(this.tempregister) & 0x80) != 0;
    }

    private void cpy() {
        this.CFlag = Byte.toUnsignedInt(this.y_index_register) >= Byte.toUnsignedInt(this.tempregister);
        this.ZFlag = this.y_index_register == this.tempregister;
        this.NFlag = (Byte.toUnsignedInt(this.y_index_register) - Byte.toUnsignedInt(this.tempregister) & 0x80) != 0;
    }

    private void dcp() {
        if (this.showInvalid) {
            System.out.println("Invalid instruction DCP");
        }
        this.tempregister = (byte)(this.tempregister - 1);
        this.CFlag = Byte.toUnsignedInt(this.accumulator) >= Byte.toUnsignedInt(this.tempregister);
        this.ZFlag = this.accumulator == this.tempregister;
        this.NFlag = (Byte.toUnsignedInt(this.accumulator) - Byte.toUnsignedInt(this.tempregister) & 0x80) != 0;
    }

    private void dec() {
        this.tempregister = (byte)(this.tempregister - 1);
        this.ZFlag = this.tempregister == 0;
        this.NFlag = this.tempregister < 0;
    }

    private void dex() {
        switch (this.instruction_cycle) {
            case 1: {
                this.pollInterrupts();
                ++this.instruction_cycle;
                break;
            }
            case 2: {
                this.x_index_register = (byte)(this.x_index_register - 1);
                this.ZFlag = this.x_index_register == 0;
                this.NFlag = this.x_index_register < 0;
                this.instruction_cycle = 1;
            }
        }
    }

    private void dey() {
        switch (this.instruction_cycle) {
            case 1: {
                this.pollInterrupts();
                ++this.instruction_cycle;
                break;
            }
            case 2: {
                this.y_index_register = (byte)(this.y_index_register - 1);
                this.ZFlag = this.y_index_register == 0;
                this.NFlag = this.y_index_register < 0;
                this.instruction_cycle = 1;
            }
        }
    }

    private void eor() {
        this.accumulator = (byte)(this.accumulator ^ this.tempregister);
        this.ZFlag = this.accumulator == 0;
        this.NFlag = this.accumulator < 0;
    }

    private void hlt() {
    }

    private void inc() {
        this.tempregister = (byte)(this.tempregister + 1);
        this.ZFlag = this.tempregister == 0;
        this.NFlag = this.tempregister < 0;
    }

    private void inx() {
        switch (this.instruction_cycle) {
            case 1: {
                this.pollInterrupts();
                ++this.instruction_cycle;
                break;
            }
            case 2: {
                this.x_index_register = (byte)(this.x_index_register + 1);
                this.ZFlag = this.x_index_register == 0;
                this.NFlag = this.x_index_register < 0;
                this.instruction_cycle = 1;
            }
        }
    }

    private void iny() {
        switch (this.instruction_cycle) {
            case 1: {
                this.pollInterrupts();
                ++this.instruction_cycle;
                break;
            }
            case 2: {
                this.y_index_register = (byte)(this.y_index_register + 1);
                this.ZFlag = this.y_index_register == 0;
                this.NFlag = this.y_index_register < 0;
                this.instruction_cycle = 1;
            }
        }
    }

    private void irq() {
        switch (this.instruction_cycle) {
            case 1: {
                ++this.instruction_cycle;
                break;
            }
            case 2: {
                ++this.instruction_cycle;
                break;
            }
            case 3: {
                this.map.cpuwrite(Byte.toUnsignedInt(this.stack_pointer) + 256, (byte)(this.program_counter >> 8));
                this.stack_pointer = (byte)(this.stack_pointer - 1);
                ++this.instruction_cycle;
                break;
            }
            case 4: {
                this.map.cpuwrite(Byte.toUnsignedInt(this.stack_pointer) + 256, (byte)(this.program_counter & 0xFF));
                this.stack_pointer = (byte)(this.stack_pointer - 1);
                ++this.instruction_cycle;
                if (!this.doNMI || this.oldnmi) break;
                this.nmihijack = true;
                this.nmiInterrupt = false;
                this.irqInterrupt = false;
                break;
            }
            case 5: {
                this.BFlag = false;
                this.map.cpuwrite(Byte.toUnsignedInt(this.stack_pointer) + 256, this.buildFlags());
                if (this.nmihijack) {
                    this.current_instruction = (byte)2;
                    this.nmihijack = false;
                    this.nmiInterrupt = false;
                }
                this.stack_pointer = (byte)(this.stack_pointer - 1);
                ++this.instruction_cycle;
                break;
            }
            case 6: {
                this.program_counter = this.map.cpureadu(65534);
                ++this.instruction_cycle;
                this.IFlag = true;
                break;
            }
            case 7: {
                this.program_counter = this.map.cpureadu(65535) << 8 | this.program_counter;
                this.instruction_cycle = 1;
            }
        }
    }

    private void isb() {
        this.tempregister = (byte)(this.tempregister + 1);
        if (this.showInvalid) {
            System.out.println("Invalid instruction ISB");
        }
        int sum = Byte.toUnsignedInt(this.accumulator) - Byte.toUnsignedInt(this.tempregister) - (this.CFlag ? 0 : 1);
        this.CFlag = sum >> 8 == 0;
        this.VFlag = ((this.accumulator ^ this.tempregister) & 0x80) != 0 && ((this.accumulator ^ sum) & 0x80) != 0;
        this.accumulator = (byte)(sum & 0xFF);
        this.NFlag = this.accumulator < 0;
        this.ZFlag = this.accumulator == 0;
    }

    private void jmp() {
        switch (this.instruction_cycle) {
            case 1: {
                ++this.instruction_cycle;
                break;
            }
            case 2: {
                this.address = this.map.cpureadu(this.program_counter);
                ++this.program_counter;
                ++this.instruction_cycle;
                break;
            }
            case 3: {
                this.address |= this.map.cpureadu(this.program_counter) << 8;
                ++this.program_counter;
                ++this.instruction_cycle;
                break;
            }
            case 4: {
                this.program_counter = this.map.cpureadu(this.address);
                ++this.instruction_cycle;
                break;
            }
            case 5: {
                this.address = (this.address + 1 & 0xFF) == 0 ? (this.address &= 0xFF00) : ++this.address;
                this.program_counter |= this.map.cpureadu(this.address) << 8;
                this.instruction_cycle = 1;
            }
        }
    }

    private void jmp_a() {
        switch (this.instruction_cycle) {
            case 1: {
                ++this.instruction_cycle;
                break;
            }
            case 2: {
                this.address = this.map.cpureadu(this.program_counter);
                ++this.program_counter;
                ++this.instruction_cycle;
                this.pollInterrupts();
                break;
            }
            case 3: {
                this.address |= this.map.cpureadu(this.program_counter) << 8;
                this.program_counter = this.address;
                this.instruction_cycle = 1;
            }
        }
    }

    private void jsr() {
        switch (this.instruction_cycle) {
            case 1: {
                ++this.instruction_cycle;
                break;
            }
            case 2: {
                this.address = this.map.cpureadu(this.program_counter);
                ++this.program_counter;
                ++this.instruction_cycle;
                return;
            }
            case 3: {
                ++this.instruction_cycle;
                break;
            }
            case 4: {
                this.map.cpuwrite(Byte.toUnsignedInt(this.stack_pointer) + 256, (byte)(this.program_counter >>> 8));
                this.stack_pointer = (byte)(this.stack_pointer - 1);
                ++this.instruction_cycle;
                break;
            }
            case 5: {
                this.map.cpuwrite(Byte.toUnsignedInt(this.stack_pointer) + 256, (byte)(this.program_counter & 0xFF));
                this.stack_pointer = (byte)(this.stack_pointer - 1);
                ++this.instruction_cycle;
                this.pollInterrupts();
                break;
            }
            case 6: {
                this.address |= this.map.cpureadu(this.program_counter) << 8;
                this.program_counter = this.address;
                this.instruction_cycle = 1;
            }
        }
    }

    private void las() {
    }

    private void lax() {
        if (this.showInvalid) {
            System.out.println("Invalid instruction LAX");
        }
        this.x_index_register = this.accumulator = this.tempregister;
        this.NFlag = this.accumulator < 0;
        this.ZFlag = this.accumulator == 0;
    }

    private void lda() {
        this.accumulator = this.tempregister;
        this.ZFlag = this.accumulator == 0;
        this.NFlag = this.accumulator < 0;
    }

    private void ldx() {
        this.x_index_register = this.tempregister;
        this.ZFlag = this.x_index_register == 0;
        this.NFlag = this.x_index_register < 0;
    }

    private void ldy() {
        this.y_index_register = this.tempregister;
        this.ZFlag = this.y_index_register == 0;
        this.NFlag = this.y_index_register < 0;
    }

    private void lsr() {
        this.CFlag = (this.tempregister & 1) > 0;
        this.tempregister = (byte)(Byte.toUnsignedInt(this.tempregister) >>> 1);
        this.ZFlag = this.tempregister == 0;
        this.NFlag = this.tempregister < 0;
    }

    private void nmi() {
        switch (this.instruction_cycle) {
            case 1: {
                ++this.instruction_cycle;
                break;
            }
            case 2: {
                ++this.instruction_cycle;
            }
            case 3: {
                this.map.cpuwrite(Byte.toUnsignedInt(this.stack_pointer) + 256, (byte)(this.program_counter >> 8));
                this.stack_pointer = (byte)(this.stack_pointer - 1);
                ++this.instruction_cycle;
                break;
            }
            case 4: {
                this.map.cpuwrite(Byte.toUnsignedInt(this.stack_pointer) + 256, (byte)(this.program_counter & 0xFF));
                this.stack_pointer = (byte)(this.stack_pointer - 1);
                ++this.instruction_cycle;
                break;
            }
            case 5: {
                this.BFlag = false;
                this.map.cpuwrite(Byte.toUnsignedInt(this.stack_pointer) + 256, this.buildFlags());
                this.stack_pointer = (byte)(this.stack_pointer - 1);
                ++this.instruction_cycle;
                break;
            }
            case 6: {
                this.program_counter = this.map.cpureadu(65530);
                ++this.instruction_cycle;
                this.IFlag = true;
                break;
            }
            case 7: {
                this.program_counter = this.map.cpureadu(65531) << 8 | this.program_counter;
                this.instruction_cycle = 1;
            }
        }
    }

    private void nop() {
        switch (this.instruction_cycle) {
            case 1: {
                this.pollInterrupts();
                ++this.instruction_cycle;
                break;
            }
            case 2: {
                this.instruction_cycle = 1;
            }
        }
    }

    private void skb() {
        if (this.showInvalid) {
            System.out.println("Invalid instruction SKB");
        }
    }

    private void skw() {
        if (this.showInvalid) {
            System.out.println("Invalid instruction SKW");
        }
    }

    private void ora() {
        this.accumulator = (byte)(this.accumulator | this.tempregister);
        this.ZFlag = this.accumulator == 0;
        this.NFlag = this.accumulator < 0;
    }

    private void pha() {
        switch (this.instruction_cycle) {
            case 1: {
                ++this.instruction_cycle;
                break;
            }
            case 2: {
                ++this.instruction_cycle;
                this.pollInterrupts();
                break;
            }
            case 3: {
                this.map.cpuwrite(Byte.toUnsignedInt(this.stack_pointer) + 256, this.accumulator);
                this.stack_pointer = (byte)(this.stack_pointer - 1);
                this.instruction_cycle = 1;
            }
        }
    }

    private void php() {
        switch (this.instruction_cycle) {
            case 1: {
                ++this.instruction_cycle;
                break;
            }
            case 2: {
                ++this.instruction_cycle;
                this.pollInterrupts();
                break;
            }
            case 3: {
                this.BFlag = true;
                byte x = this.buildFlags();
                this.map.cpuwrite(Byte.toUnsignedInt(this.stack_pointer) + 256, x);
                this.BFlag = false;
                this.stack_pointer = (byte)(this.stack_pointer - 1);
                this.instruction_cycle = 1;
            }
        }
    }

    private void pla() {
        switch (this.instruction_cycle) {
            case 1: {
                ++this.instruction_cycle;
                break;
            }
            case 2: {
                ++this.instruction_cycle;
                break;
            }
            case 3: {
                this.stack_pointer = (byte)(this.stack_pointer + 1);
                ++this.instruction_cycle;
                this.pollInterrupts();
                break;
            }
            case 4: {
                this.accumulator = this.map.cpuread(Byte.toUnsignedInt(this.stack_pointer) + 256);
                this.ZFlag = this.accumulator == 0;
                this.NFlag = this.accumulator < 0;
                this.instruction_cycle = 1;
            }
        }
    }

    private void plp() {
        switch (this.instruction_cycle) {
            case 1: {
                ++this.instruction_cycle;
                break;
            }
            case 2: {
                ++this.instruction_cycle;
                break;
            }
            case 3: {
                this.stack_pointer = (byte)(this.stack_pointer + 1);
                ++this.instruction_cycle;
                this.pollInterrupts();
                break;
            }
            case 4: {
                this.setFlags(this.map.cpuread(Byte.toUnsignedInt(this.stack_pointer) + 256));
                this.instruction_cycle = 1;
            }
        }
    }

    private void rla() {
        if (this.showInvalid) {
            System.out.println("Invalid instruction RLA");
        }
        boolean tcarry = this.tempregister < 0;
        this.tempregister = (byte)(this.tempregister << 1);
        this.tempregister = (byte)(this.tempregister | (this.CFlag ? (byte)1 : 0));
        this.CFlag = tcarry;
        this.ZFlag = this.tempregister == 0;
        this.NFlag = this.tempregister < 0;
        this.accumulator = (byte)(this.accumulator & this.tempregister);
        this.ZFlag = this.accumulator == 0;
        this.NFlag = this.accumulator < 0;
    }

    private void rol() {
        boolean tcarry = this.tempregister < 0;
        this.tempregister = (byte)(this.tempregister << 1);
        this.tempregister = (byte)(this.tempregister | (this.CFlag ? (byte)1 : 0));
        this.CFlag = tcarry;
        this.ZFlag = this.tempregister == 0;
        this.NFlag = this.tempregister < 0;
    }

    private void ror() {
        int tcarry = this.tempregister & 1;
        this.tempregister = (byte)(Byte.toUnsignedInt(this.tempregister) >>> 1);
        this.tempregister = (byte)(this.tempregister | (this.CFlag ? 128 : 0));
        this.CFlag = tcarry != 0;
        this.ZFlag = this.tempregister == 0;
        this.NFlag = this.tempregister < 0;
    }

    private void rra() {
        if (this.showInvalid) {
            System.out.println("Invalid instruction RRA");
        }
        if (this.CFlag) {
            this.CFlag = (this.tempregister & 1) != 0;
            this.tempregister = (byte)(Byte.toUnsignedInt(this.tempregister) >> 1 | 0x80);
        } else {
            this.CFlag = (this.tempregister & 1) != 0;
            this.tempregister = (byte)(Byte.toUnsignedInt(this.tempregister) >> 1);
        }
        int sum = Byte.toUnsignedInt(this.accumulator) + Byte.toUnsignedInt(this.tempregister) + (this.CFlag ? 1 : 0);
        this.CFlag = sum > 255;
        this.VFlag = (~(this.accumulator ^ this.tempregister) & (this.accumulator ^ sum) & 0x80) != 0;
        this.accumulator = (byte)sum;
        this.NFlag = this.accumulator < 0;
        this.ZFlag = this.accumulator == 0;
    }

    private void rti() {
        switch (this.instruction_cycle) {
            case 1: {
                ++this.instruction_cycle;
                break;
            }
            case 2: {
                ++this.instruction_cycle;
                break;
            }
            case 3: {
                this.stack_pointer = (byte)(this.stack_pointer + 1);
                ++this.instruction_cycle;
                break;
            }
            case 4: {
                this.setFlags(this.map.cpuread(Byte.toUnsignedInt(this.stack_pointer) + 256));
                this.stack_pointer = (byte)(this.stack_pointer + 1);
                ++this.instruction_cycle;
                break;
            }
            case 5: {
                this.program_counter = this.map.cpureadu(Byte.toUnsignedInt(this.stack_pointer) + 256);
                this.stack_pointer = (byte)(this.stack_pointer + 1);
                ++this.instruction_cycle;
                this.pollInterrupts();
                break;
            }
            case 6: {
                this.program_counter |= this.map.cpureadu(Byte.toUnsignedInt(this.stack_pointer) + 256) << 8;
                this.instruction_cycle = 1;
            }
        }
    }

    private void rts() {
        switch (this.instruction_cycle) {
            case 1: {
                ++this.instruction_cycle;
                break;
            }
            case 2: {
                ++this.instruction_cycle;
                break;
            }
            case 3: {
                this.stack_pointer = (byte)(this.stack_pointer + 1);
                ++this.instruction_cycle;
                break;
            }
            case 4: {
                this.program_counter = 0;
                this.program_counter = this.map.cpureadu(Byte.toUnsignedInt(this.stack_pointer) + 256);
                this.stack_pointer = (byte)(this.stack_pointer + 1);
                ++this.instruction_cycle;
                break;
            }
            case 5: {
                this.program_counter |= this.map.cpureadu(Byte.toUnsignedInt(this.stack_pointer) + 256) << 8;
                ++this.instruction_cycle;
                this.pollInterrupts();
                break;
            }
            case 6: {
                ++this.program_counter;
                this.instruction_cycle = 1;
            }
        }
    }

    private void sax() {
        if (this.showInvalid) {
            System.out.println("Invalid instruction SAX");
        }
        this.tempregister = (byte)(this.x_index_register & this.accumulator);
        this.map.cpuwrite(this.address, this.tempregister);
    }

    private void sbc() {
        this.tempregister = ~this.tempregister;
        int sum = Byte.toUnsignedInt(this.accumulator) + Byte.toUnsignedInt(this.tempregister) + (this.CFlag ? 1 : 0);
        this.CFlag = sum > 255;
        this.VFlag = (~(this.accumulator ^ this.tempregister) & (this.accumulator ^ sum) & 0x80) != 0;
        this.accumulator = (byte)sum;
        this.NFlag = this.accumulator < 0;
        this.ZFlag = this.accumulator == 0;
    }

    private void sec() {
        switch (this.instruction_cycle) {
            case 1: {
                this.pollInterrupts();
                ++this.instruction_cycle;
                break;
            }
            case 2: {
                this.CFlag = true;
                this.instruction_cycle = 1;
            }
        }
    }

    private void sed() {
        switch (this.instruction_cycle) {
            case 1: {
                this.pollInterrupts();
                ++this.instruction_cycle;
                break;
            }
            case 2: {
                this.DFlag = true;
                this.instruction_cycle = 1;
            }
        }
    }

    private void sei() {
        switch (this.instruction_cycle) {
            case 1: {
                this.pollInterrupts();
                ++this.instruction_cycle;
                break;
            }
            case 2: {
                this.IFlag = true;
                this.instruction_cycle = 1;
            }
        }
    }

    private void sha() {
    }

    private void shs() {
    }

    private void shx() {
        if (this.showInvalid) {
            System.out.println("Invalid instruction SHX");
        }
        switch (this.instruction_cycle) {
            case 1: {
                ++this.instruction_cycle;
                break;
            }
            case 2: {
                this.address = this.map.cpureadu(this.program_counter);
                ++this.program_counter;
                ++this.instruction_cycle;
                break;
            }
            case 3: {
                this.address |= this.map.cpureadu(this.program_counter) << 8;
                ++this.program_counter;
                ++this.instruction_cycle;
                break;
            }
            case 4: {
                this.map.cpureadu(this.address);
                ++this.instruction_cycle;
                break;
            }
            case 5: {
                int t = Byte.toUnsignedInt(this.x_index_register) & (this.address >> 8) + 1 & 0xFF;
                this.lowpc = this.address & 0xFF00;
                this.address += Byte.toUnsignedInt(this.y_index_register);
                this.address = this.address & 0xFF | this.lowpc;
                this.map.cpuread(this.address & 0xFF | this.lowpc);
                this.map.cpuwrite(this.address & 0xFFFF, (byte)t);
                this.instruction_cycle = 1;
            }
        }
    }

    private void shy() {
        if (this.showInvalid) {
            System.out.println("Invalid instruction SHY");
        }
        switch (this.instruction_cycle) {
            case 1: {
                ++this.instruction_cycle;
                break;
            }
            case 2: {
                this.address = this.map.cpureadu(this.program_counter);
                ++this.program_counter;
                ++this.instruction_cycle;
                break;
            }
            case 3: {
                this.address |= this.map.cpureadu(this.program_counter) << 8;
                ++this.program_counter;
                ++this.instruction_cycle;
                break;
            }
            case 4: {
                this.map.cpureadu(this.address);
                ++this.instruction_cycle;
                break;
            }
            case 5: {
                int t = Byte.toUnsignedInt(this.y_index_register) & (this.address >> 8) + 1 & 0xFF;
                this.lowpc = this.address & 0xFF00;
                this.address += Byte.toUnsignedInt(this.x_index_register);
                this.address = this.address & 0xFF | this.lowpc;
                this.map.cpuread(this.address & 0xFF | this.lowpc);
                this.map.cpuwrite(this.address & 0xFFFF, (byte)t);
                this.instruction_cycle = 1;
            }
        }
    }

    private void slo() {
        if (this.showInvalid) {
            System.out.println("Invalid instruction SLO");
        }
        this.CFlag = (this.tempregister & 0x80) != 0;
        this.tempregister = (byte)(this.tempregister << 1);
        this.accumulator = (byte)(this.accumulator | this.tempregister);
        this.NFlag = this.accumulator < 0;
        this.ZFlag = this.accumulator == 0;
    }

    private void sre() {
        int result = Byte.toUnsignedInt(this.tempregister);
        this.CFlag = (result & 1) != 0;
        this.accumulator = (byte)(this.accumulator ^ (byte)(result >>= 1));
        this.tempregister = (byte)result;
        this.NFlag = this.accumulator < 0;
        this.ZFlag = this.accumulator == 0;
    }

    private void sta() {
        this.map.cpuwrite(this.address, this.accumulator);
    }

    private void stx() {
        this.map.cpuwrite(this.address, this.x_index_register);
    }

    private void sty() {
        this.map.cpuwrite(this.address, this.y_index_register);
    }

    private void tax() {
        switch (this.instruction_cycle) {
            case 1: {
                this.pollInterrupts();
                ++this.instruction_cycle;
                break;
            }
            case 2: {
                this.x_index_register = this.accumulator;
                this.ZFlag = this.x_index_register == 0;
                this.NFlag = this.x_index_register < 0;
                this.instruction_cycle = 1;
            }
        }
    }

    private void tay() {
        switch (this.instruction_cycle) {
            case 1: {
                this.pollInterrupts();
                ++this.instruction_cycle;
                break;
            }
            case 2: {
                this.y_index_register = this.accumulator;
                this.ZFlag = this.y_index_register == 0;
                this.NFlag = this.y_index_register < 0;
                this.instruction_cycle = 1;
            }
        }
    }

    private void tsx() {
        switch (this.instruction_cycle) {
            case 1: {
                this.pollInterrupts();
                ++this.instruction_cycle;
                break;
            }
            case 2: {
                this.x_index_register = this.stack_pointer;
                this.ZFlag = this.x_index_register == 0;
                this.NFlag = this.x_index_register < 0;
                this.instruction_cycle = 1;
            }
        }
    }

    private void txa() {
        switch (this.instruction_cycle) {
            case 1: {
                this.pollInterrupts();
                ++this.instruction_cycle;
                break;
            }
            case 2: {
                this.accumulator = this.x_index_register;
                this.ZFlag = this.accumulator == 0;
                this.NFlag = this.accumulator < 0;
                this.instruction_cycle = 1;
            }
        }
    }

    private void txs() {
        switch (this.instruction_cycle) {
            case 1: {
                this.pollInterrupts();
                ++this.instruction_cycle;
                break;
            }
            case 2: {
                this.stack_pointer = this.x_index_register;
                this.instruction_cycle = 1;
            }
        }
    }

    private void tya() {
        switch (this.instruction_cycle) {
            case 1: {
                this.pollInterrupts();
                ++this.instruction_cycle;
                break;
            }
            case 2: {
                this.accumulator = this.y_index_register;
                this.ZFlag = this.accumulator == 0;
                this.NFlag = this.accumulator < 0;
                this.instruction_cycle = 1;
            }
        }
    }

    public static enum IRQSource {
        External,
        FrameCounter,
        DMC;

    }
}

