/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.mappers.Mapper;
import java.io.Serializable;

public class Controller
implements Serializable {
    private static final long serialVersionUID = 8353857861874602491L;
    final Mapper map;
    final int controllerNum;
    boolean strobe;
    int output;
    int keysPressed;
    public int nextKey;
    boolean debug;

    public Controller(Mapper m, int num) {
        this.map = m;
        this.strobe = false;
        this.output = 0;
        this.keysPressed = 0;
        this.controllerNum = num;
        this.nextKey = 0;
    }

    public byte getControllerStatus() {
        int getNextKey = 0;
        if (this.nextKey > 7) {
            getNextKey = 1;
        } else {
            int n = getNextKey = this.map.system.pollController()[this.controllerNum][this.nextKey] ? 1 : 0;
        }
        if (!this.strobe) {
            ++this.nextKey;
        }
        this.output &= 0x11111110;
        this.output |= getNextKey;
        return (byte)this.output;
    }

    public void inputRegister(byte b) {
        if ((b & 1) == 1) {
            this.nextKey = 0;
            this.strobe = true;
        } else {
            this.strobe = false;
            this.nextKey = 0;
        }
    }
}

