/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.APU;
import core.CPU_6502;
import core.NESAccess;
import core.NESCallback;
import core.NesSettings;
import core.exceptions.UnSupportedMapperException;
import core.mappers.Mapper;
import core.ppu2C02;
import core.video.NesColors;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;

public class NES
implements Runnable,
NESAccess {
    private volatile Mapper map;
    private String romName;
    private NESCallback system;
    private File save;
    private boolean batteryExists;
    private boolean pal;
    private volatile boolean flag = true;
    private volatile boolean pause = false;
    private volatile boolean pauseConfirmed = false;
    private boolean nsfplayer = false;
    private long frameStartTime;
    private long frameStopTime;
    private long fpsStartTime;
    private double currentFPS;
    private int framecount = 0;

    public NES(NESCallback sys) {
        this.system = sys;
    }

    @Override
    public void setCallback(NESCallback system) {
        this.system = system;
    }

    @Override
    public final void loadRom(File rom) throws IOException, UnSupportedMapperException {
        String ext;
        this.romName = rom.getName().substring(0, rom.getName().length() - 4);
        switch (ext = rom.getName().toLowerCase().substring(rom.getName().lastIndexOf(".") + 1)) {
            case "nes": {
                this.loadiNES(rom);
                break;
            }
            case "nsf": {
                this.loadNSF(rom);
                break;
            }
            case "nsfe": {
                this.loadNSFe(rom);
            }
        }
        this.map.setNes(this);
        this.map.setSystem(this.system);
        this.map.setInitialPC();
    }

    private void loadiNES(File rom) throws IOException, UnSupportedMapperException {
        FileInputStream sx = new FileInputStream(rom);
        byte[] header = new byte[16];
        sx.read(header);
        if (header[0] == 78 && header[1] == 69 && header[2] == 83 && header[3] == 26) {
            byte[] PRG_ROM = new byte[16384 * Byte.toUnsignedInt(header[4])];
            sx.read(PRG_ROM);
            byte[] CHR_ROM = new byte[8192 * Byte.toUnsignedInt(header[5])];
            sx.read(CHR_ROM);
            this.batteryExists = (header[6] & 2) != 0;
            int id = Byte.toUnsignedInt(header[6]) >> 4;
            this.map = Mapper.getmapper(id |= Byte.toUnsignedInt(header[7]) & 0xF0);
            System.out.println("PRG_ROM:" + PRG_ROM.length / 1024 + "KB");
            this.map.setPRG(PRG_ROM);
            System.out.println("CHR_ROM:" + CHR_ROM.length / 1024 + "KB");
            this.map.setCHR(CHR_ROM);
            this.map.setPRGRAM(this.batteryExists);
            this.map.setMirror(header[6] & 1);
            if (header[9] == 1 || rom.getName().contains("(E)")) {
                this.pal = true;
                System.out.println("Pal Game");
            }
            this.map.ppu.setpal(this.pal);
            if (this.batteryExists) {
                this.loadSave();
            }
        }
        sx.close();
    }

    private void loadNSF(File rom) throws IOException, UnSupportedMapperException {
        FileInputStream sx = new FileInputStream(rom);
        byte[] header = new byte[128];
        sx.read(header);
        if (header[0] == 78 && header[1] == 69 && header[2] == 83 && header[3] == 77 && header[4] == 26) {
            int totalsongs = Byte.toUnsignedInt(header[6]);
            int startsong = Byte.toUnsignedInt(header[7]);
            int dataloadaddr = (header[9] & 0xFF) << 8 | header[8] & 0xFF;
            int datainitaddr = (header[11] & 0xFF) << 8 | header[10] & 0xFF;
            int dataplayaddr = (header[13] & 0xFF) << 8 | header[12] & 0xFF;
            String songname = new String(Arrays.copyOfRange(header, 14, 45));
            String artistname = new String(Arrays.copyOfRange(header, 46, 77));
            int playspeed = (header[111] & 0xFF) << 8 | header[110] & 0xFF;
            byte[] bankswitch = Arrays.copyOfRange(header, 112, 120);
            int tuneregion = header[122] & 3;
            byte extrasoundchips = header[123];
            long size = rom.length() - 128L;
            System.out.println(String.valueOf(size / 1024L) + "KB");
            byte[] data = new byte[(int)size];
            this.map = Mapper.getmapper(1001);
            sx.read(data);
            this.map.loadData(data);
            this.map.setBanking(bankswitch);
            this.map.addExtraAudio(extrasoundchips);
            this.map.setNSFVariables(dataplayaddr, datainitaddr, dataloadaddr, playspeed, startsong, totalsongs, tuneregion, songname, artistname);
            this.map.setCHR(new byte[0]);
            this.map.setSystem(this.system);
            this.nsfplayer = true;
        }
        sx.close();
    }

    private void loadNSFe(File rom) throws IOException, UnSupportedMapperException {
        FileInputStream sx;
        block39: {
            sx = new FileInputStream(rom);
            byte[] header = new byte[4];
            sx.read(header);
            if (header[0] != 78 || header[1] != 83 || header[2] != 70 || header[3] != 69) break block39;
            this.map = Mapper.getmapper(1002);
            int songnum = 0;
            String ncname = "";
            while (!ncname.equals("NEND")) {
                byte[] ncheader = new byte[8];
                sx.read(ncheader);
                int nclength = (ncheader[3] & 0xFF) << 24 | (ncheader[2] & 0xFF) << 16 | (ncheader[1] & 0xFF) << 8 | ncheader[0] & 0xFF;
                switch (ncname = String.valueOf((char)Byte.toUnsignedInt(ncheader[4])) + (char)Byte.toUnsignedInt(ncheader[5]) + (char)Byte.toUnsignedInt(ncheader[6]) + (char)Byte.toUnsignedInt(ncheader[7])) {
                    case "INFO": {
                        int totalsongs;
                        System.out.println("Reading INFO Chunk");
                        byte[] data = new byte[nclength];
                        sx.read(data);
                        int dataloadaddr = (data[1] & 0xFF) << 8 | data[0] & 0xFF;
                        int datainitaddr = (data[3] & 0xFF) << 8 | data[2] & 0xFF;
                        int dataplayaddr = (data[5] & 0xFF) << 8 | data[4] & 0xFF;
                        byte extrasoundchips = data[7];
                        songnum = totalsongs = Byte.toUnsignedInt(data[8]);
                        int startsong = Byte.toUnsignedInt(data[9]);
                        this.map.setNSFVariables(dataplayaddr, datainitaddr, dataloadaddr, 0, startsong, totalsongs, 0, "null", "null");
                        this.map.addExtraAudio(extrasoundchips);
                        break;
                    }
                    case "DATA": {
                        System.out.println("Reading DATA Chunk");
                        byte[] data = new byte[nclength];
                        sx.read(data);
                        this.map.loadData(data);
                        break;
                    }
                    case "BANK": {
                        System.out.println("Reading BANK Chunk");
                        byte[] out = new byte[8];
                        byte[] data = new byte[nclength];
                        sx.read(data);
                        if (nclength < 8) {
                            int i = 0;
                            byte[] byArray = data;
                            int n = data.length;
                            int n2 = 0;
                            while (n2 < n) {
                                byte b;
                                out[i] = b = byArray[n2];
                                ++n2;
                            }
                        } else if (nclength > 8) {
                            int i = 0;
                            while (i < 8) {
                                out[i] = data[i];
                                ++i;
                            }
                        } else {
                            out = data;
                        }
                        this.map.setBanking(out);
                        break;
                    }
                    case "tlbl": {
                        System.out.println("Reading tlbl Chunk");
                        String[] tracknames = new String[songnum];
                        byte[] data = new byte[nclength];
                        sx.read(data);
                        int i = 0;
                        String name = "";
                        byte[] byArray = data;
                        int n = data.length;
                        int n3 = 0;
                        while (n3 < n) {
                            byte b = byArray[n3];
                            if (b == 0) {
                                tracknames[i++] = name;
                                name = "";
                            } else {
                                name = String.valueOf(name) + (char)Byte.toUnsignedInt(b);
                            }
                            ++n3;
                        }
                        this.map.setTrackNames(tracknames);
                        break;
                    }
                    case "time": {
                        System.out.println("Reading time Chunk");
                        int[] tracktimes = new int[songnum];
                        byte[] data = new byte[nclength];
                        sx.read(data);
                        int x = 0;
                        while (x < songnum) {
                            int length = (data[x * 4 + 3] & 0xFF) << 24 | (data[x * 4 + 2] & 0xFF) << 16 | (data[x * 4 + 1] & 0xFF) << 8 | data[x * 4 + 0] & 0xFF;
                            tracktimes[x] = (int)((double)length / 16.6666);
                            ++x;
                        }
                        this.map.setTrackTimes(tracktimes);
                        break;
                    }
                    case "auth": {
                        System.out.println("Reading auth Chunk");
                        String[] info = new String[4];
                        byte[] data = new byte[nclength];
                        sx.read(data);
                        int z = 0;
                        String nameinfo = "";
                        byte[] byArray = data;
                        int n = data.length;
                        int n4 = 0;
                        while (n4 < n) {
                            byte b = byArray[n4];
                            if (b == 0) {
                                info[z++] = nameinfo;
                                nameinfo = "";
                            } else {
                                nameinfo = String.valueOf(nameinfo) + (char)Byte.toUnsignedInt(b);
                            }
                            ++n4;
                        }
                        this.map.setAuthInfo(info);
                        break;
                    }
                    default: {
                        System.out.println("Unsupported Chunk type: " + ncname);
                        byte[] data = new byte[nclength];
                        sx.read(data);
                    }
                    case "NEND": 
                }
            }
            this.map.setCHR(new byte[0]);
            this.map.setSystem(this.system);
            this.nsfplayer = true;
        }
        sx.close();
    }

    @Override
    public final void run() {
        System.out.println("NES STARTED RUNNING");
        while (this.flag) {
            this.autoRunFrame();
            if (!this.pause) continue;
            this.pauseConfirmed = true;
            while (this.pause) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.pauseConfirmed = false;
        }
        if (this.batteryExists) {
            try {
                this.saveGame();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public final void exit() {
        this.flag = false;
    }

    private void autoRunFrame() {
        this.frameStartTime = System.nanoTime();
        this.map.runFrame();
        this.frameStopTime = System.nanoTime() - this.frameStartTime;
        if (this.frameStopTime < 16000000L && NesSettings.frameLimit) {
            try {
                while (System.nanoTime() - this.frameStartTime < 16000000L) {
                    if (!NesSettings.politeFrameTiming) continue;
                    Thread.sleep(0L, 100000);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (this.framecount % 60 == 0) {
            double x = 1000.0 / (double)(System.currentTimeMillis() - this.fpsStartTime);
            this.currentFPS = x * 60.0;
            this.fpsStartTime = System.currentTimeMillis();
        }
        ++this.framecount;
        this.system.videoCallback(this.map.ppu.renderer.colorized);
    }

    @Override
    public final void runFrame() {
        this.map.runFrame();
        this.system.videoCallback(this.map.ppu.renderer.colorized);
    }

    @Override
    public final double getFPS() {
        return this.currentFPS;
    }

    @Override
    public final void saveState(String slot) throws IOException {
        if (!this.nsfplayer) {
            FileOutputStream fout = new FileOutputStream(slot);
            ObjectOutputStream out = new ObjectOutputStream(fout);
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            out.writeObject(this.map);
            out.writeObject(this.map.apu);
            out.writeObject(this.map.cpu);
            out.writeObject(this.map.ppu);
            out.close();
        }
    }

    @Override
    public final void restoreState(String slot) throws IOException, ClassNotFoundException {
        if (!this.nsfplayer) {
            FileInputStream fin = new FileInputStream(slot);
            ObjectInputStream in = new ObjectInputStream(fin);
            this.pause = true;
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.map = (Mapper)in.readObject();
            this.map.apu = (APU)in.readObject();
            this.map.cpu = (CPU_6502)in.readObject();
            this.map.ppu = (ppu2C02)in.readObject();
            this.map.setSystem(this.system);
            in.close();
            this.pause = false;
        }
    }

    @Override
    public final void pause() {
        this.pause = true;
        while (!this.pauseConfirmed) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public final void unpause() {
        this.pause = false;
    }

    @Override
    public final void togglePause() {
        if (this.pause) {
            this.unpause();
        } else {
            this.pause();
        }
    }

    @Override
    public final void loadSave() throws IOException {
        this.save = new File(String.valueOf(this.romName) + ".sav");
        System.out.println(this.save.getAbsolutePath());
        if (this.save.exists()) {
            System.out.println("Save Found! Loading...");
            FileInputStream sx = new FileInputStream(this.save);
            byte[] savearray = new byte[(int)this.save.length()];
            sx.read(savearray);
            this.map.restoreSave(savearray);
            sx.close();
        } else {
            System.out.println("Save not found!");
        }
    }

    @Override
    public final void saveGame() throws IOException {
        System.out.println("Attempting to save game.");
        this.save = new File(String.valueOf(this.romName) + ".sav");
        if (this.save.exists()) {
            this.save.delete();
        }
        this.save.createNewFile();
        FileOutputStream sx = new FileOutputStream(this.save);
        byte[] savearray = this.map.getSave();
        sx.write(savearray);
        sx.close();
    }

    @Override
    public final Object[][] getAudioChannelInfo() {
        return this.map.apu.channelInfo();
    }

    @Override
    public final void setSampleRate(int rate) {
        NesSettings.logSampleRate(rate);
        this.map.apu.setSampleRate(rate);
    }

    @Override
    public final void runCPUCycle() {
        this.map.runCPUCycle();
        if (this.map.ppu.doneFrame) {
            this.system.videoCallback(this.map.ppu.renderer.colorized);
            this.map.ppu.doneFrame = false;
        }
    }

    public static final void setInternalPalette(String palette) {
        NesColors.updatePalette(palette);
        NesSettings.logInternalPalette(palette);
    }

    public static final int[] getInternalPaletteRGB(String palette) {
        return NesColors.getpalette(palette);
    }

    public static final void setCustomPalette(int[] palette) {
        NesColors.setCustomPalette(palette);
    }

    @Override
    public final Object[] getCPUDebugInfo() {
        return this.map.cpu.getDebugInfo();
    }

    @Override
    public final Object[] getPPUDebugInfo() {
        return this.map.ppu.getDebugInfo();
    }

    @Override
    public final int[] getAPUDebugInfo() {
        return null;
    }

    @Override
    public final int[] getMapperDebugInfo() {
        return null;
    }
}

