/*
 * Decompiled with CFR 0.152.
 */
package core.audio;

import core.CPU_6502;
import core.NesSettings;
import core.audio.AudioMixer;
import core.audio.Channel;
import core.mappers.Mapper;

public class DMC
extends Channel {
    private static final long serialVersionUID = -5904036727532211365L;
    final Mapper map;
    boolean irqEnable = false;
    public boolean irqflag = false;
    public boolean silence = true;
    boolean bufferempty = true;
    int outputlevel = 0;
    int sampleaddress = 49152;
    int addressStart = 49152;
    public int samplelength = 1;
    public int sampleremaining = 0;
    int samplebuffer = 0;
    int rate = 54;
    int temprate = 54;
    int bitsremaining = 8;
    int shiftreg = 0;
    final int[] rateindex = new int[]{428, 380, 340, 320, 286, 254, 226, 214, 190, 160, 142, 128, 106, 84, 72, 54};

    public DMC(Mapper m, int location) {
        super(location);
        this.map = m;
        this.bitsremaining = 8;
        this.loop = false;
    }

    public void registerWrite(int index, byte b) {
        switch (index % 4) {
            case 0: {
                boolean bl = this.irqEnable = (b & 0x80) == 128;
                if (!this.irqEnable) {
                    this.map.cpu.removeIRQ(CPU_6502.IRQSource.DMC);
                }
                this.loop = (b & 0x40) == 64;
                this.rate = this.rateindex[b & 0xF];
                break;
            }
            case 1: {
                this.outputlevel = b & 0x7F;
                break;
            }
            case 2: {
                this.addressStart = (Byte.toUnsignedInt(b) << 6) + 49152;
                break;
            }
            case 3: {
                this.samplelength = (Byte.toUnsignedInt(b) << 4) + 1;
            }
        }
    }

    public void clearFlag() {
        this.map.cpu.removeIRQ(CPU_6502.IRQSource.DMC);
    }

    @Override
    public final void clockTimer() {
        if (this.bufferempty && this.sampleremaining > 0) {
            this.memoryreader();
        }
        this.temprate -= 2;
        if (this.temprate <= 0) {
            if (!this.silence) {
                this.outputlevel += (this.shiftreg & 1) == 1 ? 2 : -2;
                if (this.outputlevel > 127) {
                    this.outputlevel -= 2;
                } else if (this.outputlevel < 0) {
                    this.outputlevel += 2;
                }
                this.shiftreg >>= 1;
                --this.bitsremaining;
            }
            if (this.bitsremaining <= 0) {
                this.bitsremaining = 8;
                if (this.bufferempty) {
                    this.silence = true;
                } else {
                    this.silence = false;
                    this.shiftreg = this.samplebuffer;
                    this.bufferempty = true;
                }
            }
            this.temprate = this.rate;
        }
        int n = this.outputLocation;
        AudioMixer.audioLevels[n] = AudioMixer.audioLevels[n] + (double)this.outputlevel;
    }

    public void memoryreader() {
        if (this.sampleremaining > 0) {
            this.samplebuffer = this.map.cpureadu(this.sampleaddress++);
            this.bufferempty = false;
            if (this.map.cpu.writeDMA) {
                this.map.cpu.stall(2);
            } else {
                this.map.cpu.stall(4);
            }
            if (this.sampleaddress > 65535) {
                this.sampleaddress = 32768;
            }
            --this.sampleremaining;
            if (this.sampleremaining == 0) {
                if (this.loop) {
                    this.restart();
                } else if (this.irqEnable) {
                    this.map.cpu.setIRQ(CPU_6502.IRQSource.DMC);
                }
            }
        } else {
            this.silence = true;
        }
    }

    public void restart() {
        this.sampleaddress = this.addressStart;
        this.sampleremaining = this.samplelength;
        this.silence = false;
    }

    void outputUnit() {
        if (this.bitsremaining <= 0) {
            this.bitsremaining = 8;
            if (this.bufferempty) {
                this.silence = true;
            } else {
                this.silence = false;
                this.shiftreg = this.samplebuffer;
                this.samplebuffer = 0;
                this.bufferempty = true;
            }
        }
        if (!this.silence) {
            this.outputlevel += (this.shiftreg & 1) == 1 ? 2 : -2;
            if (this.outputlevel > 127) {
                this.outputlevel = 126;
            } else if (this.outputlevel < 0) {
                this.outputlevel = 1;
            }
            this.shiftreg >>>= 1;
            --this.bitsremaining;
        }
    }

    public double getOutput() {
        return (double)this.outputlevel / 2.0 * ((double)NesSettings.dmcMixLevel / 100.0);
    }

    @Override
    public int getUserPanning() {
        return NesSettings.dmcPanning;
    }

    @Override
    public int getUserMixLevel() {
        return NesSettings.dmcMixLevel;
    }

    @Override
    public double getChannelMixingRatio() {
        return 0.00335;
    }
}

