/*
 * Decompiled with CFR 0.152.
 */
package core.audio;

import core.NesSettings;
import core.audio.AudioMixer;
import core.audio.Channel;

public class Pulse
extends Channel {
    private static final long serialVersionUID = -3321343541094080447L;
    private int dutynumber = 7;
    private boolean p1;
    private int duty;
    private boolean[] current_duty = new boolean[8];
    private boolean[] duty0;
    private boolean[] duty1;
    private boolean[] duty2;
    private boolean[] duty3;
    public boolean output;
    private boolean doSweep;
    private int targetPeriod;
    private int sDivider;
    private int dividerPeriod;
    private boolean sweepReload;
    private int shift;
    private boolean negate;
    private final String name;

    public Pulse(boolean number, int location) {
        super(location);
        boolean[] blArray = new boolean[8];
        blArray[1] = true;
        this.duty0 = blArray;
        boolean[] blArray2 = new boolean[8];
        blArray2[1] = true;
        blArray2[2] = true;
        this.duty1 = blArray2;
        boolean[] blArray3 = new boolean[8];
        blArray3[1] = true;
        blArray3[2] = true;
        blArray3[3] = true;
        blArray3[4] = true;
        this.duty2 = blArray3;
        boolean[] blArray4 = new boolean[8];
        blArray4[0] = true;
        blArray4[3] = true;
        blArray4[4] = true;
        blArray4[5] = true;
        blArray4[6] = true;
        blArray4[7] = true;
        this.duty3 = blArray4;
        this.sweepReload = false;
        this.p1 = number;
        this.duty = 0;
        this.name = this.getName();
    }

    @Override
    public final void clockTimer() {
        if (this.tCount == 0) {
            this.tCount = this.timer;
            ++this.dutynumber;
            this.output = this.current_duty[this.dutynumber % 8];
        } else {
            --this.tCount;
        }
        if (this.lengthCount == 0 || !this.output || this.decay == 0 || this.timer < 8) {
            return;
        }
        int n = this.outputLocation;
        AudioMixer.audioLevels[n] = AudioMixer.audioLevels[n] + (double)this.decay;
    }

    public void registerWrite(int index, byte b, int clock) {
        switch (index % 4) {
            case 0: {
                this.duty = Byte.toUnsignedInt(b) >>> 6;
                switch (this.duty) {
                    case 0: {
                        this.current_duty = this.duty0;
                        break;
                    }
                    case 1: {
                        this.current_duty = this.duty1;
                        break;
                    }
                    case 2: {
                        this.current_duty = this.duty2;
                        break;
                    }
                    case 3: {
                        this.current_duty = this.duty3;
                    }
                }
                if (clock == 14915) {
                    this.delayedChange = (b & 0x10) != 0 ? 2 : 1;
                } else {
                    this.loop = (b & 0x20) != 0;
                }
                this.constantVolume = (b & 0x10) != 0;
                this.volume = b & 0xF;
                this.eStart = true;
                break;
            }
            case 1: {
                boolean bl = this.doSweep = (b & 0x80) != 0;
                if (!this.doSweep) {
                    this.targetPeriod = this.timer;
                }
                this.dividerPeriod = (b & 0x70) >> 4;
                this.sDivider = this.dividerPeriod + 1;
                this.negate = (b & 8) != 0;
                this.shift = b & 7;
                this.sweepReload = true;
                break;
            }
            case 2: {
                this.timer &= 0xFF00;
                this.timer |= b & 0xFF;
                this.targetPeriod = this.timer;
                break;
            }
            case 3: {
                int x = Byte.toUnsignedInt(b) >> 3;
                if (this.enable) {
                    if (clock == 14915) {
                        if (this.lengthCount == 0) {
                            this.lengthCount = this.lengthLookupTable[x];
                            this.block = true;
                        }
                    } else {
                        this.lengthCount = this.lengthLookupTable[x];
                    }
                }
                this.dutynumber = 0;
                this.timer &= 0xFF;
                this.timer |= (b & 7) << 8;
                this.targetPeriod = this.timer;
                this.eStart = true;
            }
        }
    }

    public void sweepClock() {
        if (this.enable && this.doSweep) {
            if (this.sweepReload) {
                this.sDivider = this.dividerPeriod + 1;
                if (this.sDivider == 0) {
                    this.targetPeriod = this.timer;
                }
                this.sweepReload = false;
            } else if (this.sDivider != 0) {
                --this.sDivider;
            } else {
                this.sDivider = this.dividerPeriod + 1;
                int change = this.targetPeriod >> this.shift;
                this.targetPeriod = this.negate ? (this.p1 ? this.targetPeriod - change - 1 : (this.targetPeriod -= change)) : (this.targetPeriod += change);
            }
            this.timer = this.targetPeriod & 0xFFF;
        }
    }

    public double getOutput() {
        if (this.lengthCount == 0 || !this.output || this.decay == 0 || this.timer < 8) {
            return 0.0;
        }
        return (double)this.decay * ((double)(this.p1 ? NesSettings.pulse1MixLevel : NesSettings.pulse2MixLevel) / 100.0);
    }

    @Override
    public double getFrequency() {
        if (this.getOutput() == 0.0) {
            return 0.0;
        }
        return 1789773.0 / (16.0 * (double)(this.timer + 1));
    }

    @Override
    public Object[] getInfo() {
        return new Object[]{this.name, this.getFrequency()};
    }

    @Override
    public String getName() {
        return "Pulse " + (this.p1 ? "1" : "2");
    }

    @Override
    public int getUserPanning() {
        return this.p1 ? NesSettings.pulse1Panning : NesSettings.pulse2Panning;
    }

    @Override
    public int getUserMixLevel() {
        return this.p1 ? NesSettings.pulse1MixLevel : NesSettings.pulse2MixLevel;
    }

    @Override
    public double getChannelMixingRatio() {
        return 0.00752;
    }
}

