/*
 * Decompiled with CFR 0.152.
 */
package core.audio;

import core.NesSettings;
import core.audio.AudioMixer;
import core.audio.Channel;

public class VRC6Pulse
extends Channel {
    private static final long serialVersionUID = -9117535976094772034L;
    int dutynumber;
    public boolean[] current_duty = new boolean[16];
    boolean[] duty0;
    boolean[] duty1;
    boolean[] duty2;
    boolean[] duty3;
    boolean[] duty4;
    boolean[] duty5;
    boolean[] duty6;
    boolean[] duty7;
    private boolean dutymode;
    private boolean chanone;
    private final String name;

    public VRC6Pulse(boolean channelone, int location) {
        super(location);
        boolean[] blArray = new boolean[16];
        blArray[0] = true;
        this.duty0 = blArray;
        boolean[] blArray2 = new boolean[16];
        blArray2[0] = true;
        blArray2[1] = true;
        this.duty1 = blArray2;
        boolean[] blArray3 = new boolean[16];
        blArray3[0] = true;
        blArray3[1] = true;
        blArray3[2] = true;
        this.duty2 = blArray3;
        boolean[] blArray4 = new boolean[16];
        blArray4[0] = true;
        blArray4[1] = true;
        blArray4[2] = true;
        blArray4[3] = true;
        this.duty3 = blArray4;
        boolean[] blArray5 = new boolean[16];
        blArray5[0] = true;
        blArray5[1] = true;
        blArray5[2] = true;
        blArray5[3] = true;
        blArray5[4] = true;
        this.duty4 = blArray5;
        boolean[] blArray6 = new boolean[16];
        blArray6[0] = true;
        blArray6[1] = true;
        blArray6[2] = true;
        blArray6[3] = true;
        blArray6[4] = true;
        blArray6[5] = true;
        this.duty5 = blArray6;
        boolean[] blArray7 = new boolean[16];
        blArray7[0] = true;
        blArray7[1] = true;
        blArray7[2] = true;
        blArray7[3] = true;
        blArray7[4] = true;
        blArray7[5] = true;
        blArray7[6] = true;
        this.duty6 = blArray7;
        boolean[] blArray8 = new boolean[16];
        blArray8[0] = true;
        blArray8[1] = true;
        blArray8[2] = true;
        blArray8[3] = true;
        blArray8[4] = true;
        blArray8[5] = true;
        blArray8[6] = true;
        blArray8[7] = true;
        this.duty7 = blArray8;
        this.chanone = false;
        this.chanone = channelone;
        this.name = "VRC6 Pulse " + (this.chanone ? "1" : "2");
    }

    public void registerWrite(int index, byte b) {
        switch (index % 4) {
            case 0: {
                int duty = Byte.toUnsignedInt(b) >>> 4 & 7;
                switch (duty) {
                    case 0: {
                        this.current_duty = this.duty0;
                        break;
                    }
                    case 1: {
                        this.current_duty = this.duty1;
                        break;
                    }
                    case 2: {
                        this.current_duty = this.duty2;
                        break;
                    }
                    case 3: {
                        this.current_duty = this.duty3;
                        break;
                    }
                    case 4: {
                        this.current_duty = this.duty4;
                        break;
                    }
                    case 5: {
                        this.current_duty = this.duty5;
                        break;
                    }
                    case 6: {
                        this.current_duty = this.duty6;
                        break;
                    }
                    case 7: {
                        this.current_duty = this.duty7;
                    }
                }
                this.dutymode = b < 0;
                this.volume = b & 0xF;
                break;
            }
            case 1: {
                this.timer &= 0xFF00;
                this.timer |= b & 0xFF;
                break;
            }
            case 2: {
                this.timer &= 0xFF;
                this.timer |= (b & 0xF) << 8;
                this.enable = b < 0;
            }
        }
    }

    @Override
    public final void clockTimer() {
        if (this.tCount == 0) {
            this.tCount = this.timer;
            ++this.dutynumber;
            this.output = this.current_duty[this.dutynumber % 16];
        } else {
            --this.tCount;
        }
        if (!(this.dutymode || this.enable && this.output)) {
            return;
        }
        int n = this.outputLocation;
        AudioMixer.audioLevels[n] = AudioMixer.audioLevels[n] + (double)this.volume;
    }

    @Override
    public double getFrequency() {
        if (!this.enable) {
            return 0.0;
        }
        return 1789773.0 / (16.0 * (double)(this.timer + 1));
    }

    @Override
    public Object[] getInfo() {
        return new Object[]{this.name, this.getFrequency()};
    }

    @Override
    public String getName() {
        return "VRC6 Pulse";
    }

    @Override
    public double getChannelMixingRatio() {
        return 0.012;
    }

    @Override
    public int getUserPanning() {
        return NesSettings.vrc6Panning;
    }

    @Override
    public int getUserMixLevel() {
        return NesSettings.vrc6MixLevel;
    }
}

