/*
 * Decompiled with CFR 0.152.
 */
package core.mappers;

import core.mappers.Mapper;
import java.util.Arrays;

public class AxROM
extends Mapper {
    private static final long serialVersionUID = -365861735346222319L;
    byte[][] CHRbanks;
    byte[][] PRGbanks;
    int nametable;

    public AxROM() {
        System.out.println("Mapper 7 (AxROM) Fully Supported!");
        this.PRG_RAM = new byte[8192];
    }

    @Override
    public void setCHR(byte[] chr) {
        if (chr.length > 0) {
            this.CHRbanks = new byte[chr.length / 4096][4096];
            int i = 0;
            while (i * 4096 < chr.length) {
                this.CHRbanks[i] = Arrays.copyOfRange(chr, i * 4096, i * 4096 + 4096);
                ++i;
            }
            this.CHR_ROM[0] = this.CHRbanks[0];
            this.CHR_ROM[1] = this.CHRbanks[1];
        } else {
            this.CHR_ROM[0] = new byte[4096];
            this.CHR_ROM[1] = new byte[4096];
            this.CHR_ram = true;
        }
    }

    @Override
    public void cartridgeWrite(int index, byte b) {
        if (index >= 32768 && index <= 65535) {
            this.nametable = (b & 0x10) >> 4;
            if (this.nametable == 0) {
                this.setNameTable(Mapper.Mirror.SingleScreenLow);
            } else {
                this.setNameTable(Mapper.Mirror.SingleScreenHigh);
            }
            int x = (b & 7) * 2 & this.PRGbanks.length - 1;
            this.PRG_ROM[0] = this.PRGbanks[x];
            this.PRG_ROM[1] = this.PRGbanks[x + 1];
        }
    }

    @Override
    public void setPRG(byte[] prg) {
        this.PRGbanks = new byte[prg.length / 16384][16384];
        int i = 0;
        while (i * 16384 < prg.length) {
            this.PRGbanks[i] = Arrays.copyOfRange(prg, i * 16384, i * 16384 + 16384);
            ++i;
        }
        this.PRG_ROM[0] = this.PRGbanks[this.PRGbanks.length - 2];
        this.PRG_ROM[1] = this.PRGbanks[this.PRGbanks.length - 1];
    }
}

