/*
 * Decompiled with CFR 0.152.
 */
package core.mappers;

import core.mappers.Mapper;
import java.util.Arrays;

public class CNROM
extends Mapper {
    private static final long serialVersionUID = 8386178162845980471L;
    byte[][] CHRbanks;

    public CNROM() {
        System.out.println("Mapper 3 Fully Supported!");
        this.PRG_RAM = new byte[8192];
    }

    @Override
    public void cartridgeWrite(int i, byte b) {
        super.cartridgeWrite(i, b);
        if (i >= 32768 && i <= 65535) {
            this.CHR_ROM[0] = Arrays.copyOfRange(this.CHRbanks[b & this.CHRbanks.length - 1], 0, 4096);
            this.CHR_ROM[1] = Arrays.copyOfRange(this.CHRbanks[b & this.CHRbanks.length - 1], 4096, 8192);
        }
    }

    @Override
    public void setPRG(byte[] prg) {
        if (prg.length == 32768) {
            this.PRG_ROM[0] = Arrays.copyOfRange(prg, 0, 16384);
            this.PRG_ROM[1] = Arrays.copyOfRange(prg, 16384, 32768);
        } else {
            System.out.println("smole rom");
            this.PRG_ROM[0] = prg;
            this.PRG_ROM[1] = prg;
        }
    }

    @Override
    public void setCHR(byte[] CHR) {
        this.CHRbanks = new byte[CHR.length / 8192][8192];
        this.CHR_ROM = new byte[2][4096];
        System.out.println("CHR SIZE" + CHR.length / 8192);
        if (CHR.length == 0) {
            this.CHR_ROM = new byte[2][4096];
            this.CHR_ram = true;
        }
        int i = 0;
        while (i * 8192 < CHR.length) {
            this.CHRbanks[i] = Arrays.copyOfRange(CHR, i * 8192, i * 8192 + 8192);
            ++i;
        }
        this.CHR_ROM[0] = Arrays.copyOfRange(this.CHRbanks[0], 0, 4096);
        this.CHR_ROM[1] = Arrays.copyOfRange(this.CHRbanks[0], 4096, 8192);
    }
}

