/*
 * Decompiled with CFR 0.152.
 */
package core.mappers;

import core.CPU_6502;
import core.audio.Sunsoft5B;
import core.mappers.Mapper;
import java.util.Arrays;

public class FME_7
extends Mapper {
    private static final long serialVersionUID = -8144050394409729548L;
    byte[][] PRG_RAMbanks;
    boolean hasaudio = true;
    Sunsoft5B audio;
    int command;
    int audiocommand;
    boolean prgramenable;
    boolean rominramspot;
    boolean irqEnabled;
    boolean irqCounterEnabled;
    int irqCounter;

    public FME_7() {
        this.audio = new Sunsoft5B(this.apu.mixer.requestNewOutputLocation());
        this.apu.addExpansionChannel(this.audio);
    }

    @Override
    public void setPRG(byte[] prg) {
        this.PRG_ROM = new byte[4][8192];
        this.PRGbanks = new byte[prg.length / 8192][8192];
        int i = 0;
        while (i * 8192 < prg.length) {
            this.PRGbanks[i] = Arrays.copyOfRange(prg, i * 8192, i * 8192 + 8192);
            ++i;
        }
        this.PRG_ROM[0] = this.PRGbanks[0];
        this.PRG_ROM[1] = this.PRGbanks[1];
        this.PRG_ROM[2] = this.PRGbanks[this.PRGbanks.length - 2];
        this.PRG_ROM[3] = this.PRGbanks[this.PRGbanks.length - 1];
        this.PRG_RAMbanks = new byte[1][8192];
        this.PRG_RAM = this.PRG_RAMbanks[0];
    }

    @Override
    public void setCHR(byte[] chr) {
        this.CHR_ROM = new byte[8][1024];
        if (chr.length > 0) {
            this.CHRbanks = new byte[chr.length / 1024][1024];
            int i = 0;
            while (i * 1024 < chr.length) {
                this.CHRbanks[i] = Arrays.copyOfRange(chr, i * 1024, i * 1024 + 1024);
                ++i;
            }
            this.CHR_ROM[0] = this.CHRbanks[0];
            this.CHR_ROM[1] = this.CHRbanks[1];
            this.CHR_ROM[2] = this.CHRbanks[2];
            this.CHR_ROM[3] = this.CHRbanks[3];
            this.CHR_ROM[4] = this.CHRbanks[4];
            this.CHR_ROM[5] = this.CHRbanks[5];
            this.CHR_ROM[6] = this.CHRbanks[6];
            this.CHR_ROM[7] = this.CHRbanks[7];
        } else {
            this.CHR_ram = true;
        }
    }

    @Override
    final byte cartridgeRead(int index) {
        if (index >= 24576 && index <= Short.MAX_VALUE) {
            if (this.rominramspot) {
                return this.PRG_RAM[index % 8192];
            }
            if (this.prgramenable) {
                return this.PRG_RAM[index % 8192];
            }
            return this.openbus;
        }
        if (index >= 32768 && index <= 40959) {
            return this.PRG_ROM[0][index % 8192];
        }
        if (index >= 40960 && index <= 49151) {
            return this.PRG_ROM[1][index % 8192];
        }
        if (index >= 49152 && index <= 57343) {
            return this.PRG_ROM[2][index % 8192];
        }
        if (index >= 57344 && index <= 65535) {
            return this.PRG_ROM[3][index % 8192];
        }
        return 0;
    }

    @Override
    public final void cartridgeWrite(int index, byte b) {
        this.openbus = b;
        if (index >= 24576 && index <= Short.MAX_VALUE) {
            if (!this.rominramspot && this.prgramenable) {
                this.PRG_RAM[index % 8192] = b;
            }
        } else if (index >= 32768 && index <= 40959) {
            this.command = b & 0xF;
        } else if (index >= 40960 && index <= 49151) {
            this.doCommand(b & 0xFF);
        } else if (index >= 49152 && index <= 57343 && this.hasaudio) {
            this.audiocommand = b & 0xF;
        } else if (index >= 57344 && index <= 65535 && this.hasaudio) {
            this.audio.registerWrite(this.audiocommand, b);
        }
    }

    private final void doCommand(int param) {
        switch (this.command) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.CHR_ROM[this.command] = this.CHRbanks[param & this.CHRbanks.length - 1];
                break;
            }
            case 8: {
                this.prgramenable = (param & 0x80) != 0;
                boolean bl = this.rominramspot = (param & 0x40) == 0;
                if (this.rominramspot) {
                    this.PRG_RAM = this.PRGbanks[param & 0x3F & this.PRGbanks.length - 1];
                    break;
                }
                this.PRG_RAM = this.PRG_RAMbanks[param & 0x3F & this.PRGbanks.length - 1];
                break;
            }
            case 9: {
                this.PRG_ROM[0] = this.PRGbanks[param & 0x3F & this.PRGbanks.length - 1];
                break;
            }
            case 10: {
                this.PRG_ROM[1] = this.PRGbanks[param & 0x3F & this.PRGbanks.length - 1];
                break;
            }
            case 11: {
                this.PRG_ROM[2] = this.PRGbanks[param & 0x3F & this.PRGbanks.length - 1];
                break;
            }
            case 12: {
                switch (param & 3) {
                    case 0: {
                        this.setNameTable(Mapper.Mirror.Vertical);
                        break;
                    }
                    case 1: {
                        this.setNameTable(Mapper.Mirror.Horizontal);
                        break;
                    }
                    case 2: {
                        this.setNameTable(Mapper.Mirror.SingleScreenLow);
                        break;
                    }
                    case 3: {
                        this.setNameTable(Mapper.Mirror.SingleScreenHigh);
                    }
                }
                break;
            }
            case 13: {
                this.cpu.removeIRQ(CPU_6502.IRQSource.External);
                this.irqEnabled = (param & 1) != 0;
                this.irqCounterEnabled = (param & 0x80) != 0;
                break;
            }
            case 14: {
                this.irqCounter &= 0xFF00;
                this.irqCounter |= param;
                break;
            }
            case 15: {
                this.irqCounter &= 0xFF;
                this.irqCounter |= param << 8;
            }
        }
    }

    @Override
    public byte ppureadPT(int index) {
        return this.CHR_ROM[index / 1024][index % 1024];
    }

    @Override
    public byte ppuread(int index) {
        if (index < 8192) {
            return this.CHR_ROM[index / 1024][index % 1024];
        }
        if (index >= 8192 && index <= 16127) {
            return this.nametables[index / 1024][(index &= 0xFFF) % 1024];
        }
        return this.ppu_palette[index -= (index &= 0x1F) >= 16 && (index & 3) == 0 ? 16 : 0];
    }

    private void clockirq() {
        if (this.irqCounterEnabled) {
            if (this.irqCounter == 0) {
                this.irqCounter = 65535;
                if (this.irqEnabled) {
                    this.cpu.setIRQ(CPU_6502.IRQSource.External);
                }
            } else {
                --this.irqCounter;
            }
        }
    }

    @Override
    public void runFrame() {
        while (!this.ppu.doneFrame) {
            this.ppu.doCycle();
            this.ppu.doCycle();
            this.ppu.doCycle();
            this.cpu.run_cycle();
            this.clockirq();
            this.apu.doCycle();
        }
        this.ppu.doneFrame = false;
    }
}

