/*
 * Decompiled with CFR 0.152.
 */
package core.mappers;

import core.mappers.Mapper;
import java.util.Arrays;

public class MMC1
extends Mapper {
    private static final long serialVersionUID = 5115571780542961923L;
    int shiftregister;
    int PRG_ROM_mode;
    int CHR_ROM_mode;
    int Mirror_mode;
    byte[][] PRGbanks;
    byte[][] CHRbanks;
    int banknumber;
    int lastbank;
    boolean bigrom;
    boolean smallchrrom;
    int lastwrite = 0;
    boolean prgramdisable;
    int prgswitch;
    int cpuclock;

    public MMC1() {
        System.out.println("Mapper 1 (SNROM) Fully Supported!");
        this.PRG_RAM = new byte[8192];
    }

    @Override
    public void cartridgeWrite(int index, byte b) {
        if (index >= 24576 && index < 32768 && !this.prgramdisable) {
            this.PRG_RAM[index % 8192] = b;
        }
        if (this.lastwrite == this.cpuclock - 1) {
            return;
        }
        if (index >= 32768 && index <= 65535) {
            if (b < 0) {
                this.shiftregister = 16;
                this.shiftregister = this.Mirror_mode | this.PRG_ROM_mode << 2 | this.CHR_ROM_mode << 4 | 0xC;
                this.writeRegister(32768);
                this.shiftregister = 16;
                this.PRG_ROM[1] = this.PRGbanks[this.lastbank];
            } else if ((this.shiftregister & 1) == 0) {
                this.shiftregister >>= 1;
                int x = (Byte.toUnsignedInt(b) & 1) << 4;
                this.shiftregister |= x;
            } else if ((this.shiftregister & 1) == 1) {
                this.shiftregister >>= 1;
                int x = (Byte.toUnsignedInt(b) & 1) << 4;
                this.shiftregister |= x;
                this.writeRegister(index);
                this.shiftregister = 16;
            }
            this.lastwrite = this.cpuclock;
        }
    }

    @Override
    public void setPRG(byte[] prg) {
        this.PRGbanks = new byte[prg.length / 16384][16384];
        int i = 0;
        while (i * 16384 < prg.length) {
            this.PRGbanks[i] = Arrays.copyOfRange(prg, i * 16384, i * 16384 + 16384);
            ++i;
        }
        this.PRG_ROM[0] = this.PRGbanks[0];
        this.PRG_ROM[1] = this.PRGbanks[this.PRGbanks.length - 1];
        if (prg.length / 1024 == 512) {
            this.bigrom = true;
            this.lastbank = 15;
        } else {
            this.lastbank = this.PRGbanks.length - 1;
        }
    }

    @Override
    public void setCHR(byte[] chr) {
        if (chr.length > 0) {
            this.CHRbanks = new byte[chr.length / 4096][4096];
            int i = 0;
            while (i * 4096 < chr.length) {
                this.CHRbanks[i] = Arrays.copyOfRange(chr, i * 4096, i * 4096 + 4096);
                ++i;
            }
            this.CHR_ROM[0] = this.CHRbanks[0];
            this.CHR_ROM[1] = this.CHRbanks[1];
        } else {
            this.CHR_ROM[0] = new byte[4096];
            this.CHR_ROM[1] = new byte[4096];
            this.CHR_ram = true;
        }
        this.smallchrrom = this.CHR_ram || this.CHRbanks.length == 2;
    }

    @Override
    byte cartridgeRead(int index) {
        if (index < 32768 && index >= 24576) {
            return this.PRG_RAM[index % 8192];
        }
        if (index >= 32768 && index < 49152) {
            return this.PRG_ROM[0][index % 16384];
        }
        if (index >= 49152) {
            return this.PRG_ROM[1][index % 16384];
        }
        return 0;
    }

    public void writeRegister(int index) {
        if (index >= 32768 && index <= 40959) {
            this.Mirror_mode = this.shiftregister & 3;
            switch (this.Mirror_mode) {
                case 0: {
                    this.setNameTable(Mapper.Mirror.SingleScreenLow);
                    break;
                }
                case 1: {
                    this.setNameTable(Mapper.Mirror.SingleScreenHigh);
                    break;
                }
                case 2: {
                    this.setNameTable(Mapper.Mirror.Vertical);
                    break;
                }
                case 3: {
                    this.setNameTable(Mapper.Mirror.Horizontal);
                }
            }
            this.PRG_ROM_mode = (this.shiftregister & 0xC) >> 2;
            this.CHR_ROM_mode = (this.shiftregister & 0x10) >> 4;
            this.updatePRGbanks();
        } else if (index >= 40960 && index <= 49151) {
            if (!this.CHR_ram) {
                if (this.CHR_ROM_mode == 0) {
                    this.CHR_ROM[0] = this.CHRbanks[this.shiftregister & 0x1E & this.CHRbanks.length - 1];
                    this.CHR_ROM[1] = this.CHRbanks[(this.shiftregister & 0x1E & this.CHRbanks.length - 1) + 1];
                } else {
                    this.CHR_ROM[0] = this.CHRbanks[this.shiftregister & this.CHRbanks.length - 1];
                }
            }
            if (this.bigrom) {
                this.prgswitch = (this.shiftregister & 0x10) > 0 ? 16 : 0;
                this.banknumber &= 0xF;
                this.banknumber |= this.prgswitch;
                this.lastbank &= 0xF;
                this.lastbank |= this.prgswitch;
                this.updatePRGbanks();
            }
        } else if (index >= 49152 && index <= 57343) {
            if (!this.CHR_ram && this.CHR_ROM_mode == 1) {
                this.CHR_ROM[1] = this.CHRbanks[this.shiftregister & this.CHRbanks.length - 1];
            }
            if (this.bigrom && this.CHR_ROM_mode == 1) {
                this.prgswitch = (this.shiftregister & 0x10) > 0 ? 16 : 0;
                this.banknumber &= 0xF;
                this.banknumber |= this.prgswitch;
                this.lastbank &= 0xF;
                this.lastbank |= this.prgswitch;
                this.updatePRGbanks();
            }
        } else if (index >= 57344 && index <= 65535) {
            this.banknumber = this.shiftregister & 0xF;
            this.updatePRGbanks();
        }
    }

    private void updatePRGbanks() {
        switch (this.PRG_ROM_mode) {
            case 0: 
            case 1: {
                this.PRG_ROM[0] = this.PRGbanks[this.banknumber & this.lastbank];
                this.PRG_ROM[1] = this.PRGbanks[this.banknumber + 1 & this.lastbank];
                break;
            }
            case 2: {
                this.PRG_ROM[0] = this.PRGbanks[0];
                this.PRG_ROM[1] = this.PRGbanks[this.banknumber & this.lastbank];
                break;
            }
            case 3: {
                this.PRG_ROM[0] = this.PRGbanks[this.banknumber & this.lastbank];
                this.PRG_ROM[1] = this.PRGbanks[this.lastbank];
            }
        }
    }

    @Override
    public void runFrame() {
        while (!this.ppu.doneFrame) {
            this.ppu.doCycle();
            this.ppu.doCycle();
            this.ppu.doCycle();
            this.cpu.run_cycle();
            ++this.cpuclock;
            this.apu.doCycle();
        }
        this.ppu.doneFrame = false;
    }
}

