/*
 * Decompiled with CFR 0.152.
 */
package core.mappers;

import core.CPU_6502;
import core.mappers.Mapper;
import java.util.Arrays;

public class MMC3
extends Mapper {
    private static final long serialVersionUID = -8413903049772229695L;
    boolean PRG_mode;
    boolean CHR_mode;
    boolean mirrormode;
    boolean reloadirq;
    boolean irqenable;
    boolean doingIRQ;
    boolean oldsignal = false;
    boolean currentsignal;
    int scanlinecount;
    int irqreload;
    int bankselect;
    int bankdata;
    boolean cura12;
    public boolean olda12;
    int countdown;
    boolean x;

    public MMC3() {
        System.out.println("Making an MMC3!");
    }

    @Override
    public void setPRG(byte[] prg) {
        this.PRG_ROM = new byte[4][8192];
        this.PRGbanks = new byte[prg.length / 8192][8192];
        int i = 0;
        while (i * 8192 < prg.length) {
            this.PRGbanks[i] = Arrays.copyOfRange(prg, i * 8192, i * 8192 + 8192);
            ++i;
        }
        this.PRG_ROM[0] = this.PRGbanks[0];
        this.PRG_ROM[1] = this.PRGbanks[1];
        this.PRG_ROM[2] = this.PRGbanks[this.PRGbanks.length - 2];
        this.PRG_ROM[3] = this.PRGbanks[this.PRGbanks.length - 1];
        this.PRG_RAM = new byte[8192];
    }

    @Override
    public void setCHR(byte[] chr) {
        this.CHR_ROM = new byte[8][1024];
        if (chr.length > 0) {
            this.CHRbanks = new byte[chr.length / 1024][1024];
            int i = 0;
            while (i * 1024 < chr.length) {
                this.CHRbanks[i] = Arrays.copyOfRange(chr, i * 1024, i * 1024 + 1024);
                ++i;
            }
            this.CHR_ROM[0] = this.CHRbanks[0];
            this.CHR_ROM[1] = this.CHRbanks[1];
            this.CHR_ROM[2] = this.CHRbanks[2];
            this.CHR_ROM[3] = this.CHRbanks[3];
            this.CHR_ROM[4] = this.CHRbanks[4];
            this.CHR_ROM[5] = this.CHRbanks[5];
            this.CHR_ROM[6] = this.CHRbanks[6];
            this.CHR_ROM[7] = this.CHRbanks[7];
        } else {
            this.CHRbanks = new byte[8][1024];
            this.CHR_ram = true;
        }
    }

    @Override
    public final void cartridgeWrite(int index, byte b) {
        if (index < 32768) {
            this.PRG_RAM[index - 24576] = b;
        } else if (index >= 32768 && index < 40960) {
            if (index % 2 == 0) {
                this.bankselect = b;
                this.PRG_mode = (b & 0x40) != 0;
                this.CHR_mode = (b & 0x80) != 0;
            } else {
                this.selectBank(b);
            }
        } else if (index >= 40960 && index < 49152) {
            if (index % 2 == 0) {
                boolean bl = this.mirrormode = (b & 1) == 1;
                if (this.mirrormode) {
                    this.setNameTable(Mapper.Mirror.Horizontal);
                } else {
                    this.setNameTable(Mapper.Mirror.Vertical);
                }
            }
        } else if (index >= 49152 && index < 57344) {
            if (index % 2 == 0) {
                this.irqreload = Byte.toUnsignedInt(b);
            } else {
                this.scanlinecount = 0;
            }
        } else if (index >= 57344 && index <= 65535) {
            if (index % 2 == 0) {
                this.cpu.removeIRQ(CPU_6502.IRQSource.External);
                this.doingIRQ = false;
                this.irqenable = false;
            } else {
                this.irqenable = true;
            }
        }
    }

    private void selectBank(byte b) {
        switch (this.bankselect & 7) {
            case 0: {
                if (this.CHR_mode) {
                    this.CHR_ROM[4] = this.CHRbanks[b & this.CHRbanks.length - 1];
                    this.CHR_ROM[5] = this.CHRbanks[(b & this.CHRbanks.length - 1) + 1];
                    break;
                }
                this.CHR_ROM[0] = this.CHRbanks[b & this.CHRbanks.length - 1];
                this.CHR_ROM[1] = this.CHRbanks[(b & this.CHRbanks.length - 1) + 1];
                break;
            }
            case 1: {
                if (this.CHR_mode) {
                    this.CHR_ROM[6] = this.CHRbanks[b & this.CHRbanks.length - 1];
                    this.CHR_ROM[7] = this.CHRbanks[(b & this.CHRbanks.length - 1) + 1];
                    break;
                }
                this.CHR_ROM[2] = this.CHRbanks[b & this.CHRbanks.length - 1];
                this.CHR_ROM[3] = this.CHRbanks[(b & this.CHRbanks.length - 1) + 1];
                break;
            }
            case 2: {
                if (this.CHR_mode) {
                    this.CHR_ROM[0] = this.CHRbanks[b & this.CHRbanks.length - 1];
                    break;
                }
                this.CHR_ROM[4] = this.CHRbanks[b & this.CHRbanks.length - 1];
                break;
            }
            case 3: {
                if (this.CHR_mode) {
                    this.CHR_ROM[1] = this.CHRbanks[b & this.CHRbanks.length - 1];
                    break;
                }
                this.CHR_ROM[5] = this.CHRbanks[b & this.CHRbanks.length - 1];
                break;
            }
            case 4: {
                if (this.CHR_mode) {
                    this.CHR_ROM[2] = this.CHRbanks[b & this.CHRbanks.length - 1];
                    break;
                }
                this.CHR_ROM[6] = this.CHRbanks[b & this.CHRbanks.length - 1];
                break;
            }
            case 5: {
                if (this.CHR_mode) {
                    this.CHR_ROM[3] = this.CHRbanks[b & this.CHRbanks.length - 1];
                    break;
                }
                this.CHR_ROM[7] = this.CHRbanks[b & this.CHRbanks.length - 1];
                break;
            }
            case 6: {
                if (this.PRG_mode) {
                    this.PRG_ROM[2] = this.PRGbanks[b & this.PRGbanks.length - 1];
                    this.PRG_ROM[0] = this.PRGbanks[this.PRGbanks.length - 2];
                    break;
                }
                this.PRG_ROM[0] = this.PRGbanks[b & this.PRGbanks.length - 1];
                this.PRG_ROM[2] = this.PRGbanks[this.PRGbanks.length - 2];
                break;
            }
            case 7: {
                this.PRG_ROM[1] = this.PRGbanks[b & this.PRGbanks.length - 1];
                break;
            }
        }
    }

    @Override
    final byte cartridgeRead(int index) {
        if (index < 32768 && index >= 24576) {
            return this.PRG_RAM[index - 24576];
        }
        if (index >= 32768 && index < 40960) {
            return this.PRG_ROM[0][index - 32768];
        }
        if (index >= 40960 && index < 49152) {
            return this.PRG_ROM[1][index - 40960];
        }
        if (index >= 49152 && index < 57344) {
            return this.PRG_ROM[2][index - 49152];
        }
        if (index >= 57344 && index <= 65535) {
            return this.PRG_ROM[3][index - 57344];
        }
        return 0;
    }

    @Override
    public final byte ppuread(int index) {
        if (index < 8192) {
            if (index < 1024) {
                return this.CHR_ROM[0][index];
            }
            if (index >= 1024 && index < 2048) {
                return this.CHR_ROM[1][index - 1024];
            }
            if (index >= 2048 && index < 3072) {
                return this.CHR_ROM[2][index - 2048];
            }
            if (index >= 3072 && index < 4096) {
                return this.CHR_ROM[3][index - 3072];
            }
            if (index >= 4096 && index < 5120) {
                return this.CHR_ROM[4][index - 4096];
            }
            if (index >= 5120 && index < 6144) {
                return this.CHR_ROM[5][index - 5120];
            }
            if (index >= 6144 && index < 7168) {
                return this.CHR_ROM[6][index - 6144];
            }
            return this.CHR_ROM[7][index - 7168];
        }
        if (index >= 8192 && index <= 16127) {
            return this.nametables[index / 1024][(index &= 0xFFF) % 1024];
        }
        return this.ppu_palette[(index & 0xFF) % 32];
    }

    @Override
    public final byte ppureadPT(int index) {
        this.check(index);
        return this.CHR_ROM[index / 1024][index % 1024];
    }

    @Override
    public final void ppuwrite(int index, byte b) {
        if (index < 8192 && this.CHR_ram) {
            switch (index / 1024) {
                case 0: {
                    this.CHR_ROM[0][index % 1024] = b;
                    break;
                }
                case 1: {
                    this.CHR_ROM[1][index % 1024] = b;
                    break;
                }
                case 2: {
                    this.CHR_ROM[2][index % 1024] = b;
                    break;
                }
                case 3: {
                    this.CHR_ROM[3][index % 1024] = b;
                    break;
                }
                case 4: {
                    this.CHR_ROM[4][index % 1024] = b;
                    break;
                }
                case 5: {
                    this.CHR_ROM[5][index % 1024] = b;
                    break;
                }
                case 6: {
                    this.CHR_ROM[6][index % 1024] = b;
                    break;
                }
                case 7: {
                    this.CHR_ROM[7][index % 1024] = b;
                }
            }
        } else if (index >= 8192 && index <= 16127) {
            this.nametables[index / 1024][(index &= 0xFFF) % 1024] = b;
        } else {
            int i = (index & 0xFF) % 32;
            if (i % 4 == 0) {
                this.ppu_palette[i] = b;
                this.ppu_palette[i += i < 16 ? 16 : -16] = b;
            }
            this.ppu_palette[(index & 0xFF) % 32] = b;
        }
    }

    @Override
    public void check(int x) {
        boolean bl = this.cura12 = (x & 0x1000) != 0;
        if (this.cura12 && !this.olda12) {
            if (this.countdown <= 0) {
                this.scanlinecounter();
            }
        } else if (!this.cura12 && this.olda12) {
            this.countdown = 8;
        }
        --this.countdown;
        this.olda12 = this.cura12;
    }

    @Override
    public void scanlinecounter() {
        if (this.scanlinecount-- == 0) {
            this.scanlinecount = this.irqreload;
        }
        if (this.scanlinecount == 0 && this.irqenable) {
            this.cpu.setIRQ(CPU_6502.IRQSource.External);
            this.doingIRQ = true;
        }
    }
}

