/*
 * Decompiled with CFR 0.152.
 */
package core.mappers;

import core.APU;
import core.CPU_6502;
import core.Controller;
import core.NES;
import core.NESCallback;
import core.exceptions.UnSupportedMapperException;
import core.mappers.AxROM;
import core.mappers.CNROM;
import core.mappers.FME_7;
import core.mappers.MMC1;
import core.mappers.MMC2;
import core.mappers.MMC3;
import core.mappers.MMC4;
import core.mappers.MMC5;
import core.mappers.Mapper_11;
import core.mappers.Mapper_13;
import core.mappers.Mapper_71;
import core.mappers.NROM;
import core.mappers.NSFPlayer;
import core.mappers.Namco;
import core.mappers.UxROM;
import core.mappers.VRC1;
import core.mappers.VRC3;
import core.mappers.VRC6;
import core.ppu2C02;
import java.io.Serializable;
import java.util.Arrays;

public class Mapper
implements Serializable {
    private static final long serialVersionUID = 6655950169350506050L;
    public transient NESCallback system;
    transient NES nes;
    public CPU_6502 cpu;
    public APU apu;
    public ppu2C02 ppu;
    public Controller control;
    public Controller control2;
    byte[] cpu_ram = new byte[2048];
    byte[][] ppu_internal_ram = new byte[2][1024];
    byte[][] nametables = new byte[4][1024];
    public byte[] ppu_palette = new byte[]{9, 1, 0, 1, 0, 2, 2, 13, 8, 16, 8, 36, 0, 0, 4, 44, 9, 1, 52, 3, 0, 4, 0, 20, 8, 58, 0, 2, 0, 32, 44, 8};
    public byte[] ppu_oam = new byte[256];
    byte[] cpu_mmr = new byte[24];
    byte[][] PRG_ROM = new byte[2][16384];
    byte[][] PRGbanks;
    byte[] PRG_RAM = new byte[8192];
    byte[][] CHR_ROM = new byte[2][4096];
    byte[][] CHRbanks;
    boolean CHR_ram = false;
    boolean mirrormode;
    public boolean blockppu = true;
    public boolean olda12;
    public byte openbus;
    public boolean lastcpuwrite;
    public int lastwriteaddress;
    public int lastreadaddress;
    boolean dodebug;

    public Mapper() {
        this.ppu = new ppu2C02(this);
        this.cpu = new CPU_6502(this);
        this.apu = new APU(this);
        this.control = new Controller(this, 0);
        this.control2 = new Controller(this, 1);
    }

    public void setcomponents(CPU_6502 c, ppu2C02 p, Controller cont, Controller cont2, APU a) {
        this.cpu = c;
        this.ppu = p;
        this.apu = a;
        this.control = cont;
        this.control2 = cont2;
    }

    public void setSystem(NESCallback system2) {
        this.system = system2;
    }

    public void setNes(NES n) {
        this.nes = n;
    }

    public void setMirror(int i) {
        boolean bl = this.mirrormode = i == 0;
        if (this.mirrormode) {
            this.setNameTable(Mirror.Horizontal);
        } else {
            this.setNameTable(Mirror.Vertical);
        }
        System.out.println("Mode set to:" + this.mirrormode);
    }

    public final void setNameTable(Mirror mirroringType) {
        switch (mirroringType) {
            case Horizontal: {
                this.nametables[0] = this.ppu_internal_ram[0];
                this.nametables[1] = this.ppu_internal_ram[0];
                this.nametables[2] = this.ppu_internal_ram[1];
                this.nametables[3] = this.ppu_internal_ram[1];
                break;
            }
            case Vertical: {
                this.nametables[0] = this.ppu_internal_ram[0];
                this.nametables[1] = this.ppu_internal_ram[1];
                this.nametables[2] = this.ppu_internal_ram[0];
                this.nametables[3] = this.ppu_internal_ram[1];
                break;
            }
            case SingleScreenLow: {
                this.nametables[0] = this.ppu_internal_ram[0];
                this.nametables[1] = this.ppu_internal_ram[0];
                this.nametables[2] = this.ppu_internal_ram[0];
                this.nametables[3] = this.ppu_internal_ram[0];
                break;
            }
            case SingleScreenHigh: {
                this.nametables[0] = this.ppu_internal_ram[1];
                this.nametables[1] = this.ppu_internal_ram[1];
                this.nametables[2] = this.ppu_internal_ram[1];
                this.nametables[3] = this.ppu_internal_ram[1];
            }
        }
    }

    boolean blockppu() {
        return this.apu.cyclenum > 14700L;
    }

    public void cpuwrite(int index, byte b) {
        if (index < 8192) {
            this.cpu_ram[index % 2048] = b;
        } else if (index >= 8192 && index < 16384) {
            this.ppuregisterhandler(index % 8, b, true);
        } else if (index >= 16384 && index <= 16407) {
            if (index == 16404) {
                this.cpu_mmr[20] = b;
                this.cpu.dxx = Byte.toUnsignedInt(b) << 8;
                this.cpu.writeDMA = true;
            } else if (index == 16406) {
                this.controllerWrite(index, b);
            } else if (index >= 16384 && index <= 16403) {
                this.apu.writeRegister(index, b);
            } else if (index == 16405 || index == 16407) {
                this.apu.writeRegister(index, b);
            }
            this.openbus = b;
        } else {
            this.cartridgeWrite(index, b);
        }
    }

    public void cpuwriteoam(int index, byte b) {
        this.ppu_oam[index] = b;
    }

    public byte cpuread(int index) {
        if (index < 8192) {
            return this.cpu_ram[index % 2048];
        }
        if (index >= 8192 && index < 16384) {
            return this.ppuregisterhandler(index % 8, (byte)0, false);
        }
        if (index >= 16384 && index <= 16639) {
            if (index == 16405) {
                return this.apu.readRegisters(index);
            }
            if (index == 16406) {
                return (byte)(this.openbus & 0xE0 | this.control.getControllerStatus());
            }
            if (index == 16407) {
                return (byte)(this.openbus & 0xE0 | this.control2.getControllerStatus());
            }
            return this.openbus;
        }
        return this.cartridgeRead(index);
    }

    public int cpureadu(int index) {
        return Byte.toUnsignedInt(this.cpuread(index));
    }

    public byte controllerRead(int index) {
        if (index == 16406) {
            return this.control.getControllerStatus();
        }
        return this.control2.getControllerStatus();
    }

    public void controllerWrite(int index, byte b) {
        this.control.inputRegister(b);
        this.control2.inputRegister(b);
    }

    public void ppuwrite(int index, byte b) {
        if (index < 8192 && this.CHR_ram) {
            if (index < 4096) {
                this.CHR_ROM[0][index] = b;
            } else {
                this.CHR_ROM[1][index % 4096] = b;
            }
        } else if (index >= 8192 && index <= 16127) {
            this.nametables[index / 1024][(index &= 0xFFF) % 1024] = b;
        } else {
            int i = index & 0x1F;
            if (i % 4 == 0) {
                i += i >= 16 ? -16 : 0;
            }
            this.ppu_palette[i] = b;
        }
    }

    public byte ppuread(int index) {
        if (index < 8192) {
            return this.CHR_ROM[(index & 0x1000) != 0 ? 1 : 0][index % 4096];
        }
        if (index >= 8192 && index <= 16127) {
            return this.nametables[index / 1024][(index &= 0xFFF) % 1024];
        }
        return this.ppu_palette[index -= (index &= 0x1F) >= 16 && (index & 3) == 0 ? 16 : 0];
    }

    public byte ppureadNT(int index) {
        return this.nametables[index / 1024][(index &= 0xFFF) % 1024];
    }

    public byte ppureadPT(int index) {
        return this.CHR_ROM[(index & 0x1000) != 0 ? 1 : 0][index % 4096];
    }

    public byte ppureadAT(int index) {
        return this.ppureadNT(index);
    }

    public byte ppureadoam(int index) {
        return this.ppu_oam[index % 256];
    }

    public void ppuwriteoam(int index, byte b) {
        this.ppu_oam[index] = b;
    }

    protected byte ppuregisterhandler(int index, byte x, boolean write) {
        switch (index) {
            case 0: {
                if (write && this.blockppu()) {
                    this.ppu.writeRegisters(index, x);
                    break;
                }
                if (write && !this.blockppu()) {
                    this.ppu.OPEN_BUS = x;
                    break;
                }
                return this.ppu.OPEN_BUS;
            }
            case 1: {
                if (write && this.blockppu()) {
                    this.ppu.writeRegisters(index, x);
                    break;
                }
                if (write && !this.blockppu()) {
                    this.ppu.OPEN_BUS = x;
                    break;
                }
                return this.ppu.OPEN_BUS;
            }
            case 2: {
                if (write) {
                    this.ppu.OPEN_BUS = x;
                    break;
                }
                return this.ppu.readRegister(index);
            }
            case 3: {
                if (write) {
                    this.ppu.writeRegisters(index, x);
                    break;
                }
                return this.ppu.OPEN_BUS;
            }
            case 4: {
                if (write) {
                    this.ppu.writeRegisters(index, x);
                    break;
                }
                return this.ppu.readRegister(index);
            }
            case 5: {
                if (write && this.blockppu()) {
                    this.ppu.writeRegisters(index, x);
                    break;
                }
                if (write && !this.blockppu()) {
                    this.ppu.OPEN_BUS = x;
                    break;
                }
                return this.ppu.OPEN_BUS;
            }
            case 6: {
                if (write && this.blockppu()) {
                    this.ppu.writeRegisters(index, x);
                    break;
                }
                if (write && !this.blockppu()) {
                    this.ppu.OPEN_BUS = x;
                    break;
                }
                return this.ppu.OPEN_BUS;
            }
            case 7: {
                if (write) {
                    this.ppu.writeRegisters(index, x);
                    break;
                }
                return this.ppu.readRegister(index);
            }
        }
        return 0;
    }

    void cartridgeWrite(int index, byte b) {
        if (index < 32768 && index >= 24576) {
            this.PRG_RAM[index - 24576] = b;
        }
    }

    byte cartridgeRead(int index) {
        if (index < 32768 && index >= 24576) {
            return this.PRG_RAM[index - 24576];
        }
        if (index < 49152) {
            return this.PRG_ROM[0][index % 16384];
        }
        return this.PRG_ROM[1][index % 16384];
    }

    public void restoreSave(byte[] save) {
        this.PRG_RAM = save;
    }

    public byte[] getSave() {
        return this.PRG_RAM;
    }

    public void setPRG(byte[] prg) {
        if (prg.length == 32768) {
            this.PRG_ROM[0] = Arrays.copyOfRange(prg, 0, 16384);
            this.PRG_ROM[1] = Arrays.copyOfRange(prg, 16384, 32768);
        } else {
            this.PRG_ROM[0] = Arrays.copyOfRange(prg, 0, 16384);
            this.PRG_ROM[1] = Arrays.copyOfRange(prg, 0, 16384);
        }
    }

    public void check(int i) {
    }

    public void setCHR(byte[] chr) {
        if (chr.length == 0) {
            this.CHR_ROM = new byte[2][4096];
            this.CHR_ram = true;
        } else {
            this.CHR_ROM[0] = Arrays.copyOfRange(chr, 0, 4096);
            this.CHR_ROM[1] = Arrays.copyOfRange(chr, 4096, 8192);
        }
    }

    public void setPRGRAM(boolean present) {
    }

    public void printMemory(int offset, int length) {
        System.out.print("[");
        for (int i = offset; i < offset + length - 1; ++i) {
            System.out.print(Integer.toHexString(Byte.toUnsignedInt(this.cpuread(i))) + ", ");
        }
        System.out.println("]");
    }

    public void printMemoryPPU(int offset, int length) {
        System.out.print("[");
        for (int i = offset; i < offset + length - 1; ++i) {
            System.out.print(Integer.toHexString(Byte.toUnsignedInt(this.ppuread(i))) + ", ");
        }
        System.out.println("]");
    }

    public void printOAMPPU(int offset, int length) {
        System.out.print("[");
        for (int i = offset; i < offset + length - 1; ++i) {
            System.out.print(Integer.toHexString(Byte.toUnsignedInt(this.ppureadoam(i))) + ", ");
        }
        System.out.println("]");
    }

    public void loadData(byte[] data) {
    }

    public void setBanking(byte[] b) {
    }

    public void scanlinecounter() {
    }

    public void addExtraAudio(byte b) {
    }

    public void setNSFVariables(int playaddr, int initaddr, int loadaddr, int playspeed, int startsong, int tuneregion, int tuneregion2, String songname, String artistname) {
    }

    public void setTrackNames(String[] tracknames) {
    }

    public void setTrackTimes(int[] tracktimes) {
    }

    public void setAuthInfo(String[] info) {
    }

    public static Mapper getmapper(int i) throws UnSupportedMapperException {
        switch (i) {
            case 0: {
                return new NROM();
            }
            case 1: {
                return new MMC1();
            }
            case 2: {
                return new UxROM();
            }
            case 3: {
                return new CNROM();
            }
            case 4: {
                return new MMC3();
            }
            case 5: {
                return new MMC5();
            }
            case 7: {
                return new AxROM();
            }
            case 9: {
                return new MMC2();
            }
            case 10: {
                return new MMC4();
            }
            case 11: {
                return new Mapper_11();
            }
            case 13: {
                return new Mapper_13();
            }
            case 19: {
                return new Namco(163);
            }
            case 24: {
                return new VRC6(24);
            }
            case 26: {
                return new VRC6(26);
            }
            case 69: {
                return new FME_7();
            }
            case 71: {
                return new Mapper_71();
            }
            case 73: {
                return new VRC3();
            }
            case 75: {
                return new VRC1();
            }
            case 210: {
                return new Namco(175);
            }
            case 1001: {
                return new NSFPlayer(0);
            }
            case 1002: {
                return new NSFPlayer(1);
            }
        }
        throw new UnSupportedMapperException(i);
    }

    public void runFrame() {
        while (!this.ppu.doneFrame) {
            this.ppu.doCycle();
            this.ppu.doCycle();
            this.ppu.doCycle();
            this.cpu.run_cycle();
            this.apu.doCycle();
        }
        this.ppu.doneFrame = false;
    }

    public void runCPUCycle() {
        this.ppu.doCycle();
        this.ppu.doCycle();
        this.ppu.doCycle();
        this.cpu.run_cycle();
        this.apu.doCycle();
    }

    public void setInitialPC() {
        this.cpu.setPC(this.cpureadu(65533) << 8 | this.cpureadu(65532));
    }

    public static enum Mirror {
        Horizontal,
        Vertical,
        SingleScreenLow,
        SingleScreenHigh;

    }
}

