/*
 * Decompiled with CFR 0.152.
 */
package core.mappers;

import core.CPU_6502;
import core.NesSettings;
import core.audio.MMC5Audio;
import core.audio.NamcoSound;
import core.audio.Sunsoft5B;
import core.audio.VRC6Pulse;
import core.audio.VRC6Saw;
import core.mappers.Mapper;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.font.TextAttribute;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.HashMap;

public class NSFPlayer
extends Mapper {
    private static final long serialVersionUID = 2962869930880758980L;
    private VRC6Pulse vrc6pulse1;
    private VRC6Pulse vrc6pulse2;
    private VRC6Saw vrc6saw;
    private NamcoSound namco;
    private byte[] namcomemory;
    private int soundAddress;
    private boolean addrAutoInc;
    private MMC5Audio mmc5;
    private byte[] mmc5exram;
    private boolean multlowready;
    private boolean multhighready;
    private int multlow;
    private int multhigh;
    private int multproduct;
    private Sunsoft5B sunsoft;
    private int audiocommand;
    private byte[] initialbanks;
    private int initaddr;
    private int playaddr;
    private int loadaddr;
    private int playspeed;
    private int currentsong;
    private int totalsongs;
    private String title;
    private String artist;
    private int[] tracktimes;
    private String[] tracknames;
    private byte irqstatus;
    private int irqcounter;
    private boolean irqEnable;
    private int irqreload;
    private boolean doingIRQ;
    private int nextirq;
    private int tracktimer = 0;
    private String expansionInfo;
    private boolean doingBanking;
    private Font largefont;
    private Font smallfont;
    private boolean nsfemode;
    boolean pause = false;
    boolean primednext;
    boolean primedprev;
    boolean prevpause;
    boolean prevlooping;
    boolean looping = false;
    boolean prevforever;
    boolean playingforever = false;
    int[] nsfbios;
    byte[] data;
    byte[] banks;
    byte soundchip;
    boolean initdone;
    BufferedImage image;
    Graphics g;

    public NSFPlayer(int i) {
        int[] nArray = new int[256];
        nArray[0] = 255;
        nArray[1] = 255;
        nArray[2] = 255;
        nArray[3] = 120;
        nArray[4] = 162;
        nArray[5] = 255;
        nArray[6] = 142;
        nArray[7] = 23;
        nArray[8] = 64;
        nArray[9] = 232;
        nArray[10] = 32;
        nArray[11] = 48;
        nArray[12] = 63;
        nArray[13] = 142;
        nArray[15] = 32;
        nArray[16] = 142;
        nArray[17] = 1;
        nArray[18] = 32;
        nArray[19] = 142;
        nArray[20] = 18;
        nArray[21] = 62;
        nArray[22] = 88;
        nArray[23] = 76;
        nArray[24] = 23;
        nArray[25] = 63;
        nArray[26] = 72;
        nArray[27] = 138;
        nArray[28] = 72;
        nArray[29] = 152;
        nArray[30] = 72;
        nArray[31] = 174;
        nArray[32] = 18;
        nArray[33] = 62;
        nArray[34] = 240;
        nArray[35] = 89;
        nArray[36] = 202;
        nArray[37] = 240;
        nArray[38] = 220;
        nArray[39] = 32;
        nArray[40] = 249;
        nArray[41] = 63;
        nArray[42] = 104;
        nArray[43] = 168;
        nArray[44] = 104;
        nArray[45] = 170;
        nArray[46] = 104;
        nArray[47] = 64;
        nArray[48] = 142;
        nArray[49] = 21;
        nArray[50] = 64;
        nArray[51] = 173;
        nArray[52] = 19;
        nArray[53] = 62;
        nArray[54] = 74;
        nArray[55] = 144;
        nArray[56] = 9;
        nArray[57] = 142;
        nArray[58] = 2;
        nArray[59] = 144;
        nArray[60] = 142;
        nArray[61] = 2;
        nArray[62] = 160;
        nArray[63] = 142;
        nArray[64] = 2;
        nArray[65] = 176;
        nArray[66] = 74;
        nArray[67] = 144;
        nArray[68] = 13;
        nArray[69] = 160;
        nArray[70] = 32;
        nArray[71] = 140;
        nArray[72] = 16;
        nArray[73] = 144;
        nArray[74] = 142;
        nArray[75] = 48;
        nArray[76] = 144;
        nArray[77] = 200;
        nArray[78] = 192;
        nArray[79] = 38;
        nArray[80] = 208;
        nArray[81] = 245;
        nArray[82] = 74;
        nArray[83] = 144;
        nArray[84] = 11;
        nArray[85] = 160;
        nArray[86] = 128;
        nArray[87] = 140;
        nArray[88] = 131;
        nArray[89] = 64;
        nArray[90] = 140;
        nArray[91] = 135;
        nArray[92] = 64;
        nArray[93] = 140;
        nArray[94] = 137;
        nArray[95] = 64;
        nArray[96] = 74;
        nArray[97] = 144;
        nArray[98] = 3;
        nArray[99] = 142;
        nArray[100] = 21;
        nArray[101] = 80;
        nArray[102] = 74;
        nArray[103] = 144;
        nArray[104] = 8;
        nArray[105] = 202;
        nArray[106] = 142;
        nArray[108] = 248;
        nArray[109] = 232;
        nArray[110] = 142;
        nArray[112] = 72;
        nArray[113] = 74;
        nArray[114] = 144;
        nArray[115] = 8;
        nArray[116] = 160;
        nArray[117] = 7;
        nArray[118] = 140;
        nArray[120] = 192;
        nArray[121] = 140;
        nArray[123] = 224;
        nArray[124] = 96;
        nArray[125] = 32;
        nArray[126] = 48;
        nArray[127] = 63;
        nArray[128] = 138;
        nArray[129] = 202;
        nArray[130] = 154;
        nArray[131] = 142;
        nArray[132] = 247;
        nArray[133] = 95;
        nArray[134] = 202;
        nArray[135] = 142;
        nArray[136] = 246;
        nArray[137] = 95;
        nArray[138] = 162;
        nArray[139] = 127;
        nArray[140] = 133;
        nArray[142] = 134;
        nArray[143] = 1;
        nArray[144] = 168;
        nArray[145] = 162;
        nArray[146] = 39;
        nArray[147] = 145;
        nArray[149] = 200;
        nArray[150] = 208;
        nArray[151] = 251;
        nArray[152] = 202;
        nArray[153] = 48;
        nArray[154] = 10;
        nArray[155] = 198;
        nArray[156] = 1;
        nArray[157] = 224;
        nArray[158] = 7;
        nArray[159] = 208;
        nArray[160] = 242;
        nArray[161] = 134;
        nArray[162] = 1;
        nArray[163] = 240;
        nArray[164] = 238;
        nArray[165] = 162;
        nArray[166] = 20;
        nArray[167] = 202;
        nArray[168] = 157;
        nArray[170] = 64;
        nArray[171] = 208;
        nArray[172] = 250;
        nArray[173] = 162;
        nArray[174] = 7;
        nArray[175] = 189;
        nArray[176] = 8;
        nArray[177] = 62;
        nArray[178] = 157;
        nArray[179] = 248;
        nArray[180] = 95;
        nArray[181] = 202;
        nArray[182] = 16;
        nArray[183] = 247;
        nArray[184] = 160;
        nArray[185] = 15;
        nArray[186] = 140;
        nArray[187] = 21;
        nArray[188] = 64;
        nArray[189] = 173;
        nArray[190] = 19;
        nArray[191] = 62;
        nArray[192] = 41;
        nArray[193] = 4;
        nArray[194] = 240;
        nArray[195] = 16;
        nArray[196] = 173;
        nArray[197] = 14;
        nArray[198] = 62;
        nArray[199] = 240;
        nArray[200] = 3;
        nArray[201] = 141;
        nArray[202] = 246;
        nArray[203] = 95;
        nArray[204] = 173;
        nArray[205] = 15;
        nArray[206] = 62;
        nArray[207] = 240;
        nArray[208] = 3;
        nArray[209] = 141;
        nArray[210] = 247;
        nArray[211] = 95;
        nArray[212] = 174;
        nArray[213] = 17;
        nArray[214] = 62;
        nArray[215] = 189;
        nArray[216] = 4;
        nArray[217] = 62;
        nArray[218] = 141;
        nArray[219] = 16;
        nArray[220] = 62;
        nArray[221] = 189;
        nArray[222] = 6;
        nArray[223] = 62;
        nArray[224] = 141;
        nArray[225] = 17;
        nArray[226] = 62;
        nArray[227] = 140;
        nArray[228] = 18;
        nArray[229] = 62;
        nArray[230] = 173;
        nArray[231] = 18;
        nArray[232] = 62;
        nArray[233] = 88;
        nArray[234] = 173;
        nArray[235] = 16;
        nArray[236] = 62;
        nArray[237] = 32;
        nArray[238] = 246;
        nArray[239] = 63;
        nArray[240] = 141;
        nArray[241] = 19;
        nArray[242] = 62;
        nArray[243] = 76;
        nArray[244] = 23;
        nArray[245] = 63;
        nArray[246] = 108;
        nArray[248] = 62;
        nArray[249] = 108;
        nArray[250] = 2;
        nArray[251] = 62;
        nArray[252] = 3;
        nArray[253] = 63;
        nArray[254] = 26;
        nArray[255] = 63;
        this.nsfbios = nArray;
        this.initdone = false;
        this.image = new BufferedImage(256, 240, 1);
        this.g = this.image.getGraphics();
        System.out.println("Making an NSF Player!");
        HashMap<TextAttribute, Object> attributes = new HashMap<TextAttribute, Object>();
        attributes.put(TextAttribute.FAMILY, "Default");
        attributes.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_SEMIBOLD);
        attributes.put(TextAttribute.SIZE, 14);
        this.largefont = Font.getFont(attributes);
        attributes.put(TextAttribute.FAMILY, "Default");
        attributes.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_SEMIBOLD);
        attributes.put(TextAttribute.SIZE, 10);
        this.smallfont = Font.getFont(attributes);
        this.nsfemode = i == 1;
    }

    public void setupData() {
        this.initialbanks = this.banks;
        this.PRG_ROM = new byte[8][4096];
        this.doingBanking = false;
        byte[] byArray = this.banks;
        int n = this.banks.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            if (b != 0) {
                this.doingBanking = true;
                break;
            }
            ++n2;
        }
        if (!this.doingBanking) {
            int cBank = this.loadaddr / 4096 - 8;
            int offset = 4096 - this.loadaddr % 4096;
            System.arraycopy(this.data, 0, this.PRG_ROM[cBank], this.loadaddr % 4096, offset);
            ++cBank;
            while (offset + 4096 < this.data.length) {
                System.arraycopy(this.data, offset, this.PRG_ROM[cBank], 0, 4096);
                offset += 4096;
                ++cBank;
            }
            if (offset < this.data.length) {
                System.arraycopy(this.data, offset, this.PRG_ROM[cBank], 0, this.data.length - offset);
            }
        } else {
            int padding = 0xFFF & this.loadaddr;
            byte[] databanks = new byte[padding + this.data.length];
            System.arraycopy(this.data, 0, databanks, padding, this.data.length);
            this.PRGbanks = new byte[databanks.length / 4096 + 10][4096];
            int i = 0;
            while (i * 4096 < databanks.length) {
                this.PRGbanks[i] = Arrays.copyOfRange(databanks, i * 4096, i * 4096 + 4096);
                ++i;
            }
            this.PRG_ROM[0] = this.PRGbanks[this.banks[0] & 0xFF];
            this.PRG_ROM[1] = this.PRGbanks[this.banks[1] & 0xFF];
            this.PRG_ROM[2] = this.PRGbanks[this.banks[2] & 0xFF];
            this.PRG_ROM[3] = this.PRGbanks[this.banks[3] & 0xFF];
            this.PRG_ROM[4] = this.PRGbanks[this.banks[4] & 0xFF];
            this.PRG_ROM[5] = this.PRGbanks[this.banks[5] & 0xFF];
            this.PRG_ROM[6] = this.PRGbanks[this.banks[6] & 0xFF];
            this.PRG_ROM[7] = this.PRGbanks[this.banks[7] & 0xFF];
        }
    }

    @Override
    public void loadData(byte[] d) {
        this.data = d;
    }

    @Override
    public void setBanking(byte[] b) {
        this.banks = b;
    }

    @Override
    public void addExtraAudio(byte b) {
        this.soundchip = b;
        if (b != 0) {
            this.expansionInfo = "Extra Audio: ";
        }
        if ((b & 1) == 1) {
            this.vrc6pulse1 = new VRC6Pulse(true, this.apu.requestNewOutputLocation());
            this.vrc6pulse2 = new VRC6Pulse(false, this.apu.requestNewOutputLocation());
            this.vrc6saw = new VRC6Saw(this.apu.requestNewOutputLocation());
            this.apu.addExpansionChannel(this.vrc6pulse1);
            this.apu.addExpansionChannel(this.vrc6pulse2);
            this.apu.addExpansionChannel(this.vrc6saw);
            this.expansionInfo = String.valueOf(this.expansionInfo) + "VRC6 ";
        }
        if ((b & 8) == 8) {
            this.mmc5 = new MMC5Audio(this);
            this.mmc5exram = new byte[1024];
            this.apu.addExpansionChannel(this.mmc5);
            this.expansionInfo = String.valueOf(this.expansionInfo) + "MMC5 ";
        }
        if ((b & 0x10) == 16) {
            this.namcomemory = new byte[128];
            this.namco = new NamcoSound(this.namcomemory, this.apu.mixer.requestNewOutputLocation());
            this.apu.addExpansionChannel(this.namco);
            this.expansionInfo = String.valueOf(this.expansionInfo) + "Namco ";
        }
        if ((b & 0x20) == 32) {
            this.sunsoft = new Sunsoft5B(this.apu.mixer.requestNewOutputLocation());
            this.apu.addExpansionChannel(this.sunsoft);
            this.expansionInfo = String.valueOf(this.expansionInfo) + "Sunsoft5B ";
        }
    }

    @Override
    public void setNSFVariables(int play, int init, int load, int speed, int startsong, int total, int tuneregion, String name, String artist) {
        this.initaddr = init;
        this.playaddr = play;
        this.loadaddr = load;
        this.playspeed = speed;
        this.playspeed = (int)((double)this.playspeed * 1.789773);
        this.playspeed = 29828;
        this.currentsong = 0;
        this.totalsongs = total;
        this.title = name;
        this.artist = artist;
    }

    @Override
    public void setTrackNames(String[] tracks) {
        this.tracknames = tracks;
    }

    @Override
    public void setTrackTimes(int[] times) {
        this.tracktimes = times;
    }

    @Override
    public void setAuthInfo(String[] info) {
        this.title = info[0];
        this.artist = info[1];
    }

    @Override
    public void setCHR(byte[] chr) {
        this.doingIRQ = true;
        this.cpu.setIRQ(CPU_6502.IRQSource.External);
    }

    private void soundwrite(byte b) {
        if (this.soundAddress < 64) {
            this.namcomemory[this.soundAddress] = b;
        } else {
            this.namco.registerWrite(this.soundAddress % 8, b, this.soundAddress / 8 - 8);
            this.namcomemory[this.soundAddress] = b;
            if (this.soundAddress == 127) {
                this.namco.setEnables((b & 0x70) >> 4);
            }
        }
        if (this.addrAutoInc) {
            ++this.soundAddress;
            if (this.soundAddress == 128) {
                this.soundAddress = 0;
            }
        }
    }

    private byte soundread() {
        byte b = this.namcomemory[this.soundAddress];
        if (this.addrAutoInc) {
            ++this.soundAddress;
            if (this.soundAddress == 128) {
                this.soundAddress = 0;
            }
        }
        return b;
    }

    private byte varread(int index) {
        switch (index) {
            case 15872: {
                return (byte)(this.initaddr & 0xFF);
            }
            case 15873: {
                return (byte)(this.initaddr >> 8 & 0xFF);
            }
            case 15874: {
                return (byte)(this.playaddr & 0xFF);
            }
            case 15875: {
                return (byte)(this.playaddr >> 8 & 0xFF);
            }
            case 15876: {
                return (byte)(this.playspeed & 0xFF);
            }
            case 15877: {
                return (byte)(this.playspeed & 0xFF);
            }
            case 15878: {
                return (byte)(this.playspeed >> 8 & 0xFF);
            }
            case 15879: {
                return (byte)(this.playspeed >> 8 & 0xFF);
            }
            case 15880: {
                return this.initialbanks[0];
            }
            case 15881: {
                return this.initialbanks[1];
            }
            case 15882: {
                return this.initialbanks[2];
            }
            case 15883: {
                return this.initialbanks[3];
            }
            case 15884: {
                return this.initialbanks[4];
            }
            case 15885: {
                return this.initialbanks[5];
            }
            case 15886: {
                return this.initialbanks[6];
            }
            case 15887: {
                return this.initialbanks[7];
            }
            case 15888: {
                return (byte)this.currentsong;
            }
            case 15889: {
                return 0;
            }
            case 15890: {
                if (this.doingIRQ) {
                    this.cpu.removeIRQ(CPU_6502.IRQSource.External);
                }
                this.doingIRQ = false;
                return this.irqstatus;
            }
            case 15891: {
                return (byte)(this.soundchip & 0x3F);
            }
        }
        return 0;
    }

    private void varwrite(int index, byte b) {
        switch (index) {
            case 15888: {
                this.irqreload &= 0xFF00;
                this.irqreload |= b & 0xFF;
                break;
            }
            case 15889: {
                this.irqreload &= 0xFF;
                this.irqreload |= (b & 0xFF) << 8;
                break;
            }
            case 15890: {
                this.irqcounter = this.irqreload * 5;
                this.irqEnable = b != 0;
                break;
            }
            case 15891: {
                this.irqcounter = this.irqreload;
            }
        }
    }

    @Override
    public byte cpuread(int index) {
        if (index <= 2048) {
            return this.cpu_ram[index];
        }
        if (index >= 15872 && index <= 15891) {
            return this.varread(index);
        }
        if (index >= 16128 && index <= 16383) {
            return (byte)this.nsfbios[index - 16128];
        }
        if (index == 16405) {
            return this.apu.readRegisters(index);
        }
        if ((index < 16448 || index > 16511) && index != 16528 && index != 16530) {
            if (index == 18432) {
                return this.soundread();
            }
            if (index == 20997 || index == 20998) {
                if (index == 20997) {
                    return (byte)(this.multproduct & 0xFF);
                }
                return (byte)(this.multproduct >> 8 & 0xFF);
            }
            if (index >= 23552 && index <= 24565) {
                return this.mmc5exram[index % 1024];
            }
            if (index >= 24576 && index <= 65529) {
                if (index <= Short.MAX_VALUE) {
                    return this.PRG_RAM[index % 8192];
                }
                return this.PRG_ROM[index / 4096 - 8][index % 4096];
            }
            switch (index) {
                case 65535: {
                    return 63;
                }
                case 65534: {
                    return 26;
                }
            }
        }
        return 0;
    }

    @Override
    public void cpuwrite(int index, byte b) {
        if (index <= 2048) {
            this.cpu_ram[index] = b;
        } else if (index >= 15872 && index <= 15891) {
            this.varwrite(index, b);
        } else if (index >= 16128 && index <= 16383) {
            this.nsfbios[index - 16128] = b;
        } else if (index >= 16384 && index <= 16403) {
            this.apu.writeRegister(index, b);
        } else if (index == 16405 || index == 16407) {
            this.apu.writeRegister(index, b);
        } else if (!(index >= 16448 && index <= 16512 || index >= 16514 && index <= 16522)) {
            if (index == 18432) {
                this.soundwrite(b);
            } else if (index >= 20480 && index <= 20501) {
                this.mmc5.registerWrite(index, b);
            } else if (index == 20997 || index == 20998) {
                if (index == 20997) {
                    this.multlow = b & 0xFF;
                    this.multlowready = true;
                    this.doMultiply();
                } else {
                    this.multhigh = b & 0xFF;
                    this.multhighready = true;
                    this.doMultiply();
                }
            } else if (index >= 23552 && index <= 24565) {
                this.mmc5exram[index % 1024] = b;
            } else if (index != 24566 && index != 24567) {
                if (index >= 24568 && index <= 24575) {
                    if (this.doingBanking) {
                        this.PRG_ROM[index % 8] = this.PRGbanks[b & 0xFF];
                    }
                } else if (index >= 24576 && index <= Short.MAX_VALUE) {
                    this.PRG_RAM[index % 8192] = b;
                } else {
                    switch (index) {
                        case 36864: {
                            this.vrc6pulse1.registerWrite(0, b);
                            break;
                        }
                        case 36865: {
                            this.vrc6pulse1.registerWrite(1, b);
                            break;
                        }
                        case 36866: {
                            this.vrc6pulse1.registerWrite(2, b);
                            break;
                        }
                        case 40960: {
                            this.vrc6pulse2.registerWrite(0, b);
                            break;
                        }
                        case 40961: {
                            this.vrc6pulse2.registerWrite(1, b);
                            break;
                        }
                        case 40962: {
                            this.vrc6pulse2.registerWrite(2, b);
                            break;
                        }
                        case 45056: {
                            this.vrc6saw.registerWrite(0, b);
                            break;
                        }
                        case 45057: {
                            this.vrc6saw.registerWrite(1, b);
                            break;
                        }
                        case 45058: {
                            this.vrc6saw.registerWrite(2, b);
                            break;
                        }
                        case 63488: {
                            this.soundAddress = b & 0x7F;
                            this.addrAutoInc = (b & 0x80) != 0;
                            break;
                        }
                        case 49152: {
                            this.audiocommand = 0xF & b;
                            break;
                        }
                        case 57344: {
                            this.sunsoft.registerWrite(this.audiocommand, b);
                        }
                    }
                }
            }
        }
    }

    private void doMultiply() {
        if (this.multhighready && this.multlowready) {
            this.multproduct = this.multlow * this.multhigh;
            this.multlowready = false;
            this.multhighready = false;
        }
    }

    private void init() {
        this.cpu.program_counter = 16131;
        this.setupData();
    }

    private void nextTrack() {
        if (this.currentsong + 1 != this.totalsongs) {
            ++this.currentsong;
        }
        this.nextirq = 0;
        this.tracktimer = 0;
    }

    private void prevTrack() {
        if (this.tracktimer / 60 < 5) {
            --this.currentsong;
            if (this.currentsong < 0) {
                this.currentsong = 0;
            }
        }
        this.nextirq = 0;
        this.tracktimer = 0;
    }

    private String timeformat(int i) {
        String out = String.valueOf(i / 3600) + ":";
        int seconds = i / 60 % 60;
        out = String.valueOf(out) + (seconds < 10 ? "0" + seconds : Integer.valueOf(seconds));
        return out;
    }

    private void drawscreen() {
        this.g.setColor(Color.BLACK);
        this.g.fillRect(0, 0, 256, 240);
        this.g.setColor(Color.BLUE);
        this.g.setFont(this.largefont);
        this.g.drawString("Key Bindings", 0, 20);
        this.g.drawString("NSF Player Status:", 0, 100);
        this.g.drawString(this.expansionInfo, 0, 160);
        this.g.drawString("Title: " + this.title, 0, 180);
        if (this.nsfemode && this.tracknames != null) {
            this.g.drawString("Song: " + this.tracknames[this.currentsong], 0, 195);
        }
        this.g.drawString("Artist: " + this.artist, 0, 210);
        if (this.nsfemode && this.tracktimes != null) {
            this.g.drawString("Track " + (this.currentsong + 1) + "/" + this.totalsongs + "         " + this.timeformat(this.tracktimer) + "/" + this.timeformat(this.tracktimes[this.currentsong]), 0, 230);
        } else {
            this.g.drawString("Track " + (this.currentsong + 1) + "/" + this.totalsongs + "         " + this.timeformat(this.tracktimer) + "/" + this.timeformat(NesSettings.nsfPlayerSongLength), 0, 230);
        }
        this.g.setFont(this.smallfont);
        this.g.drawString("Next Track: Right", 0, 35);
        this.g.drawString("Prev Track: Left", 0, 45);
        this.g.drawString("Pause: Start", 0, 55);
        this.g.drawString("Loop: A", 0, 65);
        this.g.drawString("Forever Mode: B", 0, 75);
        this.g.drawString(!this.pause ? "Playing" : "Paused", 0, 115);
        this.g.drawString(this.playingforever ? "Playing Current Song Forever" : "", 0, 125);
        this.g.drawString(this.looping ? "Looping Current Song" : "", 0, 135);
        this.image.getRGB(0, 0, 256, 240, this.ppu.renderer.colorized, 0, 256);
    }

    private void pollPlayerControls() {
        boolean[] controls = this.system.pollController()[0];
        if (!this.prevpause && controls[3]) {
            this.pause = !this.pause;
        }
        this.prevpause = controls[3];
        if (controls[7]) {
            this.primednext = true;
        } else {
            if (this.primednext) {
                this.nextTrack();
            }
            this.primednext = false;
        }
        if (controls[6]) {
            this.primedprev = true;
        } else {
            if (this.primedprev) {
                this.prevTrack();
            }
            this.primedprev = false;
        }
        if (!this.prevforever && controls[1]) {
            this.playingforever = !this.playingforever;
        }
        this.prevforever = controls[1];
        if (!this.prevlooping && controls[0]) {
            this.looping = !this.looping;
        }
        this.prevlooping = controls[0];
    }

    @Override
    public void runFrame() {
        if (!this.initdone) {
            this.init();
        }
        this.initdone = true;
        this.pollPlayerControls();
        while (this.cpu.program_counter != 16377 && !this.pause) {
            this.cpu.run_cycle();
            if (this.irqEnable) {
                --this.irqcounter;
                if (this.irqcounter == 0) {
                    this.irqcounter = this.irqreload;
                    if (!this.doingIRQ) {
                        this.cpu.setIRQ(CPU_6502.IRQSource.External);
                        this.irqstatus = (byte)this.nextirq;
                    }
                    this.doingIRQ = true;
                }
            }
            this.apu.doCycle();
        }
        this.nextirq = 2;
        this.cpu.run_cycle();
        this.cpu.run_cycle();
        this.cpu.run_cycle();
        this.cpu.run_cycle();
        this.cpu.run_cycle();
        this.apu.doCycle();
        this.apu.doCycle();
        this.apu.doCycle();
        this.apu.doCycle();
        this.apu.doCycle();
        if (!this.pause) {
            if (this.nsfemode) {
                if (this.tracktimes != null && ++this.tracktimer >= this.tracktimes[this.currentsong] && !this.playingforever) {
                    if (this.looping) {
                        this.nextirq = 0;
                        this.tracktimer = 0;
                    } else {
                        this.nextTrack();
                    }
                }
            } else if (++this.tracktimer >= NesSettings.nsfPlayerSongLength && !this.playingforever) {
                if (this.looping) {
                    this.nextirq = 0;
                    this.tracktimer = 0;
                } else {
                    this.nextTrack();
                }
            }
        }
        this.drawscreen();
    }
}

