/*
 * Decompiled with CFR 0.152.
 */
package core.mappers;

import core.CPU_6502;
import core.audio.NamcoSound;
import core.mappers.Mapper;
import java.util.Arrays;

public class Namco
extends Mapper {
    private static final long serialVersionUID = 6370867416895887534L;
    private int irqcounter;
    private boolean irqEnable;
    private boolean hasirq;
    private boolean irqstopped;
    private int mappertype;
    private boolean disablechrramlow;
    private boolean disablechrramhigh;
    private boolean soundEnable;
    private boolean soundAutoInc;
    private int soundAddress;
    private byte[] soundMemory = new byte[128];
    private NamcoSound soundChannel;
    private boolean PRGramenable;
    private boolean ramenable1;
    private boolean ramenable2;
    private boolean ramenable3;
    private boolean ramenable4;

    public Namco(int type) {
        this.mappertype = type;
        System.out.println("Made a Namco " + this.mappertype + "!");
        if (type == 163 || type == 129) {
            this.hasirq = true;
            this.soundChannel = new NamcoSound(this.soundMemory, this.apu.mixer.requestNewOutputLocation());
            this.apu.addExpansionChannel(this.soundChannel);
        }
    }

    @Override
    public void setPRG(byte[] prg) {
        this.PRG_ROM = new byte[4][8192];
        this.PRGbanks = new byte[prg.length / 8192][8192];
        int i = 0;
        while (i * 8192 < prg.length) {
            this.PRGbanks[i] = Arrays.copyOfRange(prg, i * 8192, i * 8192 + 8192);
            ++i;
        }
        this.PRG_ROM[0] = this.PRGbanks[0];
        this.PRG_ROM[1] = this.PRGbanks[1];
        this.PRG_ROM[2] = this.PRGbanks[this.PRGbanks.length - 2];
        this.PRG_ROM[3] = this.PRGbanks[this.PRGbanks.length - 1];
        this.PRG_RAM = new byte[8192];
    }

    @Override
    public void setCHR(byte[] chr) {
        this.CHR_ROM = new byte[8][1024];
        if (chr.length > 0) {
            this.CHRbanks = new byte[chr.length / 1024][1024];
            int i = 0;
            while (i * 1024 < chr.length) {
                this.CHRbanks[i] = Arrays.copyOfRange(chr, i * 1024, i * 1024 + 1024);
                ++i;
            }
            this.CHR_ROM[0] = this.CHRbanks[0];
            this.CHR_ROM[1] = this.CHRbanks[1];
            this.CHR_ROM[2] = this.CHRbanks[2];
            this.CHR_ROM[3] = this.CHRbanks[3];
            this.CHR_ROM[4] = this.CHRbanks[4];
            this.CHR_ROM[5] = this.CHRbanks[5];
            this.CHR_ROM[6] = this.CHRbanks[6];
            this.CHR_ROM[7] = this.CHRbanks[7];
        } else {
            this.CHR_ram = true;
        }
    }

    @Override
    public final void cartridgeWrite(int index, byte b) {
        if (index >= 18432) {
            if (index <= 20479) {
                this.soundwrite(b);
            } else if (index <= 22527) {
                if (this.mappertype == 129 || this.mappertype == 163) {
                    this.irqcounter &= 0xFF00;
                    this.irqcounter |= b & 0xFF;
                    if (this.irqstopped) {
                        this.cpu.removeIRQ(CPU_6502.IRQSource.External);
                        this.irqstopped = false;
                    }
                }
            } else if (index <= 24575) {
                if (this.mappertype == 129 || this.mappertype == 163) {
                    this.irqcounter &= 0xFF;
                    this.irqcounter |= (b & 0x7F) << 8;
                    boolean bl = this.irqEnable = (b & 0x80) != 0;
                    if (this.irqstopped) {
                        this.cpu.removeIRQ(CPU_6502.IRQSource.External);
                        this.irqstopped = false;
                    }
                }
            } else if (index <= 26623) {
                if (this.ramenable1) {
                    this.PRG_RAM[index % 8192] = b;
                }
            } else if (index <= 28671) {
                if (this.ramenable2) {
                    this.PRG_RAM[index % 8192] = b;
                }
            } else if (index <= 30719) {
                if (this.ramenable3) {
                    this.PRG_RAM[index % 8192] = b;
                }
            } else if (index <= Short.MAX_VALUE) {
                if (this.ramenable4) {
                    this.PRG_RAM[index % 8192] = b;
                }
            } else if (index <= 57343) {
                int data = Byte.toUnsignedInt(b);
                if (data <= 223) {
                    switch (index / 2048) {
                        case 16: {
                            this.CHR_ROM[0] = this.CHRbanks[data & this.CHRbanks.length - 1];
                            break;
                        }
                        case 17: {
                            this.CHR_ROM[1] = this.CHRbanks[data & this.CHRbanks.length - 1];
                            break;
                        }
                        case 18: {
                            this.CHR_ROM[2] = this.CHRbanks[data & this.CHRbanks.length - 1];
                            break;
                        }
                        case 19: {
                            this.CHR_ROM[3] = this.CHRbanks[data & this.CHRbanks.length - 1];
                            break;
                        }
                        case 20: {
                            this.CHR_ROM[4] = this.CHRbanks[data & this.CHRbanks.length - 1];
                            break;
                        }
                        case 21: {
                            this.CHR_ROM[5] = this.CHRbanks[data & this.CHRbanks.length - 1];
                            break;
                        }
                        case 22: {
                            this.CHR_ROM[6] = this.CHRbanks[data & this.CHRbanks.length - 1];
                            break;
                        }
                        case 23: {
                            this.CHR_ROM[7] = this.CHRbanks[data & this.CHRbanks.length - 1];
                        }
                    }
                    if (this.mappertype == 129 || this.mappertype == 163) {
                        switch (index / 2048) {
                            case 24: {
                                this.nametables[0] = this.CHRbanks[data & this.CHRbanks.length - 1];
                                break;
                            }
                            case 25: {
                                this.nametables[0] = this.CHRbanks[data & this.CHRbanks.length - 1];
                                break;
                            }
                            case 26: {
                                this.nametables[0] = this.CHRbanks[data & this.CHRbanks.length - 1];
                                break;
                            }
                            case 27: {
                                this.nametables[0] = this.CHRbanks[data & this.CHRbanks.length - 1];
                            }
                        }
                    }
                } else if (this.mappertype == 129 || this.mappertype == 163) {
                    switch (index / 2048) {
                        case 16: {
                            if (this.disablechrramlow) break;
                            if ((data & 1) == 0) {
                                this.CHR_ROM[0] = this.ppu_internal_ram[0];
                                break;
                            }
                            this.CHR_ROM[0] = this.ppu_internal_ram[1];
                            break;
                        }
                        case 17: {
                            if (this.disablechrramlow) break;
                            if ((data & 1) == 0) {
                                this.CHR_ROM[1] = this.ppu_internal_ram[0];
                                break;
                            }
                            this.CHR_ROM[1] = this.ppu_internal_ram[1];
                            break;
                        }
                        case 18: {
                            if (this.disablechrramlow) break;
                            if ((data & 1) == 0) {
                                this.CHR_ROM[2] = this.ppu_internal_ram[0];
                                break;
                            }
                            this.CHR_ROM[2] = this.ppu_internal_ram[1];
                            break;
                        }
                        case 19: {
                            if (this.disablechrramlow) break;
                            if ((data & 1) == 0) {
                                this.CHR_ROM[3] = this.ppu_internal_ram[0];
                                break;
                            }
                            this.CHR_ROM[3] = this.ppu_internal_ram[1];
                            break;
                        }
                        case 20: {
                            if (this.disablechrramhigh) break;
                            if ((data & 1) == 0) {
                                this.CHR_ROM[4] = this.ppu_internal_ram[0];
                                break;
                            }
                            this.CHR_ROM[4] = this.ppu_internal_ram[1];
                            break;
                        }
                        case 21: {
                            if (this.disablechrramhigh) break;
                            if ((data & 1) == 0) {
                                this.CHR_ROM[5] = this.ppu_internal_ram[0];
                                break;
                            }
                            this.CHR_ROM[5] = this.ppu_internal_ram[1];
                            break;
                        }
                        case 22: {
                            if (this.disablechrramhigh) break;
                            if ((data & 1) == 0) {
                                this.CHR_ROM[6] = this.ppu_internal_ram[0];
                                break;
                            }
                            this.CHR_ROM[6] = this.ppu_internal_ram[1];
                            break;
                        }
                        case 23: {
                            if (this.disablechrramhigh) break;
                            this.CHR_ROM[7] = (data & 1) == 0 ? this.ppu_internal_ram[0] : this.ppu_internal_ram[1];
                        }
                    }
                    switch (index / 2048) {
                        case 24: {
                            this.nametables[0] = (data & 1) == 0 ? this.ppu_internal_ram[0] : this.ppu_internal_ram[1];
                            break;
                        }
                        case 25: {
                            this.nametables[1] = (data & 1) == 0 ? this.ppu_internal_ram[0] : this.ppu_internal_ram[1];
                            break;
                        }
                        case 26: {
                            this.nametables[2] = (data & 1) == 0 ? this.ppu_internal_ram[0] : this.ppu_internal_ram[1];
                            break;
                        }
                        case 27: {
                            byte[] byArray = this.nametables[3] = (data & 1) == 0 ? this.ppu_internal_ram[0] : this.ppu_internal_ram[1];
                        }
                    }
                }
                if (index >= 49152 && index <= 51199 && this.mappertype == 175) {
                    this.PRGramenable = (b & 1) == 1;
                }
            } else if (index <= 59391) {
                this.PRG_ROM[0] = this.PRGbanks[b & 0x3F & this.PRGbanks.length - 1];
                if (this.mappertype == 129 || this.mappertype == 163) {
                    boolean bl = this.soundEnable = (b & 0x40) != 0;
                    if (!this.soundEnable) {
                        this.soundChannel.disable();
                    }
                } else if (this.mappertype == 340) {
                    switch (Byte.toUnsignedInt(b) >> 6) {
                        case 0: {
                            this.setNameTable(Mapper.Mirror.SingleScreenLow);
                            break;
                        }
                        case 1: {
                            this.setNameTable(Mapper.Mirror.Vertical);
                            break;
                        }
                        case 2: {
                            this.setNameTable(Mapper.Mirror.Horizontal);
                            break;
                        }
                        case 3: {
                            this.setNameTable(Mapper.Mirror.SingleScreenHigh);
                        }
                    }
                }
            } else if (index <= 61439) {
                this.PRG_ROM[1] = this.PRGbanks[b & 0x3F & this.PRGbanks.length - 1];
                if (this.mappertype == 129 || this.mappertype == 163) {
                    this.disablechrramlow = (b & 0x40) != 0;
                    this.disablechrramhigh = (b & 0x80) != 0;
                }
            } else if (index <= 63487) {
                this.PRG_ROM[2] = this.PRGbanks[b & 0x3F & this.PRGbanks.length - 1];
            } else if (index <= 65535 && (this.mappertype == 129 || this.mappertype == 163)) {
                this.ramenable1 = (b & 0xF0) == 64 && (b & 1) == 0;
                this.ramenable2 = (b & 0xF0) == 64 && (b & 2) == 0;
                this.ramenable3 = (b & 0xF0) == 64 && (b & 4) == 0;
                this.ramenable4 = (b & 0xF0) == 64 && (b & 8) == 0;
                this.soundAddress = b & 0x7F;
                this.soundAutoInc = (b & 0x80) != 0;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    final byte cartridgeRead(int index) {
        if (index < 18432) return 0;
        if (index <= 20479) {
            if (!this.hasirq) return 0;
            return this.soundread();
        }
        if (index <= 22527) {
            if (!this.hasirq) return 0;
            return (byte)(this.irqcounter & 0xFF);
        }
        if (index <= 24575) {
            if (!this.hasirq) return 0;
            return (byte)(this.irqcounter >> 8 & 0xFF);
        }
        if (index < 32768) {
            if (this.mappertype != 175) return this.PRG_RAM[index - 24576];
            if (!this.PRGramenable) return 0;
            return this.PRG_RAM[index - 24576];
        }
        if (index < 40960) {
            return this.PRG_ROM[0][index - 32768];
        }
        if (index < 49152) {
            return this.PRG_ROM[1][index - 40960];
        }
        if (index < 57344) {
            return this.PRG_ROM[2][index - 49152];
        }
        if (index > 65535) return 0;
        return this.PRG_ROM[3][index - 57344];
    }

    @Override
    public byte ppureadPT(int index) {
        return this.CHR_ROM[index / 1024][index % 1024];
    }

    private void soundwrite(byte b) {
        if (this.soundAddress < 64) {
            this.soundMemory[this.soundAddress] = b;
        } else {
            this.soundChannel.registerWrite(this.soundAddress % 8, b, this.soundAddress / 8 - 8);
            this.soundMemory[this.soundAddress] = b;
            if (this.soundAddress == 127) {
                this.soundChannel.setEnables((b & 0x70) >> 4);
            }
        }
        if (this.soundAutoInc) {
            ++this.soundAddress;
            if (this.soundAddress == 128) {
                this.soundAddress = 0;
            }
        }
    }

    private byte soundread() {
        byte b = this.soundMemory[this.soundAddress];
        if (this.soundAutoInc) {
            ++this.soundAddress;
            if (this.soundAddress == 128) {
                this.soundAddress = 0;
            }
        }
        return b;
    }

    private void clockirq() {
        if (this.irqEnable && !this.irqstopped) {
            ++this.irqcounter;
            if (this.irqcounter == Short.MAX_VALUE) {
                this.cpu.setIRQ(CPU_6502.IRQSource.External);
                this.irqstopped = true;
            }
        }
    }

    @Override
    public void runFrame() {
        while (!this.ppu.doneFrame) {
            this.ppu.doCycle();
            this.ppu.doCycle();
            this.ppu.doCycle();
            this.cpu.run_cycle();
            if (this.hasirq) {
                this.clockirq();
            }
            this.apu.doCycle();
        }
        this.ppu.doneFrame = false;
    }
}

