/*
 * Decompiled with CFR 0.152.
 */
package core.mappers;

import core.CPU_6502;
import core.mappers.Mapper;
import java.util.Arrays;

public class VRC3
extends Mapper {
    private static final long serialVersionUID = 5509863799463095751L;
    private int irqlatch;
    private int irqmode = 0;
    private boolean irqacknowledge;
    private boolean irqEnable = false;
    private boolean doingIRQ;
    private int irqcounter;

    public VRC3() {
        System.out.println("Making a VRC3!");
    }

    @Override
    public void setPRG(byte[] prg) {
        this.PRG_ROM = new byte[2][16384];
        this.PRGbanks = new byte[prg.length / 16384][16384];
        int i = 0;
        while (i * 16384 < prg.length) {
            this.PRGbanks[i] = Arrays.copyOfRange(prg, i * 16384, i * 16384 + 16384);
            ++i;
        }
        this.PRG_ROM[0] = this.PRGbanks[0];
        this.PRG_ROM[1] = this.PRGbanks[this.PRGbanks.length - 1];
    }

    @Override
    void cartridgeWrite(int index, byte b) {
        if (index >= 24576) {
            if (index <= Short.MAX_VALUE) {
                this.PRG_RAM[index % 8192] = b;
            } else if (index <= 36863) {
                this.irqlatch &= 0xFFF0;
                this.irqlatch |= b & 0xF;
            } else if (index <= 40959) {
                this.irqlatch &= 0xFF0F;
                this.irqlatch |= (b & 0xF) << 4;
            } else if (index <= 45055) {
                this.irqlatch &= 0xF0FF;
                this.irqlatch |= (b & 0xF) << 8;
            } else if (index <= 49151) {
                this.irqlatch &= 0xFFF;
                this.irqlatch |= (b & 0xF) << 12;
            } else if (index <= 53247) {
                this.irqEnable = (b & 2) > 0;
                this.irqacknowledge = (b & 1) == 1;
                this.irqmode = (b & 4) >> 2;
                if (this.irqEnable) {
                    this.irqcounter = this.irqlatch;
                }
                if (this.doingIRQ) {
                    this.cpu.removeIRQ(CPU_6502.IRQSource.External);
                    this.doingIRQ = false;
                }
            } else if (index <= 57343) {
                if (this.doingIRQ) {
                    this.cpu.removeIRQ(CPU_6502.IRQSource.External);
                    this.doingIRQ = false;
                }
                this.irqEnable = this.irqacknowledge;
            } else if (index >= 61440 && index <= 65535) {
                this.PRG_ROM[0] = this.PRGbanks[b & 7 & this.PRGbanks.length - 1];
            }
        }
    }

    private void clockIRQ() {
        if (this.irqEnable) {
            if (this.irqmode == 0) {
                ++this.irqcounter;
                if (this.irqcounter > 65535) {
                    if (!this.doingIRQ) {
                        this.cpu.setIRQ(CPU_6502.IRQSource.External);
                    }
                    this.doingIRQ = true;
                    this.irqcounter = this.irqlatch;
                }
            } else if ((this.irqcounter & 0xFF) == 255) {
                if (!this.doingIRQ) {
                    this.cpu.setIRQ(CPU_6502.IRQSource.External);
                }
                this.doingIRQ = true;
                this.irqcounter = this.irqlatch;
            } else {
                ++this.irqcounter;
            }
        }
    }

    @Override
    public void runFrame() {
        while (!this.ppu.doneFrame) {
            this.ppu.doCycle();
            this.ppu.doCycle();
            this.ppu.doCycle();
            this.cpu.run_cycle();
            this.clockIRQ();
            this.apu.doCycle();
        }
        this.ppu.doneFrame = false;
    }
}

