/*
 * Decompiled with CFR 0.152.
 */
package core.mappers;

import core.CPU_6502;
import core.audio.VRC6Pulse;
import core.audio.VRC6Saw;
import core.mappers.Mapper;
import java.util.Arrays;

public class VRC6
extends Mapper {
    private static final long serialVersionUID = 478999998259356806L;
    private int[] Rvals = new int[8];
    private int ppubankmode;
    VRC6Pulse pulse1 = new VRC6Pulse(true, this.apu.requestNewOutputLocation());
    VRC6Pulse pulse2 = new VRC6Pulse(false, this.apu.requestNewOutputLocation());
    VRC6Saw saw = new VRC6Saw(this.apu.requestNewOutputLocation());
    private final boolean maptype;
    private int irqlatch;
    private int irqmode = 0;
    private boolean irqacknowledge;
    private boolean irqEnable = false;
    private int prescaler = 341;
    private boolean doingIRQ;
    private int irqcounter;

    public VRC6(int type) {
        this.apu.addExpansionChannel(this.pulse1);
        this.apu.addExpansionChannel(this.pulse2);
        this.apu.addExpansionChannel(this.saw);
        System.out.println("Making a VRC6!");
        this.maptype = type == 26;
    }

    @Override
    public void setPRG(byte[] prg) {
        this.PRG_ROM = new byte[4][8192];
        this.PRGbanks = new byte[prg.length / 8192][8192];
        int i = 0;
        while (i * 8192 < prg.length) {
            this.PRGbanks[i] = Arrays.copyOfRange(prg, i * 8192, i * 8192 + 8192);
            ++i;
        }
        this.PRG_ROM[0] = this.PRGbanks[0];
        this.PRG_ROM[1] = this.PRGbanks[1];
        this.PRG_ROM[2] = this.PRGbanks[2];
        this.PRG_ROM[3] = this.PRGbanks[this.PRGbanks.length - 1];
    }

    @Override
    public void setCHR(byte[] chr) {
        this.CHR_ROM = new byte[8][1024];
        if (chr.length > 0) {
            this.CHRbanks = new byte[chr.length / 1024][1024];
            int i = 0;
            while (i * 1024 < chr.length) {
                this.CHRbanks[i] = Arrays.copyOfRange(chr, i * 1024, i * 1024 + 1024);
                ++i;
            }
        } else {
            this.CHR_ram = true;
        }
    }

    @Override
    public byte cartridgeRead(int index) {
        if (index >= 24576 && index < 32768) {
            return this.PRG_RAM[index % 8192];
        }
        if (index >= 32768 && index <= 40959) {
            return this.PRG_ROM[0][index % 8192];
        }
        if (index >= 40960 && index <= 49151) {
            return this.PRG_ROM[1][index % 8192];
        }
        if (index >= 49152 && index <= 57343) {
            return this.PRG_ROM[2][index % 8192];
        }
        if (index >= 57344 && index <= 65535) {
            return this.PRG_ROM[3][index % 8192];
        }
        return 0;
    }

    @Override
    public void cartridgeWrite(int index, byte b) {
        if (index >= 24576 && index <= Short.MAX_VALUE) {
            this.PRG_RAM[index % 8192] = b;
        } else {
            if (this.maptype) {
                index &= 0xF003;
            }
            switch (index) {
                case 32768: 
                case 32769: 
                case 32770: 
                case 32771: {
                    int bank = (b & 0xF) << 1;
                    this.PRG_ROM[0] = this.PRGbanks[bank & this.PRGbanks.length - 1];
                    this.PRG_ROM[1] = this.PRGbanks[(bank & this.PRGbanks.length - 1) + 1];
                    break;
                }
                case 36864: {
                    this.pulse1.registerWrite(0, b);
                    break;
                }
                case 36865: {
                    this.pulse1.registerWrite(1, b);
                    break;
                }
                case 36866: {
                    this.pulse1.registerWrite(2, b);
                    break;
                }
                case 40960: {
                    this.pulse2.registerWrite(0, b);
                    break;
                }
                case 40961: {
                    this.pulse2.registerWrite(1, b);
                    break;
                }
                case 40962: {
                    this.pulse2.registerWrite(2, b);
                    break;
                }
                case 45056: {
                    this.saw.registerWrite(0, b);
                    break;
                }
                case 45057: {
                    this.saw.registerWrite(1, b);
                    break;
                }
                case 45058: {
                    this.saw.registerWrite(2, b);
                    break;
                }
                case 45059: {
                    this.ppubankmode = b & 3;
                    this.setCHR();
                    switch (b >> 2 & 3) {
                        case 0: {
                            this.setNameTable(Mapper.Mirror.Vertical);
                            break;
                        }
                        case 1: {
                            this.setNameTable(Mapper.Mirror.Horizontal);
                            break;
                        }
                        case 2: {
                            this.setNameTable(Mapper.Mirror.SingleScreenLow);
                            break;
                        }
                        case 3: {
                            this.setNameTable(Mapper.Mirror.SingleScreenHigh);
                        }
                    }
                    break;
                }
                case 49152: 
                case 49153: 
                case 49154: 
                case 49155: {
                    this.PRG_ROM[2] = this.PRGbanks[b & 0x1F & this.PRGbanks.length - 1];
                    break;
                }
                case 53248: 
                case 53249: 
                case 53250: 
                case 53251: {
                    this.Rvals[index & 3] = Byte.toUnsignedInt(b);
                    this.setCHR();
                    break;
                }
                case 57344: 
                case 57345: 
                case 57346: 
                case 57347: {
                    this.Rvals[(index & 3) + 4] = Byte.toUnsignedInt(b);
                    this.setCHR();
                    break;
                }
                case 61440: {
                    this.irqlatch = Byte.toUnsignedInt(b);
                    break;
                }
                case 61441: {
                    this.irqEnable = (b & 2) > 0;
                    this.irqacknowledge = (b & 1) == 1;
                    this.irqmode = (b & 4) >> 2;
                    if (this.irqEnable) {
                        this.irqcounter = this.irqlatch;
                        this.prescaler = 341;
                    }
                    if (!this.doingIRQ) break;
                    this.cpu.removeIRQ(CPU_6502.IRQSource.External);
                    this.doingIRQ = false;
                    break;
                }
                case 61442: {
                    if (this.doingIRQ) {
                        this.cpu.removeIRQ(CPU_6502.IRQSource.External);
                        this.doingIRQ = false;
                    }
                    this.irqEnable = this.irqacknowledge;
                }
            }
        }
    }

    @Override
    public byte ppureadPT(int index) {
        return this.CHR_ROM[index / 1024][index % 1024];
    }

    private void setCHR() {
        switch (this.ppubankmode) {
            case 0: {
                this.CHR_ROM[0] = this.CHRbanks[this.Rvals[0] & this.CHRbanks.length - 1];
                this.CHR_ROM[1] = this.CHRbanks[this.Rvals[1] & this.CHRbanks.length - 1];
                this.CHR_ROM[2] = this.CHRbanks[this.Rvals[2] & this.CHRbanks.length - 1];
                this.CHR_ROM[3] = this.CHRbanks[this.Rvals[3] & this.CHRbanks.length - 1];
                this.CHR_ROM[4] = this.CHRbanks[this.Rvals[4] & this.CHRbanks.length - 1];
                this.CHR_ROM[5] = this.CHRbanks[this.Rvals[5] & this.CHRbanks.length - 1];
                this.CHR_ROM[6] = this.CHRbanks[this.Rvals[6] & this.CHRbanks.length - 1];
                this.CHR_ROM[7] = this.CHRbanks[this.Rvals[7] & this.CHRbanks.length - 1];
                break;
            }
            case 1: {
                this.CHR_ROM[0] = this.CHRbanks[this.Rvals[0] & this.CHRbanks.length - 1];
                this.CHR_ROM[1] = this.CHRbanks[this.Rvals[0] & this.CHRbanks.length - 1];
                this.CHR_ROM[2] = this.CHRbanks[this.Rvals[1] & this.CHRbanks.length - 1];
                this.CHR_ROM[3] = this.CHRbanks[this.Rvals[1] & this.CHRbanks.length - 1];
                this.CHR_ROM[4] = this.CHRbanks[this.Rvals[2] & this.CHRbanks.length - 1];
                this.CHR_ROM[5] = this.CHRbanks[this.Rvals[2] & this.CHRbanks.length - 1];
                this.CHR_ROM[6] = this.CHRbanks[this.Rvals[3] & this.CHRbanks.length - 1];
                this.CHR_ROM[7] = this.CHRbanks[this.Rvals[3] & this.CHRbanks.length - 1];
                break;
            }
            case 2: 
            case 3: {
                this.CHR_ROM[0] = this.CHRbanks[this.Rvals[0] & this.CHRbanks.length - 1];
                this.CHR_ROM[1] = this.CHRbanks[this.Rvals[1] & this.CHRbanks.length - 1];
                this.CHR_ROM[2] = this.CHRbanks[this.Rvals[2] & this.CHRbanks.length - 1];
                this.CHR_ROM[3] = this.CHRbanks[this.Rvals[3] & this.CHRbanks.length - 1];
                this.CHR_ROM[4] = this.CHRbanks[this.Rvals[4] & this.CHRbanks.length - 1];
                this.CHR_ROM[5] = this.CHRbanks[this.Rvals[4] & this.CHRbanks.length - 1];
                this.CHR_ROM[6] = this.CHRbanks[this.Rvals[5] & this.CHRbanks.length - 1];
                this.CHR_ROM[7] = this.CHRbanks[this.Rvals[5] & this.CHRbanks.length - 1];
            }
        }
    }

    private void clockIRQ() {
        if (this.irqEnable) {
            this.prescaler -= 3;
            if (this.irqmode == 1 || this.prescaler <= 0 && this.irqmode == 0) {
                if (this.irqcounter == 255) {
                    if (!this.doingIRQ) {
                        this.cpu.setIRQ(CPU_6502.IRQSource.External);
                    }
                    this.doingIRQ = true;
                    this.irqcounter = this.irqlatch;
                } else {
                    ++this.irqcounter;
                }
                this.prescaler += 341;
            }
        }
    }

    @Override
    public void runFrame() {
        while (!this.ppu.doneFrame) {
            this.ppu.doCycle();
            this.ppu.doCycle();
            this.ppu.doCycle();
            this.cpu.run_cycle();
            this.clockIRQ();
            this.apu.doCycle();
        }
        this.ppu.doneFrame = false;
    }
}

