/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.NesSettings;
import core.mappers.Mapper;
import core.video.Renderer;
import java.io.Serializable;
import java.util.Arrays;

public class ppu2C02
implements Serializable {
    private static final long serialVersionUID = -1721542574813003352L;
    int finalscanline;
    boolean palregion;
    double currentFPS;
    boolean oddframe = false;
    int oamcounter = 0;
    byte[] oambuffer = new byte[32];
    int oamBCounter = 0;
    int[] spritebm = new int[8];
    int[] spriteco = new int[8];
    boolean[] spritepriority = new boolean[8];
    boolean[] spritehorizontal = new boolean[8];
    int[] spritepalette = new int[8];
    public int scanline;
    public int pcycle;
    int cyclepart;
    int shiftreg16a = 0;
    int shiftreg16b = 0;
    int shiftreg8a = 0;
    int shiftreg8b = 0;
    int palettelatchnew = 0;
    int palettelatchold = 0;
    int nametablebyte;
    int atablebyte;
    int ptablemap0;
    int ptablemap1;
    int fineX;
    byte PPUCTRL;
    int PPUCTRL_bna;
    boolean PPUCTRL_vraminc;
    boolean PPUCTRL_spta;
    public boolean PPUCTRL_bpta;
    boolean PPUCTRL_ss;
    boolean PPUCTRL_ms;
    boolean PPUCTRL_genNmi;
    int PPUMASK;
    boolean PPUMASK_grey;
    boolean PPUMASK_bl;
    boolean PPUMASK_sl;
    boolean PPUMASK_sb;
    public boolean PPUMASK_ss = false;
    boolean render;
    int PPUMASK_colorbits;
    int leftmask_b = 0;
    int leftmask_s = 0;
    byte PPUSTATUS;
    int PPUSTATUS_lsb;
    boolean PPUSTATUS_so;
    boolean PPUSTATUS_sz;
    public boolean PPUSTATUS_vb;
    public byte OAMADDR;
    int OAMDATA;
    byte PPUDATA_readbuffer = 0;
    public byte OPEN_BUS;
    public boolean spritefetch;
    public boolean doneFrame;
    public int v;
    public int t;
    public int x;
    public Renderer renderer;
    private int[] pixels;
    public int pixelnum;
    Mapper map;
    int tv;
    boolean even = true;
    boolean block;
    boolean prevrender;
    boolean delayset;
    private int stage = 1;
    private int n;
    private int m = 0;
    int spritec = 0;
    boolean oldspritezero;
    boolean spritezero;
    int numsprites;
    int[] BitReverseTable256;

    public ppu2C02(Mapper m) {
        int[] nArray = new int[256];
        nArray[1] = 128;
        nArray[2] = 64;
        nArray[3] = 192;
        nArray[4] = 32;
        nArray[5] = 160;
        nArray[6] = 96;
        nArray[7] = 224;
        nArray[8] = 16;
        nArray[9] = 144;
        nArray[10] = 80;
        nArray[11] = 208;
        nArray[12] = 48;
        nArray[13] = 176;
        nArray[14] = 112;
        nArray[15] = 240;
        nArray[16] = 8;
        nArray[17] = 136;
        nArray[18] = 72;
        nArray[19] = 200;
        nArray[20] = 40;
        nArray[21] = 168;
        nArray[22] = 104;
        nArray[23] = 232;
        nArray[24] = 24;
        nArray[25] = 152;
        nArray[26] = 88;
        nArray[27] = 216;
        nArray[28] = 56;
        nArray[29] = 184;
        nArray[30] = 120;
        nArray[31] = 248;
        nArray[32] = 4;
        nArray[33] = 132;
        nArray[34] = 68;
        nArray[35] = 196;
        nArray[36] = 36;
        nArray[37] = 164;
        nArray[38] = 100;
        nArray[39] = 228;
        nArray[40] = 20;
        nArray[41] = 148;
        nArray[42] = 84;
        nArray[43] = 212;
        nArray[44] = 52;
        nArray[45] = 180;
        nArray[46] = 116;
        nArray[47] = 244;
        nArray[48] = 12;
        nArray[49] = 140;
        nArray[50] = 76;
        nArray[51] = 204;
        nArray[52] = 44;
        nArray[53] = 172;
        nArray[54] = 108;
        nArray[55] = 236;
        nArray[56] = 28;
        nArray[57] = 156;
        nArray[58] = 92;
        nArray[59] = 220;
        nArray[60] = 60;
        nArray[61] = 188;
        nArray[62] = 124;
        nArray[63] = 252;
        nArray[64] = 2;
        nArray[65] = 130;
        nArray[66] = 66;
        nArray[67] = 194;
        nArray[68] = 34;
        nArray[69] = 162;
        nArray[70] = 98;
        nArray[71] = 226;
        nArray[72] = 18;
        nArray[73] = 146;
        nArray[74] = 82;
        nArray[75] = 210;
        nArray[76] = 50;
        nArray[77] = 178;
        nArray[78] = 114;
        nArray[79] = 242;
        nArray[80] = 10;
        nArray[81] = 138;
        nArray[82] = 74;
        nArray[83] = 202;
        nArray[84] = 42;
        nArray[85] = 170;
        nArray[86] = 106;
        nArray[87] = 234;
        nArray[88] = 26;
        nArray[89] = 154;
        nArray[90] = 90;
        nArray[91] = 218;
        nArray[92] = 58;
        nArray[93] = 186;
        nArray[94] = 122;
        nArray[95] = 250;
        nArray[96] = 6;
        nArray[97] = 134;
        nArray[98] = 70;
        nArray[99] = 198;
        nArray[100] = 38;
        nArray[101] = 166;
        nArray[102] = 102;
        nArray[103] = 230;
        nArray[104] = 22;
        nArray[105] = 150;
        nArray[106] = 86;
        nArray[107] = 214;
        nArray[108] = 54;
        nArray[109] = 182;
        nArray[110] = 118;
        nArray[111] = 246;
        nArray[112] = 14;
        nArray[113] = 142;
        nArray[114] = 78;
        nArray[115] = 206;
        nArray[116] = 46;
        nArray[117] = 174;
        nArray[118] = 110;
        nArray[119] = 238;
        nArray[120] = 30;
        nArray[121] = 158;
        nArray[122] = 94;
        nArray[123] = 222;
        nArray[124] = 62;
        nArray[125] = 190;
        nArray[126] = 126;
        nArray[127] = 254;
        nArray[128] = 1;
        nArray[129] = 129;
        nArray[130] = 65;
        nArray[131] = 193;
        nArray[132] = 33;
        nArray[133] = 161;
        nArray[134] = 97;
        nArray[135] = 225;
        nArray[136] = 17;
        nArray[137] = 145;
        nArray[138] = 81;
        nArray[139] = 209;
        nArray[140] = 49;
        nArray[141] = 177;
        nArray[142] = 113;
        nArray[143] = 241;
        nArray[144] = 9;
        nArray[145] = 137;
        nArray[146] = 73;
        nArray[147] = 201;
        nArray[148] = 41;
        nArray[149] = 169;
        nArray[150] = 105;
        nArray[151] = 233;
        nArray[152] = 25;
        nArray[153] = 153;
        nArray[154] = 89;
        nArray[155] = 217;
        nArray[156] = 57;
        nArray[157] = 185;
        nArray[158] = 121;
        nArray[159] = 249;
        nArray[160] = 5;
        nArray[161] = 133;
        nArray[162] = 69;
        nArray[163] = 197;
        nArray[164] = 37;
        nArray[165] = 165;
        nArray[166] = 101;
        nArray[167] = 229;
        nArray[168] = 21;
        nArray[169] = 149;
        nArray[170] = 85;
        nArray[171] = 213;
        nArray[172] = 53;
        nArray[173] = 181;
        nArray[174] = 117;
        nArray[175] = 245;
        nArray[176] = 13;
        nArray[177] = 141;
        nArray[178] = 77;
        nArray[179] = 205;
        nArray[180] = 45;
        nArray[181] = 173;
        nArray[182] = 109;
        nArray[183] = 237;
        nArray[184] = 29;
        nArray[185] = 157;
        nArray[186] = 93;
        nArray[187] = 221;
        nArray[188] = 61;
        nArray[189] = 189;
        nArray[190] = 125;
        nArray[191] = 253;
        nArray[192] = 3;
        nArray[193] = 131;
        nArray[194] = 67;
        nArray[195] = 195;
        nArray[196] = 35;
        nArray[197] = 163;
        nArray[198] = 99;
        nArray[199] = 227;
        nArray[200] = 19;
        nArray[201] = 147;
        nArray[202] = 83;
        nArray[203] = 211;
        nArray[204] = 51;
        nArray[205] = 179;
        nArray[206] = 115;
        nArray[207] = 243;
        nArray[208] = 11;
        nArray[209] = 139;
        nArray[210] = 75;
        nArray[211] = 203;
        nArray[212] = 43;
        nArray[213] = 171;
        nArray[214] = 107;
        nArray[215] = 235;
        nArray[216] = 27;
        nArray[217] = 155;
        nArray[218] = 91;
        nArray[219] = 219;
        nArray[220] = 59;
        nArray[221] = 187;
        nArray[222] = 123;
        nArray[223] = 251;
        nArray[224] = 7;
        nArray[225] = 135;
        nArray[226] = 71;
        nArray[227] = 199;
        nArray[228] = 39;
        nArray[229] = 167;
        nArray[230] = 103;
        nArray[231] = 231;
        nArray[232] = 23;
        nArray[233] = 151;
        nArray[234] = 87;
        nArray[235] = 215;
        nArray[236] = 55;
        nArray[237] = 183;
        nArray[238] = 119;
        nArray[239] = 247;
        nArray[240] = 15;
        nArray[241] = 143;
        nArray[242] = 79;
        nArray[243] = 207;
        nArray[244] = 47;
        nArray[245] = 175;
        nArray[246] = 111;
        nArray[247] = 239;
        nArray[248] = 31;
        nArray[249] = 159;
        nArray[250] = 95;
        nArray[251] = 223;
        nArray[252] = 63;
        nArray[253] = 191;
        nArray[254] = 127;
        nArray[255] = 255;
        this.BitReverseTable256 = nArray;
        this.map = m;
        this.pixels = new int[61440];
        this.scanline = 0;
        this.pcycle = 0;
        this.renderer = new Renderer();
    }

    public Object[] getDebugInfo() {
        return new Object[]{this.pcycle, this.scanline, this.PPUSTATUS_vb, this.PPUSTATUS_so, this.PPUSTATUS_sz};
    }

    public void setpal(boolean pal) {
        this.finalscanline = pal ? 310 : 260;
        this.palregion = pal;
    }

    public boolean getSpriteSize() {
        return this.PPUCTRL_ss;
    }

    public void writeRegisters(int index, byte b) {
        this.OPEN_BUS = b;
        switch (index) {
            case 0: {
                this.t &= 0xFFFFF3FF;
                this.t |= (b & 3) << 10;
                this.PPUCTRL = b;
                this.PPUCTRL_bna = b & 3;
                this.PPUCTRL_vraminc = (b & 4) != 0;
                this.PPUCTRL_spta = (b & 8) != 0;
                this.PPUCTRL_bpta = (b & 0x10) != 0;
                this.PPUCTRL_ss = (b & 0x20) != 0;
                this.PPUCTRL_ms = (b & 0x40) != 0;
                boolean bl = this.PPUCTRL_genNmi = (b & 0x80) != 0;
                if (this.scanline == -1 && this.pcycle == 0) {
                    this.map.cpu.setNMI(false);
                    break;
                }
                this.map.cpu.setNMI(this.PPUCTRL_genNmi && this.PPUSTATUS_vb);
                break;
            }
            case 1: {
                this.PPUMASK = Byte.toUnsignedInt(b);
                this.PPUMASK_grey = (b & 1) != 0;
                this.PPUMASK_bl = (b & 2) != 0;
                this.leftmask_b = this.PPUMASK_bl ? 0 : 8;
                this.PPUMASK_sl = (b & 4) != 0;
                this.leftmask_s = this.PPUMASK_sl ? 0 : 8;
                this.PPUMASK_sb = (b & 8) != 0;
                this.PPUMASK_ss = (b & 0x10) != 0;
                this.render = this.PPUMASK_ss || this.PPUMASK_sb;
                this.PPUMASK_colorbits = (b & 0xE0) << 3;
                if (!this.PPUMASK_grey) break;
                this.PPUMASK_colorbits |= 0x800;
                break;
            }
            case 3: {
                this.OAMADDR = b;
                break;
            }
            case 4: {
                if (this.scanline >= 240 || !this.dorender()) {
                    if ((this.OAMADDR & 3) == 2) {
                        b = (byte)(b & 0xE3);
                    }
                    this.map.ppuwriteoam(Byte.toUnsignedInt(this.OAMADDR), b);
                    this.OAMADDR = (byte)(this.OAMADDR + 1);
                    break;
                }
                this.OAMADDR = (byte)(this.OAMADDR + 4);
                break;
            }
            case 5: {
                if (this.even) {
                    this.t &= 0xFFFFFFE0;
                    this.fineX = b & 7;
                    this.t |= Byte.toUnsignedInt(b) >> 3;
                    this.even = false;
                    break;
                }
                this.t &= 0xFFFF8FFF;
                this.t |= (Byte.toUnsignedInt(b) & 7) << 12;
                this.t &= 0xFFFFFC1F;
                this.t |= (Byte.toUnsignedInt(b) & 0xF8) << 2;
                this.even = true;
                break;
            }
            case 6: {
                if (this.even) {
                    this.t &= 0xC0FF;
                    this.t |= (Byte.toUnsignedInt(b) & 0x3F) << 8;
                    this.t &= 0x3FFF;
                    this.even = false;
                    break;
                }
                this.t &= 0x7F00;
                this.t |= Byte.toUnsignedInt(b);
                this.tv = this.v;
                this.v = this.t;
                if ((this.v & 0x1000) != 0 && (this.tv & 0x1000) == 0) {
                    this.map.scanlinecounter();
                }
                this.even = true;
                break;
            }
            case 7: {
                this.tv = this.v;
                this.map.ppuwrite(this.v & 0x3FFF, b);
                if (!this.dorender() || this.scanline > 240 && this.scanline <= 261) {
                    this.v += this.PPUCTRL_vraminc ? 32 : 1;
                } else if ((this.v & 0x7000) == 28672) {
                    int ys = this.v & 0x3E0;
                    this.v &= 0xFFF;
                    switch (ys) {
                        case 928: {
                            this.v ^= 0xBA0;
                            break;
                        }
                        case 992: {
                            this.v ^= 0x3E0;
                            break;
                        }
                        default: {
                            this.v += 32;
                            break;
                        }
                    }
                } else {
                    this.v += 4096;
                }
                if ((this.v & 0x1000) == 0 || (this.tv & 0x1000) != 0) break;
                this.map.scanlinecounter();
                break;
            }
            default: {
                System.out.println("Something went wrong in ppureg write");
            }
        }
    }

    public byte readRegister(int index) {
        int b = 0;
        this.tv = this.v;
        switch (index) {
            case 2: {
                b = (byte)(b | (this.PPUSTATUS_so ? 32 : 0));
                b = (byte)(b | (this.PPUSTATUS_sz ? 64 : 0));
                if (this.scanline != 241 || this.pcycle != 0) {
                    b = (byte)(b | (this.PPUSTATUS_vb ? 128 : 0));
                }
                if (this.scanline == 241 && (this.pcycle == 0 || this.pcycle == 1 || this.pcycle == 2)) {
                    this.map.cpu.nmi = false;
                }
                b = (byte)(b | this.OPEN_BUS & 0x1F);
                this.even = true;
                this.PPUSTATUS_vb = false;
                this.map.cpu.setNMI(false);
                this.OPEN_BUS = (byte)b;
                break;
            }
            case 4: {
                this.OPEN_BUS = this.map.ppureadoam(Byte.toUnsignedInt(this.OAMADDR));
                if (this.dorender() && this.pcycle <= 65 && this.scanline < 241) {
                    return -1;
                }
                return this.map.ppureadoam(Byte.toUnsignedInt(this.OAMADDR));
            }
            case 7: {
                if ((this.v & 0x3FFF) < 16128) {
                    b = this.PPUDATA_readbuffer;
                    this.PPUDATA_readbuffer = this.map.ppuread(this.v & 0x3FFF);
                } else {
                    this.PPUDATA_readbuffer = this.map.ppuread((this.v & 0x3FFF) - 4096);
                    b = this.map.ppuread(this.v & 0x3FFF);
                    b = (byte)(b & 0x3F);
                    b = (byte)(b | this.OPEN_BUS & 0xC0);
                }
                if (!this.dorender() || this.scanline > 240 && this.scanline <= 260) {
                    this.v += this.PPUCTRL_vraminc ? 32 : 1;
                } else {
                    this.incx();
                    this.incy();
                }
                if ((this.v & 0x1000) != 0 && (this.tv & 0x1000) == 0) {
                    this.map.scanlinecounter();
                }
                this.OPEN_BUS = (byte)b;
                break;
            }
            default: {
                System.out.println("Something broke in readreg");
                return this.OPEN_BUS;
            }
        }
        return this.OPEN_BUS;
    }

    public boolean dorender() {
        return this.render;
    }

    private void incx() {
        if ((this.v & 0x1F) == 31) {
            this.v &= 0xFFFFFFE0;
            this.v ^= 0x400;
        } else {
            ++this.v;
        }
    }

    private void incy() {
        if ((this.v & 0x7000) != 28672) {
            this.v += 4096;
        } else {
            this.v &= 0xFFFF8FFF;
            int y = (this.v & 0x3E0) >> 5;
            if (y == 29) {
                y = 0;
                this.v ^= 0x800;
            } else {
                y = y + 1 & 0x1F;
            }
            this.v = this.v & 0xFFFFFC1F | y << 5;
        }
    }

    public void getBG() {
        switch ((this.pcycle - 1) % 8) {
            case 0: {
                this.shiftreg16a = this.shiftreg16a << 8 | this.ptablemap1;
                this.shiftreg16b = this.shiftreg16b << 8 | this.ptablemap0;
                this.palettelatchold = this.palettelatchnew;
                this.palettelatchnew = this.atablebyte << 2;
                this.cyclepart = 0;
                this.nametablebyte = Byte.toUnsignedInt(this.map.ppureadNT(0x2000 | this.v & 0xFFF)) << 4;
                this.nametablebyte += this.PPUCTRL_bpta ? 4096 : 0;
                break;
            }
            case 1: {
                this.cyclepart = 1;
                break;
            }
            case 2: {
                int tempx = 0x23C0 | this.v & 0xC00 | this.v >> 4 & 0x38 | this.v >> 2 & 7;
                byte attbyte = this.map.ppureadAT(tempx);
                int sel = (this.v & 2) >> 1 | (this.v & 0x40) >> 5;
                this.atablebyte = (0xFF & attbyte) >> sel * 2 & 3;
                this.cyclepart = 2;
                break;
            }
            case 3: {
                this.nametablebyte += (this.v & 0x7000) >>> 12;
                this.ptablemap0 = Byte.toUnsignedInt(this.map.ppureadPT(this.nametablebyte));
                this.cyclepart = 3;
                break;
            }
            case 4: {
                this.cyclepart = 4;
                break;
            }
            case 5: {
                this.ptablemap1 = Byte.toUnsignedInt(this.map.ppureadPT(this.nametablebyte + 8));
                this.cyclepart = 5;
                break;
            }
            case 6: {
                this.cyclepart = 6;
                break;
            }
            case 7: {
                if (this.pcycle != 256) {
                    this.incx();
                } else {
                    this.incy();
                }
                this.cyclepart = 7;
            }
        }
    }

    public void doCycle() {
        if (this.pcycle > 339) {
            this.pcycle = 0;
            if (this.scanline == this.finalscanline) {
                this.scanline = -1;
                this.oddframe = !this.oddframe;
                this.doneFrame = true;
            } else {
                ++this.scanline;
            }
            if (this.scanline == -1) {
                this.PPUSTATUS_so = false;
                this.PPUSTATUS_sz = false;
            } else if (this.scanline == 241) {
                this.genFrame();
            }
            this.oldspritezero = this.spritezero;
            this.spritezero = false;
        } else {
            ++this.pcycle;
            if (this.scanline < 240) {
                this.render();
            }
        }
        this.prevrender = this.render;
    }

    void render() {
        int cycle = this.pcycle;
        if (cycle <= 256) {
            if (this.prevrender) {
                this.getBG();
            }
            if (this.scanline >= 0) {
                this.drawpixel();
                if ((this.pcycle & 1) == 0) {
                    this.spriteEvaluationNew();
                }
            } else if (this.pcycle == 1) {
                this.PPUSTATUS_vb = false;
                this.map.cpu.setNMI(false);
            }
        } else if (cycle == 257) {
            if (this.prevrender) {
                this.v &= 0xFFFFFBE0;
                this.v |= this.t & 0x41F;
            }
            this.oamBCounter = 0;
            this.numsprites = 0;
            this.spritec = 0;
        } else if (cycle <= 320) {
            if (this.prevrender) {
                this.OAMADDR = 0;
                if (this.scanline == -1 && cycle >= 280 && cycle <= 304) {
                    this.v = this.t;
                }
                if (cycle % 8 == 4) {
                    this.loadSprites();
                }
            }
        } else if (cycle <= 336) {
            if (this.prevrender) {
                this.getBG();
            }
        } else if (cycle == 339 || cycle == 337) {
            this.map.ppureadNT(this.v & 0xFFF);
            if (this.scanline == -1 && cycle == 339 && !this.oddframe && this.prevrender && !this.palregion) {
                this.pcycle = 340;
            }
        }
    }

    private void genFrame() {
        this.PPUSTATUS_vb = true;
        this.map.cpu.doNMI = this.PPUCTRL_genNmi;
        this.renderer.buildFrame(this.pixels);
        this.pixelnum = 0;
    }

    private void drawpixel() {
        if (this.render || (this.v & 0x3F00) != 16128) {
            int backgroundcolor = 0;
            int cycle = this.pcycle;
            int offset = 15 - (this.fineX + this.cyclepart);
            if (this.PPUMASK_sb && this.leftmask_b < cycle) {
                int bit = this.shiftreg16a >> offset - 1 & 2 | this.shiftreg16b >> offset & 1;
                if (NesSettings.RenderBackground && bit != 0) {
                    backgroundcolor = (offset >= 8 ? this.palettelatchold : this.palettelatchnew) | bit;
                }
            }
            if (this.PPUMASK_ss) {
                int i = 0;
                while (i < this.numsprites) {
                    int bit;
                    int off = 7 - (cycle - this.spriteco[i] - 1);
                    if (off >= 0 && off < 8 && (bit = (this.spritebm[i] >> off & 1) << 1 | this.spritebm[i] >> off + 8 & 1) != 0) {
                        if (this.oldspritezero && !this.PPUSTATUS_sz && i == 0 && this.PPUMASK_sb && backgroundcolor != 0 && this.leftmask_s < cycle && cycle < 256) {
                            this.PPUSTATUS_sz = true;
                        }
                        if (!NesSettings.RenderSprites || !this.spritepriority[i] && backgroundcolor != 0) break;
                        this.pixels[this.pixelnum++] = this.PPUMASK_colorbits | 0xFF & this.map.ppu_palette[16 + 4 * this.spritepalette[i] + bit];
                        return;
                    }
                    ++i;
                }
            }
            this.pixels[this.pixelnum++] = this.PPUMASK_colorbits | 0xFF & this.map.ppu_palette[backgroundcolor];
        } else {
            this.pixels[this.pixelnum++] = this.PPUMASK_colorbits | Byte.toUnsignedInt(this.map.ppuread(this.v));
        }
    }

    int pixelColor() {
        int backgroundcolor = 0;
        int cycle = this.pcycle;
        int offset = 15 - (this.fineX + this.cyclepart);
        if (this.PPUMASK_sb && this.leftmask_b < cycle) {
            int bit = this.shiftreg16a >> offset - 1 & 2 | this.shiftreg16b >> offset & 1;
            if (NesSettings.RenderBackground && bit != 0) {
                backgroundcolor = (offset >= 8 ? this.palettelatchold : this.palettelatchnew) | bit;
            }
        }
        if (this.numsprites > 0 && this.PPUMASK_ss) {
            int i = 0;
            while (i < this.numsprites) {
                int bit;
                int off = cycle - this.spriteco[i] - 1;
                if (off >= 0 && off < 8 && (bit = (this.spritebm[i] >> 7 - off & 1) << 1 | this.spritebm[i] >> 7 - off + 8 & 1) != 0) {
                    if (this.oldspritezero && !this.PPUSTATUS_sz && i == 0 && this.PPUMASK_sb && backgroundcolor != 0 && this.leftmask_s < cycle && cycle < 256) {
                        this.delayset = true;
                    }
                    if (!NesSettings.RenderSprites || !this.spritepriority[i] && backgroundcolor != 0) break;
                    return 0xFF & this.map.ppu_palette[16 + 4 * this.spritepalette[i] + bit];
                }
                ++i;
            }
        }
        return 0xFF & this.map.ppu_palette[backgroundcolor];
    }

    private int inrange(int y) {
        int x = this.scanline - y;
        if (x >= 0) {
            return x;
        }
        return 20;
    }

    void stage2() {
        if (this.n == 63) {
            this.n = 0;
            this.stage = 7;
            return;
        }
        ++this.n;
        if (this.oamBCounter < 8) {
            this.stage = 1;
        } else if (this.oamBCounter == 8) {
            this.m = 0;
            this.stage = 6;
        }
    }

    private void stage3() {
        int y = Byte.toUnsignedInt(this.map.ppureadoam(4 * this.n + this.m));
        if (this.PPUCTRL_ss ? this.inrange(y) < 16 : this.inrange(y) < 8) {
            if ((this.PPUMASK_ss || this.PPUMASK_sb) && y < 240) {
                this.PPUSTATUS_so = true;
            }
            if (this.m == 3) {
                ++this.n;
                this.m = 0;
            } else {
                ++this.m;
            }
        } else if (this.n == 63) {
            this.stage = 7;
            this.n = 0;
            this.m = 0;
        } else {
            ++this.n;
            this.m = this.m + 1 & 3;
        }
    }

    void clearSprites() {
        Arrays.fill(this.spriteco, 0);
        Arrays.fill(this.spritepriority, false);
        Arrays.fill(this.spritepalette, 0);
        Arrays.fill(this.spritebm, 0);
        this.numsprites = 0;
    }

    public void spriteEvaluationNew() {
        if (this.pcycle < 65) {
            if (this.pcycle == 2) {
                Arrays.fill(this.oambuffer, (byte)-1);
                this.stage = 1;
                this.m = 0;
                this.n = 0;
                this.oamBCounter = 0;
                this.spritec = 0;
            }
            return;
        }
        if (this.pcycle <= 256) {
            switch (this.stage) {
                case 1: {
                    int y = Byte.toUnsignedInt(this.map.ppu_oam[this.n * 4]);
                    this.oambuffer[4 * this.oamBCounter] = (byte)y;
                    if (this.PPUCTRL_ss ? this.inrange(y) < 16 : this.inrange(y) < 8) {
                        this.stage = 2;
                    } else {
                        this.oambuffer[4 * this.oamBCounter] = -1;
                        this.stage2();
                    }
                    return;
                }
                case 2: {
                    this.oambuffer[4 * this.oamBCounter + 1] = this.map.ppu_oam[4 * this.n + 1];
                    this.stage = 3;
                    return;
                }
                case 3: {
                    this.oambuffer[4 * this.oamBCounter + 2] = this.map.ppu_oam[4 * this.n + 2];
                    this.stage = 4;
                    return;
                }
                case 4: {
                    this.oambuffer[4 * this.oamBCounter + 3] = this.map.ppu_oam[4 * this.n + 3];
                    ++this.oamBCounter;
                    if (this.n == 0) {
                        this.spritezero = true;
                    }
                    this.stage2();
                    return;
                }
                case 5: {
                    return;
                }
                case 6: {
                    this.stage3();
                    return;
                }
                case 7: {
                    return;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: {
                    return;
                }
            }
        }
    }

    void loadSprites() {
        int tileindex;
        this.spriteco[this.spritec] = Byte.toUnsignedInt(this.oambuffer[4 * this.oamBCounter + 3]);
        byte attributes = this.oambuffer[4 * this.oamBCounter + 2];
        this.spritepalette[this.spritec] = attributes & 3;
        this.spritepriority[this.spritec] = (attributes & 0x20) <= 0;
        int y = this.inrange(Byte.toUnsignedInt(this.oambuffer[4 * this.oamBCounter]));
        if (this.PPUCTRL_ss) {
            int temp = Byte.toUnsignedInt(this.oambuffer[4 * this.oamBCounter + 1]);
            tileindex = (temp & 1) * 4096 + (temp & 0xFE) * 16;
            if (y >= 8) {
                tileindex += 16;
            }
        } else {
            tileindex = Byte.toUnsignedInt(this.oambuffer[4 * this.oamBCounter + 1]) << 4;
            tileindex += this.PPUCTRL_spta ? 4096 : 0;
        }
        if ((attributes & 0x80) != 0) {
            if (this.PPUCTRL_ss) {
                tileindex = y < 8 ? (tileindex += 16) : (tileindex -= 16);
                y %= 8;
            }
            tileindex += 7 - y;
        } else {
            tileindex += (y %= 8);
        }
        this.spritefetch = true;
        this.spritebm[this.spritec] = (attributes & 0x40) != 0 ? this.BitReverseTable256[Byte.toUnsignedInt(this.map.ppureadPT(tileindex))] << 8 | this.BitReverseTable256[Byte.toUnsignedInt(this.map.ppureadPT(tileindex + 8))] : Byte.toUnsignedInt(this.map.ppureadPT(tileindex)) << 8 | Byte.toUnsignedInt(this.map.ppureadPT(tileindex + 8));
        this.spritefetch = false;
        if (tileindex < 0) {
            tileindex *= -1;
        }
        if (this.scanline >= 0 && Byte.toUnsignedInt(this.oambuffer[4 * this.oamBCounter]) != 255) {
            ++this.numsprites;
        }
        ++this.spritec;
        ++this.oamBCounter;
    }
}

