/*
 * Decompiled with CFR 0.152.
 */
package core.video;

import java.util.Arrays;
import java.util.Scanner;

public class NesColors {
    private static final int[] defaultPalette = new int[]{0x606060, 599694, 1708477, 3410358, 6162818, 7932217, 7277577, 5316361, 2701065, 870409, 609801, 609047, 604762, 0, 0, 0, 0xB1B1B1, 1464567, 0x4433FF, 8200447, 11867608, 13311347, 12986658, 9785097, 6255113, 2665481, 629769, 626738, 620194, 592137, 0, 0, 0xFFFFFF, 6139391, 10323199, 14117631, 0xFF5DFF, 16737222, 16744784, 16753933, 13419529, 7663625, 5569564, 3405953, 4183295, 0x494949, 0, 0, 0xFFFFFF, 13167359, 14801151, 0xFFCCFF, 0xFFC6FF, 0xFFCBFB, 16766914, 0xFFE999, 15792518, 14090128, 12451759, 11796439, 0xB3FFFF, 0xBCBCBC, 0, 0};
    private static final int[] NTSCHardwareFBX = new int[]{0x6A6D6A, 4992, 1966218, 3735674, 0x550056, 5898264, 5181440, 3678464, 2175744, 15616, 16384, 14628, 11861, 0, 0, 0, 0xB9BCB9, 1593543, 4927715, 7545558, 9772969, 10299484, 9845760, 8016128, 5990144, 0x227700, 163330, 30277, 28298, 0, 0, 0, 0xFFFFFF, 6858495, 0x9299FF, 11568639, 14251517, 14907321, 15043944, 13607468, 11775756, 8110609, 5622343, 4639617, 4702661, 0x4A4D4A, 0, 0, 0xFFFFFF, 13429503, 0xDDDEFF, 15522559, 16308222, 16570101, 16636879, 16377781, 15855786, 14351017, 13238204, 12843991, 12908278, 12501438, 0, 0};
    private static final int[] nesClassicFBX = new int[]{6316383, 131, 1900949, 3410037, 5309790, 5636111, 4982528, 3613448, 2112011, 1002254, 1657878, 147998, 143700, 0, 0, 0, 0xA9AAA8, 1067967, 4657880, 6488266, 8913065, 9636678, 9055492, 7295494, 6058260, 1805586, 1676553, 1541192, 2124686, 0, 0, 0, 0xFBFBFB, 6724088, 9008377, 11229432, 13981679, 14573481, 14450521, 13083172, 10993155, 7722755, 6349647, 3987085, 5687756, 4276800, 0, 0, 0xFBFBFB, 12506362, 13223929, 14139130, 15251705, 16104165, 15977154, 14667175, 14278812, 13233054, 12643768, 11924679, 12184297, 0xABABAB, 0, 0};
    private static final int[] compositeDirectFBX = new int[]{0x656565, 4733, 1573006, 3539074, 5636189, 5898264, 5178624, 3676416, 1913088, 15616, 16640, 15127, 11861, 0, 0, 0, 0xAFAFAF, 1658568, 4665315, 7020503, 9640878, 10361438, 10039808, 8080128, 5990144, 2521600, 33280, 31294, 28298, 0, 0, 0, 0xFFFFFF, 6597119, 9341439, 11958015, 14708735, 15690948, 15761514, 14194732, 12170250, 8637196, 6018623, 4903294, 5097419, 0x4C4C4C, 0, 0, 0xFFFFFF, 13100543, 0xD9D9FF, 15323647, 16371455, 0xFFCCF1, 16766155, 16310193, 15592100, 14087332, 12974264, 12515027, 0xBFF1F1, 0xB9B9B9, 0, 0};
    private static final int[] sonypvmFBX = new int[]{6908771, 6004, 1966215, 3407987, 5636183, 6160403, 5446144, 3875840, 2371584, 408064, 16128, 15134, 13134, 0, 0, 0, 0xB9BBB3, 1332153, 5057754, 6758110, 9967772, 10298180, 10501632, 9262336, 6647040, 2914560, 33024, 32066, 30858, 0, 0, 0, 0xFFFFFF, 6924543, 9867775, 11700986, 15367674, 15956935, 15896153, 15117607, 14141445, 9494279, 6612284, 4579965, 4773337, 5132360, 0, 0, 0xFFFFFF, 13822719, 0xE2E2FF, 15325439, 16110335, 16308714, 16441017, 16378011, 15987340, 13892241, 12123304, 11467466, 13300723, 12501176, 0, 0};
    private static final int[] vc_3ds = new int[]{0x737373, 2168972, 173, 4325532, 9175155, 11337744, 0xA50000, 8062976, 4335872, 16896, 20992, 14608, 1587546, 0, 0, 0, 0xBDBDBD, 29679, 2177519, 8650999, 0xBD00BD, 15138906, 14559488, 13519368, 9204480, 37888, 44288, 37945, 33932, 0x101010, 0, 0, 0xFFFFFF, 3784191, 5936383, 10849535, 0xF77BFF, 16741301, 16741219, 16751673, 16235833, 8705552, 4906570, 5963676, 61406, 0x393939, 0, 0, 0xFFFFFF, 11397119, 13031167, 14077695, 0xFFC6FF, 16762590, 16760245, 16768685, 16770981, 15204261, 11401149, 11927502, 10289143, 0x8C8C8C, 0, 0};
    private static final int[] asq_reality_c = new int[]{0x6C6C6C, 9870, 168, 0x400094, 0x700070, 7864384, 0x700000, 6428160, 0x442400, 0x343400, 20480, 17476, 16480, 0, 0x101010, 0x101010, 0xBABABA, 2120924, 0x3838FF, 8397040, 0xC000C0, 13636724, 0xD02020, 11288596, 8147968, 5792768, 34816, 29800, 29852, 0x202020, 0x101010, 0x101010, 0xFFFFFF, 5021951, 0x8888FF, 12610815, 0xFF50FF, 16737464, 0xFF7878, 16750136, 14396160, 10668576, 4906058, 2935972, 1884906, 0x585858, 0x101010, 0x101010, 0xFFFFFF, 11588863, 0xC4C4FF, 15251711, 0xFFB0FF, 16759016, 0xFFC4C4, 16766120, 16771216, 15791268, 0xC0FFC0, 11334896, 10545407, 0xC2C2C2, 0x202020, 0x101010};
    private static final int[] av_famicom = new int[]{0x6B6A6B, 2705, 1376417, 3604622, 5832798, 6225936, 0x530000, 3478272, 1124096, 14080, 15360, 13325, 9556, 1, 1, 1, 0xBCBBBD, 1066720, 4530940, 7344106, 10357173, 11144533, 10430720, 8209920, 0x566600, 1735680, 34048, 31804, 27797, 1, 1, 1, 0xFFFFFF, 6793471, 9865215, 12546815, 15494143, 16607938, 16417375, 14588960, 12434691, 8705032, 5889601, 4708747, 5230046, 5065806, 1, 1, 0xFFFFFF, 13560575, 0xDFDDFF, 15586815, 16699903, 16765177, 16767187, 16703674, 16183470, 14809517, 13696704, 13172187, 0xC9F9F9, 0xC6C4C6, 1, 1};
    private static final int[] bmf_final_3 = new int[]{0x686868, 4761, 1706154, 5309082, 8257641, 9306140, 8258305, 5314560, 2045696, 85504, 23040, 20508, 16481, 0, 0, 0, 0xB9B9B9, 810199, 5256688, 8985056, 12258483, 13503585, 12593934, 9784577, 6385408, 2067200, 104460, 37707, 33179, 0, 0, 0, 0xFFFFFF, 6534399, 10195455, 13858815, 15690495, 16345280, 16350572, 15571757, 12434710, 8182300, 4974663, 3532177, 4184541, 0x606060, 0, 0, 0xFFFFFF, 11331583, 14011903, 15579903, 16298239, 16691436, 16629173, 16372366, 15264636, 12317570, 10090402, 9106896, 9630961, 0xBEBEBE, 0, 0};
    private static final int[] consumer = new int[]{0x666666, 7834, 919976, 4456595, 7405664, 8978717, 8786688, 6891776, 3751424, 281600, 20224, 18219, 13676, 0, 0, 0, 0xADADAD, 20721, 3880191, 8397544, 12263077, 14362958, 14106624, 11623936, 7567616, 2984704, 36616, 33888, 28085, 0, 0, 0, 0xFFFFFF, 4956415, 9078015, 13726463, 16739831, 16742814, 16748615, 16756234, 12896768, 8248339, 4317527, 2217392, 2473727, 0x4F4F4F, 0, 0, 0xFFFFFF, 11983103, 13684223, 15582975, 0xFFC4FC, 16763096, 16765620, 16768668, 15198612, 13300127, 11727803, 10874591, 10937855, 0xB8B8B8, 0, 0};
    private static final int[] dougeff = new int[]{0x787878, 0x181878, 3283340, 4984726, 6032192, 7078407, 5049860, 3937541, 2042626, 17664, 17677, 212252, 1523834, 328965, 328965, 328965, 0xADADAD, 0x3434E3, 5712606, 8336326, 13374653, 13566021, 13708053, 10572827, 6913293, 956932, 104725, 2466146, 2856911, 328965, 328965, 328965, 16119022, 7903998, 0x7878FF, 10119422, 16282852, 16606102, 16616291, 15906371, 12377653, 7917865, 2940506, 4318618, 5232113, 0x686868, 328965, 328965, 0xFCFCF7, 12240878, 13092847, 13944309, 16041719, 16173017, 15912646, 16114870, 14282148, 12836259, 10475680, 11263176, 11458524, 0xA6A6A6, 328965, 328965};
    private static final int[] drag3 = new int[]{0x4C4C4C, 1385, 133, 983166, 4325461, 6488086, 0x6B0000, 0x560000, 2823424, 9728, 11520, 10496, 6705, 0, 0, 0, 0x9C9C9C, 16322, 336614, 4983773, 9306792, 12257110, 12917504, 11155200, 7427072, 2779648, 29696, 28192, 23417, 0, 0, 0, 0xF7F7F7, 2398719, 6192127, 10905087, 15358975, 16736688, 16741462, 16748812, 13413888, 8701184, 4247334, 1296761, 636372, 0x323232, 0, 0, 0xF7F7F7, 10670591, 12174847, 14073087, 15907068, 16759515, 16761526, 16633496, 15129225, 13165453, 11397026, 10216900, 9952745, 0xA7A7A7, 0, 0};
    private static final int[] fceux = new int[]{0x747474, 2365580, 168, 4456604, 9175156, 11010064, 0xA40000, 8128512, 4205568, 17408, 20480, 15380, 1588316, 0, 0, 0, 0xBCBCBC, 28908, 2111724, 0x8000F0, 0xBC00BC, 14942296, 14166016, 13126668, 0x887000, 37888, 43008, 36920, 32904, 0, 0, 0, 0xFCFCFC, 3980540, 6067452, 0xCC88FC, 16021756, 16544948, 16544864, 16554040, 15776828, 8441872, 5037128, 5830808, 59608, 0x787878, 0, 0, 0xFCFCFC, 11068668, 12899580, 13945084, 0xFCC4FC, 16565464, 16563376, 16570536, 16573600, 14744736, 11071676, 11599052, 10288368, 0xC4C4C4, 0, 0};
    private static final int[] fceux_15 = new int[]{0x606060, 112, 1310848, 2883694, 4849742, 7077912, 5899010, 5314560, 3417088, 13312, 12800, 13344, 11384, 0, 131586, 131586, 0xC4C4C4, 22750, 3153916, 8328416, 11010224, 12584540, 12593934, 10895376, 7299328, 0x308000, 31744, 31804, 28292, 0x141414, 263172, 263172, 0xF0F0F0, 5024511, 7304181, 11563263, 14310143, 15753408, 16286573, 13668400, 13942832, 0x66D000, 2546970, 3065958, 3457726, 0x545454, 394758, 394758, 0xFFFFFF, 11983615, 13159167, 14336767, 15777535, 16563438, 16765108, 16767632, 15527058, 14481054, 12124066, 0xAEEABE, 0x9EEFEF, 0xBEBEBE, 526344, 526344};
    private static final int[] gameboy = new int[]{0x306030, 538632, 538632, 538632, 538632, 538632, 538632, 538632, 538632, 0x306030, 0x306030, 0x306030, 538632, 538632, 538632, 538632, 0x88A808, 0x306030, 0x306030, 0x306030, 0x306030, 0x306030, 0x306030, 0x306030, 0x306030, 0x306030, 0x306030, 0x306030, 0x306030, 538632, 538632, 538632, 12049425, 0x88A808, 0x88A808, 0x88A808, 0x88A808, 0x88A808, 0x88A808, 0x88A808, 0x88A808, 0x88A808, 0x88A808, 0x88A808, 0x88A808, 0x306030, 538632, 538632, 12049425, 12049425, 0x88A808, 0x88A808, 0x88A808, 0x88A808, 0x88A808, 12049425, 12049425, 12049425, 12049425, 12049425, 12049425, 0x88A808, 538632, 538632};
    private static final int[] grayscale = new int[]{0x666666, 0x333333, 0x333333, 0x353535, 0x353535, 0x353535, 0x333333, 0x2F2F2F, 0x333333, 0x3C3C3C, 0x454545, 0x434343, 0x3A3A3A, 0, 0, 0, 0xACACAC, 0x666666, 0x616161, 0x616161, 0x646464, 0x616161, 0x616161, 0x616161, 0x686868, 0x757575, 0x7C7C7C, 0x7A7A7A, 0x707070, 0, 0, 0, 0xFFFFFF, 0xACACAC, 0x9C9C9C, 0x999999, 0xA1A1A1, 0xA4A4A4, 0xA6A6A6, 0xACACAC, 0xB6B6B6, 0xC1C1C1, 0xC7C7C7, 0xC4C4C4, 0xBCBCBC, 0x4E4E4E, 0, 0, 0xFFFFFF, 0xDADADA, 0xD5D5D5, 0xD2D2D2, 0xD5D5D5, 0xD5D5D5, 0xD8D8D8, 0xDADADA, 0xE0E0E0, 0xE3E3E3, 0xE3E3E3, 0xE3E3E3, 0xE0E0E0, 0xB6B6B6, 0, 0};
    private static final int[] kizul = new int[]{0x5C5C5C, 5771, 2163096, 4522119, 6947170, 7274775, 0x600100, 4200704, 2044417, 17408, 19201, 17186, 14426, 0, 657930, 657930, 0xA1A1A1, 18896, 4203757, 7474654, 11076278, 11929170, 11083776, 8470273, 5988353, 752129, 296706, 98367, 30090, 657930, 657930, 657930, 0xEFEFEF, 4104447, 0x7C77FF, 11493118, 15291647, 16666293, 16475219, 14385169, 12100353, 6799363, 3658021, 1888116, 2673085, 0x484848, 657930, 657930, 0xEFEFEF, 11129340, 0xC1C1FF, 13940735, 15446783, 16231902, 16299956, 15319703, 14405772, 12443018, 11068572, 10282170, 10346714, 0xABABAB, 657930, 657930};
    private static final int[] nesticle = new int[]{0x7F7F7F, 255, 191, 4664255, 9896071, 11206691, 11211520, 9115392, 0x533000, 30720, 27392, 23296, 17240, 0, 0, 0, 0xBFBFBF, 30968, 22776, 7030783, 14352589, 15138907, 16267264, 15163155, 11501312, 47104, 43776, 43847, 35723, 0, 0, 0, 0xF8F8F8, 0x3FBFFF, 7047423, 9992440, 0xF878F8, 16275608, 16283736, 16753479, 16300032, 12122136, 6019927, 5830808, 60379, 0x787878, 0, 0, 0xFFFFFF, 11003903, 0xB8B8F8, 14203128, 0xF8B8F8, 16492483, 15782064, 16769963, 16505723, 14219384, 0xB8F8B8, 12122328, 65535, 0xF8D8F8, 0, 0};
    private static final int[] nestopia_rgb = new int[]{0x6D6D6D, 9362, 219, 7162331, 9568365, 11927661, 11936768, 9586944, 7162112, 2377984, 27940, 37376, 18761, 0, 0, 0, 0xB6B6B6, 28123, 18943, 9568511, 11927807, 16711826, 0xFF0000, 14380288, 9596160, 2396672, 37376, 46701, 37522, 0x242424, 0, 0, 0xFFFFFF, 7190271, 0x9292FF, 14380543, 0xFF00FF, 0xFF6DFF, 16749056, 16758272, 0xDBDB00, 7199488, 65280, 4849627, 65535, 0x494949, 0, 0, 0xFFFFFF, 11983871, 14399231, 0xFFB6FF, 0xFF92FF, 0xFFB6B6, 16767890, 0xFFFF49, 0xFFFF6D, 11992905, 9633645, 4849627, 9624575, 0x929292, 0, 0};
    private static final int[] nestopia_yuv = new int[]{0x666666, 10888, 1315495, 3866788, 6029438, 7209024, 7079680, 5643520, 0x333500, 804864, 20992, 20232, 16461, 0, 0, 0, 0xADADAD, 1400793, 4342015, 7677950, 10492620, 12000891, 11874592, 10046976, 7040256, 3704576, 889600, 36658, 31885, 0, 0, 0, 0xFFFFFF, 6598911, 9605375, 13006591, 15887103, 16740044, 16744816, 15375906, 12369408, 0x88D800, 6087728, 4579458, 4771294, 0x4F4F4F, 0, 0, 0xFFFFFF, 12640255, 13882111, 15255807, 16433919, 16762090, 0xFFCCC5, 16242853, 15000980, 13627286, 12448939, 11793356, 11922418, 0xB8B8B8, 0, 0};
    private static final int[] nintendulator_ntsc = new int[]{0x656565, 11163, 1117888, 4128956, 6684815, 8060997, 7930112, 6298624, 3553280, 544512, 23040, 22274, 17749, 0, 0, 0, 0xAEAEAE, 483829, 4078591, 8134143, 11472613, 13308803, 13117973, 10964224, 7303680, 3313920, 40704, 39722, 33944, 0, 0, 0, 0xFFFFFF, 5681663, 9341951, 0xCC6CFF, 0xFF5DFF, 16736980, 16742756, 16293126, 0xC0C300, 8512000, 5107990, 3206266, 3462634, 0x4E4E4E, 0, 0, 0xFFFFFF, 12247039, 13750527, 15451135, 0xFFBDFF, 0xFFBFEE, 16763072, 16570265, 15067012, 13431687, 11991456, 11204809, 11333367, 0xB7B7B7, 0, 0};
    private static final int[] rinao = new int[]{0x696969, 6861, 1115375, 5374168, 8650893, 10027043, 0x8B0000, 6165760, 1977088, 15360, 17152, 15884, 12154, 0, 0, 0, 0xBBBBBB, 21247, 4667391, 0x9922FF, 14162659, 15802462, 14692864, 11029760, 5793792, 425216, 34304, 32834, 28106, 0, 0, 0, 0xFFFFFF, 5484287, 10720255, 16088831, 0xFF76FF, 16743354, 16748081, 16754944, 11846656, 6478080, 2416920, 711837, 1821183, 0x505050, 0, 0, 0xFFFFFF, 0xCCF1FF, 15525631, 0xFFDEFF, 0xFFDAFF, 0xFFDDF5, 16770239, 16773013, 15989380, 13827984, 12189621, 0xAFFFEA, 11992319, 0xC8C8C8, 0, 0};
    private static final int[] rockman_9 = new int[]{0x707070, 168, 2103432, 4194456, 0x880070, 11010064, 0xA00000, 0x780800, 4204544, 16384, 20480, 14352, 1587288, 0, 0, 0, 0xB8B8B8, 28904, 2111720, 0x8000F0, 0xB800B8, 14680152, 14166016, 13125640, 0x887000, 36864, 43008, 36920, 32904, 0, 0, 0, 0xF8F8F8, 3717368, 5804280, 10520824, 15759608, 16281776, 16281696, 16291896, 15775800, 8441872, 0x48D848, 5830808, 3717368, 0x505050, 0, 0, 0xF8F8F8, 11067640, 12636408, 13682936, 16302328, 16302296, 16300208, 16308392, 16310432, 14743712, 11071672, 11598024, 10025200, 0x989898, 0, 0};
    private static final int[] rp2c04_0001 = new int[]{0xFFB6B6, 14380543, 0xFF0000, 0x9292FF, 37522, 2377984, 0x494949, 16711826, 0xFFFFFF, 0x6D6D6D, 16758272, 11927661, 9568365, 0xDBDB00, 7162112, 0xFFFFFF, 7190271, 0xDBB66D, 7152640, 7199488, 9624575, 14399231, 16767890, 18943, 16767744, 4849627, 0, 0x490000, 0xDBDBDB, 0x929292, 0xFF00FF, 9362, 109, 11983871, 0xFFB6FF, 65280, 65535, 18761, 46701, 11927807, 0, 9586944, 0xFF92FF, 11936768, 9568511, 219, 16749056, 0, 0, 2396672, 0xB6B6B6, 27940, 11992905, 7162331, 0xFFFF00, 14380288, 18688, 28123, 37376, 0x242424, 0xFFFF6D, 0xFF6DFF, 9596160, 9633645};
    private static final int[] rp2c04_0002 = new int[]{0, 16758272, 9596160, 11992905, 9633645, 0xFF6DFF, 37522, 11983871, 0xFF0000, 9568511, 0xFFFF6D, 0xFF92FF, 0xFFFFFF, 14380543, 9624575, 37376, 18688, 7190271, 11936768, 0xDBDBDB, 46701, 7199488, 0x490000, 0x9292FF, 0x494949, 0xFF00FF, 109, 4849627, 14399231, 7162112, 0, 7162331, 9568365, 16767890, 16749056, 0xFFB6FF, 28123, 7152640, 0xB6B6B6, 219, 11927807, 16767744, 0x6D6D6D, 2377984, 18943, 0, 0xDBDB00, 0xFFFFFF, 0xDBB66D, 0x242424, 65280, 14380288, 18761, 9362, 16711826, 2396672, 0, 65535, 9586944, 0xFFFF00, 0xFFB6B6, 11927661, 27940, 0x929292};
    private static final int[] rp2c04_0003 = new int[]{11927807, 0xFF6DFF, 9633645, 0xB6B6B6, 37376, 0xFFFFFF, 11983871, 2377984, 9362, 0, 16767890, 7162112, 16711826, 0xDBDBDB, 0xDBB66D, 9624575, 0x9292FF, 37522, 11927661, 18943, 2396672, 9596160, 14380288, 46701, 0x6D6D6D, 7162331, 0, 219, 0xFF0000, 11936768, 0xFF92FF, 0xFFB6B6, 14380543, 18688, 109, 0xFFFF00, 0x242424, 16758272, 16749056, 0xFFFFFF, 7199488, 9568365, 7190271, 0xFF00FF, 28123, 0x929292, 0, 7152640, 65535, 0x490000, 11992905, 0xFFB6FF, 9586944, 65280, 0xDBDB00, 0x494949, 27940, 0, 14399231, 0xFFFF6D, 9568511, 4849627, 16767744, 18761};
    private static final int[] rp2c04_0004 = new int[]{9596160, 7162331, 37522, 0xDBDB00, 0, 0xFFB6B6, 9362, 14380288, 0xB6B6B6, 7152640, 65280, 109, 16767890, 0xFFFF00, 37376, 11992905, 0xFF6DFF, 0x490000, 18943, 0xFF92FF, 0, 0x494949, 11936768, 16749056, 0xDBB66D, 46701, 0x9292FF, 2396672, 9568365, 0, 9633645, 7190271, 11927661, 27940, 9586944, 219, 9568511, 11927807, 0x6D6D6D, 16711826, 18761, 0xDBDBDB, 28123, 18688, 0x242424, 0xFFFF6D, 0x929292, 0xFF00FF, 0xFFB6FF, 0xFFFFFF, 7162112, 0xFF0000, 16767744, 4849627, 0xFFFFFF, 9624575, 0, 16758272, 14380543, 11983871, 7199488, 14399231, 65535, 2377984};
    private static final int[] terratec_cinergy = new int[]{0x535454, 1649, 786560, 2621553, 4653134, 4849670, 0x400000, 2624512, 991744, 11776, 12800, 10764, 8260, 0, 0, 0, 10395807, 212409, 3415256, 5901260, 8718505, 9373516, 9052160, 7158016, 5199360, 1272064, 29184, 27436, 24949, 0, 0, 0, 16185591, 4955129, 7896063, 10381055, 13393407, 14702780, 14904158, 13402653, 11706368, 7780352, 4965922, 3654499, 3653035, 0x3C3D3C, 0, 0, 0xF7F8F7, 11589112, 12830719, 13876991, 15186943, 15775974, 15909054, 15321505, 14669202, 13099149, 11855519, 11265721, 11199449, 0xAAABAA, 0, 0};
    private static final int[] trebor = new int[]{0x6C6C6C, 8340, 168, 3932312, 0x700070, 7274545, 0x640000, 5181696, 3086592, 1981440, 17408, 14647, 14671, 0, 0x101010, 0x101010, 0xBABABA, 2775254, 3945215, 8397040, 0xC000C0, 11801700, 12462090, 10373892, 6770944, 4415744, 30720, 29011, 27030, 0x101010, 0x101010, 0x101010, 0xFFFFFF, 6201599, 9208575, 12873983, 0xFF5CFF, 16736917, 0xFF8778, 16033089, 14137600, 9487380, 5427752, 2147986, 1620700, 0x585858, 0x101010, 0x101010, 0xFFFFFF, 13031679, 13945599, 15779071, 0xFFBCFF, 16761029, 16763070, 16767427, 16572560, 14871192, 13300384, 10545890, 10543866, 0xC2C2C2, 0x101010, 0x101010};
    private static final int[] vc_wii = new int[]{0x494949, 106, 589923, 2687065, 4325450, 0x490000, 0x420000, 2691328, 1582848, 12304, 12288, 10512, 73795, 0, 0, 0, 0x747174, 12420, 3211692, 4915604, 6553723, 7012409, 7020801, 5910272, 4344064, 1595649, 1071361, 88370, 84314, 0x101010, 0, 0, 0xADADAD, 4878774, 6576341, 8671462, 10768813, 11356548, 11887178, 9728306, 8090154, 5932545, 3706417, 3247706, 3772045, 0x383838, 0, 0, 0xB6B6B6, 9215413, 9277102, 10260156, 10913724, 11373981, 11441804, 10260348, 10264178, 9741948, 8693627, 8166788, 7575181, 0xDEDEDE, 0, 0};
    private static int[] custom = Arrays.copyOf(defaultPalette, defaultPalette.length);
    private static final double att = 0.7;
    public static int[][] col = NesColors.GetNESColors(defaultPalette);
    public static byte[][][] colbytes = NesColors.NESColorsToBytes(col);

    private NesColors() {
    }

    private static int[][] GetNESColors(int[] colorarray) {
        int i = 0;
        while (i < colorarray.length) {
            int n = i++;
            colorarray[n] = colorarray[n] | 0xFF000000;
        }
        int[][] colors = new int[16][colorarray.length];
        for (int j = 0; j < colorarray.length; ++j) {
            int col = colorarray[j];
            int r = NesColors.r(col);
            int b = NesColors.b(col);
            int g = NesColors.g(col);
            colors[0][j] = col;
            colors[1][j] = NesColors.compose_col(r, (double)g * 0.7, (double)b * 0.7);
            colors[2][j] = NesColors.compose_col((double)r * 0.7, g, (double)b * 0.7);
            colors[3][j] = NesColors.compose_col(r, g, (double)b * 0.7);
            colors[4][j] = NesColors.compose_col((double)r * 0.7, (double)g * 0.7, b);
            colors[5][j] = NesColors.compose_col(r, (double)g * 0.7, b);
            colors[6][j] = NesColors.compose_col((double)r * 0.7, g, b);
            colors[7][j] = NesColors.compose_col((double)r * 0.7, (double)g * 0.7, (double)b * 0.7);
            for (int i2 = 8; i2 < 16; ++i2) {
                for (int x = 0; x < colorarray.length; ++x) {
                    colors[i2][x] = colors[i2 - 8][x & 0x30];
                }
            }
        }
        return colors;
    }

    public static void updatePalette(String palettename) {
        switch (palettename) {
            case "ntscHardwareFBX": {
                col = NesColors.GetNESColors(NTSCHardwareFBX);
                colbytes = NesColors.NESColorsToBytes(col);
                break;
            }
            case "nesClassicFBX": {
                col = NesColors.GetNESColors(nesClassicFBX);
                colbytes = NesColors.NESColorsToBytes(col);
                break;
            }
            case "compositeDirectFBX": {
                col = NesColors.GetNESColors(compositeDirectFBX);
                colbytes = NesColors.NESColorsToBytes(col);
                break;
            }
            case "sonypvmFBX": {
                col = NesColors.GetNESColors(sonypvmFBX);
                colbytes = NesColors.NESColorsToBytes(col);
                break;
            }
            case "vc_3ds": {
                col = NesColors.GetNESColors(vc_3ds);
                colbytes = NesColors.NESColorsToBytes(col);
                break;
            }
            case "asq_reality_c": {
                col = NesColors.GetNESColors(asq_reality_c);
                colbytes = NesColors.NESColorsToBytes(col);
                break;
            }
            case "av_famicom": {
                col = NesColors.GetNESColors(av_famicom);
                colbytes = NesColors.NESColorsToBytes(col);
                break;
            }
            case "bmf_final_3": {
                col = NesColors.GetNESColors(bmf_final_3);
                colbytes = NesColors.NESColorsToBytes(col);
                break;
            }
            case "consumer": {
                col = NesColors.GetNESColors(consumer);
                colbytes = NesColors.NESColorsToBytes(col);
                break;
            }
            case "dougeff": {
                col = NesColors.GetNESColors(dougeff);
                colbytes = NesColors.NESColorsToBytes(col);
                break;
            }
            case "drag3": {
                col = NesColors.GetNESColors(drag3);
                colbytes = NesColors.NESColorsToBytes(col);
                break;
            }
            case "fceux": {
                col = NesColors.GetNESColors(fceux);
                colbytes = NesColors.NESColorsToBytes(col);
                break;
            }
            case "fceux_15": {
                col = NesColors.GetNESColors(fceux_15);
                colbytes = NesColors.NESColorsToBytes(col);
                break;
            }
            case "gameboy": {
                col = NesColors.GetNESColors(gameboy);
                colbytes = NesColors.NESColorsToBytes(col);
                break;
            }
            case "grayscale": {
                col = NesColors.GetNESColors(grayscale);
                colbytes = NesColors.NESColorsToBytes(col);
                break;
            }
            case "kizul": {
                col = NesColors.GetNESColors(kizul);
                colbytes = NesColors.NESColorsToBytes(col);
                break;
            }
            case "nesticle": {
                col = NesColors.GetNESColors(nesticle);
                colbytes = NesColors.NESColorsToBytes(col);
                break;
            }
            case "nestopia_rgb": {
                col = NesColors.GetNESColors(nestopia_rgb);
                colbytes = NesColors.NESColorsToBytes(col);
                break;
            }
            case "nestopia_yuv": {
                col = NesColors.GetNESColors(nestopia_yuv);
                colbytes = NesColors.NESColorsToBytes(col);
                break;
            }
            case "nintendulator_ntsc": {
                col = NesColors.GetNESColors(nintendulator_ntsc);
                colbytes = NesColors.NESColorsToBytes(col);
                break;
            }
            case "rinao": {
                col = NesColors.GetNESColors(rinao);
                colbytes = NesColors.NESColorsToBytes(col);
                break;
            }
            case "rockman_9": {
                col = NesColors.GetNESColors(rockman_9);
                colbytes = NesColors.NESColorsToBytes(col);
                break;
            }
            case "rp2c04_0001": {
                col = NesColors.GetNESColors(rp2c04_0001);
                colbytes = NesColors.NESColorsToBytes(col);
                break;
            }
            case "rp2c04_0002": {
                col = NesColors.GetNESColors(rp2c04_0002);
                colbytes = NesColors.NESColorsToBytes(col);
                break;
            }
            case "rp2c04_0003": {
                col = NesColors.GetNESColors(rp2c04_0003);
                colbytes = NesColors.NESColorsToBytes(col);
                break;
            }
            case "rp2c04_0004": {
                col = NesColors.GetNESColors(rp2c04_0004);
                colbytes = NesColors.NESColorsToBytes(col);
                break;
            }
            case "terratec_cinergy": {
                col = NesColors.GetNESColors(terratec_cinergy);
                colbytes = NesColors.NESColorsToBytes(col);
                break;
            }
            case "trebor": {
                col = NesColors.GetNESColors(trebor);
                colbytes = NesColors.NESColorsToBytes(col);
                break;
            }
            case "vc_wii": {
                col = NesColors.GetNESColors(vc_wii);
                colbytes = NesColors.NESColorsToBytes(col);
                break;
            }
            case "Custom": {
                col = NesColors.GetNESColors(custom);
                colbytes = NesColors.NESColorsToBytes(col);
                break;
            }
            default: {
                col = NesColors.GetNESColors(defaultPalette);
                colbytes = NesColors.NESColorsToBytes(col);
            }
        }
    }

    private static byte[][][] NESColorsToBytes(int[][] col) {
        byte[][][] colbytes = new byte[col.length][][];
        for (int i = 0; i < col.length; ++i) {
            int[] col2 = col[i];
            byte[][] colbytes2 = colbytes[i] = new byte[col2.length][3];
            for (int j = 0; j < col2.length; ++j) {
                colbytes2[j][0] = (byte)NesColors.b(col2[j]);
                colbytes2[j][1] = (byte)NesColors.g(col2[j]);
                colbytes2[j][2] = (byte)NesColors.r(col2[j]);
            }
        }
        return colbytes;
    }

    private static int r(int col) {
        return col >> 16 & 0xFF;
    }

    private static int g(int col) {
        return col >> 8 & 0xFF;
    }

    private static int b(int col) {
        return col & 0xFF;
    }

    private static int compose_col(double r, double g, double b) {
        return (((int)r & 0xFF) << 16) + (((int)g & 0xFF) << 8) + ((int)b & 0xFF) + -16777216;
    }

    public static String getCustomPalette() {
        String out = "";
        for (int i : custom) {
            out = out + i + " ";
        }
        return out;
    }

    public static void setCustomPalette(String palette) {
        if (palette.length() > 0) {
            Scanner s = new Scanner(palette);
            for (int i = 0; i < custom.length; ++i) {
                NesColors.custom[i] = s.nextInt();
            }
            s.close();
        }
    }

    public static void setCustomPalette(int[] pal) {
        for (int i = 0; i < custom.length; ++i) {
            NesColors.custom[i] = pal[i];
        }
    }

    public static int[] getpalette(String selectedPalette) {
        switch (selectedPalette) {
            case "ntscHardwareFBX": {
                return NTSCHardwareFBX;
            }
            case "nesClassicFBX": {
                return nesClassicFBX;
            }
            case "compositeDirectFBX": {
                return compositeDirectFBX;
            }
            case "sonypvmFBX": {
                return sonypvmFBX;
            }
            case "vc_3ds": {
                return vc_3ds;
            }
            case "asq_reality_c": {
                return asq_reality_c;
            }
            case "av_famicom": {
                return av_famicom;
            }
            case "bmf_final_3": {
                return bmf_final_3;
            }
            case "consumer": {
                return consumer;
            }
            case "dougeff": {
                return dougeff;
            }
            case "drag3": {
                return drag3;
            }
            case "fceux": {
                return fceux;
            }
            case "fceux_15": {
                return fceux_15;
            }
            case "gameboy": {
                return gameboy;
            }
            case "grayscale": {
                return grayscale;
            }
            case "kizul": {
                return kizul;
            }
            case "nesticle": {
                return nesticle;
            }
            case "nestopia_rgb": {
                return nestopia_rgb;
            }
            case "nestopia_yuv": {
                return nestopia_yuv;
            }
            case "nintendulator_ntsc": {
                return nintendulator_ntsc;
            }
            case "rinao": {
                return rinao;
            }
            case "rockman_9": {
                return rockman_9;
            }
            case "rp2c04_0001": {
                return rp2c04_0001;
            }
            case "rp2c04_0002": {
                return rp2c04_0002;
            }
            case "rp2c04_0003": {
                return rp2c04_0003;
            }
            case "rp2c04_0004": {
                return rp2c04_0004;
            }
            case "terratec_cinergy": {
                return terratec_cinergy;
            }
            case "trebor": {
                return trebor;
            }
            case "vc_wii": {
                return vc_wii;
            }
            case "Custom": {
                return custom;
            }
        }
        return defaultPalette;
    }
}

