/*
 * Decompiled with CFR 0.152.
 */
package core.video;

import core.NesSettings;
import core.video.NesColors;
import java.io.Serializable;

public class Renderer
implements Serializable {
    private static final long serialVersionUID = -6820858889740836382L;
    public int[] colorized = new int[61440];

    public void buildFrame(int[] pixels) {
        switch (NesSettings.RenderMethod) {
            case 1: {
                this.buildImageRGBnoEmp(pixels);
                break;
            }
            case 2: {
                this.buildImageRGBEmp(pixels);
                break;
            }
            case 3: {
                this.buildImageRawNes(pixels);
                break;
            }
        }
    }

    void buildImageRawNes(int[] pixels) {
        int i = 0;
        while (i < 61440) {
            this.colorized[i] = (pixels[i] & 0x700) >> 2 | ((pixels[i] & 0x800) != 0 ? pixels[i] & 0x30 : pixels[i] & 0xFF);
            ++i;
        }
    }

    void buildImageRGBnoEmp(int[] pixels) {
        int i = 0;
        while (i < 61440) {
            this.colorized[i] = NesColors.col[0][pixels[i] & NesColors.col[0].length - 1];
            ++i;
        }
    }

    void buildImageRGBEmp(int[] pixels) {
        int i = 0;
        while (i < 61440) {
            this.colorized[i] = NesColors.col[pixels[i] >> 8][pixels[i] & NesColors.col[0].length - 1];
            ++i;
        }
    }

    void buildImageNTSC(int[] pixels, int[] maskpixels) {
    }
}

