/*
 * Decompiled with CFR 0.152.
 */
package ui;

import core.NesSettings;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import ui.About;
import ui.DebugUI;
import ui.SystemUI;
import ui.UISettings;

public class MainUI
extends JFrame {
    SystemUI sys;

    public MainUI(SystemUI s) {
        this.setTitle("BassNES");
        this.sys = s;
        this.setDefaultCloseOperation(3);
        this.setBounds(100, 100, 256, 240);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e2) {
            e2.printStackTrace();
        }
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        menuBar.setPreferredSize(new Dimension(240, 25));
        JMenu mnSystem = new JMenu("System");
        mnSystem.setFont(new Font("Segoe UI", 0, 12));
        menuBar.add(mnSystem);
        AbstractAction startCPU = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!MainUI.this.sys.rom.equals(null)) {
                    if (MainUI.this.sys.nes != null) {
                        MainUI.this.sys.nes.exit();
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    MainUI.this.sys.createAndStart(MainUI.this.sys.rom);
                }
            }
        };
        AbstractAction loadRom = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainUI.this.sys.fc.setCurrentDirectory(new File(UISettings.lastLoadedDir));
                int returnval = MainUI.this.sys.fc.showOpenDialog(MainUI.this.sys.mainWindow);
                if (returnval == 0) {
                    MainUI.this.sys.rom = MainUI.this.sys.fc.getSelectedFile();
                    UISettings.lastLoadedDir = MainUI.this.sys.fc.getCurrentDirectory().getAbsolutePath();
                    if (UISettings.autoLoad) {
                        if (MainUI.this.sys.nes != null) {
                            MainUI.this.sys.nes.exit();
                        }
                        MainUI.this.sys.createAndStart(MainUI.this.sys.rom);
                    }
                }
            }
        };
        AbstractAction autoLoad = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UISettings.autoLoad = !UISettings.autoLoad;
            }
        };
        AbstractAction showFPS = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UISettings.ShowFPS = !UISettings.ShowFPS;
            }
        };
        AbstractAction saveState1 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MainUI.this.sys.saveState(1);
            }
        };
        AbstractAction saveState2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MainUI.this.sys.saveState(2);
            }
        };
        AbstractAction saveState3 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MainUI.this.sys.saveState(3);
            }
        };
        AbstractAction saveState4 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MainUI.this.sys.saveState(4);
            }
        };
        AbstractAction loadState1 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainUI.this.sys.restoreState(1);
            }
        };
        AbstractAction loadState2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainUI.this.sys.restoreState(2);
            }
        };
        AbstractAction loadState3 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainUI.this.sys.restoreState(3);
            }
        };
        AbstractAction loadState4 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainUI.this.sys.restoreState(4);
            }
        };
        this.rootPane.getInputMap(2).put(KeyStroke.getKeyStroke(49, 128), "saveState1");
        this.rootPane.getActionMap().put("saveState1", saveState1);
        this.rootPane.getInputMap(2).put(KeyStroke.getKeyStroke(49, 64), "loadState1");
        this.rootPane.getActionMap().put("loadState1", loadState1);
        this.rootPane.getInputMap(2).put(KeyStroke.getKeyStroke(50, 128), "saveState2");
        this.rootPane.getActionMap().put("saveState2", saveState2);
        this.rootPane.getInputMap(2).put(KeyStroke.getKeyStroke(50, 64), "loadState2");
        this.rootPane.getActionMap().put("loadState2", loadState2);
        this.rootPane.getInputMap(2).put(KeyStroke.getKeyStroke(51, 128), "saveState3");
        this.rootPane.getActionMap().put("saveState3", saveState3);
        this.rootPane.getInputMap(2).put(KeyStroke.getKeyStroke(51, 64), "loadState3");
        this.rootPane.getActionMap().put("loadState3", loadState3);
        this.rootPane.getInputMap(2).put(KeyStroke.getKeyStroke(52, 128), "saveState4");
        this.rootPane.getActionMap().put("saveState4", saveState4);
        this.rootPane.getInputMap(2).put(KeyStroke.getKeyStroke(52, 64), "loadState4");
        this.rootPane.getActionMap().put("loadState4", loadState4);
        this.rootPane.getInputMap(2).put(KeyStroke.getKeyStroke(83, 128), "startCPU");
        this.rootPane.getActionMap().put("startCPU", startCPU);
        JMenuItem mntmLoadRom = new JMenuItem("Load Rom");
        mntmLoadRom.addActionListener(loadRom);
        mnSystem.add(mntmLoadRom);
        JCheckBoxMenuItem chckbxmntmAutoload = new JCheckBoxMenuItem("AutoLoad");
        chckbxmntmAutoload.addActionListener(autoLoad);
        chckbxmntmAutoload.setSelected(UISettings.autoLoad);
        mnSystem.add(chckbxmntmAutoload);
        JCheckBoxMenuItem chckbxmntmShowFps = new JCheckBoxMenuItem("Show FPS");
        chckbxmntmShowFps.addActionListener(showFPS);
        chckbxmntmShowFps.setSelected(UISettings.ShowFPS);
        mnSystem.add(chckbxmntmShowFps);
        JMenu mnSaveState = new JMenu("Save State");
        mnSystem.add(mnSaveState);
        JMenuItem mntmState_4 = new JMenuItem("State 1");
        mnSaveState.add(mntmState_4);
        mntmState_4.addActionListener(saveState1);
        JMenuItem mntmState_5 = new JMenuItem("State 2");
        mnSaveState.add(mntmState_5);
        mntmState_5.addActionListener(saveState2);
        JMenuItem mntmState_6 = new JMenuItem("State 3");
        mnSaveState.add(mntmState_6);
        mntmState_6.addActionListener(saveState3);
        JMenuItem mntmState_7 = new JMenuItem("State 4");
        mnSaveState.add(mntmState_7);
        mntmState_7.addActionListener(saveState4);
        JMenu mnLoadState = new JMenu("Load State");
        mnSystem.add(mnLoadState);
        JMenuItem mntmState = new JMenuItem("State 1");
        mnLoadState.add(mntmState);
        mntmState.addActionListener(loadState1);
        JMenuItem mntmState_1 = new JMenuItem("State 2");
        mnLoadState.add(mntmState_1);
        mntmState_1.addActionListener(loadState2);
        JMenuItem mntmState_2 = new JMenuItem("State 3");
        mnLoadState.add(mntmState_2);
        mntmState_2.addActionListener(loadState3);
        JMenuItem mntmState_3 = new JMenuItem("State 4");
        mnLoadState.add(mntmState_3);
        mntmState_3.addActionListener(loadState4);
        JMenu mnCpu = new JMenu("CPU");
        mnCpu.setFont(new Font("Segoe UI", 0, 12));
        menuBar.add(mnCpu);
        JMenuItem mntmStartCpu = new JMenuItem("Start/Reset CPU");
        mntmStartCpu.addActionListener(startCPU);
        mnCpu.add(mntmStartCpu);
        JMenuItem mntmPauseCpu = new JMenuItem("Pause CPU");
        mntmPauseCpu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MainUI.this.sys.nes != null) {
                    MainUI.this.sys.nes.togglePause();
                }
            }
        });
        mnCpu.add(mntmPauseCpu);
        JMenu mnNewMenu = new JMenu("Audio");
        mnNewMenu.setFont(new Font("Segoe UI", 0, 12));
        menuBar.add(mnNewMenu);
        JCheckBoxMenuItem chckbxmntmEnableAudio = new JCheckBoxMenuItem("Enable Audio");
        UISettings.AudioEnabled = true;
        chckbxmntmEnableAudio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UISettings.AudioEnabled = !UISettings.AudioEnabled;
            }
        });
        chckbxmntmEnableAudio.setSelected(UISettings.AudioEnabled);
        mnNewMenu.add(chckbxmntmEnableAudio);
        JMenuItem mntmAudioMixer = new JMenuItem("Audio Settings");
        mntmAudioMixer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MainUI.this.sys.audiomixerWindow.setVisible(true);
            }
        });
        mnNewMenu.add(mntmAudioMixer);
        JMenuItem mntmShowOscillascope = new JMenuItem("Show Visualizer");
        mntmShowOscillascope.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MainUI.this.sys.showscope();
            }
        });
        mnNewMenu.add(mntmShowOscillascope);
        JMenu mnGraphics = new JMenu("Graphics");
        mnGraphics.setFont(new Font("Segoe UI", 0, 12));
        menuBar.add(mnGraphics);
        JMenu mnScaling = new JMenu("Scaling");
        mnGraphics.add(mnScaling);
        JRadioButtonMenuItem rdbtnmntmxScaling = new JRadioButtonMenuItem("1x Scaling");
        rdbtnmntmxScaling.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainUI.this.sys.display.updateScaling(1);
                MainUI.this.sys.mainWindow.getContentPane().setPreferredSize(new Dimension(256, 240));
                MainUI.this.sys.mainWindow.pack();
            }
        });
        ButtonGroup videoSizeGroup = new ButtonGroup();
        videoSizeGroup.add(rdbtnmntmxScaling);
        mnScaling.add(rdbtnmntmxScaling);
        JRadioButtonMenuItem rdbtnmntmxScaling_1 = new JRadioButtonMenuItem("2x Scaling");
        rdbtnmntmxScaling_1.setSelected(true);
        rdbtnmntmxScaling_1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainUI.this.sys.display.updateScaling(2);
                MainUI.this.sys.mainWindow.getContentPane().setPreferredSize(new Dimension(512, 480));
                MainUI.this.sys.mainWindow.pack();
            }
        });
        mnScaling.add(rdbtnmntmxScaling_1);
        videoSizeGroup.add(rdbtnmntmxScaling_1);
        JRadioButtonMenuItem rdbtnmntmxScaling_2 = new JRadioButtonMenuItem("3x Scaling");
        rdbtnmntmxScaling_2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainUI.this.sys.display.updateScaling(3);
                MainUI.this.sys.mainWindow.getContentPane().setPreferredSize(new Dimension(768, 720));
                MainUI.this.sys.mainWindow.pack();
            }
        });
        mnScaling.add(rdbtnmntmxScaling_2);
        videoSizeGroup.add(rdbtnmntmxScaling_2);
        JRadioButtonMenuItem rdbtnmntmxScaling_3 = new JRadioButtonMenuItem("4x Scaling");
        rdbtnmntmxScaling_3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainUI.this.sys.display.updateScaling(4);
                MainUI.this.sys.mainWindow.getContentPane().setPreferredSize(new Dimension(1024, 960));
                MainUI.this.sys.mainWindow.pack();
            }
        });
        mnScaling.add(rdbtnmntmxScaling_3);
        videoSizeGroup.add(rdbtnmntmxScaling_3);
        JMenuItem mntmMoreSettings = new JMenuItem("More Settings");
        mntmMoreSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainUI.this.sys.advancedGraphicsWindow.setVisible(true);
            }
        });
        JMenu mnVideoFilter = new JMenu("Video Filter");
        mnGraphics.add(mnVideoFilter);
        ButtonGroup videoFilterGroup = new ButtonGroup();
        JCheckBoxMenuItem chckbxmntmNone = new JCheckBoxMenuItem("None");
        chckbxmntmNone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MainUI.this.resetImage();
                UISettings.currentFilter = UISettings.VideoFilter.None;
            }
        });
        chckbxmntmNone.setSelected(true);
        mnVideoFilter.add(chckbxmntmNone);
        videoFilterGroup.add(chckbxmntmNone);
        JCheckBoxMenuItem chckbxmntmNtsc = new JCheckBoxMenuItem("NTSC");
        chckbxmntmNtsc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainUI.this.resetImage();
                MainUI.this.sys.display.updateImage(602, 240);
                NesSettings.RenderMethod = 3;
                UISettings.currentFilter = UISettings.VideoFilter.NTSC;
            }
        });
        mnVideoFilter.add(chckbxmntmNtsc);
        mnGraphics.add(mntmMoreSettings);
        videoFilterGroup.add(chckbxmntmNtsc);
        switch (UISettings.currentFilter) {
            case NTSC: {
                chckbxmntmNtsc.setSelected(true);
                break;
            }
            default: {
                chckbxmntmNone.setSelected(true);
            }
        }
        JCheckBoxMenuItem chckbxmntmScanlines = new JCheckBoxMenuItem("Scanlines");
        chckbxmntmScanlines.setSelected(UISettings.scanlinesEnabled);
        chckbxmntmScanlines.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UISettings.scanlinesEnabled = !UISettings.scanlinesEnabled;
            }
        });
        JSeparator separator = new JSeparator();
        mnVideoFilter.add(separator);
        mnVideoFilter.add(chckbxmntmScanlines);
        JMenu mnControl = new JMenu("Control");
        mnControl.setFont(new Font("Segoe UI", 0, 12));
        menuBar.add(mnControl);
        JMenuItem mntmConfigure = new JMenuItem("Configure");
        mntmConfigure.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainUI.this.sys.keyconfigWindow.setVisible(true);
            }
        });
        mnControl.add(mntmConfigure);
        JMenu mnDebug = new JMenu("Debug");
        mnDebug.setFont(new Font("Segoe UI", 0, 12));
        menuBar.add(mnDebug);
        JCheckBoxMenuItem chckbxmntmShowDebug = new JCheckBoxMenuItem("Show Debug");
        chckbxmntmShowDebug.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MainUI.this.sys.debugWindow == null) {
                    MainUI.this.sys.debugWindow = new DebugUI();
                }
                MainUI.this.sys.debugWindow.setVisible(!MainUI.this.sys.debugWindow.isVisible());
            }
        });
        mnDebug.add(chckbxmntmShowDebug);
        JMenuItem mntmDebugInfo = new JMenuItem("Debugger");
        mntmDebugInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainUI.this.sys.enterDebug();
            }
        });
        mnDebug.add(mntmDebugInfo);
        JMenu mnHelp = new JMenu("Help");
        menuBar.add(mnHelp);
        JMenuItem mntmReportABug = new JMenuItem("Report a Bug");
        mntmReportABug.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    MainUI.this.openWebpage(new URL("https://github.com/QuantumSoundings/BassNES/issues/new"));
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
        });
        mnHelp.add(mntmReportABug);
        JSeparator separator_1 = new JSeparator();
        mnHelp.add(separator_1);
        JMenuItem mntmAbout = new JMenuItem("About");
        mntmAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MainUI.this.sys.aboutWindow == null) {
                    MainUI.this.sys.aboutWindow = new About();
                }
                MainUI.this.sys.aboutWindow.setVisible(!MainUI.this.sys.aboutWindow.isVisible());
            }
        });
        mnHelp.add(mntmAbout);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                if (MainUI.this.sys.nes != null) {
                    MainUI.this.sys.nes.exit();
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                NesSettings.saveSettings(MainUI.this.sys.configuration);
                UISettings.saveSettings(MainUI.this.sys.configuration);
                System.exit(0);
            }
        });
    }

    private void resetImage() {
        this.sys.display.updateImage(256, 240);
        NesSettings.RenderMethod = 2;
    }

    private void openWebpage(URI uri) {
        Desktop desktop;
        Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
            try {
                desktop.browse(uri);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void openWebpage(URL url) {
        try {
            this.openWebpage(url.toURI());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }
}

