/*
 * Decompiled with CFR 0.152.
 */
package ui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import ui.UISettings;
import ui.filter.NesNtsc;

public class NesDisplay
extends JPanel {
    int scaling = 1;
    private static final long serialVersionUID = 1L;
    BufferedImage frame;
    private int width = 256;
    private int height = 240;
    NesNtsc ntsc = new NesNtsc();

    public NesDisplay(BufferedImage img) {
        if (UISettings.currentFilter == UISettings.VideoFilter.NTSC) {
            this.frame = new BufferedImage(602, 240, 1);
            this.width = 602;
            this.height = 240;
        } else {
            this.frame = new BufferedImage(256, 240, 1);
        }
    }

    public NesDisplay() {
        if (UISettings.currentFilter == UISettings.VideoFilter.NTSC) {
            this.frame = new BufferedImage(602, 240, 1);
            this.width = 602;
            this.height = 240;
            NesNtsc.restartNTSC();
        } else {
            this.frame = new BufferedImage(256, 240, 1);
        }
        this.frame.setAccelerationPriority(1.0f);
    }

    @Override
    public void paintComponent(Graphics g) {
        g.drawImage(this.frame, 0, 0, 256 * this.scaling, 240 * this.scaling, this);
        g.dispose();
    }

    public void updateScaling(int i) {
        this.scaling = i;
    }

    public void sendFrame(int[] pixels) {
        if (UISettings.currentFilter != UISettings.VideoFilter.None) {
            pixels = this.dofilter(pixels);
        }
        if (UISettings.scanlinesEnabled) {
            pixels = this.scanline(pixels);
        }
        this.frame.setRGB(0, 0, this.width, this.height, pixels, 0, this.width);
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(256, 240);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    private int[] dofilter(int[] pixels) {
        switch (UISettings.currentFilter) {
            case NTSC: {
                return this.ntsc(pixels);
            }
        }
        return pixels;
    }

    public void updateImage(int width, int height) {
        this.width = width;
        this.height = height;
        this.frame = new BufferedImage(width, height, 1);
    }

    private int[] ntsc(int[] pixels) {
        this.ntsc.filter(pixels, 0, 240);
        return this.ntsc.getImageData();
    }

    private int[] scanline(int[] pixels) {
        int i = 0;
        while (i < this.height) {
            if (i % 2 == 0) {
                int j = this.width * i;
                while (j < this.width * (i + 1)) {
                    pixels[j] = this.darkenpixel(pixels[j]);
                    ++j;
                }
            }
            ++i;
        }
        return pixels;
    }

    private int darkenpixel(int pixel) {
        int high = (int)((double)((pixel & 0xFF0000) >> 16) * UISettings.scanlineThickness) << 16;
        int mid = (int)((double)((pixel & 0xFF00) >> 8) * UISettings.scanlineThickness) << 8;
        int low = (int)((double)(pixel & 0xFF) * UISettings.scanlineThickness);
        return high | mid | low;
    }
}

