/*
 * Decompiled with CFR 0.152.
 */
package ui;

import core.NES;
import core.NESCallback;
import core.NesSettings;
import core.exceptions.UnSupportedMapperException;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.java.games.input.Keyboard;
import ui.AdvancedGraphics;
import ui.AudioInterface;
import ui.AudioSettingsUI;
import ui.ControlUI;
import ui.InputManager;
import ui.MainUI;
import ui.NesDisplay;
import ui.UISettings;
import ui.UpdateEventListener;
import ui.debugger.BreakPoint;
import ui.debugger.Debugger;

public class SystemUI
implements NESCallback {
    public NES nes;
    final JFileChooser fc;
    public JFrame mainWindow;
    public JFrame debugWindow;
    public JFrame keyconfigWindow;
    public JFrame audiomixerWindow;
    public JFrame advancedGraphicsWindow;
    public JFrame aboutWindow;
    public InputManager input;
    Debugger debugInfo;
    File rom;
    File configuration = new File("config.properties");
    NesDisplay display;
    public UpdateEventListener listener;
    private int[] pixels;
    private int[] audiobuffer;
    Thread current;
    Thread render;
    Properties prop;
    String testoutput;
    private AudioInterface audio;
    Keyboard key;
    boolean debugMode = false;
    boolean docpucycle = false;
    public boolean dobreakseek = false;

    static {
        try {
            System.loadLibrary("jinput-linux64");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
        try {
            System.loadLibrary("jinput-linux");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
    }

    public SystemUI() {
        this.input = new InputManager(this);
        try {
            NesSettings.loadSettings(this.configuration);
            UISettings.loadSettings(this.configuration);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
        this.fc = new JFileChooser();
        this.fc.setFileFilter(new FileNameExtensionFilter("Nes Files", "nes", "nsf", "nsfe", "NSFE", "NSFe", "NES", "NSF"));
        this.audio = new AudioInterface(this);
        this.debugInfo = new Debugger(this);
        this.rom = new File("gimmickj.nes");
        this.mainWindow = new MainUI(this);
        this.keyconfigWindow = new ControlUI(this.prop, this);
        this.audiomixerWindow = new AudioSettingsUI(this);
        this.advancedGraphicsWindow = new AdvancedGraphics(this);
        this.display = new NesDisplay();
        this.display.setSize(256, 240);
        this.display.updateScaling(2);
        this.listener = new UpdateEventListener(){

            @Override
            public void doVideoFrame() {
                SystemUI.this.display.sendFrame(SystemUI.this.pixels);
            }

            @Override
            public void doAudioFrame() {
                SystemUI.this.audio.setAudioFrame(SystemUI.this.audiobuffer);
            }
        };
        this.setupMainWindow();
        this.start();
    }

    public void start() {
        while (true) {
            if (this.debugMode) {
                if (this.nes != null) {
                    this.nes.pause();
                }
                if (this.docpucycle) {
                    this.nes.runCPUCycle();
                    this.debugInfo.updateInfo();
                    this.docpucycle = false;
                } else if (this.dobreakseek) {
                    BreakPoint.setsystem(this);
                    this.seekBreakpoint();
                    this.dobreakseek = false;
                }
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (UISettings.ShowFPS) {
                if (this.nes != null) {
                    this.mainWindow.setTitle("BassNES - FPS: " + String.format("%.2f", this.nes.getFPS()));
                }
            } else {
                this.mainWindow.setTitle("BassNES");
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void setupMainWindow() {
        this.mainWindow.setFocusable(true);
        this.mainWindow.requestFocusInWindow();
        this.mainWindow.add(this.display);
        this.mainWindow.setDefaultCloseOperation(0);
        this.mainWindow.setResizable(false);
        this.mainWindow.getContentPane().setPreferredSize(new Dimension(512, 480));
        this.mainWindow.pack();
        this.mainWindow.setVisible(true);
    }

    public void createNES(File rom) {
        this.nes = new NES(this);
        this.nes.setCallback(this);
        try {
            this.nes.loadRom(rom);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (UnSupportedMapperException e) {
            e.printStackTrace();
        }
        this.resetaudio();
    }

    public void createAndStart(File rom) {
        this.nes = new NES(this);
        try {
            this.nes.loadRom(rom);
            this.current = new Thread(this.nes);
            this.current.start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (UnSupportedMapperException e) {
            System.err.println("Failed to load rom.");
            System.err.println("Unsupported Mapper id: " + e.mapperid);
        }
        catch (Exception e) {
            System.err.println("Unexpected error has occured please report this bug.");
            e.printStackTrace();
        }
    }

    public void saveState(int slot) {
        this.nes.pause();
        try {
            this.nes.saveState("savestateY.txt".replaceAll("Y", String.valueOf(slot)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.nes.unpause();
    }

    public void restoreState(int slot) {
        this.nes.pause();
        try {
            this.nes.restoreState("savestateY.txt".replaceAll("Y", String.valueOf(slot)));
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
        this.nes.unpause();
    }

    @Override
    public boolean[][] pollController() {
        boolean[][] out = new boolean[2][8];
        if (this.mainWindow.hasFocus() || UISettings.controlwhilenotfocused) {
            return InputManager.currentFrameInputs;
        }
        return out;
    }

    @Override
    public void videoCallback(int[] p) {
        this.pixels = p;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SystemUI.this.listener.doVideoFrame();
                SystemUI.this.input.updateInputs();
            }
        });
    }

    @Override
    public void audioFrameCallback(int[] audioInts) {
        this.audio.setAudioFrame(audioInts);
    }

    @Override
    public void audioSampleCallback(int audiosample) {
        this.audio.outputSample(audiosample);
    }

    @Override
    public void unmixedAudioSampleCallback(int[] audiosample) {
    }

    public void resetaudio() {
        while (this.audio.inaudio) {
        }
        this.audio.lock = true;
        this.audio.restartSDL();
        this.audio.lock = false;
    }

    public Object[][] AudioChannelInfoCallback() {
        return this.nes.getAudioChannelInfo();
    }

    public void showscope() {
        this.audio.showscope();
    }

    public void enterDebug() {
        this.debugMode = true;
        this.debugInfo.setVisible(true);
        this.nes.pause();
        BreakPoint.setsystem(this);
        this.debugInfo.updateInfo();
    }

    public void exitDebug() {
        this.debugMode = false;
        this.nes.unpause();
    }

    public void seekBreakpoint() {
        boolean loop = true;
        while (loop) {
            BreakPoint.updateData();
            Object[] objectArray = this.debugInfo.breakpoints.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object point = objectArray[n2];
                if (((BreakPoint)point).checkbreakpoint()) {
                    loop = false;
                }
                ++n2;
            }
            this.nes.runCPUCycle();
        }
        this.debugInfo.updateInfo();
    }
}

