/*
 * Decompiled with CFR 0.152.
 */
package ui;

import core.NES;
import core.NesSettings;
import core.exceptions.UnSupportedMapperException;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import ui.SystemUI;
import ui.UISettings;

public class Tester {
    SystemUI sys;
    String output = "";
    int othererrors = 0;
    int totalroms = 0;
    int totalun = 0;
    int[] totalmappernumber = new int[256];
    int pass;
    int fail;
    int totalpass;
    int total;
    int regression;
    String testoutput;

    public Tester(SystemUI s) {
        this.sys = s;
    }

    public void testRomSet() {
        File[] files;
        this.sys.fc.setCurrentDirectory(new File(UISettings.lastLoadedDir));
        File folder = this.sys.fc.getCurrentDirectory();
        File[] fileArray = files = folder.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory()) {
                this.countRomsInDir(f);
            }
            ++n2;
        }
        System.out.println(this.output);
        System.out.println("Total Overall Roms: " + this.totalroms + " Overall Unsupported roms: " + this.totalun);
        System.out.println("Roms with Unexpected Errors: " + this.othererrors);
        int i = 0;
        while (i < 256) {
            if (this.totalmappernumber[i] > 0) {
                System.out.println("Found Mapper " + i + ": " + this.totalmappernumber[i] + " roms");
            }
            ++i;
        }
    }

    public void countRomsInDir(File dir) {
        File[] listofFiles = dir.listFiles();
        int total = 0;
        int unsupported = 0;
        int[] mappernumber = new int[256];
        File[] fileArray = listofFiles;
        int n = listofFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File rom = fileArray[n2];
            ++total;
            ++this.totalroms;
            try {
                this.sys.nes = new NES(this.sys);
                this.sys.nes.loadRom(rom);
            }
            catch (UnSupportedMapperException e) {
                ++unsupported;
                ++this.totalun;
                int n3 = e.mapperid;
                mappernumber[n3] = mappernumber[n3] + 1;
                int n4 = e.mapperid;
                this.totalmappernumber[n4] = this.totalmappernumber[n4] + 1;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                ++this.othererrors;
                System.err.println("Unexpected error has occured during rom loading please report this bug.");
                System.err.println("Rom location: " + rom.getAbsolutePath());
                e.printStackTrace();
            }
            ++n2;
        }
        this.output = String.valueOf(this.output) + "Dir: " + dir.getAbsolutePath() + " =======================================================================\n" + "\n";
        this.output = String.valueOf(this.output) + "Total roms: " + total + " Unsupported roms: " + unsupported + "\n";
        int i = 0;
        while (i < 256) {
            if (mappernumber[i] > 0) {
                this.output = String.valueOf(this.output) + "Found Mapper " + i + ": " + mappernumber[i] + " roms" + "\n";
            }
            ++i;
        }
    }

    void runTests() {
        try {
            this.runTests2();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    void runTests2() throws InterruptedException {
        Thread.sleep(500L);
        NesSettings.frameLimit = false;
        this.testoutput = "";
        boolean all = true;
        int speed = 2;
        if (all) {
            this.testoutput = " Blargg PPU Tests \n\n";
            this.testrom(5000, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/blarggppu/sprite_ram.nes"), -991011135);
            this.testrom(2000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/blarggppu/palette_ram.nes"), -991011135);
            this.testrom(2000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/blarggppu/power_up_palette.nes"), -991011135);
            this.testrom(2000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/blarggppu/vbl_clear_time.nes"), -991011135);
            this.testrom(2000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/blarggppu/vram_access.nes"), -991011135);
            this.testoutput = String.valueOf(this.testoutput) + "\n " + this.pass + "/" + (this.pass + this.fail) + " Passed\n";
            this.totalpass += this.pass;
            this.total += this.pass + this.fail;
            this.pass = 0;
            this.fail = 0;
        }
        if (all) {
            this.testoutput = String.valueOf(this.testoutput) + "\n Blargg CPU Tests \n\n";
            this.testrom(4000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/blarggcpu/01-basics.nes"), 898324673);
            this.testrom(3000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/blarggcpu/02-implied.nes"), 1454203073);
            this.testrom(3000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/blarggcpu/03-immediate.nes"), 1521555009);
            this.testrom(3000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/blarggcpu/04-zero_page.nes"), -806086527);
            this.testrom(7000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/blarggcpu/05-zp_xy.nes"), -502248511);
            this.testrom(3000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/blarggcpu/06-absolute.nes"), -1086829759);
            this.testrom(9000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/blarggcpu/07-abs_xy.nes"), -342091903);
            this.testrom(3000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/blarggcpu/08-ind_x.nes"), -1862521471);
            this.testrom(3000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/blarggcpu/09-ind_y.nes"), 316435457);
            this.testrom(2000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/blarggcpu/10-branches.nes"), 1739410241);
            this.testrom(5000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/blarggcpu/11-stack.nes"), 1998261697);
            this.testrom(3000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/blarggcpu/12-jmp_jsr.nes"), 836421185);
            this.testrom(2000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/blarggcpu/13-rts.nes"), 1585305601);
            this.testrom(2000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/blarggcpu/14-rti.nes"), 1973438849);
            this.testrom(2000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/blarggcpu/15-brk.nes"), 975250241);
            this.testrom(2000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/blarggcpu/16-special.nes"), -1709185727);
            this.testoutput = String.valueOf(this.testoutput) + "\n " + this.pass + "/" + (this.pass + this.fail) + " Passed\n";
            this.totalpass += this.pass;
            this.total += this.pass + this.fail;
            this.pass = 0;
            this.fail = 0;
        }
        if (all) {
            this.testoutput = String.valueOf(this.testoutput) + "\n Blargg All CPU Instructions Test\n\n";
            this.testrom(30000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/blarggcpu/all_inst.nes"), -1295142399);
            this.testoutput = String.valueOf(this.testoutput) + "\n " + this.pass + "/" + (this.pass + this.fail) + " Passed\n";
            this.totalpass += this.pass;
            this.total += this.pass + this.fail;
            this.pass = 0;
            this.fail = 0;
        }
        if (all) {
            this.testoutput = String.valueOf(this.testoutput) + "\n Blargg APU Tests \n\n";
            this.testrom(2000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/blarggapu/01.len_ctr.nes"), -991011135);
            this.testrom(2000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/blarggapu/02.len_table.nes"), -991011135);
            this.testrom(2000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/blarggapu/03.irq_flag.nes"), -991011135);
            this.testrom(2000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/blarggapu/04.clock_jitter.nes"), -991011135);
            this.testrom(2000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/blarggapu/05.len_timing_mode0.nes"), -991011135);
            this.testrom(2000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/blarggapu/06.len_timing_mode1.nes"), -991011135);
            this.testrom(2000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/blarggapu/07.irq_flag_timing.nes"), -991011135);
            this.testrom(2000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/blarggapu/08.irq_timing.nes"), -991011135);
            this.testrom(2000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/blarggapu/09.reset_timing.nes"), -991011135);
            this.testrom(2000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/blarggapu/10.len_halt_timing.nes"), -991011135);
            this.testrom(2000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/blarggapu/11.len_reload_timing.nes"), -991011135);
            this.testoutput = String.valueOf(this.testoutput) + "\n " + this.pass + "/" + (this.pass + this.fail) + " Passed\n";
            this.totalpass += this.pass;
            this.total += this.pass + this.fail;
            this.pass = 0;
            this.fail = 0;
        }
        this.testoutput = String.valueOf(this.testoutput) + "\n Various DMC Tests \n\n";
        this.testrom(2000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/dmc/dma_2007_read.nes"), 0);
        this.testrom(2000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/dmc/dma_2007_write.nes"), 41608769);
        this.testrom(2000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/dmc/dma_4016_read.nes"), 0);
        this.testrom(2000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/dmc/double_2007_read.nes"), 0);
        this.testrom(2000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/dmc/read_write_2007.nes"), 498004161);
        this.testrom(2000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/dmc/sprdma_and_dmc_dma.nes"), 0);
        this.testoutput = String.valueOf(this.testoutput) + "\n " + this.pass + "/" + (this.pass + this.fail) + " Passed\n";
        this.totalpass += this.pass;
        this.total += this.pass + this.fail;
        this.pass = 0;
        this.fail = 0;
        if (all) {
            this.testoutput = String.valueOf(this.testoutput) + "\n PPU_VBL_NMI Tests \n\n";
            this.testrom(5000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/ppu_vbl_nmi/01-vbl_basics.nes"), 1036527745);
            this.testrom(5000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/ppu_vbl_nmi/02-vbl_set_time.nes"), -236117247);
            this.testrom(5000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/ppu_vbl_nmi/03-vbl_clear_time.nes"), -2105808895);
            this.testrom(3000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/ppu_vbl_nmi/04-nmi_control.nes"), -441830719);
            this.testrom(5000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/ppu_vbl_nmi/05-nmi_timing.nes"), 1100088705);
            this.testrom(5000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/ppu_vbl_nmi/06-suppression.nes"), 2047057985);
            this.testrom(5000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/ppu_vbl_nmi/07-nmi_on_timing.nes"), -488676223);
            this.testrom(5000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/ppu_vbl_nmi/08-nmi_off_timing.nes"), -343529791);
            this.testrom(5000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/ppu_vbl_nmi/09-even_odd_frames.nes"), 2076043777);
            this.testrom(5000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/ppu_vbl_nmi/10-even_odd_timing.nes"), -698856319);
            this.testoutput = String.valueOf(this.testoutput) + "\n " + this.pass + "/" + (this.pass + this.fail) + " Passed\n";
            this.totalpass += this.pass;
            this.total += this.pass + this.fail;
            this.pass = 0;
            this.fail = 0;
        }
        if (all) {
            this.testoutput = String.valueOf(this.testoutput) + "\n Sprite Zero Hit Tests\n\n";
            this.testrom(3000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/sprite_hit/01-basics.nes"), 898324673);
            this.testrom(3000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/sprite_hit/02-alignment.nes"), -581511743);
            this.testrom(3000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/sprite_hit/03-corners.nes"), 1488564929);
            this.testrom(3000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/sprite_hit/04-flip.nes"), 1908589121);
            this.testrom(3000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/sprite_hit/05-left_clip.nes"), -1371701439);
            this.testrom(3000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/sprite_hit/06-right_edge.nes"), 1713394433);
            this.testrom(3000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/sprite_hit/07-screen_bottom.nes"), -884640127);
            this.testrom(3000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/sprite_hit/08-double_height.nes"), -1394642303);
            this.testrom(5000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/sprite_hit/09-timing.nes"), -1401514303);
            this.testrom(5000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/sprite_hit/10-timing_order.nes"), 1518391041);
            this.testoutput = String.valueOf(this.testoutput) + "\n " + this.pass + "/" + (this.pass + this.fail) + " Passed\n";
            this.totalpass += this.pass;
            this.total += this.pass + this.fail;
            this.pass = 0;
            this.fail = 0;
        }
        if (all) {
            this.testoutput = String.valueOf(this.testoutput) + "\n Sprite Overflow Tests\n\n";
            this.testrom(3000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/sprite_overflow/01-basics.nes"), 898324673);
            this.testrom(3000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/sprite_overflow/02-details.nes"), -1629941183);
            this.testrom(7000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/sprite_overflow/03-timing.nes"), -284309695);
            this.testrom(3000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/sprite_overflow/04-obscure.nes"), 1795452865);
            this.testrom(3000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/sprite_overflow/05-emulator.nes"), -1455436927);
            this.testoutput = String.valueOf(this.testoutput) + "\n " + this.pass + "/" + (this.pass + this.fail) + " Passed\n";
            this.totalpass += this.pass;
            this.total += this.pass + this.fail;
            this.pass = 0;
            this.fail = 0;
        }
        if (all) {
            this.testoutput = String.valueOf(this.testoutput) + "\n Instruction Misc Tests\n\n";
            this.testrom(3000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/instr_misc/01-abs_x_wrap.nes"), -1928374463);
            this.testrom(3000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/instr_misc/02-branch_wrap.nes"), 1758264129);
            this.testrom(3000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/instr_misc/03-dummy_reads.nes"), -868017919);
            this.testrom(7000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/instr_misc/04-dummy_reads_apu.nes"), -1866594495);
            this.testoutput = String.valueOf(this.testoutput) + "\n " + this.pass + "/" + (this.pass + this.fail) + " Passed\n";
            this.totalpass += this.pass;
            this.total += this.pass + this.fail;
            this.pass = 0;
            this.fail = 0;
        }
        if (all) {
            this.testoutput = String.valueOf(this.testoutput) + "\n CPU Interrupts\n\n";
            this.testrom(3000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/cpu_interrupts/1-cli_latency.nes"), -688698111);
            this.testrom(3000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/cpu_interrupts/2-nmi_and_brk.nes"), -1869123263);
            this.testrom(3000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/cpu_interrupts/3-nmi_and_irq.nes"), 1866557697);
            this.testrom(5000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/cpu_interrupts/4-irq_and_dma.nes"), 1806268353);
            this.testrom(7000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/cpu_interrupts/5-branch_delays_irq.nes"), 806032449);
            this.testoutput = String.valueOf(this.testoutput) + "\n " + this.pass + "/" + (this.pass + this.fail) + " Passed\n";
            this.totalpass += this.pass;
            this.total += this.pass + this.fail;
            this.pass = 0;
            this.fail = 0;
        }
        if (all) {
            this.testoutput = String.valueOf(this.testoutput) + "\n Instruction timing\n\n";
            this.testrom(23000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/1-instr_timing.nes"), 73520321);
            this.testrom(3000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/1-Branch_Basics.nes"), -947644927);
            this.testrom(3000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/2.Backward_Branch.nes"), 787820545);
            this.testrom(3000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/3.Forward_Branch.nes"), 1758476225);
            this.testoutput = String.valueOf(this.testoutput) + "\n " + this.pass + "/" + (this.pass + this.fail) + " Passed\n";
            this.totalpass += this.pass;
            this.total += this.pass + this.fail;
            this.pass = 0;
            this.fail = 0;
        }
        if (all) {
            this.testoutput = String.valueOf(this.testoutput) + "\n MMC3 Tests\n\n";
            this.testrom(3000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/mmc3_test/1-clocking.nes"), -1238792959);
            this.testrom(3000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/mmc3_test/2-details.nes"), -2075649855);
            this.testrom(3000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/mmc3_test/3-A12_clocking.nes"), -53768703);
            this.testrom(7000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/mmc3_test/4-scanline_timing.nes"), 1752656001);
            this.testrom(3000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/mmc3_test/5-MMC3.nes"), -83482111);
            this.testrom(3000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/mmc3_test/6-MMC3_alt.nes"), 0);
            this.testoutput = String.valueOf(this.testoutput) + "\n " + this.pass + "/" + (this.pass + this.fail) + " Passed\n";
            this.totalpass += this.pass;
            this.total += this.pass + this.fail;
            this.pass = 0;
            this.fail = 0;
        }
        if (all) {
            this.testoutput = String.valueOf(this.testoutput) + "\n OAM Tests\n\n";
            this.testrom(3000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/oam_read.nes"), -771118655);
            this.testrom(30000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/oam_stress.nes"), -461204351);
            this.testoutput = String.valueOf(this.testoutput) + "\n " + this.pass + "/" + (this.pass + this.fail) + " Passed\n";
            this.totalpass += this.pass;
            this.total += this.pass + this.fail;
            this.pass = 0;
            this.fail = 0;
        }
        if (all) {
            this.testoutput = String.valueOf(this.testoutput) + "\n PPU ReadBuffer Mega test\n\n";
            this.testrom(27000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/test_ppu_read_buffer.nes"), -1484609023);
            this.testoutput = String.valueOf(this.testoutput) + "\n " + this.pass + "/" + (this.pass + this.fail) + " Passed\n";
            this.totalpass += this.pass;
            this.total += this.pass + this.fail;
            this.pass = 0;
            this.fail = 0;
        }
        if (all) {
            this.testoutput = String.valueOf(this.testoutput) + "\n CPU Execution Space tests\n\n";
            this.testrom(3000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/execspace/test_cpu_exec_space_ppuio.nes"), -939378239);
            this.testrom(7000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/execspace/test_cpu_exec_space_apu.nes"), -627381823);
            this.testoutput = String.valueOf(this.testoutput) + "\n " + this.pass + "/" + (this.pass + this.fail) + " Passed\n";
            this.totalpass += this.pass;
            this.total += this.pass + this.fail;
            this.pass = 0;
            this.fail = 0;
        }
        if (all) {
            this.testoutput = String.valueOf(this.testoutput) + "\n CPU Dummy Write tests\n\n";
            this.testrom(8000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/dummywrites/cpu_dummy_writes_oam.nes"), 801265537);
            this.testrom(8000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/dummywrites/cpu_dummy_writes_ppumem.nes"), -2086578175);
            this.testoutput = String.valueOf(this.testoutput) + "\n " + this.pass + "/" + (this.pass + this.fail) + " Passed\n";
            this.totalpass += this.pass;
            this.total += this.pass + this.fail;
            this.pass = 0;
            this.fail = 0;
        }
        if (all) {
            this.testoutput = String.valueOf(this.testoutput) + "\n Holy Diver Batman tests\n\n";
            this.testrom(10000 / speed, new File(String.valueOf(System.getProperty("user.dir")) + "/tests/holydiver/M1_P128K.nes"), 0);
            this.testoutput = String.valueOf(this.testoutput) + "\n " + this.pass + "/" + (this.pass + this.fail) + " Passed\n";
            this.totalpass += this.pass;
            this.total += this.pass + this.fail;
            this.pass = 0;
            this.fail = 0;
        }
        if (this.sys.nes != null) {
            this.sys.nes.exit();
        }
        this.testoutput = String.valueOf(this.testoutput) + "\n\n Overall results: " + this.totalpass + "/" + this.total + " Passed     " + (this.regression > 0 ? String.valueOf(this.regression) + " Regressions" : "");
        System.out.println(this.testoutput);
        NesSettings.frameLimit = true;
    }

    void testrom(int delay, File r, int goodhash) throws InterruptedException {
        BufferedImage bi = new BufferedImage(this.sys.display.getWidth(), this.sys.display.getHeight(), 1);
        Graphics2D g = bi.createGraphics();
        this.sys.rom = r;
        int hash = 0;
        this.reset();
        this.startnes(delay);
        this.sys.display.paint(g);
        hash = this.getHash(bi);
        if (goodhash != 0 && hash != goodhash) {
            this.testoutput = String.valueOf(this.testoutput) + "Test: " + (hash == goodhash ? "PASS" : "FAIL") + " Name: " + this.sys.rom.getName() + " Hash: " + hash + "                 ****REGRESSION WARNING****\n";
            ++this.regression;
        } else {
            this.testoutput = String.valueOf(this.testoutput) + "Test: " + (hash == goodhash ? "PASS" : "FAIL") + " Name: " + this.sys.rom.getName() + " Hash: " + hash + "\n";
        }
        if (hash == goodhash) {
            ++this.pass;
        } else {
            ++this.fail;
        }
    }

    void reset() throws InterruptedException {
        if (this.sys.nes != null) {
            this.sys.nes.exit();
        }
        Thread.sleep(500L);
    }

    int getHash(BufferedImage bufferedImage) {
        int[] pixels = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
        return Arrays.hashCode(pixels);
    }

    void startnes(int delay) throws InterruptedException {
        this.sys.createNES(this.sys.rom);
        this.sys.current = new Thread(this.sys.nes);
        this.sys.current.start();
        Thread.sleep(delay);
    }
}

