/*
 * Decompiled with CFR 0.152.
 */
package ui.debugger;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import ui.SystemUI;
import ui.debugger.AddBreakPoint;
import ui.debugger.BreakPoint;
import ui.debugger.BreakPointPopup;

public class Debugger
extends JFrame {
    private static final long serialVersionUID = -4384773663935090830L;
    private JPanel contentPane;
    private JTextField pc;
    private JTextField a;
    private JTextField x;
    private JTextField y;
    private JTextField sp;
    private JCheckBox nflag;
    private JCheckBox vflag;
    private JCheckBox dflag;
    private JCheckBox iflag;
    private JCheckBox zflag;
    private JCheckBox cflag;
    private JCheckBox sprite0;
    private JCheckBox vb;
    private JCheckBox spriteover;
    private JCheckBox irqexternal;
    private JCheckBox irqframe;
    private JCheckBox irqdmc;
    private JCheckBox nmi;
    SystemUI sys;
    private JTextField inst;
    private JLabel lblInst;
    private JLabel lblPpuCycle;
    private JTextField ppucycle;
    private JLabel lblScanline;
    private JTextField ppuscanline;
    public JList<BreakPoint> breakpointui;
    public DefaultListModel<BreakPoint> breakpoints;
    private JButton btnAddBreak;

    public Debugger(SystemUI s) {
        this.sys = s;
        this.setDefaultCloseOperation(1);
        this.setBounds(100, 100, 611, 369);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(null);
        this.pc = new JTextField();
        this.pc.setEditable(false);
        this.pc.setBounds(45, 24, 32, 20);
        this.contentPane.add(this.pc);
        this.pc.setColumns(10);
        JLabel lblPc = new JLabel("PC");
        lblPc.setBounds(27, 26, 32, 14);
        this.contentPane.add(lblPc);
        this.a = new JTextField();
        this.a.setEditable(false);
        this.a.setBounds(45, 45, 32, 20);
        this.contentPane.add(this.a);
        this.a.setColumns(10);
        this.x = new JTextField();
        this.x.setEditable(false);
        this.x.setBounds(45, 64, 32, 20);
        this.contentPane.add(this.x);
        this.x.setColumns(10);
        this.y = new JTextField();
        this.y.setEditable(false);
        this.y.setBounds(45, 95, 32, 20);
        this.contentPane.add(this.y);
        this.y.setColumns(10);
        this.sp = new JTextField();
        this.sp.setEditable(false);
        this.sp.setBounds(45, 116, 32, 20);
        this.contentPane.add(this.sp);
        this.sp.setColumns(10);
        JLabel lblA = new JLabel("A");
        lblA.setBounds(27, 48, 32, 14);
        this.contentPane.add(lblA);
        JLabel lblX = new JLabel("X");
        lblX.setBounds(27, 73, 32, 14);
        this.contentPane.add(lblX);
        JLabel lblY = new JLabel("Y");
        lblY.setBounds(27, 98, 32, 14);
        this.contentPane.add(lblY);
        JLabel lblSp = new JLabel("SP");
        lblSp.setBounds(27, 119, 32, 14);
        this.contentPane.add(lblSp);
        this.nflag = new JCheckBox("Negative");
        this.nflag.setEnabled(false);
        this.nflag.setBounds(83, 23, 88, 23);
        this.contentPane.add(this.nflag);
        this.vflag = new JCheckBox("Overflow");
        this.vflag.setEnabled(false);
        this.vflag.setBounds(83, 44, 88, 23);
        this.contentPane.add(this.vflag);
        this.dflag = new JCheckBox("Decimal");
        this.dflag.setEnabled(false);
        this.dflag.setBounds(83, 63, 88, 23);
        this.contentPane.add(this.dflag);
        this.iflag = new JCheckBox("Interrupt");
        this.iflag.setEnabled(false);
        this.iflag.setBounds(173, 23, 82, 23);
        this.contentPane.add(this.iflag);
        this.zflag = new JCheckBox("Zero");
        this.zflag.setEnabled(false);
        this.zflag.setBounds(173, 44, 68, 23);
        this.contentPane.add(this.zflag);
        this.cflag = new JCheckBox("Carry");
        this.cflag.setEnabled(false);
        this.cflag.setBounds(173, 63, 68, 23);
        this.contentPane.add(this.cflag);
        JButton btnRunCycle = new JButton("Run Cycle");
        btnRunCycle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Debugger.this.sys.nes.runCPUCycle();
                Debugger.this.updateInfo();
            }
        });
        btnRunCycle.setBounds(10, 172, 102, 23);
        this.contentPane.add(btnRunCycle);
        this.inst = new JTextField();
        this.inst.setEditable(false);
        this.inst.setBounds(55, 141, 45, 20);
        this.contentPane.add(this.inst);
        this.inst.setColumns(10);
        this.lblInst = new JLabel("INST");
        this.lblInst.setBounds(27, 144, 32, 14);
        this.contentPane.add(this.lblInst);
        this.lblPpuCycle = new JLabel("PPU Cycle");
        this.lblPpuCycle.setBounds(136, 119, 68, 14);
        this.contentPane.add(this.lblPpuCycle);
        this.ppucycle = new JTextField();
        this.ppucycle.setEditable(false);
        this.ppucycle.setBounds(194, 116, 53, 20);
        this.contentPane.add(this.ppucycle);
        this.ppucycle.setColumns(10);
        this.lblScanline = new JLabel("Scanline");
        this.lblScanline.setBounds(136, 144, 59, 14);
        this.contentPane.add(this.lblScanline);
        this.ppuscanline = new JTextField();
        this.ppuscanline.setEditable(false);
        this.ppuscanline.setBounds(194, 141, 53, 20);
        this.contentPane.add(this.ppuscanline);
        this.ppuscanline.setColumns(10);
        JButton btnNewButton = new JButton("Seek Break");
        btnNewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Debugger.this.sys.dobreakseek = true;
            }
        });
        btnNewButton.setBounds(10, 204, 102, 23);
        this.contentPane.add(btnNewButton);
        this.sprite0 = new JCheckBox("Sprite 0");
        this.sprite0.setEnabled(false);
        this.sprite0.setBounds(253, 115, 75, 23);
        this.contentPane.add(this.sprite0);
        this.vb = new JCheckBox("Vertical Blank");
        this.vb.setEnabled(false);
        this.vb.setBounds(252, 140, 97, 23);
        this.contentPane.add(this.vb);
        this.spriteover = new JCheckBox("Sprite Overflow");
        this.spriteover.setEnabled(false);
        this.spriteover.setBounds(253, 166, 113, 23);
        this.contentPane.add(this.spriteover);
        JLabel lblInterrupts = new JLabel("Interrupts");
        lblInterrupts.setBounds(281, 11, 68, 14);
        this.contentPane.add(lblInterrupts);
        this.irqexternal = new JCheckBox("IRQ: External");
        this.irqexternal.setEnabled(false);
        this.irqexternal.setBounds(257, 23, 97, 23);
        this.contentPane.add(this.irqexternal);
        this.irqframe = new JCheckBox("IRQ: Frame");
        this.irqframe.setEnabled(false);
        this.irqframe.setBounds(257, 44, 97, 23);
        this.contentPane.add(this.irqframe);
        this.irqdmc = new JCheckBox("IRQ: DMC");
        this.irqdmc.setEnabled(false);
        this.irqdmc.setBounds(257, 63, 97, 23);
        this.contentPane.add(this.irqdmc);
        this.nmi = new JCheckBox("NMI");
        this.nmi.setEnabled(false);
        this.nmi.setBounds(258, 84, 59, 20);
        this.contentPane.add(this.nmi);
        this.breakpoints = new DefaultListModel();
        this.breakpointui = new JList<BreakPoint>(this.breakpoints);
        this.breakpointui.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent arg0) {
                if (arg0.isPopupTrigger()) {
                    this.doPop(arg0);
                }
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
                if (arg0.isPopupTrigger()) {
                    this.doPop(arg0);
                }
            }

            private void doPop(MouseEvent e) {
                if (Debugger.this.breakpointui.getSelectedValue() != null) {
                    BreakPointPopup menu = new BreakPointPopup(Debugger.this.breakpointui.getSelectedValue());
                    menu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        this.breakpointui.setBounds(172, 190, 295, 113);
        this.contentPane.add(this.breakpointui);
        this.btnAddBreak = new JButton("Add Break");
        this.btnAddBreak.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AddBreakPoint window = new AddBreakPoint(Debugger.this.breakpoints);
                window.setVisible(true);
            }
        });
        this.btnAddBreak.setBounds(378, 305, 89, 23);
        this.contentPane.add(this.btnAddBreak);
        this.setVisible(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                Debugger.this.sys.exitDebug();
            }
        });
    }

    public void updateInfo() {
        Object[] vars = this.sys.nes.getCPUDebugInfo();
        this.pc.setText(Integer.toHexString((Integer)vars[0]));
        this.a.setText(Integer.toHexString((Integer)vars[4]));
        this.x.setText(Integer.toHexString((Integer)vars[5]));
        this.y.setText(Integer.toHexString((Integer)vars[6]));
        this.sp.setText(Integer.toHexString((Integer)vars[3]));
        this.inst.setText((String)vars[1] + ": " + (Integer)vars[2]);
        this.nflag.setSelected((Boolean)vars[7]);
        this.vflag.setSelected((Boolean)vars[8]);
        this.dflag.setSelected((Boolean)vars[9]);
        this.iflag.setSelected((Boolean)vars[10]);
        this.zflag.setSelected((Boolean)vars[11]);
        this.cflag.setSelected((Boolean)vars[12]);
        this.irqexternal.setSelected(((boolean[])vars[13])[0]);
        this.irqframe.setSelected(((boolean[])vars[13])[1]);
        this.irqdmc.setSelected(((boolean[])vars[13])[2]);
        Object[] ppuvars = this.sys.nes.getPPUDebugInfo();
        this.ppuscanline.setText((Integer)ppuvars[1] + "");
        this.ppucycle.setText((Integer)ppuvars[0] + "");
        this.vb.setSelected((Boolean)ppuvars[2]);
        this.spriteover.setSelected((Boolean)ppuvars[3]);
        this.sprite0.setSelected((Boolean)ppuvars[4]);
    }
}

