/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.video.NesColors;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class NesSettings {
    static Properties prop;
    public static boolean politeFrameTiming;
    public static boolean frameLimit;
    public static boolean RenderBackground;
    public static boolean RenderSprites;
    public static int RenderMethod;
    public static String selectedPalette;
    public static final String[] palettes;
    public static int masterMixLevel;
    public static int pulse1MixLevel;
    public static int pulse2MixLevel;
    public static int triangleMixLevel;
    public static int noiseMixLevel;
    public static int dmcMixLevel;
    public static int vrc6MixLevel;
    public static int namcoMixLevel;
    public static int mmc5MixLevel;
    public static int sunsoft5BMixLevel;
    public static int sampleRate;
    public static int audioBufferSize;
    public static int pulse1Panning;
    public static int pulse2Panning;
    public static int trianglePanning;
    public static int noisePanning;
    public static int dmcPanning;
    public static int vrc6Panning;
    public static int namcoPanning;
    public static int mmc5Panning;
    public static int sunsoft5BPanning;
    public static boolean highQualitySampling;
    public static int nsfPlayerSongLength;

    static {
        politeFrameTiming = true;
        frameLimit = true;
        RenderBackground = true;
        RenderSprites = true;
        RenderMethod = 2;
        selectedPalette = "defaultPalette";
        palettes = new String[]{"defaultPalette", "Custom", "ntscHardwareFBX", "nesClassicFBX", "compositeDirectFBX", "sonypvmFBX", "vc_3ds", "asq_reality_c", "av_famicom", "bmf_final_3", "consumer", "dougeff", "drag3", "fceux", "fceux_15", "gameboy", "grayscale", "kizul", "nesticle", "nestopia_rgb", "nestopia_yuv", "nintendulator_ntsc", "rinao", "rockman_9", "rp2c04_0001", "rp2c04_0002", "rp2c04_0003", "rp2c04_0004", "terratec_cinergy", "trebor", "vc_wii"};
        masterMixLevel = 100;
        pulse1MixLevel = 100;
        pulse2MixLevel = 100;
        triangleMixLevel = 100;
        noiseMixLevel = 100;
        dmcMixLevel = 100;
        vrc6MixLevel = 100;
        namcoMixLevel = 100;
        mmc5MixLevel = 100;
        sunsoft5BMixLevel = 100;
        sampleRate = 44100;
        audioBufferSize = 20;
        pulse1Panning = 0;
        pulse2Panning = 0;
        trianglePanning = 0;
        noisePanning = 0;
        dmcPanning = 0;
        vrc6Panning = 0;
        namcoPanning = 0;
        mmc5Panning = 0;
        sunsoft5BPanning = 0;
        highQualitySampling = false;
        nsfPlayerSongLength = 7200;
    }

    public static void saveSettings(File config) {
        try {
            FileOutputStream output = new FileOutputStream(config);
            NesSettings.saveAudio();
            NesSettings.saveGraphics();
            NesSettings.saveEmulation();
            prop.store(output, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void loadSettings(File config) throws IOException {
        prop = new Properties();
        if (config.exists()) {
            FileInputStream input = new FileInputStream(config);
            prop.load(input);
            NesSettings.loadAudio();
            NesSettings.loadGraphics();
            NesSettings.loadEmulation();
        }
    }

    private static void loadAudio() {
        masterMixLevel = Integer.parseInt(prop.getProperty("mastermixlevel", "100"));
        pulse1MixLevel = Integer.parseInt(prop.getProperty("pulse1mixlevel", "100"));
        pulse2MixLevel = Integer.parseInt(prop.getProperty("pulse2mixlevel", "100"));
        triangleMixLevel = Integer.parseInt(prop.getProperty("trianglemixlevel", "100"));
        noiseMixLevel = Integer.parseInt(prop.getProperty("noisemixlevel", "100"));
        dmcMixLevel = Integer.parseInt(prop.getProperty("dmcmixlevel", "100"));
        vrc6MixLevel = Integer.parseInt(prop.getProperty("vrc6mixlevel", "100"));
        namcoMixLevel = Integer.parseInt(prop.getProperty("namcomixlevel", "100"));
        mmc5MixLevel = Integer.parseInt(prop.getProperty("mmc5mixlevel", "100"));
        sunsoft5BMixLevel = Integer.parseInt(prop.getProperty("sunsoft5bmixlevel", "100"));
        pulse1Panning = Integer.parseInt(prop.getProperty("pulse1panning", "0"));
        pulse2Panning = Integer.parseInt(prop.getProperty("pulse2panning", "0"));
        trianglePanning = Integer.parseInt(prop.getProperty("trianglepanning", "0"));
        noisePanning = Integer.parseInt(prop.getProperty("noisepanning", "0"));
        dmcPanning = Integer.parseInt(prop.getProperty("dmcpanning", "0"));
        vrc6Panning = Integer.parseInt(prop.getProperty("vrc6panning", "1"));
        mmc5Panning = Integer.parseInt(prop.getProperty("mmc5panning", "0"));
        namcoPanning = Integer.parseInt(prop.getProperty("namcopanning", "0"));
        sunsoft5BPanning = Integer.parseInt(prop.getProperty("sunsoft5bpanning", "0"));
        audioBufferSize = Integer.parseInt(prop.getProperty("audiobuffersize", "20"));
        sampleRate = Integer.parseInt(prop.getProperty("samplerate", "44100"));
        highQualitySampling = prop.getProperty("highqualitysampling", "true").equals("true");
        nsfPlayerSongLength = Integer.parseInt(prop.getProperty("nsfplayersonglength", "7200"));
    }

    private static void saveAudio() {
        prop.setProperty("mastermixlevel", String.valueOf(masterMixLevel));
        prop.setProperty("pulse1mixlevel", String.valueOf(pulse1MixLevel));
        prop.setProperty("pulse2mixlevel", String.valueOf(pulse2MixLevel));
        prop.setProperty("trianglemixlevel", String.valueOf(triangleMixLevel));
        prop.setProperty("noisemixlevel", String.valueOf(noiseMixLevel));
        prop.setProperty("dmcmixlevel", String.valueOf(dmcMixLevel));
        prop.setProperty("vrc6mixlevel", String.valueOf(vrc6MixLevel));
        prop.setProperty("namcomixlevel", String.valueOf(namcoMixLevel));
        prop.setProperty("mmc5mixlevel", String.valueOf(mmc5MixLevel));
        prop.setProperty("sunsoft5bmixlevel", String.valueOf(sunsoft5BMixLevel));
        prop.setProperty("pulse1panning", String.valueOf(pulse1Panning));
        prop.setProperty("pulse2panning", String.valueOf(pulse2Panning));
        prop.setProperty("trianglepanning", String.valueOf(trianglePanning));
        prop.setProperty("noisepanning", String.valueOf(noisePanning));
        prop.setProperty("dmcpanning", String.valueOf(dmcPanning));
        prop.setProperty("vrc6panning", String.valueOf(vrc6Panning));
        prop.setProperty("mmc5panning", String.valueOf(mmc5Panning));
        prop.setProperty("namcopanning", String.valueOf(namcoPanning));
        prop.setProperty("sunsoft5bpanning", String.valueOf(sunsoft5BPanning));
        prop.setProperty("audiobuffersize", String.valueOf(audioBufferSize));
        prop.setProperty("samplerate", String.valueOf(sampleRate));
        prop.setProperty("highqualitysampling", String.valueOf(highQualitySampling));
        prop.setProperty("nsfplayersonglength", String.valueOf(nsfPlayerSongLength));
    }

    private static void loadGraphics() {
        RenderBackground = prop.getProperty("renderbackground", "true").equals("true");
        RenderSprites = prop.getProperty("rendersprites", "true").equals("true");
        RenderMethod = Integer.parseInt(prop.getProperty("rendermethod", "2"));
        selectedPalette = prop.getProperty("selectedpalette", "defaultPalette");
        NesColors.setCustomPalette(prop.getProperty("custompalette", ""));
        NesColors.updatePalette(selectedPalette);
    }

    private static void saveGraphics() {
        prop.setProperty("renderbackground", String.valueOf(RenderBackground));
        prop.setProperty("rendersprites", String.valueOf(RenderSprites));
        prop.setProperty("rendermethod", String.valueOf(RenderMethod));
        prop.setProperty("selectedpalette", selectedPalette);
        prop.setProperty("custompalette", NesColors.getCustomPalette());
    }

    private static void loadEmulation() {
        politeFrameTiming = prop.getProperty("politeframetiming", "true").equals("true");
        frameLimit = prop.getProperty("framelimit", "true").equals("true");
    }

    private static void saveEmulation() {
        prop.setProperty("politeframetiming", String.valueOf(politeFrameTiming));
        prop.setProperty("framelimit", String.valueOf(frameLimit));
    }

    static void logSampleRate(int rate) {
        sampleRate = rate;
    }

    static void logInternalPalette(String palette) {
        selectedPalette = palette;
    }

    public static enum AudioChannels {
        Pulse1,
        Pulse2,
        Triangle,
        Noise,
        DMC,
        VRC6,
        VRC6_Pulse1,
        VRC6_Pulse2,
        VRC6_Saw,
        Namco,
        MMC5,
        MMC5_Pulse1,
        MMC5_Pulse2,
        MMC5_PCM;

    }
}

