/*
 * Decompiled with CFR 0.152.
 */
package core.audio;

import core.APU;
import core.NesSettings;
import core.audio.Channel;
import core.audio.DMC;
import core.audio.Decimator;
import core.audio.Noise;
import core.audio.Pulse;
import core.audio.Triangle;
import core.mappers.Mapper;
import java.io.Serializable;
import java.util.ArrayList;

public class AudioMixer
implements Serializable {
    private static final long serialVersionUID = -5418535414924993071L;
    private final Mapper map;
    private final Triangle triangle;
    private final Pulse pulse1;
    private final Pulse pulse2;
    private final Noise noise;
    private final DMC dmc;
    private ArrayList<Channel> expansionAudio;
    protected static double[] audioLevels;
    private Decimator resampler;
    private int[] audioBuffer;
    private int bufferPointer;
    private double cyclespersample;
    private int intcyclespersample;
    int dckiller = 0;
    int lpaccum = 0;

    public AudioMixer(Pulse p1, Pulse p2, Triangle t, Noise n, DMC d, ArrayList<Channel> exp, Mapper m) {
        this.map = m;
        this.pulse1 = p1;
        this.pulse2 = p2;
        this.triangle = t;
        this.noise = n;
        this.dmc = d;
        this.expansionAudio = exp;
        audioLevels = new double[5];
        this.updateAudioSettings();
    }

    public int requestNewOutputLocation() {
        audioLevels = new double[audioLevels.length + 1];
        return audioLevels.length - 1;
    }

    public void updateAudioSettings() {
        this.cyclespersample = 1789773.0 / (double)NesSettings.sampleRate;
        this.intcyclespersample = (int)this.cyclespersample;
        this.resampler = new Decimator(this.map, NesSettings.sampleRate);
        this.audioBuffer = new int[(int)((double)NesSettings.sampleRate / 1000.0 * (double)NesSettings.audioBufferSize) * 2];
        this.bufferPointer = 0;
    }

    public final void mixHighQualitySample() {
        double pulse_out = 95.88 / (8128.0 / (this.pulse1.getOutput() + this.pulse2.getOutput()) + 100.0);
        double tnd_out = 163.67 / (24329.0 / (3.0 * this.triangle.getOutput() + 2.0 * this.noise.getOutput() + this.dmc.getOutput()) + 100.0);
        double sample = pulse_out + tnd_out;
        double expansion = 0.0;
        for (Channel chan : this.expansionAudio) {
            expansion += audioLevels[chan.outputLocation] * ((double)chan.getUserMixLevel() / 100.0) * chan.getChannelMixingRatio();
            AudioMixer.audioLevels[chan.outputLocation] = 0.0;
        }
        this.resampler.addInputSample((sample += expansion) * 30000.0 * ((double)NesSettings.masterMixLevel / 100.0));
    }

    public final void mixSample() {
        int i = 0;
        while (i < audioLevels.length) {
            int n = i++;
            audioLevels[n] = audioLevels[n] / (double)APU.samplecounter;
        }
        double p1 = audioLevels[0] * 2.0 * ((double)NesSettings.pulse1MixLevel / 100.0);
        double p2 = audioLevels[1] * 2.0 * ((double)NesSettings.pulse2MixLevel / 100.0);
        double t = audioLevels[2] * ((double)NesSettings.triangleMixLevel / 100.0);
        double n = audioLevels[3] * ((double)NesSettings.noiseMixLevel / 100.0);
        double d = audioLevels[4] * ((double)NesSettings.dmcMixLevel / 100.0);
        double expansionLeft = 0.0;
        double expansionRight = 0.0;
        for (Channel chan : this.expansionAudio) {
            expansionLeft += audioLevels[chan.outputLocation] * ((double)chan.getUserMixLevel() / 100.0) * chan.getChannelMixingRatio() * (chan.getUserPanning() > 0 ? (double)(100 - chan.getUserPanning()) / 100.0 : 1.0);
            expansionRight += audioLevels[chan.outputLocation] * ((double)chan.getUserMixLevel() / 100.0) * chan.getChannelMixingRatio() * (chan.getUserPanning() < 0 ? (double)(chan.getUserPanning() + 100) / 100.0 : 1.0);
        }
        double pulse_out = 95.88 / (8128.0 / (p1 * (NesSettings.pulse1Panning > 0 ? (double)(100 - NesSettings.pulse1Panning) / 100.0 : 1.0) + p2 * (NesSettings.pulse2Panning > 0 ? (double)(100 - NesSettings.pulse2Panning) / 100.0 : 1.0)) + 100.0);
        double tnd_out = 163.67 / (24329.0 / (3.0 * t * (NesSettings.trianglePanning > 0 ? (double)(100 - NesSettings.trianglePanning) / 100.0 : 1.0) + 2.0 * n * (NesSettings.noisePanning > 0 ? (double)(100 - NesSettings.noisePanning) / 100.0 : 1.0) + d * (NesSettings.dmcPanning > 0 ? (double)(100 - NesSettings.dmcPanning) / 100.0 : 1.0)) + 100.0);
        double sample = pulse_out + tnd_out + expansionLeft;
        sample = sample * 30000.0 * ((double)NesSettings.masterMixLevel / 100.0);
        this.addSample((int)sample);
        pulse_out = 95.88 / (8128.0 / (p1 * (NesSettings.pulse1Panning < 0 ? (double)(NesSettings.pulse1Panning + 100) / 100.0 : 1.0) + p2 * (NesSettings.pulse2Panning < 0 ? (double)(NesSettings.pulse2Panning + 100) / 100.0 : 1.0)) + 100.0);
        tnd_out = 163.67 / (24329.0 / (3.0 * t * (NesSettings.trianglePanning < 0 ? (double)(NesSettings.trianglePanning + 100) / 100.0 : 1.0) + 2.0 * n * (NesSettings.noisePanning < 0 ? (double)(NesSettings.noisePanning + 100) / 100.0 : 1.0) + d * (NesSettings.dmcPanning < 0 ? (double)(NesSettings.dmcPanning + 100) / 100.0 : 1.0)) + 100.0);
        sample = pulse_out + tnd_out + expansionRight;
        sample = sample * 30000.0 * ((double)NesSettings.masterMixLevel / 100.0);
        this.addSample((int)sample);
        int i2 = 0;
        while (i2 < audioLevels.length) {
            AudioMixer.audioLevels[i2] = 0.0;
            ++i2;
        }
    }

    public final void addSample(int sample) {
        this.audioBuffer[this.bufferPointer] = this.lowpass_filter(this.highpass_filter(sample));
        if (++this.bufferPointer == this.audioBuffer.length) {
            this.bufferPointer = 0;
            this.map.system.audioFrameCallback(this.audioBuffer);
        }
    }

    public void updateOutput(double[] out) {
        audioLevels = out;
    }

    private int highpass_filter(int sample) {
        this.dckiller -= (sample += this.dckiller) >> 8;
        this.dckiller += sample > 0 ? -1 : 1;
        return sample;
    }

    private int lowpass_filter(int sample) {
        this.lpaccum = (int)((double)this.lpaccum - (double)(sample += this.lpaccum) * 0.9);
        return this.lpaccum;
    }
}

