/*
 * Decompiled with CFR 0.152.
 */
package core.audio;

import core.CPU_6502;
import core.NesSettings;
import core.audio.AudioMixer;
import core.audio.Channel;
import core.audio.Pulse;
import core.mappers.Mapper;

public class MMC5Audio
extends Channel {
    private static final long serialVersionUID = -7799320230787869546L;
    Mapper map;
    Pulse pulse1;
    Pulse pulse2;
    boolean irqEnable;
    boolean pcmMode;
    boolean doingIRQ;
    private int pcmdata;
    private final double mixRatio = 0.00376;
    private final double pcmRatio = 0.00216;
    private final double pcmAddRatio = 0.574468085106383;
    private int frameClockCounter;
    private int frameClock = 7457;
    boolean odd = false;
    private final String name1 = "MMC5 Pulse 1";
    private final String name2 = "MMC5 Pulse 2";

    public MMC5Audio(Mapper m) {
        super(0);
        this.map = m;
        this.outputLocation = m.apu.mixer.requestNewOutputLocation();
        this.pulse1 = new Pulse(true, this.outputLocation);
        this.pulse2 = new Pulse(true, this.outputLocation);
    }

    public void registerWrite(int index, byte b) {
        switch (index) {
            case 20480: {
                this.pulse1.registerWrite(0, b, 0);
                break;
            }
            case 20481: {
                break;
            }
            case 20482: {
                this.pulse1.registerWrite(2, b, 0);
                break;
            }
            case 20483: {
                this.pulse1.registerWrite(3, b, 0);
                break;
            }
            case 20484: {
                this.pulse2.registerWrite(0, b, 0);
                break;
            }
            case 20485: {
                break;
            }
            case 20486: {
                this.pulse2.registerWrite(2, b, 0);
                break;
            }
            case 20487: {
                this.pulse2.registerWrite(3, b, 0);
                break;
            }
            case 20496: {
                this.pcmMode = (b & 1) == 1;
                this.irqEnable = (b & 0x80) != 0;
                break;
            }
            case 20497: {
                if (b == 0 && this.irqEnable) {
                    this.map.cpu.setIRQ(CPU_6502.IRQSource.External);
                    this.doingIRQ = true;
                    break;
                }
                this.pcmdata = Byte.toUnsignedInt(b);
                break;
            }
            case 20501: {
                if ((b & 1) == 1) {
                    this.pulse1.enable();
                } else {
                    this.pulse1.disable();
                }
                if ((b & 2) == 2) {
                    this.pulse2.enable();
                    break;
                }
                this.pulse2.disable();
            }
        }
    }

    public byte readRegister(int index) {
        if (index == 20496) {
            byte out = (byte)(this.doingIRQ ? 128 : 0);
            this.map.cpu.removeIRQ(CPU_6502.IRQSource.External);
            this.doingIRQ = false;
            return out;
        }
        if (index == 20501) {
            byte out = (byte)(this.pulse1.lengthCount > 0 ? 1 : 0);
            out = (byte)(out | (this.pulse2.lengthCount > 0 ? 2 : 0));
            return out;
        }
        return 0;
    }

    @Override
    public final void clockTimer() {
        ++this.frameClockCounter;
        if (this.frameClockCounter == this.frameClock) {
            this.frameClockCounter = 0;
            this.pulse1.envelopeClock();
            this.pulse1.lengthClock();
            this.pulse2.envelopeClock();
            this.pulse2.lengthClock();
        }
        if (this.odd) {
            this.pulse1.clockTimer();
            this.pulse2.clockTimer();
        }
        this.odd = !this.odd;
        int n = this.outputLocation;
        AudioMixer.audioLevels[n] = AudioMixer.audioLevels[n] + (double)this.pcmdata * 0.574468085106383;
    }

    @Override
    public Object[] getInfo() {
        return new Object[]{"MMC5 Pulse 1", this.pulse1.getFrequency(), "MMC5 Pulse 2", this.pulse2.getFrequency()};
    }

    @Override
    public String getName() {
        return "MMC5 Audio";
    }

    @Override
    public int getUserMixLevel() {
        return NesSettings.mmc5MixLevel;
    }

    @Override
    public int getUserPanning() {
        return NesSettings.mmc5Panning;
    }

    @Override
    public double getChannelMixingRatio() {
        return 0.00376;
    }
}

