/*
 * Decompiled with CFR 0.152.
 */
package core.audio;

import core.NesSettings;
import core.audio.AudioMixer;
import core.audio.Channel;

public class NamcoSound
extends Channel {
    private static final long serialVersionUID = -5491358056873773710L;
    private byte[] soundmemory;
    private int[] phase = new int[8];
    private int[] wavelength = new int[8];
    private int[] waveout = new int[8];
    private int[] timers;
    private int[] waveaddress = new int[8];
    private int[] vol = new int[8];
    private boolean[] enables = new boolean[8];
    private int currentchannel = 0;
    private int outputlevel;
    private int enabledChannels;
    int cpucounter;

    public NamcoSound(byte[] sound, int location) {
        super(0);
        this.timers = new int[8];
        this.soundmemory = sound;
        this.outputLocation = location;
    }

    @Override
    public final void clockTimer() {
        if (this.cpucounter % 15 == 0) {
            do {
                this.currentchannel = (this.currentchannel + 1) % 8;
            } while (this.currentchannel != 0 && !this.enables[this.currentchannel]);
            this.clockChannel(this.currentchannel);
        }
        int n = this.outputLocation;
        AudioMixer.audioLevels[n] = AudioMixer.audioLevels[n] + (double)this.outputlevel;
        ++this.cpucounter;
    }

    public void registerWrite(int index, byte b, int chan) {
        switch (index) {
            case 0: {
                int n = chan;
                this.timers[n] = this.timers[n] & 0x3FF00;
                int n2 = chan;
                this.timers[n2] = this.timers[n2] | 0xFF & b;
                break;
            }
            case 1: {
                int n = chan;
                this.phase[n] = this.phase[n] & 0xFFFF00;
                int n3 = chan;
                this.phase[n3] = this.phase[n3] | 0xFF & b;
                break;
            }
            case 2: {
                int n = chan;
                this.timers[n] = this.timers[n] & 0x300FF;
                int n4 = chan;
                this.timers[n4] = this.timers[n4] | (0xFF & b) << 8;
                break;
            }
            case 3: {
                int n = chan;
                this.phase[n] = this.phase[n] & 0xFF00FF;
                int n5 = chan;
                this.phase[n5] = this.phase[n5] | (0xFF & b) << 8;
                break;
            }
            case 4: {
                int n = chan;
                this.timers[n] = this.timers[n] & 0xFFFF;
                int n6 = chan;
                this.timers[n6] = this.timers[n6] | (3 & b) << 16;
                this.wavelength[chan] = 0xFF & b;
                break;
            }
            case 5: {
                int n = chan;
                this.phase[n] = this.phase[n] & 0xFFFF;
                int n7 = chan;
                this.phase[n7] = this.phase[n7] | (0xFF & b) << 16;
                break;
            }
            case 6: {
                this.waveaddress[chan] = b & 0xFF;
                break;
            }
            case 7: {
                this.vol[chan] = b & 0xF;
            }
        }
    }

    public void setmem(byte[] mem) {
        this.soundmemory = mem;
    }

    public final void clockChannel(int chan) {
        if (this.enables[chan]) {
            int length = (64 - (this.wavelength[chan] >> 2)) * 4;
            this.phase[chan] = (this.phase[chan] + this.timers[chan]) % (length << 16);
            this.waveout[chan] = (this.sample((this.phase[chan] >> 16) + this.waveaddress[chan] & 0xFF) - 8) * this.vol[chan];
            this.sumoutput();
        }
    }

    private int sample(int x) {
        return this.soundmemory[x / 2] >> (x & 1) * 4 & 0xF;
    }

    public void setEnables(int c) {
        int i = 7;
        while (i >= 0) {
            this.enables[i] = i >= 7 - c;
            --i;
        }
        this.enabledChannels = 0;
        boolean[] blArray = this.enables;
        int n = this.enables.length;
        int n2 = 0;
        while (n2 < n) {
            boolean t = blArray[n2];
            if (t) {
                ++this.enabledChannels;
            }
            ++n2;
        }
    }

    private void sumoutput() {
        this.outputlevel = 0;
        int[] nArray = this.waveout;
        int n = this.waveout.length;
        int n2 = 0;
        while (n2 < n) {
            int out = nArray[n2];
            this.outputlevel += out;
            ++n2;
        }
    }

    @Override
    public void disable() {
        this.enable = false;
    }

    @Override
    public void enable() {
        this.enable = true;
    }

    @Override
    public Object[] getInfo() {
        Object[] out = new Object[2 * this.enabledChannels];
        int x = 0;
        int i = 8 - this.enabledChannels;
        while (i < 8) {
            out[x++] = "N_Channel " + i;
            out[x++] = this.getFrequency(i);
            ++i;
        }
        return out;
    }

    public double getFrequency(int channel) {
        return 1789773.0 * (double)this.timers[channel] / (double)(983040 * this.wavelength[channel]);
    }

    @Override
    public double getChannelMixingRatio() {
        return 4.7E-4;
    }

    @Override
    public int getUserPanning() {
        return NesSettings.namcoPanning;
    }

    @Override
    public int getUserMixLevel() {
        return NesSettings.namcoMixLevel;
    }
}

