/*
 * Decompiled with CFR 0.152.
 */
package core.audio;

import core.NesSettings;
import core.audio.AudioMixer;
import core.audio.Channel;

public class Noise
extends Channel {
    private static final long serialVersionUID = 7294397072264670989L;
    boolean mode = false;
    int shiftreg = 1;
    int[] noiselookup = new int[]{4, 8, 16, 32, 64, 96, 128, 160, 202, 254, 380, 508, 762, 1016, 2034, 4068};

    public Noise(int location) {
        super(location);
    }

    public void registerWrite(int index, byte b, int clock) {
        switch (index % 4) {
            case 0: {
                if (clock == 14195) {
                    this.delayedChange = (b & 0x10) != 0 ? 2 : 1;
                } else {
                    this.loop = (b & 0x20) != 0;
                }
                this.constantVolume = (b & 0x10) != 0;
                this.volume = b & 0xF;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.mode = (b & 0x80) != 0;
                int noiseperiod = b & 0xF;
                this.timer = this.noiselookup[noiseperiod] - 1;
                break;
            }
            case 3: {
                if (this.enable) {
                    if (clock == 14915) {
                        if (this.lengthCount == 0) {
                            this.lengthCount = (b & 0xFF) >>> 3;
                            this.lengthCount = this.lengthLookupTable[this.lengthCount];
                            this.block = true;
                        }
                    } else {
                        this.lengthCount = (b & 0xFF) >>> 3;
                        this.lengthCount = this.lengthLookupTable[this.lengthCount];
                    }
                }
                this.decay = this.volume;
                this.eStart = true;
                break;
            }
        }
    }

    @Override
    public final void clockTimer() {
        if (this.tCount == 0) {
            this.tCount = this.timer;
            int feedback = this.mode ? this.shiftreg >> 6 & 1 ^ this.shiftreg & 1 : this.shiftreg >> 1 & 1 ^ this.shiftreg & 1;
            this.shiftreg >>= 1;
            this.shiftreg |= feedback << 14;
        } else {
            --this.tCount;
        }
        if (this.lengthCount == 0 || (this.shiftreg & 1) == 1) {
            return;
        }
        int n = this.outputLocation;
        AudioMixer.audioLevels[n] = AudioMixer.audioLevels[n] + (double)this.decay;
    }

    public double getOutput() {
        if (this.lengthCount == 0 || (this.shiftreg & 1) == 1) {
            return 0.0;
        }
        if (this.constantVolume) {
            return (double)this.volume * ((double)NesSettings.noiseMixLevel / 100.0);
        }
        return (double)this.decay * ((double)NesSettings.noiseMixLevel / 100.0);
    }

    @Override
    public int getUserPanning() {
        return NesSettings.noisePanning;
    }

    @Override
    public int getUserMixLevel() {
        return NesSettings.noiseMixLevel;
    }

    @Override
    public double getChannelMixingRatio() {
        return 0.00494;
    }
}

