/*
 * Decompiled with CFR 0.152.
 */
package core.audio;

import core.NesSettings;
import core.audio.AudioMixer;
import core.audio.Channel;

public class Sunsoft5B
extends Channel {
    private static final long serialVersionUID = 4661386185611176379L;
    int channelATimer;
    int tempa;
    boolean channelAEnableE;
    boolean toneA;
    int channelAVolume;
    boolean cAOut;
    int channelBTimer;
    int tempb;
    boolean channelBEnableE;
    boolean toneB;
    int channelBVolume;
    boolean cBOut;
    int channelCTimer;
    int tempc;
    boolean channelCEnableE;
    boolean toneC;
    int channelCVolume;
    boolean cCOut;
    boolean[] duty;
    int[] volumes;
    int cAduty;
    int cBduty;
    int cCduty;
    int dutynumber;
    int noisePeriod;
    int envelopePeriod;
    int enVolume;
    boolean eContinue;
    boolean eAttack;
    boolean eAlternate;
    boolean eHold;
    int divider;

    public Sunsoft5B(int location) {
        super(0);
        boolean[] blArray = new boolean[8];
        blArray[0] = true;
        blArray[1] = true;
        blArray[2] = true;
        blArray[3] = true;
        this.duty = blArray;
        int[] nArray = new int[16];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 4;
        nArray[4] = 6;
        nArray[5] = 9;
        nArray[6] = 12;
        nArray[7] = 15;
        nArray[8] = 18;
        nArray[9] = 21;
        nArray[10] = 25;
        nArray[11] = 28;
        nArray[12] = 32;
        nArray[13] = 36;
        nArray[14] = 40;
        nArray[15] = 44;
        this.volumes = nArray;
        this.cAduty = 0;
        this.cBduty = 0;
        this.cCduty = 0;
        this.dutynumber = 0;
        this.enVolume = 0;
        this.outputLocation = location;
    }

    public void registerWrite(int index, byte b) {
        switch (index) {
            case 0: {
                this.channelATimer &= 0xF00;
                this.channelATimer |= 0xFF & b;
                break;
            }
            case 1: {
                this.channelATimer &= 0xFF;
                this.channelATimer |= (0xF & b) << 8;
                break;
            }
            case 2: {
                this.channelBTimer &= 0xF00;
                this.channelBTimer |= 0xFF & b;
                break;
            }
            case 3: {
                this.channelBTimer &= 0xFF;
                this.channelBTimer |= (0xF & b) << 8;
                break;
            }
            case 4: {
                this.channelCTimer &= 0xF00;
                this.channelCTimer |= 0xFF & b;
                break;
            }
            case 5: {
                this.channelCTimer &= 0xFF;
                this.channelCTimer |= (0xF & b) << 8;
                break;
            }
            case 6: {
                this.noisePeriod = b & 0x1F;
                break;
            }
            case 7: {
                this.toneA = (b & 1) == 0;
                this.toneB = (b & 2) == 0;
                this.toneC = (b & 4) == 0;
                break;
            }
            case 8: {
                this.channelAEnableE = (b & 0x10) != 0;
                this.channelAVolume = b & 0xF;
                break;
            }
            case 9: {
                this.channelBEnableE = (b & 0x10) != 0;
                this.channelBVolume = b & 0xF;
                break;
            }
            case 10: {
                this.channelCEnableE = (b & 0x10) != 0;
                this.channelCVolume = b & 0xF;
                break;
            }
            case 11: {
                this.envelopePeriod &= 0xFF00;
                this.envelopePeriod |= 0xFF & b;
                break;
            }
            case 12: {
                this.envelopePeriod &= 0xFF;
                this.envelopePeriod |= (0xFF & b) << 8;
                break;
            }
            case 13: {
                this.eContinue = (b & 8) != 0;
                this.eAttack = (b & 4) != 0;
                this.eAlternate = (b & 2) != 0;
                this.eHold = (b & 1) != 0;
            }
        }
    }

    @Override
    public final void clockTimer() {
        if (this.divider == 0) {
            if (this.tempa == 0) {
                this.tempa = this.channelATimer;
                ++this.cAduty;
                this.cAOut = this.duty[this.cAduty % 8];
            } else {
                --this.tempa;
            }
            if (this.tempb == 0) {
                this.tempb = this.channelBTimer;
                ++this.cBduty;
                this.cBOut = this.duty[this.cBduty % 8];
            } else {
                --this.tempb;
            }
            if (this.tempc == 0) {
                this.tempc = this.channelCTimer;
                ++this.cCduty;
                this.cCOut = this.duty[this.cCduty % 8];
            } else {
                --this.tempc;
            }
        }
        ++this.divider;
        this.divider %= 4;
        int n = this.outputLocation;
        AudioMixer.audioLevels[n] = AudioMixer.audioLevels[n] + (double)(this.cAOut && this.toneA ? (this.channelAEnableE ? this.enVolume : this.volumes[this.channelAVolume]) : 0);
        int n2 = this.outputLocation;
        AudioMixer.audioLevels[n2] = AudioMixer.audioLevels[n2] + (double)(this.cBOut && this.toneB ? (this.channelBEnableE ? this.enVolume : this.volumes[this.channelBVolume]) : 0);
        int n3 = this.outputLocation;
        AudioMixer.audioLevels[n3] = AudioMixer.audioLevels[n3] + (double)(this.cCOut && this.toneC ? (this.channelCEnableE ? this.enVolume : this.volumes[this.channelCVolume]) : 0);
    }

    @Override
    public double getChannelMixingRatio() {
        return 0.00276;
    }

    @Override
    public int getUserPanning() {
        return NesSettings.sunsoft5BPanning;
    }

    @Override
    public int getUserMixLevel() {
        return NesSettings.sunsoft5BMixLevel;
    }
}

