/*
 * Decompiled with CFR 0.152.
 */
package core.audio;

import core.NesSettings;
import core.audio.AudioMixer;
import core.audio.Channel;

public class Triangle
extends Channel {
    private static final long serialVersionUID = 4651788745714469245L;
    private boolean linearReloadFlag;
    private boolean linearControl;
    private int linearReload;
    private int linearCount;
    int[] lengthlookup = new int[]{10, 254, 20, 2, 40, 4, 80, 6, 160, 8, 60, 10, 14, 12, 26, 14, 12, 16, 24, 18, 48, 20, 96, 22, 192, 24, 72, 26, 16, 28, 32, 30};
    public int[] sequencer;
    public int sequenceNum;
    private final String name = "Triangle";

    public Triangle(int location) {
        super(location);
        int[] nArray = new int[32];
        nArray[0] = 15;
        nArray[1] = 14;
        nArray[2] = 13;
        nArray[3] = 12;
        nArray[4] = 11;
        nArray[5] = 10;
        nArray[6] = 9;
        nArray[7] = 8;
        nArray[8] = 7;
        nArray[9] = 6;
        nArray[10] = 5;
        nArray[11] = 4;
        nArray[12] = 3;
        nArray[13] = 2;
        nArray[14] = 1;
        nArray[17] = 1;
        nArray[18] = 2;
        nArray[19] = 3;
        nArray[20] = 4;
        nArray[21] = 5;
        nArray[22] = 6;
        nArray[23] = 7;
        nArray[24] = 8;
        nArray[25] = 9;
        nArray[26] = 10;
        nArray[27] = 11;
        nArray[28] = 12;
        nArray[29] = 13;
        nArray[30] = 14;
        nArray[31] = 15;
        this.sequencer = nArray;
        this.sequenceNum = 0;
        this.name = "Triangle";
    }

    public void registerWrite(int index, byte b, int clock) {
        switch (index % 4) {
            case 0: {
                this.linearReload = b & 0x7F;
                if (clock == 14915) {
                    this.delayedChange = (b & 0x80) != 0 ? 2 : 1;
                    break;
                }
                this.linearControl = (b & 0x80) != 0;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.timer &= 0xFF00;
                this.timer |= b & 0xFF;
                break;
            }
            case 3: {
                int x = Byte.toUnsignedInt(b) >> 3;
                if (this.enable) {
                    if (clock == 14915) {
                        if (this.lengthCount == 0) {
                            this.lengthCount = this.lengthlookup[x];
                            this.block = true;
                        }
                    } else {
                        this.lengthCount = this.lengthlookup[x];
                    }
                }
                this.timer &= 0xFF;
                this.timer |= (b & 7) << 8;
                this.linearReloadFlag = true;
            }
        }
    }

    @Override
    public void lengthClock() {
        if (this.enable && !this.block && this.lengthCount != 0 && !this.linearControl) {
            --this.lengthCount;
        }
        if (this.delayedChange != 0) {
            this.loop = this.delayedChange == 2;
            this.delayedChange = 0;
        }
        this.block = false;
    }

    public void linearClock() {
        if (this.enable) {
            if (this.linearReloadFlag) {
                this.linearCount = this.linearReload;
            } else if (this.linearCount > 0) {
                --this.linearCount;
            }
            if (!this.linearControl) {
                this.linearReloadFlag = false;
            }
        }
    }

    @Override
    public final void clockTimer() {
        if (this.tCount == 0) {
            if (this.linearCount != 0 && this.lengthCount != 0 && this.timer > 2) {
                this.sequenceNum = (this.sequenceNum + 1) % 32;
            }
            this.tCount = this.timer;
        } else {
            --this.tCount;
        }
        int n = this.outputLocation;
        AudioMixer.audioLevels[n] = AudioMixer.audioLevels[n] + (double)this.sequencer[this.sequenceNum];
    }

    public double getOutput() {
        return (double)this.sequencer[this.sequenceNum] * ((double)NesSettings.triangleMixLevel / 100.0);
    }

    @Override
    public Object[] getInfo() {
        return new Object[]{"Triangle", this.getFrequency()};
    }

    @Override
    public double getFrequency() {
        if (this.timer == 0) {
            return 0.0;
        }
        return 1789773.0 / (32.0 * (double)(this.timer + 1));
    }

    @Override
    public String getName() {
        return "Triangle";
    }

    @Override
    public int getUserPanning() {
        return NesSettings.trianglePanning;
    }

    @Override
    public int getUserMixLevel() {
        return NesSettings.triangleMixLevel;
    }

    @Override
    public double getChannelMixingRatio() {
        return 0.00851;
    }
}

