/*
 * Decompiled with CFR 0.152.
 */
package core.audio;

import core.NesSettings;
import core.audio.AudioMixer;
import core.audio.Channel;

public class VRC6Saw
extends Channel {
    private static final long serialVersionUID = 6678747718079279169L;
    private int accumulatorRate;
    private int accumulator;
    private boolean oddClock;
    private int sawClock;
    private final String name = "VRC6 Saw";

    public VRC6Saw(int location) {
        super(location);
    }

    public void registerWrite(int index, byte b) {
        switch (index % 4) {
            case 0: {
                this.accumulatorRate = b & 0x3F;
                break;
            }
            case 1: {
                this.timer &= 0xFF00;
                this.timer |= b & 0xFF;
                break;
            }
            case 2: {
                this.timer &= 0xFF;
                this.timer |= (b & 0xF) << 8;
                boolean bl = this.enable = b < 0;
                if (this.enable) break;
                this.accumulator = 0;
            }
        }
    }

    @Override
    public final void clockTimer() {
        if (this.tCount == 0) {
            this.tCount = this.timer;
            if (this.oddClock) {
                if (this.enable) {
                    ++this.sawClock;
                    if (this.sawClock > 6) {
                        this.accumulator = 0;
                        this.sawClock = 0;
                    } else {
                        this.accumulator += this.accumulatorRate;
                    }
                } else {
                    this.accumulator = 0;
                }
            }
            this.oddClock = !this.oddClock;
        } else {
            --this.tCount;
        }
        if (!this.enable) {
            return;
        }
        int n = this.outputLocation;
        AudioMixer.audioLevels[n] = AudioMixer.audioLevels[n] + (double)(this.accumulator >> 3);
    }

    @Override
    public double getFrequency() {
        if (!this.enable || this.accumulatorRate == 0) {
            return 0.0;
        }
        return 1789773.0 / (14.0 * (double)(this.timer + 1));
    }

    @Override
    public Object[] getInfo() {
        return new Object[]{"VRC6 Saw", this.getFrequency()};
    }

    @Override
    public String getName() {
        return "VRC6 Saw";
    }

    @Override
    public double getChannelMixingRatio() {
        return 0.012;
    }

    @Override
    public int getUserMixLevel() {
        return NesSettings.vrc6MixLevel;
    }

    @Override
    public int getUserPanning() {
        return NesSettings.vrc6Panning;
    }
}

