/*
 * Decompiled with CFR 0.152.
 */
package core.mappers;

import core.mappers.Mapper;
import java.util.Arrays;

public class MMC2
extends Mapper {
    private static final long serialVersionUID = 6964328787497731249L;
    int latch0;
    byte[][] latch0bank = new byte[2][4096];
    int latch1;
    byte[][] latch1bank = new byte[2][4096];

    public MMC2() {
        System.out.println("Making an MMC2!");
        this.PRG_ROM = new byte[4][8192];
    }

    @Override
    public void setPRG(byte[] prg) {
        this.PRGbanks = new byte[prg.length / 8192][8192];
        int i = 0;
        while (i * 8192 < prg.length) {
            this.PRGbanks[i] = Arrays.copyOfRange(prg, i * 8192, i * 8192 + 8192);
            ++i;
        }
        this.PRG_ROM[0] = this.PRGbanks[0];
        this.PRG_ROM[1] = this.PRGbanks[this.PRGbanks.length - 3];
        this.PRG_ROM[2] = this.PRGbanks[this.PRGbanks.length - 2];
        this.PRG_ROM[3] = this.PRGbanks[this.PRGbanks.length - 1];
    }

    @Override
    public void setCHR(byte[] chr) {
        if (chr.length > 0) {
            this.CHRbanks = new byte[chr.length / 4096][4096];
            int i = 0;
            while (i * 4096 < chr.length) {
                this.CHRbanks[i] = Arrays.copyOfRange(chr, i * 4096, i * 4096 + 4096);
                ++i;
            }
            this.CHR_ROM[0] = this.CHRbanks[0];
            this.CHR_ROM[1] = this.CHRbanks[1];
        } else {
            this.CHR_ROM[0] = new byte[4096];
            this.CHR_ROM[1] = new byte[4096];
            this.CHR_ram = true;
        }
    }

    @Override
    public void cartridgeWrite(int index, byte b) {
        if (index >= 24576 && index <= Short.MAX_VALUE) {
            this.PRG_RAM[index % 8192] = b;
        } else if (index >= 40960 && index <= 45055) {
            this.PRG_ROM[0] = this.PRGbanks[b & 0xF & this.PRGbanks.length - 1];
        } else if (index >= 45056 && index <= 49151) {
            this.latch0bank[0] = this.CHRbanks[b & 0x1F & this.CHRbanks.length - 1];
        } else if (index >= 49152 && index <= 53247) {
            this.latch0bank[1] = this.CHRbanks[b & 0x1F & this.CHRbanks.length - 1];
        } else if (index >= 53248 && index <= 57343) {
            this.latch1bank[0] = this.CHRbanks[b & 0x1F & this.CHRbanks.length - 1];
        } else if (index >= 57344 && index <= 61439) {
            this.latch1bank[1] = this.CHRbanks[b & 0x1F & this.CHRbanks.length - 1];
        } else if (index >= 61440 && index <= 65535) {
            boolean bl = this.mirrormode = (b & 1) == 1;
            if (this.mirrormode) {
                this.setNameTable(Mapper.Mirror.Horizontal);
            } else {
                this.setNameTable(Mapper.Mirror.Vertical);
            }
        }
    }

    @Override
    public byte cartridgeRead(int index) {
        if (index < 32768) {
            return this.PRG_RAM[index % 8192];
        }
        return this.PRG_ROM[(index - 32768) / 8192][index % 8192];
    }

    @Override
    public byte ppureadPT(int index) {
        byte r = index < 4096 ? this.latch0bank[this.latch0 == 253 ? 0 : 1][index % 4096] : this.latch1bank[this.latch1 == 253 ? 0 : 1][index % 4096];
        if (index == 4056) {
            this.latch0 = 253;
        } else if (index == 4072) {
            this.latch0 = 254;
        } else if (index >= 8152 && index <= 8159) {
            this.latch1 = 253;
        } else if (index >= 8168 && index <= 8175) {
            this.latch1 = 254;
        }
        return r;
    }

    @Override
    public byte ppuread(int index) {
        if (index >= 8192 && index <= 16127) {
            return this.nametables[index / 1024][(index &= 0xFFF) % 1024];
        }
        return this.ppu_palette[index -= (index &= 0x1F) >= 16 && (index & 3) == 0 ? 16 : 0];
    }
}

