/*
 * Decompiled with CFR 0.152.
 */
package core.mappers;

import core.CPU_6502;
import core.audio.MMC5Audio;
import core.mappers.Mapper;
import java.util.Arrays;

public class MMC5
extends Mapper {
    private static final long serialVersionUID = -3309464442109236184L;
    private int PRG_mode;
    private int CHR_mode;
    private int PRG_ram_protect_1;
    private int PRG_ram_protect_2;
    private int EXT_ram_mode;
    private byte[] EXT_ram = new byte[1024];
    private byte[][] nametables = new byte[4][1024];
    private int[] nametable_assignments = new int[4];
    private byte[][] ppu_internal_ram = new byte[2][1024];
    private final byte[] all_zero = new byte[1024];
    private byte[] fill_mode = new byte[1024];
    private byte fill_mode_tile;
    private byte fill_mode_color;
    private int[] chrbanksa = new int[8];
    private int[] chrbanksb = new int[4];
    private byte[][] CHR_ROMB = new byte[4][1024];
    private byte[][] PRG_RAM_banks = new byte[8][8192];
    private byte[][] PRG_MAP = new byte[4][8192];
    private boolean[] PRG_MAP_writable = new boolean[4];
    private MMC5Audio channel;
    private boolean lastbanksprite;
    private int upperchr;
    private int irqscanline;
    private int irqcounter;
    private boolean irqEnable;
    private boolean irqpending;
    private boolean multlowready;
    private boolean multhighready;
    private int multlow;
    private int multhigh;
    private int multproduct;

    public MMC5() {
        System.out.println("Making an MMC5!");
        this.EXT_ram_mode = 0;
        this.channel = new MMC5Audio(this);
        this.apu.addExpansionChannel(this.channel);
    }

    @Override
    public void setPRG(byte[] prg) {
        this.PRGbanks = new byte[prg.length / 8192][8192];
        int i = 0;
        while (i * 8192 < prg.length) {
            this.PRGbanks[i] = Arrays.copyOfRange(prg, i * 8192, i * 8192 + 8192);
            ++i;
        }
        this.PRG_MAP[0] = this.PRGbanks[0];
        this.PRG_MAP[1] = this.PRGbanks[1];
        this.PRG_MAP[2] = this.PRGbanks[0];
        this.PRG_MAP[3] = this.PRGbanks[this.PRGbanks.length - 1];
        this.PRG_RAM = this.PRG_RAM_banks[0];
    }

    @Override
    public void setCHR(byte[] chr) {
        this.CHR_ROM = new byte[8][1024];
        if (chr.length > 0) {
            this.CHRbanks = new byte[chr.length / 1024][1024];
            int i = 0;
            while (i * 1024 < chr.length) {
                this.CHRbanks[i] = Arrays.copyOfRange(chr, i * 1024, i * 1024 + 1024);
                ++i;
            }
        } else {
            this.CHR_ram = true;
        }
    }

    @Override
    void cartridgeWrite(int index, byte b) {
        block18: {
            block22: {
                block21: {
                    block20: {
                        block19: {
                            block17: {
                                if (index >= 20480 && index <= 20487) {
                                    this.channel.registerWrite(index, b);
                                } else if (index == 20496 || index == 20497 || index == 20501) {
                                    this.channel.registerWrite(index, b);
                                }
                                if (index < 20736 || index > 20743) break block17;
                                this.configuration(index, b);
                                break block18;
                            }
                            if (index < 20755 || index > 20759) break block19;
                            this.prgBankSwitching(index, b);
                            break block18;
                        }
                        if (index < 20768 || index > 20784) break block20;
                        this.chrBankSwitching(index, b);
                        break block18;
                    }
                    if (index < 20992 || index > 20998) break block21;
                    this.otherRegisters(index, b);
                    break block18;
                }
                if (index < 23552 || index > 24575) break block22;
                switch (this.EXT_ram_mode) {
                    case 0: 
                    case 1: {
                        if (this.ppu.dorender() && this.ppu.scanline < 240) {
                            this.EXT_ram[index % 1024] = b;
                            break;
                        }
                        break block18;
                    }
                    case 2: {
                        this.EXT_ram[index % 1024] = b;
                        break;
                    }
                    case 3: {
                        if (this.PRG_ram_protect_1 == 2 && this.PRG_ram_protect_2 == 1) {
                            this.EXT_ram[index % 1024] = b;
                        } else {
                            break;
                        }
                    }
                }
                break block18;
            }
            if (index >= 24576 && index <= Short.MAX_VALUE) {
                this.PRG_RAM[index % 8192] = b;
            } else if (index >= 32768 && index <= 40959 && this.PRG_MAP_writable[0]) {
                this.PRG_MAP[0][index % 8192] = b;
            } else if (index >= 40960 && index <= 49151 && this.PRG_MAP_writable[1]) {
                this.PRG_MAP[1][index % 8192] = b;
            } else if (index >= 49152 && index <= 57343 && this.PRG_MAP_writable[2]) {
                this.PRG_MAP[2][index % 8192] = b;
            }
        }
    }

    @Override
    byte cartridgeRead(int index) {
        switch (index) {
            case 20497: {
                return this.channel.readRegister(20497);
            }
            case 20501: {
                return this.channel.readRegister(20501);
            }
            case 20996: {
                byte b = (byte)(this.irqpending ? 128 : 0);
                this.irqpending = false;
                this.cpu.removeIRQ(CPU_6502.IRQSource.External);
                b = (byte)(b | (this.ppu.dorender() && this.ppu.scanline < 239 ? 64 : 0));
                return b;
            }
            case 20997: {
                return (byte)(this.multproduct & 0xFF);
            }
            case 20998: {
                return (byte)(this.multproduct >> 8 & 0xFF);
            }
        }
        if (index >= 23552 && index <= 24575) {
            switch (this.EXT_ram_mode) {
                case 0: 
                case 1: {
                    return this.openbus;
                }
                case 2: 
                case 3: {
                    return this.EXT_ram[index % 1024];
                }
            }
        } else {
            if (index >= 24576 && index <= Short.MAX_VALUE) {
                return this.PRG_RAM[index % 8192];
            }
            if (index >= 32768 && index <= 40959) {
                return this.PRG_MAP[0][index % 8192];
            }
            if (index >= 40960 && index <= 49151) {
                return this.PRG_MAP[1][index % 8192];
            }
            if (index >= 49152 && index <= 57343) {
                return this.PRG_MAP[2][index % 8192];
            }
            if (index >= 57344 && index <= 65535) {
                return this.PRG_MAP[3][index % 8192];
            }
        }
        return 0;
    }

    private void configuration(int index, byte b) {
        switch (index) {
            case 20736: {
                System.out.println("PRG MODE: " + Integer.toBinaryString(b & 3));
                this.PRG_mode = b & 3;
                break;
            }
            case 20737: {
                System.out.println("CHR MODE: " + Integer.toBinaryString(b & 3));
                this.CHR_mode = b & 3;
                break;
            }
            case 20738: {
                this.PRG_ram_protect_1 = b & 3;
                break;
            }
            case 20739: {
                this.PRG_ram_protect_2 = b & 3;
                break;
            }
            case 20740: {
                if (this.EXT_ram_mode != (b & 3)) {
                    System.out.println("EXTRAM MODE: " + Integer.toBinaryString(Byte.toUnsignedInt(b)));
                }
                this.EXT_ram_mode = b & 3;
                break;
            }
            case 20741: {
                int pos = Byte.toUnsignedInt(b);
                for (int i = 0; i < 4; ++i) {
                    switch (pos & 3) {
                        case 0: {
                            this.nametables[i] = this.ppu_internal_ram[0];
                            this.nametable_assignments[i] = 0;
                            break;
                        }
                        case 1: {
                            this.nametables[i] = this.ppu_internal_ram[1];
                            this.nametable_assignments[i] = 1;
                            break;
                        }
                        case 2: {
                            this.nametables[i] = this.EXT_ram_mode == 0 || this.EXT_ram_mode == 1 ? this.EXT_ram : this.all_zero;
                            this.nametable_assignments[i] = 2;
                            break;
                        }
                        case 3: {
                            this.nametables[i] = this.fill_mode;
                            this.nametable_assignments[i] = 3;
                        }
                    }
                    pos >>= 2;
                }
                break;
            }
            case 20742: {
                this.fill_mode_tile = b;
                for (int i = 0; i < 960; ++i) {
                    this.fill_mode[i] = this.fill_mode_tile;
                }
                break;
            }
            case 20743: {
                this.fill_mode_color = (byte)((b & 3) << 6 | (b & 3) << 4 | (b & 3) << 2 | b & 3);
                for (int i = 960; i < 1024; ++i) {
                    this.fill_mode[i] = this.fill_mode_color;
                }
                break;
            }
        }
    }

    private void prgBankSwitching(int index, byte b) {
        if (index == 20755) {
            this.PRG_RAM = this.PRG_RAM_banks[b & 7];
        } else if (index == 20756) {
            if (this.PRG_mode == 3) {
                if (b > 0) {
                    this.PRG_MAP[0] = this.PRG_RAM_banks[b & 7];
                    this.PRG_MAP_writable[0] = true;
                } else {
                    this.PRG_MAP[0] = this.PRGbanks[b & 0x7F & this.PRGbanks.length - 1];
                    this.PRG_MAP_writable[0] = false;
                }
            }
        } else if (index == 20757) {
            switch (this.PRG_mode) {
                case 1: 
                case 2: {
                    if (b > 0) {
                        this.PRG_MAP[0] = this.PRG_RAM_banks[(b & 4) + (b & 2)];
                        this.PRG_MAP[1] = this.PRG_RAM_banks[(b & 4) + (b & 2) + 1];
                        this.PRG_MAP_writable[1] = true;
                        this.PRG_MAP_writable[0] = true;
                        break;
                    }
                    this.PRG_MAP[0] = this.PRGbanks[b & 0x7E & this.PRGbanks.length - 1];
                    this.PRG_MAP[1] = this.PRGbanks[(b & 0x7E & this.PRGbanks.length - 1) + 1];
                    this.PRG_MAP_writable[1] = false;
                    this.PRG_MAP_writable[0] = false;
                    break;
                }
                case 3: {
                    if (b > 0) {
                        this.PRG_MAP[1] = this.PRG_RAM_banks[b & 7];
                        this.PRG_MAP_writable[1] = true;
                        break;
                    }
                    this.PRG_MAP[1] = this.PRGbanks[b & 0x7F & this.PRGbanks.length - 1];
                    this.PRG_MAP_writable[1] = false;
                    break;
                }
            }
        } else if (index == 20758) {
            switch (this.PRG_mode) {
                case 2: 
                case 3: {
                    if (b > 0) {
                        this.PRG_MAP[2] = this.PRG_RAM_banks[b & 7];
                        this.PRG_MAP_writable[2] = true;
                        break;
                    }
                    this.PRG_MAP[2] = this.PRGbanks[b & 0x7F & this.PRGbanks.length - 1];
                    this.PRG_MAP_writable[2] = false;
                    break;
                }
            }
        } else if (index == 20759) {
            switch (this.PRG_mode) {
                case 0: {
                    this.PRG_MAP[0] = this.PRGbanks[(b & 0x7C & this.PRGbanks.length - 1) + 0];
                    this.PRG_MAP_writable[0] = false;
                    this.PRG_MAP[1] = this.PRGbanks[(b & 0x7C & this.PRGbanks.length - 1) + 1];
                    this.PRG_MAP_writable[1] = false;
                    this.PRG_MAP[2] = this.PRGbanks[(b & 0x7C & this.PRGbanks.length - 1) + 2];
                    this.PRG_MAP_writable[2] = false;
                    this.PRG_MAP[3] = this.PRGbanks[(b & 0x7C & this.PRGbanks.length - 1) + 3];
                    this.PRG_MAP_writable[3] = false;
                    break;
                }
                case 1: {
                    this.PRG_MAP[2] = this.PRGbanks[(b & 0x7E & this.PRGbanks.length - 1) + 0];
                    this.PRG_MAP_writable[2] = false;
                    this.PRG_MAP[3] = this.PRGbanks[(b & 0x7E & this.PRGbanks.length - 1) + 1];
                    this.PRG_MAP_writable[3] = false;
                    break;
                }
                case 2: 
                case 3: {
                    this.PRG_MAP[3] = this.PRGbanks[b & 0x7F & this.PRGbanks.length - 1];
                    this.PRG_MAP_writable[3] = false;
                }
            }
        }
    }

    private void chrBankSwitching(int index, byte b) {
        int val = this.upperchr | Byte.toUnsignedInt(b);
        switch (index) {
            case 20768: {
                this.chrbanksa[0] = val;
                this.setupCHR();
                this.lastbanksprite = true;
                break;
            }
            case 20769: {
                this.chrbanksa[1] = val;
                this.setupCHR();
                this.lastbanksprite = true;
                break;
            }
            case 20770: {
                this.chrbanksa[2] = val;
                this.setupCHR();
                this.lastbanksprite = true;
                break;
            }
            case 20771: {
                this.chrbanksa[3] = val;
                this.setupCHR();
                this.lastbanksprite = true;
                break;
            }
            case 20772: {
                this.chrbanksa[4] = val;
                this.setupCHR();
                this.lastbanksprite = true;
                break;
            }
            case 20773: {
                this.chrbanksa[5] = val;
                this.setupCHR();
                this.lastbanksprite = true;
                break;
            }
            case 20774: {
                this.chrbanksa[6] = val;
                this.setupCHR();
                this.lastbanksprite = true;
                break;
            }
            case 20775: {
                this.chrbanksa[7] = val;
                this.setupCHR();
                this.lastbanksprite = true;
                break;
            }
            case 20776: {
                this.chrbanksb[0] = val;
                this.setupCHR();
                this.lastbanksprite = false;
                break;
            }
            case 20777: {
                this.chrbanksb[1] = val;
                this.setupCHR();
                this.lastbanksprite = false;
                break;
            }
            case 20778: {
                this.chrbanksb[2] = val;
                this.setupCHR();
                this.lastbanksprite = false;
                break;
            }
            case 20779: {
                this.chrbanksb[3] = val;
                this.setupCHR();
                this.lastbanksprite = false;
                break;
            }
            case 20784: {
                if (this.cpu.program_counter == 23577) {
                    this.dodebug = true;
                }
                this.upperchr = (val & 3) << 8;
                break;
            }
        }
        if (!this.ppu.PPUMASK_ss) {
            this.lastbanksprite = true;
        }
    }

    private void setupCHR() {
        switch (this.CHR_mode) {
            case 0: {
                this.CHR_ROM[0] = this.CHRbanks[this.chrbanksa[7] & this.CHRbanks.length - 1];
                this.CHR_ROM[1] = this.CHRbanks[this.chrbanksa[7] + 1 & this.CHRbanks.length - 1];
                this.CHR_ROM[2] = this.CHRbanks[this.chrbanksa[7] + 2 & this.CHRbanks.length - 1];
                this.CHR_ROM[3] = this.CHRbanks[this.chrbanksa[7] + 3 & this.CHRbanks.length - 1];
                this.CHR_ROM[4] = this.CHRbanks[this.chrbanksa[7] + 4 & this.CHRbanks.length - 1];
                this.CHR_ROM[5] = this.CHRbanks[this.chrbanksa[7] + 5 & this.CHRbanks.length - 1];
                this.CHR_ROM[6] = this.CHRbanks[this.chrbanksa[7] + 6 & this.CHRbanks.length - 1];
                this.CHR_ROM[7] = this.CHRbanks[this.chrbanksa[7] + 7 & this.CHRbanks.length - 1];
                this.CHR_ROMB[0] = this.CHRbanks[this.chrbanksb[3] << 3 & this.CHRbanks.length - 1];
                this.CHR_ROMB[1] = this.CHRbanks[(this.chrbanksb[3] << 3) + 1 & this.CHRbanks.length - 1];
                this.CHR_ROMB[2] = this.CHRbanks[(this.chrbanksb[3] << 3) + 2 & this.CHRbanks.length - 1];
                this.CHR_ROMB[3] = this.CHRbanks[(this.chrbanksb[3] << 3) + 3 & this.CHRbanks.length - 1];
                break;
            }
            case 3: {
                this.CHR_ROM[0] = this.CHRbanks[this.chrbanksa[0] & this.CHRbanks.length - 1];
                this.CHR_ROM[1] = this.CHRbanks[this.chrbanksa[1] & this.CHRbanks.length - 1];
                this.CHR_ROM[2] = this.CHRbanks[this.chrbanksa[2] & this.CHRbanks.length - 1];
                this.CHR_ROM[3] = this.CHRbanks[this.chrbanksa[3] & this.CHRbanks.length - 1];
                this.CHR_ROM[4] = this.CHRbanks[this.chrbanksa[4] & this.CHRbanks.length - 1];
                this.CHR_ROM[5] = this.CHRbanks[this.chrbanksa[5] & this.CHRbanks.length - 1];
                this.CHR_ROM[6] = this.CHRbanks[this.chrbanksa[6] & this.CHRbanks.length - 1];
                this.CHR_ROM[7] = this.CHRbanks[this.chrbanksa[7] & this.CHRbanks.length - 1];
                this.CHR_ROMB[0] = this.CHRbanks[this.chrbanksb[0] & this.CHRbanks.length - 1];
                this.CHR_ROMB[1] = this.CHRbanks[this.chrbanksb[1] & this.CHRbanks.length - 1];
                this.CHR_ROMB[2] = this.CHRbanks[this.chrbanksb[2] & this.CHRbanks.length - 1];
                this.CHR_ROMB[3] = this.CHRbanks[this.chrbanksb[3] & this.CHRbanks.length - 1];
                break;
            }
        }
    }

    private void otherRegisters(int index, byte b) {
        switch (index) {
            case 20992: {
                System.out.println("Vertical Split Write: " + Integer.toBinaryString(Byte.toUnsignedInt(b)));
                break;
            }
            case 20993: {
                System.out.println("VerticalS Scroll Write");
                break;
            }
            case 20994: {
                System.out.println("VSplit Bank Write");
                break;
            }
            case 20995: {
                this.irqscanline = Byte.toUnsignedInt(b);
                break;
            }
            case 20996: {
                this.irqEnable = b < 0;
                break;
            }
            case 20997: {
                this.multlow = b & 0xFF;
                this.multlowready = true;
                this.doMultiply();
                break;
            }
            case 20998: {
                this.multhigh = b & 0xFF;
                this.multhighready = true;
                this.doMultiply();
                break;
            }
        }
    }

    private void doMultiply() {
        if (this.multhighready && this.multlowready) {
            this.multproduct = this.multlow * this.multhigh;
            this.multlowready = false;
            this.multhighready = false;
        }
    }

    private void clockirq() {
        if (!this.ppu.dorender() || this.ppu.scanline >= 239) {
            this.irqcounter = 0;
            this.irqpending = false;
        } else {
            ++this.irqcounter;
            if (this.irqcounter == this.irqscanline) {
                this.irqpending = true;
                if (this.irqEnable) {
                    this.cpu.setIRQ(CPU_6502.IRQSource.External);
                }
            }
        }
    }

    @Override
    public final byte ppureadNT(int index) {
        if (this.ppu.pcycle == 1 && this.ppu.scanline > 1) {
            this.clockirq();
        }
        return this.nametables[index / 1024][(index %= 4096) % 1024];
    }

    @Override
    public final byte ppureadAT(int index) {
        if (this.EXT_ram_mode == 1) {
            return this.EXT_ram[index % 1024];
        }
        return this.ppureadNT(index);
    }

    @Override
    public void ppuwrite(int index, byte b) {
        if (index < 8192) {
            if (this.lastbanksprite) {
                this.CHR_ROM[index / 1024][index % 1024] = b;
            } else {
                this.CHR_ROMB[index / 1024][(index %= 4096) % 1024] = b;
            }
        } else if (index >= 8192 && index <= 16127) {
            int i = index & 0xFFF;
            this.nametables[i / 1024][index % 1024] = b;
        } else if (index >= 16128 && index <= 16383) {
            int i = index & 0x1F;
            if (i % 4 == 0) {
                i += i >= 16 ? -16 : 0;
            }
            this.ppu_palette[i] = b;
        }
    }

    @Override
    public byte ppuread(int index) {
        if (index < 8192) {
            if (this.lastbanksprite) {
                return this.CHR_ROM[index / 1024][index % 1024];
            }
            return this.CHR_ROMB[index / 1024][(index %= 4096) % 1024];
        }
        if (index >= 8192 && index <= 16127) {
            int i = index & 0xFFF;
            return this.nametables[i / 1024][i % 1024];
        }
        if (index >= 16128 && index <= 16383) {
            return this.ppu_palette[index -= (index &= 0x1F) >= 16 && (index & 3) == 0 ? 16 : 0];
        }
        return 0;
    }

    @Override
    public byte ppureadPT(int index) {
        if (this.ppu.getSpriteSize()) {
            if (this.ppu.spritefetch) {
                return this.CHR_ROM[index / 1024][index % 1024];
            }
            return this.CHR_ROMB[index / 1024][(index %= 4096) % 1024];
        }
        return this.CHR_ROM[index / 1024][index % 1024];
    }

    @Override
    public void restoreSave(byte[] save) {
        for (int i = 0; i < 8; ++i) {
            System.arraycopy(save, i * 8192, this.PRG_RAM_banks[i], 0, 8192);
        }
    }

    @Override
    public byte[] getSave() {
        byte[] save = new byte[65536];
        for (int i = 0; i < 8; ++i) {
            System.arraycopy(this.PRG_RAM_banks[i], 0, save, i * 8192, 8192);
        }
        return save;
    }

    @Override
    public void runFrame() {
        while (!this.ppu.doneFrame) {
            this.ppu.doCycle();
            this.ppu.doCycle();
            this.ppu.doCycle();
            this.cpu.run_cycle();
            this.apu.doCycle();
        }
        this.ppu.doneFrame = false;
    }
}

