/*
 * Decompiled with CFR 0.152.
 */
package core.mappers;

import core.mappers.Mapper;
import java.util.Arrays;

public class UxROM
extends Mapper {
    private static final long serialVersionUID = 5199302433584064014L;
    byte[][] PRGbanks;

    public UxROM() {
        System.out.println("Mapper 2 (UxROM) Fully Supported!");
    }

    @Override
    public void cartridgeWrite(int index, byte b) {
        if (index >= 32768 && index <= 65535) {
            this.PRG_ROM[0] = this.PRGbanks[(b & 0xF) % this.PRGbanks.length];
        }
    }

    @Override
    public void setPRG(byte[] prg) {
        this.PRGbanks = new byte[prg.length / 16384][16384];
        int i = 0;
        while (i * 16384 < prg.length) {
            this.PRGbanks[i] = Arrays.copyOfRange(prg, i * 16384, i * 16384 + 16384);
            ++i;
        }
        System.out.println("Bank size:" + this.PRGbanks.length);
        this.PRG_ROM[0] = this.PRGbanks[0];
        this.PRG_ROM[1] = this.PRGbanks[this.PRGbanks.length - 1];
    }

    @Override
    public void setCHR(byte[] chr) {
        if (chr.length > 0) {
            int i = 0;
            while (i * 4096 < chr.length) {
                this.CHR_ROM[i] = Arrays.copyOfRange(chr, i * 4096, i * 4096 + 4096);
                ++i;
            }
        } else {
            this.CHR_ram = true;
        }
    }
}

