/*
 * Decompiled with CFR 0.152.
 */
package core.mappers;

import core.mappers.Mapper;
import java.util.Arrays;

public class VRC1
extends Mapper {
    private static final long serialVersionUID = -774631191215076450L;
    int chrselect0;
    int chrselect1;

    public VRC1() {
        System.out.println("Made a VRC1!");
    }

    @Override
    public void setPRG(byte[] prg) {
        this.PRG_ROM = new byte[4][8192];
        this.PRGbanks = new byte[prg.length / 8192][8192];
        int i = 0;
        while (i * 8192 < prg.length) {
            this.PRGbanks[i] = Arrays.copyOfRange(prg, i * 8192, i * 8192 + 8192);
            ++i;
        }
        this.PRG_ROM[0] = this.PRGbanks[0];
        this.PRG_ROM[1] = this.PRGbanks[1];
        this.PRG_ROM[2] = this.PRGbanks[this.PRGbanks.length - 2];
        this.PRG_ROM[3] = this.PRGbanks[this.PRGbanks.length - 1];
    }

    @Override
    public void setCHR(byte[] chr) {
        this.CHR_ROM = new byte[2][4096];
        if (chr.length > 0) {
            this.CHRbanks = new byte[chr.length / 4096][4096];
            int i = 0;
            while (i * 4096 < chr.length) {
                this.CHRbanks[i] = Arrays.copyOfRange(chr, i * 4096, i * 4096 + 4096);
                ++i;
            }
            this.CHR_ROM[0] = this.CHRbanks[0];
            this.CHR_ROM[1] = this.CHRbanks[1];
        } else {
            this.CHR_ram = true;
        }
    }

    @Override
    public final void cartridgeWrite(int index, byte b) {
        if (index >= 32768) {
            if (index <= 36863) {
                this.PRG_ROM[0] = this.PRGbanks[b & 0xF & this.PRGbanks.length - 1];
            } else if (index >= 36864 && index <= 40959) {
                if ((b & 1) == 1) {
                    this.setNameTable(Mapper.Mirror.Horizontal);
                } else {
                    this.setNameTable(Mapper.Mirror.Vertical);
                }
                this.chrselect0 &= 0xF;
                this.chrselect0 |= (b & 2) << 3;
                this.chrselect1 &= 0xF;
                this.chrselect1 |= (b & 4) << 2;
                this.CHR_ROM[0] = this.CHRbanks[this.chrselect0 & this.CHRbanks.length - 1];
                this.CHR_ROM[1] = this.CHRbanks[this.chrselect1 & this.CHRbanks.length - 1];
            } else if (index >= 40960 && index <= 45055) {
                this.PRG_ROM[1] = this.PRGbanks[b & 0xF & this.PRGbanks.length - 1];
            } else if (index >= 49152 && index <= 53247) {
                this.PRG_ROM[2] = this.PRGbanks[b & 0xF & this.PRGbanks.length - 1];
            } else if (index >= 57344 && index <= 61439) {
                this.chrselect0 &= 0xF0;
                this.chrselect0 |= b & 0xF;
                this.CHR_ROM[0] = this.CHRbanks[this.chrselect0 & this.CHRbanks.length - 1];
            } else if (index >= 61440 && index <= 65535) {
                this.chrselect1 &= 0xF0;
                this.chrselect1 |= b & 0xF;
                this.CHR_ROM[1] = this.CHRbanks[this.chrselect1 & this.CHRbanks.length - 1];
            }
        }
    }

    @Override
    final byte cartridgeRead(int index) {
        if (index < 32768) {
            return 0;
        }
        if (index < 40960) {
            return this.PRG_ROM[0][index - 32768];
        }
        if (index < 49152) {
            return this.PRG_ROM[1][index - 40960];
        }
        if (index < 57344) {
            return this.PRG_ROM[2][index - 49152];
        }
        if (index <= 65535) {
            return this.PRG_ROM[3][index - 57344];
        }
        return 0;
    }
}

