/*
 * Decompiled with CFR 0.152.
 */
package ui;

import core.NesSettings;
import java.io.Serializable;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import ui.SystemUI;
import ui.UISettings;
import ui.Visualizer;

public class AudioInterface
implements Serializable {
    private static final long serialVersionUID = 25781276857491755L;
    transient SourceDataLine sdl;
    SystemUI sys;
    transient byte[] audiobuffer;
    transient int[] audioints;
    int bufptr = 0;
    public boolean lock;
    public boolean inaudio;
    Visualizer scope;
    int scopefrequency = 1;
    int scopecount = 0;
    int smoothing = 1;

    public AudioInterface(SystemUI s) {
        this.sys = s;
        this.restartSDL();
    }

    public void restartSDL() {
        AudioFormat form = new AudioFormat(NesSettings.sampleRate, 16, 2, true, false);
        this.bufptr = 0;
        this.audioints = new int[(int)((double)NesSettings.sampleRate / 1000.0 * (double)NesSettings.audioBufferSize) * 2];
        if (this.scope != null) {
            this.scope.setAudio(this.audioints);
        }
        this.audiobuffer = new byte[this.audioints.length * 2];
        try {
            if (this.sdl != null) {
                this.sdl.close();
            }
            this.sdl = AudioSystem.getSourceDataLine(form);
            this.sdl.open(form, this.audiobuffer.length * 3);
            this.sdl.start();
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
        }
    }

    public void outputSample(int sample) {
        if (sample > 32768) {
            sample = 32768;
        }
        if (sample < Short.MIN_VALUE) {
            sample = Short.MIN_VALUE;
        }
        this.audioints[this.bufptr++] = sample * 1;
        if (this.bufptr >= this.audioints.length) {
            this.bufptr = 0;
            this.sendsample();
        }
    }

    public void setAudioFrame(int[] audiobuf) {
        this.audioints = audiobuf;
        this.audiobuffer = new byte[this.audioints.length * 2];
        this.sendsample();
    }

    public void sendsample() {
        this.bufptr = 0;
        int[] nArray = this.audioints;
        int n = this.audioints.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            this.audiobuffer[this.bufptr] = (byte)(i & 0xFF);
            this.audiobuffer[this.bufptr + 1] = (byte)(i >> 8 & 0xFF);
            this.bufptr += 2;
            ++n2;
        }
        if (this.sdl.available() >= this.audiobuffer.length && UISettings.AudioEnabled || UISettings.lockVideoToAudio) {
            this.sdl.write(this.audiobuffer, 0, this.audiobuffer.length);
            if (this.scope != null && this.scope.isVisible() && this.scopefrequency == this.scopecount++) {
                this.scope.setAudio(this.audioints);
                this.scope.setFreq(this.sys.AudioChannelInfoCallback());
                this.scope.paintscope();
                this.scopecount = 0;
            }
        }
        this.bufptr = 0;
    }

    public void showscope() {
        if (this.scope != null) {
            this.scope.setVisible(true);
        } else {
            this.scope = new Visualizer();
            this.scope.setVisible(true);
        }
    }

    private void lowpass() {
        int value = this.audioints[0];
        int len = this.audioints.length;
        int i = 1;
        while (i < len) {
            int currentval = this.audioints[i];
            value += (currentval - value) / this.smoothing;
            this.audioints[i] = value;
            ++i;
        }
    }

    public void close() {
        this.sdl.close();
    }
}

