/*
 * Decompiled with CFR 0.152.
 */
package ui;

import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;

public class ControllerInfo {
    Controller[] controllers;
    Controller control;
    Component.Identifier id;
    String idname;
    float val;

    public ControllerInfo(Controller c, Component.Identifier i, float v) {
        this.val = v;
        this.idname = i == null ? "N/A" : i.getName();
        this.id = i;
        this.control = c;
        this.controllers = ControllerEnvironment.getDefaultEnvironment().getControllers();
    }

    public boolean checkPressed() {
        if (this.control.getType() == Controller.Type.KEYBOARD) {
            for (Controller c : this.controllers) {
                if (!c.getName().equals(this.control.getName())) continue;
                c.poll();
                if (c.getComponent(this.id).getPollData() != this.val) continue;
                return true;
            }
        } else {
            this.control.poll();
            return this.control.getComponent(this.id).getPollData() == this.val;
        }
        return false;
    }

    public String toString() {
        return this.id.toString();
    }

    public String storeInfo() {
        return this.control.getName() + ":" + this.control.getPortNumber() + ";" + this.id.getName() + ";" + this.val;
    }

    public static ControllerInfo restoreInfo(String s, String d) {
        Controller[] cont;
        String[] info = s == null ? d.split(";") : s.split(";");
        String name = info[0].split(":")[0];
        String port = info[0].split(":")[1];
        float var = Float.parseFloat(info[2]);
        for (Controller c : cont = ControllerEnvironment.getDefaultEnvironment().getControllers()) {
            if (!c.getName().equals(name) || c.getPortNumber() != Integer.parseInt(port)) continue;
            for (Component comp : c.getComponents()) {
                if (!comp.getIdentifier().getName().equals(info[1])) continue;
                return new ControllerInfo(c, comp.getIdentifier(), var);
            }
        }
        info = d.split(";");
        for (Controller c : cont) {
            System.out.println(c.getName() + " " + c.getType().toString());
            if (c.getType() != Controller.Type.KEYBOARD) continue;
            System.out.println(c.getName());
            for (Component comp : c.getComponents()) {
                if (!comp.getIdentifier().getName().equals(info[1])) continue;
                return new ControllerInfo(c, comp.getIdentifier(), var);
            }
        }
        Controller[] controllerArray = cont;
        int n = controllerArray.length;
        for (int i = 0; i < n; ++i) {
            Component comp;
            Controller c;
            int n2 = 0;
            c = controllerArray[i];
            Component[] componentArray = c.getComponents();
            int n3 = componentArray.length;
            if (n2 >= n3) continue;
            comp = componentArray[n2];
            return new ControllerInfo(c, comp.getIdentifier(), 1.0f);
        }
        return new ControllerInfo(null, null, 1.0f);
    }
}

