/*
 * Decompiled with CFR 0.152.
 */
package ui;

public final class Fft {
    public static void transform(double[] real, double[] imag) {
        if (real.length != imag.length) {
            throw new IllegalArgumentException("Mismatched lengths");
        }
        int n = real.length;
        if (n == 0) {
            return;
        }
        if ((n & n - 1) == 0) {
            Fft.transformRadix2(real, imag);
        } else {
            Fft.transformBluestein(real, imag);
        }
    }

    public static void inverseTransform(double[] real, double[] imag) {
        Fft.transform(imag, real);
    }

    public static void transformRadix2(double[] real, double[] imag) {
        int i;
        if (real.length != imag.length) {
            throw new IllegalArgumentException("Mismatched lengths");
        }
        int n = real.length;
        int levels = 31 - Integer.numberOfLeadingZeros(n);
        if (1 << levels != n) {
            throw new IllegalArgumentException("Length is not a power of 2");
        }
        double[] cosTable = new double[n / 2];
        double[] sinTable = new double[n / 2];
        for (i = 0; i < n / 2; ++i) {
            cosTable[i] = Math.cos(Math.PI * 2 * (double)i / (double)n);
            sinTable[i] = Math.sin(Math.PI * 2 * (double)i / (double)n);
        }
        for (i = 0; i < n; ++i) {
            int j = Integer.reverse(i) >>> 32 - levels;
            if (j <= i) continue;
            double temp = real[i];
            real[i] = real[j];
            real[j] = temp;
            temp = imag[i];
            imag[i] = imag[j];
            imag[j] = temp;
        }
        for (int size = 2; size <= n; size *= 2) {
            int halfsize = size / 2;
            int tablestep = n / size;
            for (int i2 = 0; i2 < n; i2 += size) {
                int j = i2;
                int k = 0;
                while (j < i2 + halfsize) {
                    double tpre = real[j + halfsize] * cosTable[k] + imag[j + halfsize] * sinTable[k];
                    double tpim = -real[j + halfsize] * sinTable[k] + imag[j + halfsize] * cosTable[k];
                    real[j + halfsize] = real[j] - tpre;
                    imag[j + halfsize] = imag[j] - tpim;
                    int n2 = j;
                    real[n2] = real[n2] + tpre;
                    int n3 = j++;
                    imag[n3] = imag[n3] + tpim;
                    k += tablestep;
                }
            }
            if (size == n) break;
        }
    }

    public static void transformBluestein(double[] real, double[] imag) {
        if (real.length != imag.length) {
            throw new IllegalArgumentException("Mismatched lengths");
        }
        int n = real.length;
        if (n >= 0x20000000) {
            throw new IllegalArgumentException("Array too large");
        }
        int m = Integer.highestOneBit(n * 2) << 1;
        double[] cosTable = new double[n];
        double[] sinTable = new double[n];
        for (int i = 0; i < n; ++i) {
            int j = (int)((long)i * (long)i % (long)(n * 2));
            cosTable[i] = Math.cos(Math.PI * (double)j / (double)n);
            sinTable[i] = Math.sin(Math.PI * (double)j / (double)n);
        }
        double[] areal = new double[m];
        double[] aimag = new double[m];
        for (int i = 0; i < n; ++i) {
            areal[i] = real[i] * cosTable[i] + imag[i] * sinTable[i];
            aimag[i] = -real[i] * sinTable[i] + imag[i] * cosTable[i];
        }
        double[] breal = new double[m];
        double[] bimag = new double[m];
        breal[0] = cosTable[0];
        bimag[0] = sinTable[0];
        for (int i = 1; i < n; ++i) {
            double d = cosTable[i];
            breal[m - i] = d;
            breal[i] = d;
            double d2 = sinTable[i];
            bimag[m - i] = d2;
            bimag[i] = d2;
        }
        double[] creal = new double[m];
        double[] cimag = new double[m];
        Fft.convolve(areal, aimag, breal, bimag, creal, cimag);
        for (int i = 0; i < n; ++i) {
            real[i] = creal[i] * cosTable[i] + cimag[i] * sinTable[i];
            imag[i] = -creal[i] * sinTable[i] + cimag[i] * cosTable[i];
        }
    }

    public static void convolve(double[] x, double[] y, double[] out) {
        int n = x.length;
        if (n != y.length || n != out.length) {
            throw new IllegalArgumentException("Mismatched lengths");
        }
        Fft.convolve(x, new double[n], y, new double[n], out, new double[n]);
    }

    public static void convolve(double[] xreal, double[] ximag, double[] yreal, double[] yimag, double[] outreal, double[] outimag) {
        int i;
        int n = xreal.length;
        if (n != ximag.length || n != yreal.length || n != yimag.length || n != outreal.length || n != outimag.length) {
            throw new IllegalArgumentException("Mismatched lengths");
        }
        xreal = (double[])xreal.clone();
        ximag = (double[])ximag.clone();
        yreal = (double[])yreal.clone();
        yimag = (double[])yimag.clone();
        Fft.transform(xreal, ximag);
        Fft.transform(yreal, yimag);
        for (i = 0; i < n; ++i) {
            double temp = xreal[i] * yreal[i] - ximag[i] * yimag[i];
            ximag[i] = ximag[i] * yreal[i] + xreal[i] * yimag[i];
            xreal[i] = temp;
        }
        Fft.inverseTransform(xreal, ximag);
        for (i = 0; i < n; ++i) {
            outreal[i] = xreal[i] / (double)n;
            outimag[i] = ximag[i] / (double)n;
        }
    }
}

