/*
 * Decompiled with CFR 0.152.
 */
package ui;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import ui.ControllerInfo;
import ui.InputManager;

public class UISettings {
    static Properties prop;
    public static final String version = "0.4.3";
    public static boolean autoLoad;
    public static boolean ShowFPS;
    public static boolean lockVideoToAudio;
    public static boolean AudioEnabled;
    public static String lastLoadedDir;
    public static VideoFilter currentFilter;
    public static boolean scanlinesEnabled;
    public static double scanlineThickness;
    public static double ntsc_hue;
    public static double ntsc_saturation;
    public static double ntsc_contrast;
    public static double ntsc_brightness;
    public static double ntsc_sharpness;
    public static double ntsc_gamma;
    public static double ntsc_resolution;
    public static double ntsc_artifacts;
    public static double ntsc_fringing;
    public static double ntsc_bleed;
    public static boolean ntsc_merge;
    public static final String[] channelNames;
    public static Color[] pianoColors;
    public static final Color[] pianoColorsColorBlind;
    public static boolean colorBlindMode;
    public static boolean allGreen;
    public static boolean controlwhilenotfocused;

    static {
        autoLoad = true;
        ShowFPS = true;
        lockVideoToAudio = false;
        AudioEnabled = true;
        lastLoadedDir = System.getProperty("user.dir");
        currentFilter = VideoFilter.None;
        scanlinesEnabled = false;
        scanlineThickness = 0.5;
        ntsc_hue = 0.0;
        ntsc_saturation = 0.0;
        ntsc_contrast = 0.0;
        ntsc_brightness = 0.0;
        ntsc_sharpness = 0.0;
        ntsc_gamma = 0.0;
        ntsc_resolution = 0.0;
        ntsc_artifacts = 0.0;
        ntsc_fringing = 0.0;
        ntsc_bleed = 0.0;
        ntsc_merge = true;
        channelNames = new String[]{"Pulse 1", "Pulse 2", "Triangle", "VRC6 Pulse 1", "VRC6 Pulse 2", "VRC6 Saw", "MMC5 Pulse 1", "MMC5 Pulse 2", "N_Channel 0", "N_Channel 1", "N_Channel 2", "N_Channel 3", "N_Channel 4", "N_Channel 5", "N_Channel 6", "N_Channel 7"};
        pianoColors = new Color[]{Color.BLUE, Color.CYAN, Color.GREEN, Color.ORANGE, Color.RED, Color.YELLOW, Color.DARK_GRAY, Color.LIGHT_GRAY, Color.magenta, Color.magenta, Color.magenta, Color.magenta, Color.magenta, Color.MAGENTA, Color.MAGENTA, Color.magenta};
        pianoColorsColorBlind = new Color[]{new Color(26112), new Color(0x99FF33), new Color(0x3399FF), new Color(255), new Color(0x9900CC), new Color(0xFF66FF), new Color(0xCC0000), new Color(0xCECECE), new Color(0x8C8C8C), new Color(0x8C8C8C), new Color(0x8C8C8C), new Color(0x8C8C8C), new Color(0x8C8C8C), new Color(0x8C8C8C), new Color(0x8C8C8C), new Color(0x8C8C8C)};
        colorBlindMode = false;
        allGreen = false;
        controlwhilenotfocused = false;
    }

    public static void saveSettings(File config) {
        try {
            FileInputStream input = new FileInputStream(config);
            prop.load(input);
            input.close();
            FileOutputStream output = new FileOutputStream(config);
            UISettings.saveKeys();
            UISettings.saveUI();
            UISettings.saveVideo();
            UISettings.saveNtsc();
            UISettings.saveVisualizer();
            prop.store(output, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void loadSettings(File config) throws IOException {
        prop = new Properties();
        if (!config.exists()) {
            UISettings.loadKeys();
        } else {
            FileInputStream input = new FileInputStream(config);
            prop.load(input);
            UISettings.loadKeys();
            UISettings.loadUI();
            UISettings.loadVideo();
            UISettings.loadNtsc();
            UISettings.loadVisualizer();
        }
    }

    private static void loadKeys() {
        System.out.println("Loading keys");
        InputManager.c1controls = new ControllerInfo[8];
        InputManager.c1controls[0] = ControllerInfo.restoreInfo(prop.getProperty("c1a"), "Standard PS/2 Keyboard:0;A;1.0");
        InputManager.c1controls[1] = ControllerInfo.restoreInfo(prop.getProperty("c1b"), "Standard PS/2 Keyboard:0;S;1.0");
        InputManager.c1controls[2] = ControllerInfo.restoreInfo(prop.getProperty("c1select"), "Standard PS/2 Keyboard:0;W;1.0");
        InputManager.c1controls[3] = ControllerInfo.restoreInfo(prop.getProperty("c1start"), "Standard PS/2 Keyboard:0;Q;1.0");
        InputManager.c1controls[4] = ControllerInfo.restoreInfo(prop.getProperty("c1up"), "Standard PS/2 Keyboard:0;Up;1.0");
        InputManager.c1controls[5] = ControllerInfo.restoreInfo(prop.getProperty("c1down"), "Standard PS/2 Keyboard:0:0;Down;1.0");
        InputManager.c1controls[6] = ControllerInfo.restoreInfo(prop.getProperty("c1left"), "Standard PS/2 Keyboard:0;Left;1.0");
        InputManager.c1controls[7] = ControllerInfo.restoreInfo(prop.getProperty("c1right"), "Standard PS/2 Keyboard:0;Right;1.0");
        InputManager.c2controls = new ControllerInfo[8];
        InputManager.c2controls[0] = ControllerInfo.restoreInfo(prop.getProperty("c2a"), "Standard PS/2 Keyboard:0;A;1.0");
        InputManager.c2controls[1] = ControllerInfo.restoreInfo(prop.getProperty("c2b"), "Standard PS/2 Keyboard:0;S;1.0");
        InputManager.c2controls[2] = ControllerInfo.restoreInfo(prop.getProperty("c2select"), "Standard PS/2 Keyboard:0;W;1.0");
        InputManager.c2controls[3] = ControllerInfo.restoreInfo(prop.getProperty("c2start"), "Standard PS/2 Keyboard:0;Q;1.0");
        InputManager.c2controls[4] = ControllerInfo.restoreInfo(prop.getProperty("c2up"), "Standard PS/2 Keyboard:0;Up;1.0");
        InputManager.c2controls[5] = ControllerInfo.restoreInfo(prop.getProperty("c2down"), "Standard PS/2 Keyboard:0;Down;1.0");
        InputManager.c2controls[6] = ControllerInfo.restoreInfo(prop.getProperty("c2left"), "Standard PS/2 Keyboard:0;Left;1.0");
        InputManager.c2controls[7] = ControllerInfo.restoreInfo(prop.getProperty("c2right"), "Standard PS/2 Keyboard:0;Right;1.0");
        InputManager.hotkeys[0] = ControllerInfo.restoreInfo(prop.getProperty("quicksave"), "Standard PS/2 Keyboard:0;Z;1.0");
        InputManager.hotkeys[1] = ControllerInfo.restoreInfo(prop.getProperty("quickload"), "Standard PS/2 Keyboard:0;X;1.0");
        InputManager.hotkeys[2] = ControllerInfo.restoreInfo(prop.getProperty("inputrecord"), "Standard PS/2 Keyboard:0;C;1.0");
        InputManager.hotkeys[3] = ControllerInfo.restoreInfo(prop.getProperty("inputplay"), "Standard PS/2 Keyboard:0;V;1.0");
        controlwhilenotfocused = prop.getProperty("controlwhilenotfocused", "true").equals("true");
    }

    private static void saveKeys() {
        prop.setProperty("c1a", String.valueOf(InputManager.c1controls[0].storeInfo()));
        prop.setProperty("c2a", String.valueOf(InputManager.c2controls[0].storeInfo()));
        prop.setProperty("c1b", String.valueOf(InputManager.c1controls[1].storeInfo()));
        prop.setProperty("c2b", String.valueOf(InputManager.c2controls[1].storeInfo()));
        prop.setProperty("c1up", String.valueOf(InputManager.c1controls[4].storeInfo()));
        prop.setProperty("c2up", String.valueOf(InputManager.c2controls[4].storeInfo()));
        prop.setProperty("c1down", String.valueOf(InputManager.c1controls[5].storeInfo()));
        prop.setProperty("c2down", String.valueOf(InputManager.c2controls[5].storeInfo()));
        prop.setProperty("c1left", String.valueOf(InputManager.c1controls[6].storeInfo()));
        prop.setProperty("c2left", String.valueOf(InputManager.c2controls[6].storeInfo()));
        prop.setProperty("c1right", String.valueOf(InputManager.c1controls[7].storeInfo()));
        prop.setProperty("c2right", String.valueOf(InputManager.c2controls[7].storeInfo()));
        prop.setProperty("c1start", String.valueOf(InputManager.c1controls[3].storeInfo()));
        prop.setProperty("c2start", String.valueOf(InputManager.c2controls[3].storeInfo()));
        prop.setProperty("c1select", String.valueOf(InputManager.c1controls[2].storeInfo()));
        prop.setProperty("c2select", String.valueOf(InputManager.c2controls[2].storeInfo()));
        prop.setProperty("quicksave", String.valueOf(InputManager.hotkeys[0].storeInfo()));
        prop.setProperty("quickload", String.valueOf(InputManager.hotkeys[1].storeInfo()));
        prop.setProperty("inputrecord", String.valueOf(InputManager.hotkeys[2].storeInfo()));
        prop.setProperty("inputplay", String.valueOf(InputManager.hotkeys[3].storeInfo()));
        prop.setProperty("controlwhilenotfocused", String.valueOf(controlwhilenotfocused));
    }

    private static void loadUI() {
        autoLoad = prop.getProperty("autoload", "true").equals("true");
        ShowFPS = prop.getProperty("showfps", "true").equals("true");
        lockVideoToAudio = prop.getProperty("lockvideotoaudio", "true").equals("true");
        AudioEnabled = prop.getProperty("audioenabled", "true").equals("true");
        lockVideoToAudio = prop.getProperty("lockvideotoaudio", "true").equals("true");
        lastLoadedDir = prop.getProperty("lastloadeddir", System.getProperty("user.dir"));
    }

    private static void saveUI() {
        prop.setProperty("autoload", String.valueOf(autoLoad));
        prop.setProperty("showfps", String.valueOf(ShowFPS));
        prop.setProperty("lockvideotoaudio", String.valueOf(lockVideoToAudio));
        prop.setProperty("audioenabled", String.valueOf(AudioEnabled));
        prop.setProperty("lastloadeddir", String.valueOf(lastLoadedDir));
    }

    private static void loadVideo() {
        currentFilter = VideoFilter.valueOf(prop.getProperty("currentfilter", "None"));
        scanlineThickness = Double.parseDouble(prop.getProperty("scanlinethickness", "0.5"));
        scanlinesEnabled = prop.getProperty("scanlinesenabled", "false").equals("true");
    }

    private static void saveVideo() {
        prop.setProperty("currentfilter", "" + (Object)((Object)currentFilter));
        prop.setProperty("scanlinethickness", String.valueOf(scanlineThickness));
        prop.setProperty("scanlinesenabled", String.valueOf(scanlinesEnabled));
    }

    private static void loadNtsc() {
        ntsc_hue = Double.parseDouble(prop.getProperty("ntsc_hue", "0"));
        ntsc_saturation = Double.parseDouble(prop.getProperty("ntsc_saturation", "0"));
        ntsc_contrast = Double.parseDouble(prop.getProperty("ntsc_contrast", "0"));
        ntsc_brightness = Double.parseDouble(prop.getProperty("ntsc_brightness", "0"));
        ntsc_sharpness = Double.parseDouble(prop.getProperty("ntsc_sharpness", "0"));
        ntsc_gamma = Double.parseDouble(prop.getProperty("ntsc_gamma", "0"));
        ntsc_resolution = Double.parseDouble(prop.getProperty("ntsc_resolution", "0"));
        ntsc_artifacts = Double.parseDouble(prop.getProperty("ntsc_artifacts", "0"));
        ntsc_fringing = Double.parseDouble(prop.getProperty("ntsc_fringing", "0"));
        ntsc_bleed = Double.parseDouble(prop.getProperty("ntsc_bleed", "0"));
        ntsc_merge = prop.getProperty("ntsc_merge", "true").equals("true");
    }

    private static void saveNtsc() {
        prop.setProperty("ntsc_hue", String.valueOf(ntsc_hue));
        prop.setProperty("ntsc_saturation", String.valueOf(ntsc_saturation));
        prop.setProperty("ntsc_contrast", String.valueOf(ntsc_contrast));
        prop.setProperty("ntsc_brightness", String.valueOf(ntsc_brightness));
        prop.setProperty("ntsc_sharpness", String.valueOf(ntsc_sharpness));
        prop.setProperty("ntsc_gamma", String.valueOf(ntsc_gamma));
        prop.setProperty("ntsc_resolution", String.valueOf(ntsc_resolution));
        prop.setProperty("ntsc_artifacts", String.valueOf(ntsc_artifacts));
        prop.setProperty("ntsc_fringing", String.valueOf(ntsc_fringing));
        prop.setProperty("ntsc_bleed", String.valueOf(ntsc_bleed));
        prop.setProperty("ntsc_merge", String.valueOf(ntsc_merge));
    }

    private static void loadVisualizer() {
        String in = prop.getProperty("pianocolors", "");
        if (in.length() > 1) {
            String[] colors = in.split(" ");
            int i = 0;
            while (i < colors.length) {
                UISettings.pianoColors[i] = new Color(Integer.parseInt(colors[i]));
                ++i;
            }
        }
        colorBlindMode = prop.getProperty("colorblindmode", "false").equals("true");
        allGreen = prop.getProperty("allgreen", "false").equals("true");
    }

    private static void saveVisualizer() {
        String out = "";
        Color[] colorArray = pianoColors;
        int n = pianoColors.length;
        int n2 = 0;
        while (n2 < n) {
            Color c = colorArray[n2];
            out = String.valueOf(out) + c.getRGB() + " ";
            ++n2;
        }
        prop.setProperty("pianocolors", out);
        prop.setProperty("colorblindmode", String.valueOf(colorBlindMode));
        prop.setProperty("allgreen", String.valueOf(allGreen));
    }

    public static enum VideoFilter {
        None,
        NTSC;

    }
}

